/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.dao.support.sql;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.form72.dao.FormPatternDao;
import com.sdjxd.hussar.core.form72.po.FormAreaPo;
import com.sdjxd.hussar.core.form72.po.FormCellEventPo;
import com.sdjxd.hussar.core.form72.po.FormCellPo;
import com.sdjxd.hussar.core.form72.po.FormPatternPo;
import com.sdjxd.hussar.core.utils.HussarDate;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.data.DbOper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class FormPatternDaoImpl
implements FormPatternDao {
    private static Logger daoLogger = Logger.getLogger(FormPatternDaoImpl.class);

    @Override
    public FormPatternPo getPatternData(String patternId) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DIRECTORYID,MODULEID,PATTERNNAME,PATTERNTYPE");
        sql.append(",SHEETSIZE,PATTERNWIDTH,PATTERNHEIGHT,PATTERNDIRECT");
        sql.append(",BKCOLOR,PAGECOUNT,TABLENAME,SHEETPATTERNID");
        sql.append(",ATTACHPATTERNID,DEVTYPE,CREATEDATE,ISAUTOCENTER");
        sql.append(",WIDTHSCALE,HEIGHTSCALE,FORM_EVENTS,LIMITINFO,LINKVIEWID,DATASOURCENAME,DATAUSERNAME");
        sql.append(",ISABSOLUTE,SCREENMODE,BGIMAGE,ENTITYID,USEDLIMITGROUPIDS ");
        sql.append(" FROM [S].JXD7_PM_PATTERN ");
        sql.append(" WHERE PATTERNID='").append(patternId).append("'");
        sql.append(" AND DATASTATUSID=1");
        FormPatternPo pattern = new FormPatternPo();
        try {
            RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
            if (rs.next()) {
                pattern.setId(patternId);
                pattern.setName(rs.getString("PATTERNNAME"));
                pattern.setModuleId(rs.getString("MODULEID"));
                pattern.setByname(rs.getString("ENTITYID"));
                pattern.setPatternType(rs.getInt("PATTERNTYPE"));
                pattern.setSheetSize(rs.getInt("SHEETSIZE"));
                pattern.setWidth(rs.getInt("PATTERNWIDTH"));
                pattern.setWidthScale(rs.getString("WIDTHSCALE"));
                pattern.setHeight(rs.getInt("PATTERNHEIGHT"));
                pattern.setHeightScale(rs.getString("HEIGHTSCALE"));
                pattern.setDirect(rs.getInt("PATTERNDIRECT"));
                int color = rs.getInt("BKCOLOR");
                StringBuffer sbColor = new StringBuffer(7);
                sbColor.append("#");
                if (color % 256 < 16) {
                    sbColor.append("0");
                }
                sbColor.append(Integer.toHexString(color % 256));
                if ((color >>= 8) % 256 < 16) {
                    sbColor.append("0");
                }
                sbColor.append(Integer.toHexString(color % 256));
                if ((color >>= 8) < 16) {
                    sbColor.append("0");
                }
                sbColor.append(Integer.toHexString(color));
                pattern.setBgColor(sbColor.toString());
                pattern.setPageCount(rs.getInt("PAGECOUNT"));
                pattern.setTable(rs.getString("TABLENAME"));
                pattern.setDataSourceName(rs.getString("DATASOURCENAME"));
                pattern.setDataUserName(rs.getString("DATAUSERNAME"));
                pattern.setLinkViewId(rs.getString("LINKVIEWID"));
                pattern.setIsAutoCenter(Const.Form.Align.values()[rs.getInt("ISAUTOCENTER")]);
                String modifyTime = rs.getString("CREATEDATE");
                if (modifyTime != null && modifyTime.length() != 0) {
                    pattern.setModifyTime(HussarDate.parseDate(modifyTime));
                }
                pattern.setM_formEvents(HussarString.trim(rs.getString("FORM_EVENTS")));
                pattern.setLimitInfo(rs.getString("LIMITINFO"));
                pattern.setPosition(Const.Form.Position.values()[rs.getInt("ISABSOLUTE")]);
                pattern.setScreenMode(Const.Form.ScreenMode.values()[rs.getInt("SCREENMODE")]);
                pattern.setBgImage(rs.getString("BGIMAGE"));
                pattern.setUsedLimitGroupIds(rs.getString("USEDLIMITGROUPIDS"));
            }
            rs = null;
            StringBuffer patternCodesql = new StringBuffer();
            patternCodesql.append(" SELECT TABLEID FROM  [S].JXD7_XT_SYSTABLEINFO WHERE TABLENAME='").append(pattern.getTable()).append("' AND DATASOURCENAME='").append(pattern.getDataSourceName()).append("' AND DATAUSERNAME='").append(pattern.getDataUserName()).append("'");
            RowSet rsEntity = DbOper.executeQuery((String)"defaultds", (String)patternCodesql.toString());
            if (rsEntity.next()) {
                pattern.setEntityPatternCode(rsEntity.getString("TABLEID"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return pattern;
    }

    @Override
    public String getFormIdByVersion(String formVersionId) throws SQLException {
        String formId = null;
        String sql = "SELECT PATTERNID FROM [S].JXD7_PM_PATTERN WHERE PATTERNVERSION='" + formVersionId + "' AND (STARTUPTIME IS NULL OR STARTUPTIME='' OR STARTUPTIME<='" + HussarDate.getNow() + "') AND (TERMINATE IS NULL OR TERMINATE='' OR TERMINATE>='" + HussarDate.getNow() + "') AND DATASTATUSID<>" + (Object)((Object)Const.Data.Status.DELETE) + " ORDER BY VERSIONID DESC";
        try {
            formId = (String)DbOper.executeQueryObject((String)"defaultds", (String)sql);
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u8868\u5355\u7248\u672c\u7f16\u7801\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql));
            throw exp;
        }
        return formId;
    }

    public String getPatternCellsSql(String patternId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT CELLID,CELLTYPEID,CELLEXTENDTYPEID,USERCELLTYPEID,FONTID2,AREAID,CELLNAME,MAXSIZE");
        sql.append(",CELLLABEL,X1,Y1,WIDTH,HEIGHT,TEXTCOLORSTYLE,BORDERCOLOR");
        sql.append(",READBKCOLORSTYLE,BKCOLORSTYLE,ALIGNSTYLE,FONTSTYLE");
        sql.append(",ISPRINT,COMMWORDTYPE,CELLGROUPINFO,CHECKCONDITION");
        sql.append(",DTEXTNUM,VALUEFIELD,TEXTFIELD,SLAVESIGNCELLS,ASSITINFO,USERDEFINFO");
        sql.append(",MEANID");
        sql.append(",COMPARETEXT,COMPARETYPEID,LINEWIDTH,CREATEDATE,LIMIT,READONLY, WIDTHSCALE, HEIGHTSCALE, ISNEEDSAVE, TABLELINKID, LIMITINFO,ZINDEX,DEFAULTVALUETIME");
        sql.append(",VERIFYMEAN ,BGIMAGE, FILEPATH, ALLOWFILENUMS, UPLOADSERVLETURL, DOWNLOADSERVLETURL, HTMLURL, FRAMEPATTERNID, VIEWPAGEPATTERNIDS, ITEMTYPE, ITEMID,ENCRYPTTYPE,ENTITYATTRIBUTEID,SKINSTYLE,USERDEFINEDBYNAME,MOBILELABELADDR");
        sql.append(" FROM [S].JXD7_PM_PATTERNCELL P WHERE PATTERNID='");
        sql.append(patternId);
        sql.append("' AND CELLID >=0 ");
        sql.append(" UNION ");
        sql.append(" SELECT  AREAID AS  CELLID ,51 AS CELLTYPEID,51 AS CELLEXTENDTYPEID,NULL AS USERCELLTYPEID,NULL AS FONTID2, AREACELL AS AREAID,AREANAME AS CELLNAME,NULL AS MAXSIZE,NULL AS CELLLABEL, X1,Y1,AREAWIDTH AS WIDTH,").append("AREAHEIGHT AS HEIGHT,NULL AS TEXTCOLORSTYLE,NULL AS BORDERCOLOR,NULL AS READBKCOLORSTYLE,NULL AS BKCOLORSTYLE,NULL AS ALIGNSTYLE,NULL AS FONTSTYLE,NULL AS ISPRINT,NULL AS COMMWORDTYPE,NULL AS CELLGROUPINFO,NULL AS CHECKCONDITION,").append("NULL AS DTEXTNUM,NULL AS VALUEFIELD,NULL AS TEXTFIELD,NULL AS SLAVESIGNCELLS,NULL AS ASSITINFO,NULL AS USERDEFINFO,NULL AS MEANID,NULL AS COMPARETEXT,NULL AS COMPARETYPEID,NULL AS LINEWIDTH,NULL AS CREATEDATE,2 AS LIMIT,NULL AS READONLY,").append("NULL AS  WIDTHSCALE,NULL AS  HEIGHTSCALE,NULL AS  ISNEEDSAVE,NULL AS  TABLELINKID,NULL AS  LIMITINFO,NULL AS ZINDEX,NULL AS DEFAULTVALUETIME,NULL AS VERIFYMEAN , BGIMAGE,NULL AS  FILEPATH,NULL AS  ALLOWFILENUMS,NULL AS  UPLOADSERVLETURL,").append("NULL AS  DOWNLOADSERVLETURL,NULL AS  HTMLURL,NULL AS  FRAMEPATTERNID,NULL AS  VIEWPAGEPATTERNIDS,NULL AS  ITEMTYPE,NULL AS  ITEMID,NULL AS ENCRYPTTYPE,NULL AS ENTITYATTRIBUTEID,SKINSTYLE,NULL AS USERDEFINEDBYNAME ,NULL AS MOBILELABELADDR FROM JXD7_PM_AREAINFO ");
        sql.append(" WHERE PATTERNID='").append(patternId).append("'");
        sql.append(" ORDER BY Y1,X1,CELLID");
        return sql.toString();
    }

    @Override
    public ArrayList<FormCellPo> getPatternCells(String patternId) throws SQLException {
        ArrayList<FormCellPo> patternCells = new ArrayList<FormCellPo>(128);
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)this.getPatternCellsSql(patternId));
        while (rs.next()) {
            FormCellPo cellPo = new FormCellPo();
            cellPo.setPatternId(patternId);
            cellPo.setCellId(rs.getInt("CELLID"));
            cellPo.setByName(String.valueOf(rs.getInt("ENTITYATTRIBUTEID")));
            String temp = rs.getString("CELLNAME");
            temp = temp == null ? "" : temp;
            cellPo.setName(temp);
            temp = rs.getString("CELLLABEL");
            temp = temp == null ? "" : temp;
            cellPo.setCellLabel(temp);
            cellPo.setCellType(rs.getInt("CELLEXTENDTYPEID"));
            cellPo.setUserCellTypeid(rs.getString("USERCELLTYPEID"));
            cellPo.setFontId2(rs.getInt("FONTID2"));
            cellPo.setAreaId(rs.getInt("AREAID"));
            cellPo.setX1(rs.getInt("X1"));
            cellPo.setY1(rs.getInt("Y1"));
            cellPo.setMaxSize(rs.getInt("MAXSIZE"));
            cellPo.setWidth(rs.getInt("WIDTH"));
            cellPo.setWidthScale(rs.getObject("WIDTHSCALE") == null ? "" : rs.getString("WIDTHSCALE"));
            cellPo.setHeight(rs.getInt("HEIGHT"));
            cellPo.setHeightScale(rs.getString("HEIGHTSCALE"));
            temp = rs.getString("TEXTCOLORSTYLE");
            temp = temp == null ? "" : temp;
            cellPo.setTextColorStyle(temp);
            temp = rs.getString("READBKCOLORSTYLE");
            temp = temp == null ? "" : temp;
            cellPo.setReadBkColorStyle(temp);
            temp = rs.getString("BKCOLORSTYLE");
            temp = temp == null ? "" : temp;
            cellPo.setBkColorStyle(temp);
            cellPo.setAlignStyle(rs.getString("ALIGNSTYLE"));
            cellPo.setFontStyle(rs.getString("FONTSTYLE"));
            cellPo.setBorderStyle(rs.getString("BORDERCOLOR"));
            if (rs.getInt("ISPRINT") == 1) {
                cellPo.setPrint(true);
            }
            cellPo.setCommwordType(rs.getString("COMMWORDTYPE"));
            cellPo.setDtextNum(rs.getInt("DTEXTNUM"));
            cellPo.setCheckCondition(rs.getInt("CHECKCONDITION"));
            temp = rs.getString("VALUEFIELD");
            temp = temp == null ? null : temp.trim();
            cellPo.setValueField(temp);
            temp = rs.getString("TEXTFIELD");
            temp = temp == null ? null : temp.trim();
            cellPo.setTextField(temp);
            cellPo.setCellProjectId(rs.getString("MEANID"));
            temp = rs.getString("ASSITINFO");
            temp = temp == null ? "" : temp;
            cellPo.setAssitInfo(temp);
            cellPo.setLineWidth(rs.getInt("LINEWIDTH"));
            cellPo.setLimit(Const.Permit.Limit.values()[rs.getInt("LIMIT")]);
            if (rs.getInt("ISNEEDSAVE") == 1) {
                cellPo.setNeedSave(true);
            }
            cellPo.setTableLinkId(rs.getString("TABLELINKID"));
            cellPo.setLimitInfo(rs.getString("LIMITINFO"));
            cellPo.setUserDefinfo(rs.getString("USERDEFINFO"));
            cellPo.setzIndex(rs.getString("ZINDEX"));
            cellPo.setDefaultValueTime(Const.Form.Cell.DefaultValueTime.values()[rs.getInt("DEFAULTVALUETIME")]);
            try {
                Object verifymean;
                if (rs.getString("VERIFYMEAN") != null && (verifymean = HussarJson.parse(rs.getString("VERIFYMEAN"))) != null && verifymean.getClass().isArray() && ((Object[])verifymean).length > 0) {
                    cellPo.setVerifyMeans((String[])HussarJson.parse(rs.getString("VERIFYMEAN")));
                }
            }
            catch (Exception exp) {
                daoLogger.error((Object)("\u5143\u4ef6\u7684\u6821\u9a8c\u5b57\u6bb5\u542b\u4e49\u8bfb\u53d6\u9519\u8bef\u3002cellId:" + cellPo.getCellId()));
                exp.printStackTrace();
            }
            cellPo.setBgImage(rs.getString("BGIMAGE"));
            cellPo.setFilePath(rs.getString("FILEPATH"));
            cellPo.setAllowFileNums(rs.getInt("ALLOWFILENUMS"));
            cellPo.setUpLoadServletUrl(rs.getString("UPLOADSERVLETURL"));
            cellPo.setDownLoadServletUrl(rs.getString("DOWNLOADSERVLETURL"));
            cellPo.setHtmlUrl(rs.getString("HTMLURL"));
            cellPo.setFramePatternId(rs.getString("FRAMEPATTERNID"));
            cellPo.setViewPagesPatternIds(rs.getString("VIEWPAGEPATTERNIDS"));
            cellPo.setItemId(rs.getString("ITEMID"));
            cellPo.setItemType(rs.getString("ITEMTYPE"));
            cellPo.setEncryptType(rs.getInt("ENCRYPTTYPE"));
            cellPo.setSkinstyle(rs.getString("SKINSTYLE"));
            cellPo.setUserDefinedByName(rs.getString("USERDEFINEDBYNAME"));
            if (rs.getInt("READONLY") == 1) {
                cellPo.setCanWrite(true);
            } else {
                cellPo.setCanWrite(false);
            }
            cellPo.setTabLocation(rs.getInt("MOBILELABELADDR"));
            patternCells.add(cellPo);
        }
        return patternCells;
    }

    @Override
    public ArrayList<FormCellEventPo> getPatternEvent(String patternId) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT C.CELLID,C.EVENTID,C.ACTIONID,C.PARAMID,C.PARAMNAME");
        sql.append(",C.PARAMVALUE,C.ACTIONORDER,P.PARAMORDER,E.EVENTCODE");
        sql.append(",A.ACTIONCODE,A.ACTIONNAME,A.JSORJAVA,A.PARAMETER");
        sql.append(",ISNEGLECT,CANBACK ,P.PARAMTYPEID,P.DEFAULTVALUE,P.PARAMDESCRIPTION FROM [S].JXD7_PM_CELLACTION C");
        sql.append(" INNER JOIN [S].JXD7_PM_ACTION A ON C.ACTIONID=A.ACTIONID");
        sql.append(" INNER JOIN [S].JXD7_PM_EVENT E ON C.EVENTID=E.EVENTID");
        sql.append(" LEFT OUTER JOIN [S].JXD7_PM_ACTIONPARAM P ON P.PARAMID=C.PARAMID");
        sql.append(" AND P.ACTIONID=A.ACTIONID");
        sql.append(" WHERE C.PATTERNID='");
        sql.append(patternId);
        sql.append("' ORDER BY C.CELLID,ACTIONORDER,P.PARAMORDER");
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
        ArrayList<FormCellEventPo> cellActions = new ArrayList<FormCellEventPo>();
        while (rs.next()) {
            FormCellEventPo model = new FormCellEventPo();
            model.setCellId(rs.getInt("CELLID"));
            model.setEventId(rs.getInt("EVENTID"));
            model.setEventCode(rs.getString("EVENTCODE"));
            model.setActionOrder(rs.getInt("ACTIONORDER"));
            model.setId(rs.getString("ACTIONID"));
            model.setCode(rs.getString("ACTIONCODE"));
            model.setName(rs.getString("ACTIONNAME"));
            model.setParamOrder(rs.getInt("PARAMORDER"));
            model.setParamId(rs.getString("PARAMID"));
            model.setParamName(rs.getString("PARAMNAME"));
            model.setParamValue(rs.getString("PARAMVALUE"));
            model.setParamType(rs.getInt("PARAMTYPEID"));
            model.setDefaultValue(rs.getString("DEFAULTVALUE"));
            model.setDescription(rs.getString("PARAMDESCRIPTION"));
            model.setType(rs.getInt("JSORJAVA"));
            cellActions.add(model);
        }
        if (cellActions.size() == 0) {
            cellActions = null;
        }
        return cellActions;
    }

    @Override
    public ArrayList<FormAreaPo> getPatternAreas(String patternId) throws SQLException {
        ArrayList<FormAreaPo> areaPos = new ArrayList<FormAreaPo>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AREAID,AREATYPE,AREASTYLE");
        sql.append(",AREANAME,X1,Y1,AREAWIDTH,AREAHEIGHT");
        sql.append(",DWTYPE,ISQUERY,CELLDWTYPE,NEEDSCROLL, WIDTHSCALE, HEIGHTSCALE,ALIGNSTYLE,AREACELL,ZINDEX FROM ");
        sql.append("[S].JXD7_PM_AREAINFO WHERE PATTERNID='");
        sql.append(patternId);
        sql.append("' ORDER BY AREACELL,Y1,X1,AREAID");
        try {
            RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
            while (rs.next()) {
                FormAreaPo areaPo = new FormAreaPo();
                areaPo.setAreaId(rs.getInt("AREAID"));
                areaPo.setName(rs.getString("AREANAME"));
                areaPo.setByName(rs.getString("AREAID"));
                areaPo.setAreaType(rs.getInt("ISQUERY"));
                areaPo.setBaseStyle(rs.getString("AREASTYLE"));
                areaPo.setX1(rs.getInt("X1"));
                areaPo.setY1(rs.getInt("Y1"));
                areaPo.setWidth(rs.getInt("AREAWIDTH"));
                areaPo.setHeight(rs.getInt("AREAHEIGHT"));
                areaPo.setChildPosition(rs.getInt("CELLDWTYPE"));
                areaPo.setScroll(rs.getInt("NEEDSCROLL"));
                areaPo.setLimit(areaPo.getAreaType() == Const.Form.AreaType.QUERY ? Const.Permit.Limit.UNVISIBLE : Const.Permit.Limit.READONLY);
                areaPo.setWidthScale(rs.getString("WIDTHSCALE"));
                areaPo.setHeightScale(rs.getString("HEIGHTSCALE"));
                areaPo.setParentId(rs.getInt("AREACELL"));
                areaPo.setPatternId(patternId);
                areaPo.setzIndex(rs.getString("ZINDEX"));
                areaPos.add(areaPo);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6a21\u7248\u533a\u57df\u8868\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        if (areaPos.size() == 0) {
            areaPos = null;
        }
        return areaPos;
    }

    @Override
    public ArrayList<String> getPatternJsFiles(String patternId) throws SQLException {
        ArrayList<String> jsFiles = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FILEPATH FROM [S].JXD7_PM_SCRIPT S ,[S].JXD7_PM_SCRIPTPATTERN P ");
        sql.append(" WHERE P.SID= S.SID  AND P.SID <>'0BF6CE9E-D07C-4590-A796-10206B9D83DF' AND ");
        sql.append(" P.PATTERNID='").append(patternId).append("'");
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
        while (rs.next()) {
            jsFiles.add(rs.getString("FILEPATH"));
        }
        if (jsFiles.size() > 0) {
            return jsFiles;
        }
        return null;
    }

    @Override
    public Map<Integer, String> getDefaultSkinStyle() throws SQLException {
        HashMap<Integer, String> defaultSkinStyle = new HashMap<Integer, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT CELLEXTENDTYPEID,SKINSTYLE FROM JXD7_DM_CELLTYPE ");
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
        while (rs.next()) {
            defaultSkinStyle.put(rs.getInt("CELLEXTENDTYPEID"), rs.getString("SKINSTYLE"));
        }
        return defaultSkinStyle;
    }
}

