/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.dao.support.sql;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectTree;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.treeData.LinkAppTable;
import com.sdjxd.hussar.core.form72.bo.cellData.OptionBo;
import com.sdjxd.hussar.core.form72.bo.cellData.TreeNodeBo;
import com.sdjxd.hussar.core.form72.dao.CellProjectDao;
import com.sdjxd.hussar.core.form72.po.FormCellMeanPo;
import com.sdjxd.hussar.core.form72.po.ListStyleColumnDataPo;
import com.sdjxd.hussar.core.form72.po.ListStyleDataPo;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.DropDownOptionBean;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class CellProjectDaoImpl
implements CellProjectDao {
    private static Logger daoLogger = Logger.getLogger(CellProjectDaoImpl.class);

    @Override
    public FormCellMeanPo getFormCellMeanPo(String projectId) throws SQLException {
        FormCellMeanPo cellMeanPo = new FormCellMeanPo();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM [S].JXD7_XT_ATTRIMEAN");
        sql.append(" WHERE MEANID='");
        sql.append(projectId);
        sql.append("'");
        try {
            RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
            if (rs != null && rs.next()) {
                cellMeanPo.setId(projectId);
                cellMeanPo.setName(rs.getString("MEANNAME"));
                cellMeanPo.setAssitinfo(rs.getString("ASSITINFO"));
                cellMeanPo.setType(rs.getString("MEANTYPE"));
                cellMeanPo.setModuleId(rs.getString("MODULEID"));
                cellMeanPo.setDataSourceName(rs.getString("DATASOURCENAME"));
                cellMeanPo.setMulsel(String.valueOf(rs.getInt("ALLOWMULSEL")));
                rs.close();
            }
            rs = null;
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5143\u4ef6\u5b57\u6bb5\u542b\u4e49\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql));
            throw exp;
        }
        return cellMeanPo;
    }

    @Override
    public ListStyleDataPo getFormCellListStylePo(String projectId) throws SQLException {
        ListStyleDataPo listStyleDataPo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM [S].JXD7_PM_LISTSTYLE");
        sql.append(" WHERE STYLEID='").append(projectId).append("'");
        try {
            RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
            if (rs != null && rs.next()) {
                listStyleDataPo = new ListStyleDataPo();
                listStyleDataPo.setStyleId(projectId);
                listStyleDataPo.setStyleName(rs.getString("STYLENAME"));
                listStyleDataPo.setTableId(rs.getString("TABLEID"));
                listStyleDataPo.setOrderField(rs.getString("ORDERFIELD"));
                listStyleDataPo.setFilterSql(rs.getString("FILTERSQL"));
                listStyleDataPo.setHeaderSort(rs.getInt("HEADERSORT"));
                listStyleDataPo.setPageDataSize(rs.getInt("PAGEDATASIZE"));
                listStyleDataPo.setAllowPage(rs.getInt("ALLOWPAGE"));
                listStyleDataPo.setLoadData(rs.getInt("ISLOADDATA"));
                listStyleDataPo.setLinkViewId(rs.getString("LINKVIEWID"));
                listStyleDataPo.setIsAutoHeight(rs.getInt("ISAUTOHEIGHT"));
                rs.close();
            }
            rs = null;
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5143\u4ef6\u663e\u793a\u65b9\u6848\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql));
            throw exp;
        }
        return listStyleDataPo;
    }

    public String getViewInfo(String tableId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT VIEWFIELDINFO, VIEWCONDITION ");
        sql.append("FROM [S].JXD7_XT_SYSVIEWINFO ");
        sql.append("WHERE VIEWID = '").append(tableId).append("'");
        return sql.toString();
    }

    public String getEventSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT EVENTID,EVENTNAME,EVENTCODE");
        sb.append(" FROM [S].JXD7_PM_EVENT ORDER BY EVENTID");
        return sb.toString();
    }

    public String getListStyleColumn(String styleId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT C.STYLEID, C.COLUMNID, C.SHOWNAME, C.SHOWORDER, C.MEANID,");
        sb.append("   C.COLUMNWIDTH, C.COLUMNTYPE, C.HALIGN, C.CELLSTYLE, C.EVENTINFO,");
        sb.append("   C.EVENTARG, C.ASSITINFO,C.VERIFYMEAN,C.COLUMNSTYLE,C.DISPLAYTITLE ");
        sb.append(" FROM [S].JXD7_PM_LISTSTYLECOLUMN C ");
        sb.append(" WHERE STYLEID='").append(styleId).append("'");
        sb.append(" ORDER BY SHOWORDER");
        return sb.toString();
    }

    @Override
    public List<ListStyleColumnDataPo> getFormCellListColumnStylePos(String projectId, int isView, String tableID) throws SQLException {
        RowSet rs;
        String sql = "";
        ArrayList<ListStyleColumnDataPo> list = new ArrayList<ListStyleColumnDataPo>();
        ListStyleColumnDataPo styleColumn = null;
        String strViewConditionFields = ",";
        if (1 == isView) {
            try {
                sql = this.getViewInfo(tableID);
                rs = DbOper.executeQuery((String)"defaultds", (String)sql);
                if (rs != null && rs.next()) {
                    String fieldInfo = rs.getString("VIEWFIELDINFO");
                    String condition = rs.getString("VIEWCONDITION");
                    Object[] arrField = HussarJson.strToArray(fieldInfo);
                    if (arrField != null) {
                        int i = 0;
                        while (i < arrField.length) {
                            Object[] tableItem = (Object[])arrField[i];
                            String strTableBM = (String)tableItem[2];
                            int j = 3;
                            while (j < tableItem.length) {
                                Object[] fieldItem = (Object[])tableItem[j];
                                String strTemp = String.valueOf(strTableBM) + "." + (String)fieldItem[0];
                                String strViewField = (String)fieldItem[1];
                                if (condition == null || condition.indexOf("\"" + strTemp + " ") >= 0 || condition.indexOf(" " + strTemp + "\"") >= 0) {
                                    strViewConditionFields = String.valueOf(strViewConditionFields) + strViewField + ",";
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (SQLException exp) {
                daoLogger.error((Object)exp);
            }
        }
        try {
            sql = this.getListStyleColumn(projectId);
            rs = DbOper.executeQuery((String)"defaultds", (String)sql);
            if (rs != null) {
                while (rs.next()) {
                    styleColumn = new ListStyleColumnDataPo();
                    styleColumn.setStyleId(projectId);
                    String columnId = HussarString.nullToStr(rs.getString("COLUMNID"));
                    styleColumn.setColumnId(columnId);
                    if (columnId.indexOf(" AS ") > 0) {
                        styleColumn.setAsName(columnId.split(" AS ")[1]);
                    } else {
                        styleColumn.setAsName(columnId);
                    }
                    styleColumn.setShowName(HussarString.nullToStr(rs.getString("SHOWNAME")));
                    styleColumn.setShowOrder(rs.getInt("SHOWORDER"));
                    styleColumn.setHAlign(rs.getInt("HALIGN"));
                    styleColumn.setCellStyle(rs.getInt("CELLSTYLE"));
                    styleColumn.setColumnType(rs.getInt("COLUMNTYPE"));
                    styleColumn.setColumnWidth(rs.getString("COLUMNWIDTH"));
                    styleColumn.setMeanId(rs.getString("MEANID"));
                    styleColumn.setVerifyMeans((String[])HussarJson.parse(rs.getString("VERIFYMEAN")));
                    styleColumn.setEventArg(rs.getString("EVENTARG"));
                    styleColumn.setAssitInfo(rs.getString("ASSITINFO"));
                    String strEventInfo = rs.getString("EVENTINFO");
                    styleColumn.setEventInfo(strEventInfo);
                    if (-1 == rs.getInt("COLUMNSTYLE")) {
                        styleColumn.setColumnStyle(Const.Form.Cell.List.COLUMNSTYLE.MERGECOL);
                    } else {
                        styleColumn.setColumnStyle(Const.Form.Cell.List.COLUMNSTYLE.values()[rs.getInt("COLUMNSTYLE")]);
                    }
                    if (-1 == rs.getInt("DISPLAYTITLE")) {
                        styleColumn.setDisplay(Const.Form.Cell.List.DISPLAYTITLE.HIDETITLE);
                    } else {
                        styleColumn.setDisplay(Const.Form.Cell.List.DISPLAYTITLE.values()[rs.getInt("DISPLAYTITLE")]);
                    }
                    if (strViewConditionFields.indexOf("," + columnId + ",") >= 0) {
                        styleColumn.setDataLimit(1);
                    }
                    list.add(styleColumn);
                }
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
        }
        return list;
    }

    @Override
    public int getDataCount(String dataSourceName, String dataUserName, String tableName, String query) throws SQLException {
        int count = 0;
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT COUNT(1) FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(dataUserName);
        }
        sb.append(tableName);
        DataSource dataSource = DataSource.getDataSource();
        if ("sql".equalsIgnoreCase(dataSource.getDbType().getName())) {
            sb.append(" WITH(NOLOCK) ");
        }
        sb.append(" WHERE ").append(HussarString.replaceKeyWord(query));
        String sql = sb.toString();
        try {
            Object o = DbOper.executeQueryObject((String)dataSourceName, (String)sql);
            if (o != null) {
                count = Integer.parseInt(o.toString());
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)sql);
            daoLogger.error((Object)exp);
            throw exp;
        }
        return count;
    }

    @Override
    public String getViewSql(String viewId, String mainTableName, String pkColumn) {
        String sql = this.getViewInfo(viewId);
        StringBuffer viewSql = new StringBuffer();
        try {
            RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql);
            if (rs.next()) {
                String tableName = "";
                viewSql.append("select ");
                String temp = rs.getString("VIEWFIELDINFO");
                Object[] tempArr1 = HussarJson.strToArray(temp);
                int i = 0;
                while (i < tempArr1.length) {
                    Object[] tempArr2 = (Object[])tempArr1[i];
                    if (tempArr2.length >= 4) {
                        if (i > 0) {
                            tableName = String.valueOf(tableName) + ",";
                        }
                        TableBean tableBean = Table.getTable((String)((String)tempArr2[0]));
                        tableName = String.valueOf(tableName) + tableBean.getDataUserName();
                        tableName = String.valueOf(tableName) + tempArr2[1];
                        tableName = String.valueOf(tableName) + " ";
                        tableName = String.valueOf(tableName) + tempArr2[2];
                        int j = 3;
                        while (j < tempArr2.length) {
                            String[] tempArr3 = (String[])tempArr2[j];
                            if (i > 0) {
                                viewSql.append(",");
                            } else if (j > 3) {
                                viewSql.append(",");
                            }
                            viewSql.append(tempArr2[2]);
                            viewSql.append(".");
                            viewSql.append(tempArr3[0]);
                            viewSql.append(" as ");
                            viewSql.append(tempArr3[1]);
                            ++j;
                        }
                        if (viewSql.length() > 1 && tempArr2[1].equals(mainTableName)) {
                            viewSql.append(",").append(tempArr2[2]).append(".").append(pkColumn);
                        }
                    }
                    ++i;
                }
                viewSql.append(" from ");
                viewSql.append(tableName);
                viewSql.append(" where ");
                temp = rs.getString("VIEWCONDITION");
                tempArr1 = HussarJson.strToArray(temp);
                if (tempArr1.length > 1) {
                    i = 1;
                    while (i < tempArr1.length) {
                        if (i > 1) {
                            viewSql.append(" and ");
                        }
                        viewSql.append((String)tempArr1[i]);
                        ++i;
                    }
                } else if (tempArr1.length == 1) {
                    viewSql.append((String)tempArr1[0]);
                }
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return viewSql.toString();
    }

    @Override
    public List getAllListData(String dataSourceName, String field, String dataUserName, String tableName, String pkCol, String filter, String order) throws Exception {
        ArrayList list;
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ").append(" ").append(field).append(" FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(dataUserName);
        }
        sb.append(tableName).append(" WHERE ").append(filter);
        sb.append(" ORDER BY ").append(order);
        String sql = sb.toString();
        try {
            list = DbOper.executeList((String)dataSourceName, (String)sql);
        }
        catch (Exception exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5217\u8868\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql));
            exp.printStackTrace();
            throw exp;
        }
        return list;
    }

    @Override
    public List getPageListData(String dataSourceName, String field, String dataUserName, String tableName, String pkCol, String filter, String order, int pageDataSize, int pageIndex) throws Exception {
        ArrayList list;
        String sql = this.getPageListDataSql(dataSourceName, field, dataUserName, tableName, pkCol, filter, order, pageDataSize, pageIndex);
        try {
            list = DbOper.executeList((String)dataSourceName, (String)sql);
        }
        catch (Exception exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5217\u8868\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql));
            exp.printStackTrace();
            throw exp;
        }
        return list;
    }

    protected String getPageListDataSql(String dataSourceName, String field, String dataUserName, String tableName, String pkCol, String filter, String order, int pageDataSize, int pageIndex) {
        StringBuffer sb = new StringBuffer(128);
        int start = (pageIndex - 1) * pageDataSize;
        sb.append("SELECT TOP ").append(pageDataSize).append(" ").append(field);
        sb.append(" FROM ");
        if (tableName != null && !tableName.substring(0, 1).equals("(")) {
            sb.append(dataUserName);
        }
        sb.append(tableName);
        sb.append(" WHERE (").append(filter);
        sb.append(")");
        if (start > 0) {
            sb.append(" AND ").append(pkCol).append(" NOT IN (");
            sb.append("SELECT TOP ").append(start).append(" ").append(pkCol);
            sb.append(" FROM ");
            if (tableName != null && !tableName.substring(0, 1).equals("(")) {
                sb.append(dataUserName);
            }
            sb.append(tableName);
            sb.append(" WHERE ").append(filter);
            sb.append(" ORDER BY ").append(order);
            sb.append(")");
        }
        sb.append(" ORDER BY ").append(order);
        return sb.toString();
    }

    @Override
    public ArrayList<OptionBo> getMeanOptions(String dataSouceName, String tableName, String idFieldName, String textFieldName, String filter, String order, String tempFilter) throws SQLException {
        ArrayList<OptionBo> options = new ArrayList<OptionBo>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(textFieldName).append(",").append(idFieldName).append(" FROM ").append(tableName).append(" ");
        if (!HussarString.isEmpty(filter)) {
            filter = HussarString.replaceKeyWord(filter);
            sql.append(filter);
        }
        if (!HussarString.isEmpty(tempFilter)) {
            if (HussarString.isEmpty(filter)) {
                sql.append(" WHERE ").append(tempFilter);
            } else {
                sql.append(" AND ").append(tempFilter);
            }
        }
        if (!HussarString.isEmpty(order)) {
            sql.append(order);
        }
        try {
            RowSet rs = DbOper.executeQuery((String)dataSouceName, (String)sql.toString());
            if (rs != null) {
                while (rs.next()) {
                    OptionBo b = new OptionBo();
                    b.setText(rs.getString(textFieldName));
                    b.setValue(rs.getString(idFieldName));
                    options.add(b);
                }
                rs.close();
            }
            rs = null;
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5143\u4ef6\u5b57\u6bb5\u542b\u4e49\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql));
            throw exp;
        }
        return options;
    }

    @Override
    public OptionBo getMeanOptionByValue(String id, String dataSouceName, String tableName, String idFieldName, String textFieldName, String filter) throws SQLException {
        OptionBo b = new OptionBo();
        b.setValue(id);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + textFieldName + " FROM " + tableName);
        if (!HussarString.isEmpty(filter)) {
            filter = HussarString.replaceKeyWord(filter);
            sql.append(" ");
            sql.append(filter);
        }
        if (HussarString.isEmpty(filter)) {
            sql.append(" WHERE ");
        } else {
            sql.append(" AND ");
        }
        sql.append(idFieldName).append(" ='").append(id).append("'");
        try {
            RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql.toString());
            if (rs != null && rs.next()) {
                b.setText(rs.getString(textFieldName));
                rs.close();
            }
            rs = null;
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u4e0b\u62c9\u6846\u663e\u793a\u65b9\u5b89 \u6839\u636eID\u8f6c\u6362TEXT\u65f6\u51fa\u9519,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql));
            throw exp;
        }
        return b;
    }

    @Override
    public HashMap<String, String> getAppInfo(String appId) throws Exception {
        HashMap<String, String> m_appMap = null;
        StringBuffer sb = new StringBuffer();
        RowSet rs = null;
        sb.append("SELECT L.APPID, L.APPNAME, L.TABLEID");
        sb.append(", LAT.ATTCOLUMN, LAT.ATTTABLE, LAT.FILTER, LAT.ORDERBY, LAT.ISSHOWINFO, LAT.INFOJMID, LAT.INFOFORMID, LAT.LIMITINFO");
        sb.append(", TI.TABLENAME, TI.SHOWNAMECOL, TI.PKCOL, TI.PICPATH,L.DATASOURCENAME,TI.DATAUSERNAME ");
        sb.append(" from [S].JXD7_XT_LINKAPP L, [S].JXD7_XT_LINKAPPTABLE LAT, [S].JXD7_XT_SYSTABLEINFO TI");
        sb.append(" where L.TABLEID=TI.TABLEID AND LAT.APPID=L.APPID AND LAT.TABLEID=L.TABLEID AND LAT.LINKID='-1' ");
        sb.append(" AND L.APPID='" + appId + "'");
        try {
            rs = DbOper.executeQuery((String)"defaultds", (String)sb.toString());
            if (rs.next()) {
                m_appMap = new HashMap<String, String>();
                m_appMap.put("APPID", rs.getString("APPID"));
                m_appMap.put("APPNAME", rs.getString("APPNAME"));
                m_appMap.put("TABLEID", rs.getString("TABLEID"));
                m_appMap.put("ATTCOLUMN", rs.getString("ATTCOLUMN"));
                m_appMap.put("ATTTABLE", rs.getString("ATTTABLE"));
                m_appMap.put("FILTER", rs.getString("FILTER"));
                m_appMap.put("ORDERBY", rs.getString("ORDERBY"));
                m_appMap.put("ISSHOWINFO", String.valueOf(rs.getInt("ISSHOWINFO")));
                m_appMap.put("INFOJMID", rs.getString("INFOJMID"));
                m_appMap.put("INFOFORMID", rs.getString("INFOFORMID"));
                m_appMap.put("LIMITINFO", rs.getString("LIMITINFO"));
                m_appMap.put("TABLENAME", rs.getString("TABLENAME"));
                m_appMap.put("DATASOURCENAME", rs.getString("DATASOURCENAME"));
                m_appMap.put("DATAUSERNAME", rs.getString("DATAUSERNAME"));
                m_appMap.put("SHOWNAMECOL", rs.getString("SHOWNAMECOL"));
                m_appMap.put("PKCOL", rs.getString("PKCOL"));
                m_appMap.put("PICPATH", rs.getString("PICPATH"));
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return m_appMap;
    }

    @Override
    public ArrayList<HashMap<String, String>> getAppLinksInfo(String appId) throws Exception {
        StringBuffer sb = new StringBuffer();
        RowSet rs = null;
        ArrayList<HashMap<String, String>> appLinks = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> tempMap = null;
        sb.append("select AL.LINKID,AL.SHOWTYPE,AL.GROUPCOLUMN,AL.ATTGROUP,AL.GROUPORDERBY,AL.SHOWORDER");
        sb.append(",L.PTABLEID,L.PKEYCOLUMNID,L.CTABLEID,L.LINKCOLUMNID");
        sb.append(" from [S].JXD7_XT_LINKAPPLINK AL,[S].JXD7_XT_LINKINFO L");
        sb.append(" where AL.LINKID=L.LINKID AND APPID='").append(appId).append("'");
        sb.append(" order by AL.SHOWORDER");
        try {
            rs = DbOper.executeQuery((String)"defaultds", (String)sb.toString());
            while (rs.next()) {
                tempMap = new HashMap<String, String>();
                tempMap.put("LINKID", rs.getString("LINKID"));
                tempMap.put("SHOWTYPE", String.valueOf(rs.getInt("SHOWTYPE")));
                tempMap.put("GROUPCOLUMN", rs.getString("GROUPCOLUMN"));
                tempMap.put("ATTGROUP", rs.getString("ATTGROUP"));
                tempMap.put("GROUPORDERBY", rs.getString("GROUPORDERBY"));
                tempMap.put("SHOWORDER", String.valueOf(rs.getString("SHOWORDER")));
                tempMap.put("PTABLEID", rs.getString("PTABLEID"));
                tempMap.put("PKEYCOLUMNID", rs.getString("PKEYCOLUMNID"));
                tempMap.put("CTABLEID", rs.getString("CTABLEID"));
                tempMap.put("LINKCOLUMNID", rs.getString("LINKCOLUMNID"));
                appLinks.add(tempMap);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return appLinks;
    }

    @Override
    public ArrayList<HashMap<String, String>> getAppLinkTablesInfo(String appId) throws Exception {
        StringBuffer sb = new StringBuffer();
        RowSet rs = null;
        ArrayList<HashMap<String, String>> appLinkTables = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> tempMap = null;
        sb.append("select AT.TABLEID,AT.ATTCOLUMN,AT.ATTTABLE,AT.FILTER,AT.LINKID,AT.LISTJMID,AT.INFOJMID,AT.LISTFORMID,AT.INFOFORMID,AT.ISSHOWINFO,AT.LIMITINFO,AT.ORDERBY");
        sb.append(",TI.TABLENAME,TI.SHOWNAMECOL,TI.PKCOL,TI.PICPATH,TI.DATAUSERNAME");
        sb.append(" from [S].JXD7_XT_LINKAPPTABLE AT,[S].JXD7_XT_SYSTABLEINFO TI ");
        sb.append(" where AT.TABLEID=TI.TABLEID");
        sb.append(" and AT.APPID='").append(appId).append("'");
        try {
            rs = DbOper.executeQuery((String)"defaultds", (String)sb.toString());
            while (rs.next()) {
                tempMap = new HashMap<String, String>();
                tempMap.put("TABLEID", rs.getString("TABLEID"));
                tempMap.put("LINKID", rs.getString("LINKID"));
                tempMap.put("ATTCOLUMN", rs.getString("ATTCOLUMN"));
                tempMap.put("ATTTABLE", rs.getString("ATTTABLE"));
                tempMap.put("FILTER", rs.getString("FILTER"));
                tempMap.put("LISTJMID", rs.getString("LISTJMID"));
                tempMap.put("INFOJMID", rs.getString("INFOJMID"));
                tempMap.put("LISTFORMID", rs.getString("LISTFORMID"));
                tempMap.put("INFOFORMID", rs.getString("INFOFORMID"));
                tempMap.put("ISSHOWINFO", rs.getString("ISSHOWINFO"));
                tempMap.put("LIMITINFO", rs.getString("LIMITINFO"));
                tempMap.put("ORDERBY", rs.getString("ORDERBY"));
                tempMap.put("TABLENAME", rs.getString("TABLENAME"));
                tempMap.put("DATAUSERNAME", rs.getString("DATAUSERNAME"));
                tempMap.put("SHOWNAMECOL", rs.getString("SHOWNAMECOL"));
                tempMap.put("PKCOL", rs.getString("PKCOL"));
                tempMap.put("PICPATH", rs.getString("PICPATH"));
                appLinkTables.add(tempMap);
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return appLinkTables;
    }

    @Override
    public ArrayList<TreeNodeBo> getLinkAppRootNodeArray(String appId, CellProjectTree.Table topTable, ArrayList<HashMap<String, String>> links, ArrayList<HashMap<String, String>> tables) throws SQLException {
        ArrayList<TreeNodeBo> rootNodeArray = new ArrayList<TreeNodeBo>(1000);
        String rootNodeSql = this.getTreeRootNodeSql(topTable);
        String nodeKey = String.valueOf(topTable.getTableId()) + "__0_";
        rootNodeSql = HussarString.replaceKeyWord(rootNodeSql);
        RowSet rs = DbOper.executeQuery((String)topTable.getDataSourceName(), (String)rootNodeSql);
        String value = "";
        StringBuffer nodeSheetids = new StringBuffer();
        while (rs.next()) {
            String id = rs.getString("SHEETID");
            nodeSheetids.append("'").append(id).append("',");
            String name = this.getNodeShowName(rs, topTable.getNameColumn());
            String nodeGuid = Guid.create();
            TreeNodeBo node = new TreeNodeBo();
            node.setObjectId(id);
            node.setId(nodeGuid);
            node.setText(name);
            node.setTableId(topTable.getTableId());
            node.setParentObjectId("");
            node.setParentId("");
            node.setGetData(false);
            String picPath = topTable.getPicPath();
            if (picPath == null || picPath.length() == 0) {
                picPath = "/pms/platform/image/folder2.gif";
            }
            node.setIconSrc(String.valueOf(Global.getContextPath()) + picPath);
            int i = 1;
            while (i <= rs.getMetaData().getColumnCount()) {
                String key = rs.getMetaData().getColumnName(i);
                if (!key.equals("SHEETID") && !key.equals("SHEETNAME")) {
                    Object o = rs.getObject(key);
                    value = o != null ? o.toString() : "";
                    node.attachField.put(key, value);
                }
                ++i;
            }
            rootNodeArray.add(node);
        }
        String sheetids = null;
        if (nodeSheetids != null && nodeSheetids.length() > 0) {
            sheetids = nodeSheetids.substring(0, nodeSheetids.length() - 1);
        }
        HashMap<String, String> hasChildNodesSheetID = this.getHasChildNodesSheetID(topTable.getTableId(), "", "0", topTable.getDataUserName(), topTable.getTableName(), topTable.getKeyColumn(), topTable.getKeyColumn(), sheetids, topTable.getDataSourceName(), appId, links, tables);
        for (TreeNodeBo node : rootNodeArray) {
            if (node == null) continue;
            if (hasChildNodesSheetID.containsKey(String.valueOf(nodeKey) + node.getObjectId()) || hasChildNodesSheetID.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                node.setHasChilds(true);
                continue;
            }
            node.setHasChilds(false);
        }
        return rootNodeArray;
    }

    @Override
    public ArrayList<TreeNodeBo> getLinkAppTableNodeArray(String appId, String dataSourceName, String tableId, String linkId, String sheetId, String isGroup, String gId, String parentNodeGuid, ArrayList<HashMap<String, String>> links, ArrayList<HashMap<String, String>> tables) throws SQLException {
        LinkAppTable lat = null;
        ArrayList<LinkAppTable> list = new ArrayList<LinkAppTable>();
        List latList = null;
        RowSet rs = null;
        HashMap tmpMap = null;
        latList = this.getLinkAppTable(tableId, linkId, isGroup, appId, links, tables);
        int i = 0;
        while (i < latList.size()) {
            tmpMap = (HashMap)latList.get(i);
            lat = new LinkAppTable();
            lat.setAppId(appId);
            lat.setTableId((String)tmpMap.get("TABLEID"));
            lat.setTableName((String)tmpMap.get("TABLENAME"));
            lat.setAttColumn((String)tmpMap.get("ATTCOLUMN"));
            lat.setAttTable((String)tmpMap.get("ATTTABLE"));
            lat.setFilter((String)tmpMap.get("FILTER"));
            lat.setOrderBy((String)tmpMap.get("ORDERBY"));
            lat.setNameColumn((String)tmpMap.get("SHOWNAMECOL"));
            lat.setKeyColumn((String)tmpMap.get("PKCOL"));
            lat.setPicPath((String)tmpMap.get("PICPATH"));
            lat.setTableName((String)tmpMap.get("TABLENAME"));
            lat.setDataUserName((String)tmpMap.get("DATAUSERNAME"));
            lat.setLinkColumn((String)tmpMap.get("LINKCOLUMNID"));
            lat.setLinkId((String)tmpMap.get("LINKID"));
            lat.setLimitId((String)tmpMap.get("LIMITINFO"));
            if (!"1".equals(isGroup)) {
                lat.setShowType(Integer.parseInt((String)tmpMap.get("SHOWTYPE")));
            }
            lat.setGroupColumn((String)tmpMap.get("GROUPCOLUMN"));
            lat.setGroupOrderby((String)tmpMap.get("GROUPORDERBY"));
            if (tmpMap.get("ATTGROUP") == null) {
                lat.setAttachGroup("");
            } else {
                lat.setAttachGroup((String)tmpMap.get("ATTGROUP"));
            }
            list.add(lat);
            ++i;
        }
        StringBuffer[] arrSB = new StringBuffer[list.size()];
        ArrayList<TreeNodeBo> nodeArray = new ArrayList<TreeNodeBo>(1000);
        String[] attachGroupNodeText = new String[list.size()];
        boolean curAttachGroupNodeText = false;
        if (list.size() != 0) {
            int j = 0;
            while (j < list.size()) {
                lat = (LinkAppTable)list.get(j);
                if (lat != null) {
                    TreeNodeBo node;
                    String nodeGuid;
                    String sql;
                    HashMap<String, String> hasChildNodesSheetID;
                    arrSB[j] = new StringBuffer();
                    if (SheetConstants.LINK_SHOW_TYPE.isDirect((int)lat.getShowType())) {
                        String nodeKey = String.valueOf(lat.getTableId()) + "__0_";
                        hasChildNodesSheetID = this.getHasChildNodesSheetID(lat.getTableId(), "", "0", lat.getDataUserName(), lat.getTableName(), lat.getLinkColumn(), lat.getKeyColumn(), sheetId, dataSourceName, appId, links, tables);
                        sql = this.getLinkAppTableNodeSQL(lat, sheetId, isGroup, gId);
                        sql = HussarString.replaceKeyWord(sql);
                        sql = HussarString.replace(sql, "='" + Constants.resources_blankRootNodeId + "'", " is null");
                        try {
                            rs = DbOper.executeQuery((String)dataSourceName, (String)sql);
                            String value = "";
                            while (rs.next()) {
                                String picpath = lat.getPicPath();
                                if (picpath == null || picpath.length() == 0) {
                                    try {
                                        if (rs.getObject("PICPATH") != null) {
                                            picpath = rs.getString("PICPATH");
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (picpath == null || picpath.length() == 0) {
                                    picpath = "/pms/platform/image/folder2.gif";
                                }
                                String id = rs.getString("SHEETID");
                                String name = this.getNodeShowName(rs, lat.getNameColumn());
                                nodeGuid = Guid.create();
                                node = new TreeNodeBo();
                                node.setObjectId(rs.getString("SHEETID"));
                                node.setId(nodeGuid);
                                node.setText(this.getNodeShowName(rs, lat.getNameColumn()));
                                node.setTableId(lat.getTableId());
                                node.setParentObjectId(sheetId);
                                node.setLinkId(lat.getLinkId());
                                node.setExpanded(false);
                                node.setParentId(parentNodeGuid);
                                node.setIconSrc(String.valueOf(Global.getContextPath()) + picpath);
                                node.setGroup("0");
                                int i2 = 1;
                                while (i2 <= rs.getMetaData().getColumnCount()) {
                                    String key = rs.getMetaData().getColumnName(i2);
                                    if (!key.equals("SHEETID") && !key.equals("SHEETNAME")) {
                                        Object o = rs.getObject(key);
                                        value = o != null ? o.toString() : "";
                                        node.attachField.put(key, value);
                                    }
                                    ++i2;
                                }
                                node.setGetData(false);
                                if (hasChildNodesSheetID.containsKey(String.valueOf(nodeKey) + id) || hasChildNodesSheetID.containsKey(String.valueOf(nodeKey) + "AllSheetIDContains")) {
                                    node.setHasChilds(true);
                                } else {
                                    node.setHasChilds(false);
                                }
                                nodeArray.add(node);
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            daoLogger.error((Object)("getLinkAppTableNodeInfo(String appId, String tableId)\u62a5\u95192\uff1a" + e.getMessage()));
                            throw e;
                        }
                    }
                    if (SheetConstants.LINK_SHOW_TYPE.isGroup((int)lat.getShowType()) && lat.getAttachGroup().length() == 0) {
                        sql = this.getColumnPropertyInfo(lat.getTableId(), lat.getGroupColumn());
                        boolean isIdStrPicker = false;
                        String assitInfo = "";
                        String meanType = "";
                        String meanDataSourceName = "";
                        try {
                            rs = DbOper.executeQuery((String)"defaultds", (String)sql);
                            if (rs.next()) {
                                meanType = rs.getString("MEANTYPE");
                                assitInfo = rs.getString("ASSITINFO");
                                meanDataSourceName = rs.getString("DATASOURCENAME");
                            }
                        }
                        catch (Exception e) {
                            daoLogger.error((Object)("getLinkAppTableNodeInfo(String appId, String tableId)\u62a5\u95193\uff1a" + e.getMessage()));
                        }
                        if (meanType.length() != 0 && meanType.equals("IDStringPicker")) {
                            isIdStrPicker = true;
                        }
                        ArrayList<String> nodeNames = new ArrayList<String>();
                        ArrayList<String> nodeValues = new ArrayList<String>();
                        sql = this.getLinkAppTableGroupNodeSQL(lat, sheetId);
                        sql = HussarString.replaceKeyWord(sql);
                        try {
                            rs = DbOper.executeQuery((String)dataSourceName, (String)sql);
                            while (rs.next()) {
                                if (rs.getString("GROUPNAME") == null) {
                                    nodeValues.add("");
                                    continue;
                                }
                                nodeValues.add(rs.getString("GROUPNAME"));
                            }
                        }
                        catch (Exception e) {
                            daoLogger.error((Object)("getLinkAppTableNodeInfo(String appId, String tableId)\u62a5\u95194\uff1a" + e.getMessage()));
                        }
                        if (isIdStrPicker) {
                            assitInfo = HussarString.replaceKeyWord(assitInfo);
                            List options = ((PatternDao)BeanFactory.getSingleInstance((String)"PatternDao")).getdropDownOption(meanDataSourceName, assitInfo, null);
                            int i3 = 0;
                            while (i3 < nodeValues.size()) {
                                String value = nodeValues.get(i3) == null ? "" : nodeValues.get(i3).toString();
                                boolean hasName = false;
                                int k = 0;
                                while (k < options.size()) {
                                    DropDownOptionBean option = (DropDownOptionBean)options.get(k);
                                    if (option.getOptionValue().equals(value.trim())) {
                                        nodeNames.add(option.getOptionText());
                                        hasName = true;
                                        break;
                                    }
                                    ++k;
                                }
                                if (!hasName) {
                                    nodeNames.add(value);
                                }
                                ++i3;
                            }
                        }
                        int k = 0;
                        while (k < nodeValues.size()) {
                            nodeGuid = Guid.create();
                            String id = nodeValues.get(k).toString();
                            String name = nodeNames.size() != 0 ? nodeNames.get(k).toString() : id;
                            if (name.length() == 0) {
                                name = "\u7a7a";
                            }
                            TreeNodeBo node2 = new TreeNodeBo();
                            node2.setObjectId(sheetId);
                            node2.setGId(id);
                            node2.setId(nodeGuid);
                            node2.setText(name);
                            node2.setTableId(lat.getTableId());
                            node2.setParentObjectId(sheetId);
                            node2.setLinkId(lat.getLinkId());
                            node2.setExpanded(false);
                            node2.setParentId(parentNodeGuid);
                            node2.setIconSrc(String.valueOf(Global.getContextPath()) + "/pms/platform/image/folder1.gif");
                            node2.setGroup("1");
                            node2.setGetData(false);
                            node2.setHasChilds(true);
                            nodeArray.add(node2);
                            ++k;
                        }
                    } else if (SheetConstants.LINK_SHOW_TYPE.isGroup((int)lat.getShowType()) && lat.getAttachGroup().length() != 0) {
                        String attachGroup = lat.getAttachGroup();
                        String[] arrAttachGroup = attachGroup.split("\\|");
                        hasChildNodesSheetID = this.getHasChildNodesSheetID(lat.getTableId(), lat.getLinkId(), "1", "", null, null, null, null, dataSourceName, appId, links, tables);
                        boolean hasChild = hasChildNodesSheetID.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_" + sheetId) || hasChildNodesSheetID.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_AllSheetIDContains");
                        boolean exsit = false;
                        int i4 = 0;
                        while (i4 < nodeArray.size()) {
                            if (nodeArray.get(i4).getText().equals(arrAttachGroup[0])) {
                                exsit = true;
                                break;
                            }
                            ++i4;
                        }
                        if (!exsit) {
                            String id = arrAttachGroup[0];
                            nodeGuid = Guid.create();
                            node = new TreeNodeBo();
                            node.setObjectId(sheetId);
                            node.setGId("\u9644\u52a0\u5206\u7ec4" + sheetId);
                            node.setId(nodeGuid);
                            node.setText(id);
                            node.setTableId(lat.getTableId());
                            node.setParentObjectId(sheetId);
                            node.setParentId(parentNodeGuid);
                            node.setLinkId(lat.getLinkId());
                            node.setExpanded(false);
                            node.setIconSrc(String.valueOf(Global.getContextPath()) + "/pms/platform/image/folder1.gif");
                            node.setGroup("1");
                            if (arrAttachGroup.length > 1) {
                                node.setGetData(true);
                                ArrayList<TreeNodeBo> childNodes = this.createAttachGroupNode(list, String.valueOf(arrAttachGroup[0]) + "|", sheetId, appId, dataSourceName, nodeGuid, links, tables);
                                node.setChilds(childNodes);
                            } else if (arrAttachGroup.length == 1) {
                                node.setGetData(false);
                                if (hasChild) {
                                    node.setHasChilds(true);
                                } else {
                                    node.setHasChilds(false);
                                }
                            }
                            nodeArray.add(node);
                        }
                    }
                }
                ++j;
            }
        }
        return nodeArray;
    }

    private ArrayList<TreeNodeBo> createAttachGroupNode(List latList, String groupName, String sheetId, String appId, String dataSourceName, String parentNodeGuid, ArrayList<HashMap<String, String>> links, ArrayList<HashMap<String, String>> tables) {
        ArrayList<TreeNodeBo> newAttachGroupNode = new ArrayList<TreeNodeBo>(latList.size());
        LinkAppTable lat = null;
        boolean curLen = false;
        String[] attachGroupNodeText = new String[latList.size()];
        boolean curAttachGroupNodeText = false;
        int i = 0;
        while (i < latList.size()) {
            lat = (LinkAppTable)latList.get(i);
            String attachGroup = lat.getAttachGroup();
            if (SheetConstants.LINK_SHOW_TYPE.isGroup((int)lat.getShowType()) && lat.getAttachGroup().length() != 0 && attachGroup.startsWith(groupName)) {
                String subNodes = attachGroup.substring(groupName.length());
                String id = subNodes.split("\\|")[0];
                boolean exsit = false;
                int k = 0;
                while (k < newAttachGroupNode.size()) {
                    if (newAttachGroupNode.get(k).getText().equals(id)) {
                        exsit = true;
                        break;
                    }
                    ++k;
                }
                if (!exsit) {
                    HashMap<String, String> hasChildNodesSheetID = this.getHasChildNodesSheetID(lat.getTableId(), lat.getLinkId(), "1", "", null, null, null, null, dataSourceName, appId, links, tables);
                    boolean hasChild = hasChildNodesSheetID.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_" + sheetId) || hasChildNodesSheetID.containsKey(String.valueOf(lat.getTableId()) + "_" + lat.getLinkId() + "_1_AllSheetIDContains");
                    String nodeGuid = Guid.create();
                    TreeNodeBo newNode = new TreeNodeBo();
                    newNode.setObjectId(sheetId);
                    newNode.setGId("\u9644\u52a0\u5206\u7ec4" + sheetId);
                    newNode.setId(nodeGuid);
                    newNode.setText(id);
                    newNode.setTableId(lat.getTableId());
                    newNode.setParentObjectId(sheetId);
                    newNode.setParentId(parentNodeGuid);
                    newNode.setLinkId(lat.getLinkId());
                    newNode.setExpanded(false);
                    newNode.setIconSrc(String.valueOf(Global.getContextPath()) + "/pms/platform/image/folder1.gif");
                    newNode.setGroup("1");
                    if (subNodes.split("\\|").length > 1) {
                        newNode.setGetData(true);
                        ArrayList<TreeNodeBo> childNodes = this.createAttachGroupNode(latList, String.valueOf(groupName) + subNodes.split("\\|")[0] + "|", sheetId, appId, dataSourceName, nodeGuid, links, tables);
                        newNode.setChilds(childNodes);
                    } else if (subNodes.split("\\|").length == 1) {
                        if (hasChild) {
                            newNode.setGetData(false);
                            newNode.setHasChilds(true);
                        } else {
                            newNode.setGetData(true);
                            newNode.setHasChilds(false);
                        }
                    }
                    newAttachGroupNode.add(newNode);
                }
            }
            ++i;
        }
        return newAttachGroupNode;
    }

    private String getNodeShowName(RowSet rs, String nameField) {
        String nodeShowName = nameField;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= columnCount) {
                if (nodeShowName.equals(rsmd.getColumnName(i))) {
                    nodeShowName = rs.getObject(nodeShowName).toString();
                    break;
                }
                String fieldValue = "";
                if (rs.getObject(rsmd.getColumnName(i)) != null) {
                    fieldValue = rs.getObject(rsmd.getColumnName(i)).toString();
                }
                nodeShowName = HussarString.replace(nodeShowName, "[" + rsmd.getColumnName(i) + "]", fieldValue);
                ++i;
            }
        }
        catch (Exception e) {
            daoLogger.error((Object)e.getMessage());
            e.printStackTrace();
            nodeShowName = "";
        }
        return nodeShowName;
    }

    private HashMap<String, String> getHasChildNodesSheetID(String tableId, String linkId, String isGroup, String parentDataUserName, String parentTableName, String parentLinkColumn, String parentPKColumn, String parentSheetIds, String parentDataSource, String appId, ArrayList<HashMap<String, String>> links, ArrayList<HashMap<String, String>> tables) {
        HashMap<String, String> m_hasChildsMap = new HashMap<String, String>();
        LinkAppTable lat = null;
        ArrayList<LinkAppTable> list = new ArrayList<LinkAppTable>();
        List latList = null;
        RowSet rs = null;
        HashMap tmpMap = null;
        String nodeKey = String.valueOf(tableId) + "_" + linkId + "_" + isGroup + "_";
        if (m_hasChildsMap.containsKey(String.valueOf(nodeKey) + "isLoaded_abc!@#$") && parentTableName == null) {
            return m_hasChildsMap;
        }
        m_hasChildsMap.put(String.valueOf(nodeKey) + "isLoaded_abc!@#$", String.valueOf(nodeKey) + "isLoaded_abc!@#$");
        latList = this.getLinkAppTable(tableId, linkId, isGroup, appId, links, tables);
        int i = 0;
        while (i < latList.size()) {
            tmpMap = (HashMap)latList.get(i);
            lat = new LinkAppTable();
            lat.setAppId(appId);
            lat.setTableId((String)tmpMap.get("TABLEID"));
            lat.setAttColumn((String)tmpMap.get("ATTCOLUMN"));
            lat.setAttTable((String)tmpMap.get("ATTTABLE"));
            lat.setFilter((String)tmpMap.get("FILTER"));
            lat.setOrderBy((String)tmpMap.get("ORDERBY"));
            lat.setNameColumn((String)tmpMap.get("SHOWNAMECOL"));
            lat.setKeyColumn((String)tmpMap.get("PKCOL"));
            lat.setPicPath((String)tmpMap.get("PICPATH"));
            lat.setTableName((String)tmpMap.get("TABLENAME"));
            lat.setDataUserName((String)tmpMap.get("DATAUSERNAME"));
            lat.setLinkColumn((String)tmpMap.get("LINKCOLUMNID"));
            lat.setShowType(Integer.parseInt((String)tmpMap.get("SHOWTYPE")));
            lat.setGroupColumn((String)tmpMap.get("GROUPCOLUMN"));
            lat.setGroupOrderby((String)tmpMap.get("GROUPORDERBY"));
            if (tmpMap.get("ATTGROUP") == null) {
                lat.setAttachGroup("");
            } else {
                lat.setAttachGroup((String)tmpMap.get("ATTGROUP"));
            }
            lat.setLimitId((String)tmpMap.get("LIMITINFO"));
            list.add(lat);
            ++i;
        }
        if (list.size() != 0) {
            int j = 0;
            while (j < list.size()) {
                lat = (LinkAppTable)list.get(j);
                if (lat != null) {
                    if (lat.getAttachGroup() != null && lat.getAttachGroup().length() > 0) {
                        m_hasChildsMap.put(String.valueOf(nodeKey) + "AllSheetIDContains", "AllSheetIDContains");
                        return m_hasChildsMap;
                    }
                    String sql = this.getSimpleLinkAppTableNodeSQL(lat, parentDataUserName, parentTableName, parentLinkColumn, parentPKColumn, parentSheetIds);
                    sql = HussarString.replaceKeyWord(sql);
                    try {
                        rs = DbOper.executeQuery((String)parentDataSource, (String)sql);
                        while (rs.next()) {
                            if (m_hasChildsMap.containsKey(String.valueOf(nodeKey) + rs.getString("SHEETID"))) continue;
                            m_hasChildsMap.put(String.valueOf(nodeKey) + rs.getString("SHEETID"), rs.getString("SHEETID"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                ++j;
            }
        }
        return m_hasChildsMap;
    }

    private List getLinkAppTable(String tableId, String linkId, String isGroup, String appId, ArrayList<HashMap<String, String>> links, ArrayList<HashMap<String, String>> tables) {
        ArrayList list;
        block11: {
            if (appId.equals("")) {
                return null;
            }
            list = new ArrayList();
            if ("1".equals(isGroup)) {
                HashMap<String, String> linkAppTableMap = new HashMap<String, String>();
                int i = 0;
                while (i < links.size()) {
                    HashMap<String, String> tmpMap = links.get(i);
                    String temp = tmpMap.get("LINKID");
                    if (temp.equals(linkId)) {
                        linkAppTableMap.putAll(tmpMap);
                        int j = 0;
                        while (j < tables.size()) {
                            tmpMap = tables.get(j);
                            temp = tmpMap.get("LINKID");
                            if (temp.equals(linkId) && (temp = tmpMap.get("TABLEID")).equals(tableId)) {
                                linkAppTableMap.putAll(tmpMap);
                                list.add(linkAppTableMap);
                                break block11;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < links.size()) {
                    HashMap<String, String> linkAppTableMap = new HashMap<String, String>();
                    HashMap<String, String> tmpMap = links.get(i);
                    String temp = tmpMap.get("PTABLEID");
                    if (temp.equals(tableId)) {
                        linkAppTableMap.putAll(tmpMap);
                        int j = 0;
                        while (j < tables.size()) {
                            tmpMap = tables.get(j);
                            temp = tmpMap.get("LINKID");
                            if (temp.equals(linkAppTableMap.get("LINKID"))) {
                                linkAppTableMap.putAll(tmpMap);
                                list.add(linkAppTableMap);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return list;
    }

    public String getSimpleLinkAppTableNodeSQL(LinkAppTable lat, String parentDataUserName, String parentTableName, String parentLinkColumn, String parentPKColumn, String parentSheetId) {
        StringBuffer sb = new StringBuffer();
        if (parentTableName == null) {
            sb.append(" SELECT DISTINCT T.").append(lat.getLinkColumn()).append(" AS SHEETID ");
            sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
            if (lat.getAttTable() != null && lat.getAttTable().length() != 0) {
                sb.append("," + lat.getAttTable());
            }
            if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
                sb.append(" WHERE ").append(lat.getAllFilter());
            }
        } else {
            sb.append(" SELECT DISTINCT T.").append(lat.getLinkColumn()).append(" AS SHEETID ");
            sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
            if (lat.getAttTable() != null && lat.getAttTable().length() != 0) {
                sb.append("," + lat.getAttTable());
            }
            sb.append(", ").append(parentDataUserName).append(parentTableName);
            sb.append(" WHERE T.").append(lat.getLinkColumn()).append("=").append(parentDataUserName).append(parentTableName).append(".").append(parentPKColumn);
            if (parentLinkColumn != null) {
                if (parentSheetId != null) {
                    if (!parentSheetId.startsWith("'") && !parentSheetId.endsWith("'")) {
                        sb.append(" AND ").append(parentDataUserName).append(parentTableName).append(".").append(parentLinkColumn).append(" ='").append(parentSheetId).append("'");
                    } else {
                        sb.append(" AND ").append(parentDataUserName).append(parentTableName).append(".").append(parentLinkColumn).append(" IN (").append(parentSheetId).append(")");
                    }
                } else {
                    sb.append(" AND ").append(parentDataUserName).append(parentTableName).append(".").append(parentLinkColumn).append(" IS NULL");
                }
            }
            if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
                sb.append(" AND ").append(lat.getAllFilter());
            }
        }
        return sb.toString();
    }

    private String getTreeRootNodeSql(CellProjectTree.Table topTable) {
        StringBuffer rootNodeSql = new StringBuffer();
        rootNodeSql.append(" SELECT T.").append(topTable.getKeyColumn()).append(" AS SHEETID ");
        if (topTable.getAttField() != null && topTable.getAttField().length() != 0) {
            rootNodeSql.append("," + topTable.getAttField());
        }
        rootNodeSql.append(" FROM ").append(topTable.getDataUserName()).append(topTable.getTableName()).append(" T ");
        if (topTable.getAttTable() != null && topTable.getAttTable().length() != 0) {
            rootNodeSql.append("," + topTable.getAttTable());
        }
        if (topTable.getFilter() != null && topTable.getFilter().length() != 0) {
            rootNodeSql.append(" WHERE ").append(topTable.getFilter());
        }
        if (topTable.getFilterOfLimit() != null && topTable.getFilterOfLimit() != "") {
            rootNodeSql.append(" AND (").append(topTable.getFilterOfLimit()).append(")");
        }
        if (topTable.getOrderBy() != null && topTable.getOrderBy().length() != 0) {
            rootNodeSql.append(" ORDER BY ").append(topTable.getOrderBy());
        }
        return rootNodeSql.toString();
    }

    private String getLinkAppTableNodeSQL(LinkAppTable lat, String sheetId, String isGroup, String gId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT T.").append(lat.getKeyColumn()).append(" AS SHEETID ");
        if (lat.getAttField() != null && lat.getAttField().length() != 0) {
            sb.append("," + lat.getAttField());
        }
        sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
        if (lat.getAttTable() != null && lat.getAttTable().length() != 0) {
            sb.append("," + lat.getAttTable());
        }
        sb.append(" WHERE ").append(" (T.").append(lat.getLinkColumn()).append(")='").append(sheetId.trim()).append("'");
        if ("1".equals(isGroup) && (gId == null || !gId.startsWith("\u9644\u52a0\u5206\u7ec4"))) {
            if (gId == null || gId.length() == 0) {
                sb.append(" AND  (T.").append(lat.getGroupColumn());
                sb.append(" IS NULL  OR T.").append(lat.getGroupColumn()).append("='')");
            } else {
                sb.append(" AND  T.").append(lat.getGroupColumn());
                sb.append(" ='").append(gId).append("'");
            }
        }
        if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
            sb.append(" AND ").append(lat.getAllFilter());
        }
        if (lat.getOrderBy() != null && lat.getOrderBy().length() != 0) {
            sb.append(" ORDER BY ").append(lat.getOrderBy());
        }
        return sb.toString();
    }

    public String getColumnPropertyInfo(String tableId, String columnName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.MEANTYPE, A.ASSITINFO,A.DATASOURCENAME  FROM ");
        sb.append("[S].JXD7_XT_COLUMNS C ,");
        sb.append("[S].JXD7_XT_ATTRIMEAN A ");
        sb.append(" WHERE A.MEANID=C.COLMEANID AND C.TABLEID='").append(tableId).append("' AND  C.COLUMNID='").append(columnName).append("'");
        return sb.toString();
    }

    public String getLinkAppTableGroupNodeSQL(LinkAppTable lat, String sheetId) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T.").append(lat.getGroupColumn()).append(" AS GROUPNAME ");
        sb.append(" FROM ").append(lat.getDataUserName()).append(lat.getTableName()).append(" T ");
        sb.append(" WHERE T.").append(lat.getLinkColumn()).append(" ='").append(sheetId).append("'");
        if (lat.getAllFilter() != null && lat.getAllFilter().length() != 0) {
            sb.append(" AND ").append(lat.getAllFilter());
        }
        sb.append(" GROUP BY T.").append(lat.getGroupColumn());
        sb.append(" ORDER BY T.").append(lat.getGroupColumn()).append(" ").append(lat.getGroupOrderby());
        return sb.toString();
    }

    @Override
    public boolean conformFilter(String dataSourceName, String tableName, String pkCol, String formInstanceId, String filter) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer("SELECT 1 FROM ");
        sql.append(tableName);
        sql.append("  WHERE ");
        sql.append(pkCol);
        sql.append("='");
        sql.append(formInstanceId);
        sql.append("' AND ");
        sql.append(filter);
        RowSet vidrs = DbOper.executeQuery((String)dataSourceName, (String)sql.toString());
        if (vidrs.next()) {
            result = true;
        }
        return result;
    }

    @Override
    public Map<String, String> getWaitDoInfo(String dataSourceName, String tableName, String pkCol, String waitDoId, String filter) throws SQLException {
        HashMap<String, String> waitDoInfo = null;
        StringBuffer sql = new StringBuffer("SELECT * FROM ");
        sql.append(tableName).append(" WHERE ").append(pkCol).append("='").append(waitDoId).append("'");
        RowSet waitDoRs = DbOper.executeQuery((String)sql.toString());
        if (waitDoRs.next()) {
            waitDoInfo = new HashMap<String, String>();
            String openurl = waitDoRs.getString("OPERURL");
            if (!HussarString.isEmpty(openurl)) {
                String gwslIDTemp = openurl.substring(openurl.indexOf("h_formInstanceId=") + 17);
                waitDoInfo.put("formInstanceId", gwslIDTemp.substring(0, gwslIDTemp.indexOf("&")).trim());
                String h_flowIdTemp = openurl.substring(openurl.indexOf("h_flowId=") + 9);
                waitDoInfo.put("flowId", h_flowIdTemp.substring(0, h_flowIdTemp.indexOf("&")).trim());
                String h_flowNodeIdTemp = openurl.substring(openurl.indexOf("h_flowNodeId=") + 13);
                waitDoInfo.put("flowNodeId", h_flowNodeIdTemp.substring(0, h_flowNodeIdTemp.indexOf("&")).trim());
            }
        }
        return waitDoInfo;
    }
}

