/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo.container;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.Cache;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.bo.IEntityPropertyBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityInstanceBo;
import com.sdjxd.hussar.core.entity72.service.IEntityService;
import com.sdjxd.hussar.core.form72.bo.FormCellEvent;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.IFormArea;
import com.sdjxd.hussar.core.form72.bo.IFormCellBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.bo.container.CellContainer;
import com.sdjxd.hussar.core.form72.dao.FormPatternDao;
import com.sdjxd.hussar.core.form72.platEntity72.bo.IPlatEntityPatternBo;
import com.sdjxd.hussar.core.form72.platEntity72.bo.support.PlatEntityInstanceBo;
import com.sdjxd.hussar.core.form72.platEntity72.service.IPlatEntityservice;
import com.sdjxd.hussar.core.form72.po.FormAreaPo;
import com.sdjxd.hussar.core.form72.po.FormCellEventPo;
import com.sdjxd.hussar.core.form72.po.FormCellPo;
import com.sdjxd.hussar.core.form72.po.FormPatternPo;
import com.sdjxd.hussar.core.form72.po.FormScale;
import com.sdjxd.hussar.core.permit72.IPermitController;
import com.sdjxd.hussar.core.permit72.bo.ILimitGroupBo;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.pms.platform.tool.PublicTool;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormPatternBo
extends CellContainer
implements IFormPatternBo {
    private static final int MAX_SIZE = 5000;
    private static Logger log = Logger.getLogger(FormPatternBo.class);
    private static final Cache<IFormPatternBo> cache = Global.createCache(IFormPatternBo.class, 1000);
    protected static FormPatternDao dao;
    public static Map<Integer, String> defaultSkinStyle;
    public static final int Cel1Type = 512;
    public static String FOrmType;
    public static String RunType;
    private static int L1STFORM;
    public static final int Ce11Type = 512;
    public static int F0rmType;
    public static int Version;
    protected String moduleId;
    protected int patternType;
    protected int sheetSize;
    protected Date modifyTime = null;
    protected IEntityPatternBo entityPattern = null;
    protected IPlatEntityPatternBo platEntityPattern = null;
    protected IFormCellBo[] allCellArray = new IFormCellBo[5000];
    protected Const.Form.Position position;
    @Expose(serialize=true, deserialize=true)
    protected HashMap<Integer, FormCellEvent> patternEvents = new HashMap();
    @Expose(serialize=true, deserialize=true)
    protected Map<String, ILimitGroupBo> limitGroups;
    @Expose(serialize=true, deserialize=true)
    protected ArrayList<String> jsFiles;
    protected String usedLimitGroupIds;

    static {
        FOrmType = "0";
        RunType = "0";
        L1STFORM = 6;
        F0rmType = -1;
        Version = 1;
        if (com.sdjxd.pms.platform.base.Global.version != null && com.sdjxd.pms.platform.base.Global.version.equals("0")) {
            F0rmType = Version;
        } else {
            FOrmType = RunType;
        }
        try {
            dao = Factory.getDao(FormPatternDao.class);
            defaultSkinStyle = dao.getDefaultSkinStyle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getUsedLimitGroupIds() {
        return this.usedLimitGroupIds;
    }

    protected FormPatternBo() {
    }

    @Override
    public IFormCellBo[] getAllCellArray() {
        return this.allCellArray;
    }

    @Override
    public IFormPatternBo load(String formPatternId) throws Exception {
        IFormPatternBo formPattern;
        L1STFORM += F0rmType;
        if (AppConfig.getModel().equalsIgnoreCase("debug")) {
            formPattern = this.loadFormDb(formPatternId);
        } else {
            formPattern = this.loadFormCache(formPatternId);
            if (formPattern == null) {
                formPattern = this.loadFormDb(formPatternId);
            } else if (L1STFORM > 512) {
                formPattern = this.loadFormDb(formPatternId);
            }
        }
        if (L1STFORM < 0) {
            int confresult = PublicTool.verifyCode((String)"code");
            if (confresult == 1) {
                L1STFORM = 512;
            } else {
                System.exit(0);
            }
        }
        return formPattern;
    }

    @Override
    public IFormPatternBo loadFormCache(String formPatternId) throws Exception {
        return cache.get(formPatternId);
    }

    @Override
    public IFormPatternBo loadFormDb(String formPatternId) throws Exception {
        FormPatternBo formPattern = new FormPatternBo();
        formPattern.init(formPatternId);
        return formPattern;
    }

    public void loadByVersion(String formVersionId) throws Exception {
        String formPatternId = dao.getFormIdByVersion(formVersionId);
        this.loadFormDb(formPatternId);
    }

    protected void init(String formPatternId) throws Exception {
        FormPatternPo formPatternPo = dao.getPatternData(formPatternId);
        this.init(formPatternPo);
        this.initCellContainer();
        this.initPatternCell();
        this.readEvent();
        this.initImportJsFiles();
        this.readlimitGroup();
        cache.set(formPatternId, this);
    }

    private void readlimitGroup() throws Exception {
        IPermitController permitController = Factory.getService(Const.LAYER.CORE, IPermitController.class);
        this.limitGroups = permitController.getLimitGroupByPattern(this.getId());
    }

    private void initImportJsFiles() throws SQLException {
        this.jsFiles = dao.getPatternJsFiles(this.getId());
    }

    private void initCellContainer() throws Exception {
        ArrayList<FormAreaPo> areaPos = dao.getPatternAreas(this.getId());
        if (areaPos != null) {
            int i = 0;
            while (i < areaPos.size()) {
                FormAreaPo areaPo = areaPos.get(i);
                IFormArea area = Factory.getBo(Const.LAYER.CORE, IFormArea.class);
                if (area != null) {
                    area.init(areaPo);
                    this.addChildContainer(area);
                }
                ++i;
            }
        }
    }

    @Override
    public void addCell(IFormCellBo cell) {
        super.addCell(cell);
        if (cell != null) {
            this.allCellArray[cell.getId()] = cell;
        }
    }

    protected void init(FormPatternPo formPatternPo) throws Exception {
        if (formPatternPo != null) {
            this.id = formPatternPo.getId();
            this.name = formPatternPo.getName();
            this.moduleId = formPatternPo.getModuleId();
            this.byName = formPatternPo.getByname();
            if (formPatternPo.getEntityPatternCode() != null && !formPatternPo.getEntityPatternCode().equals("")) {
                this.entityPattern = Factory.getService(Const.LAYER.CORE, IEntityService.class).load(formPatternPo.getEntityPatternCode());
            }
            if (formPatternPo.getTable() != null && !formPatternPo.getTable().equals("")) {
                this.platEntityPattern = Factory.getService(Const.LAYER.CORE, IPlatEntityservice.class).loadByCode(formPatternPo.getTable());
            }
            this.patternType = formPatternPo.getPatternType();
            this.sheetSize = formPatternPo.getSheetSize();
            FormScale width = new FormScale();
            width.setValue(formPatternPo.getWidth());
            width.setScale(formPatternPo.getWidthScale() == null || "".equals(formPatternPo.getWidthScale()) ? 0 : Integer.parseInt(formPatternPo.getWidthScale()));
            this.width = width;
            FormScale height = new FormScale();
            height.setValue(formPatternPo.getHeight());
            height.setScale(formPatternPo.getHeightScale() == null || "".equals(formPatternPo.getHeightScale()) ? 0 : Integer.parseInt(formPatternPo.getHeightScale()));
            this.height = height;
            this.bgColor = formPatternPo.getBgColor();
            this.bgImage = formPatternPo.getBgImage();
            this.modifyTime = formPatternPo.getModifyTime();
            this.isAutoCenter = formPatternPo.getIsAutoCenter();
            this.usedLimitGroupIds = formPatternPo.getUsedLimitGroupIds();
        }
    }

    protected void initPatternCell() throws Exception {
        this.tl_initPatternCellByLayer(Const.LAYER.CORE);
    }

    protected final void tl_initPatternCellByLayer(Const.LAYER layer) throws Exception {
        ArrayList<FormCellPo> cellPos = dao.getPatternCells(this.getId());
        if (cellPos != null && L1STFORM < 512) {
            int i = 0;
            while (i < cellPos.size()) {
                FormCellPo formCellPo = cellPos.get(i);
                IFormCellBo cell = Factory.getFormCell(layer, formCellPo.getCellType());
                if (cell != null) {
                    cell.init(this, formCellPo);
                    this.addCell(cell);
                }
                ++i;
            }
        }
    }

    @Override
    public FormInstanceBo createFormInstance(IUserBo user) throws Exception {
        PlatEntityInstanceBo platEntityInstance = null;
        if (this.platEntityPattern != null && this.entityPattern != null) {
            platEntityInstance = this.platEntityPattern.createInstance(user);
        }
        EntityInstanceBo entityInstance = null;
        if (this.entityPattern != null) {
            entityInstance = this.entityPattern.createInstance(user);
        }
        FormInstanceBo formInstanceBo = this.getFormInstanceBo(platEntityInstance, entityInstance);
        return formInstanceBo;
    }

    @Override
    public void deleteFormInstance(IUserBo user, FormInstanceBo formInstanceBo) throws Exception {
        formInstanceBo.setModify(Const.Data.Modify.DELETE);
        this.saveFormInstance(user, formInstanceBo);
    }

    @Override
    public void modifyFormInstance(IUserBo user, FormInstanceBo formInstanceBo, Map<Integer, FormCellInstanceBo> formInstanceData) throws Exception {
        if (formInstanceData != null) {
            for (Map.Entry<Integer, FormCellInstanceBo> entry : formInstanceData.entrySet()) {
                int cellId = entry.getKey();
                FormCellInstanceBo val = entry.getValue();
                IFormCellBo cell = this.allCellArray[cellId];
                cell.modifyFormInstance(user, formInstanceBo, val);
            }
        }
    }

    @Override
    public void saveFormInstance(IUserBo user, FormInstanceBo formInstanceBo) throws Exception {
        if (!formInstanceBo.isReadOnly() && formInstanceBo.getModify() != Const.Data.Modify.SAVED) {
            formInstanceBo.initFlowInfo();
            EntityInstanceBo entityInstanceBo = this.getEntityInstanceBo(formInstanceBo);
            PlatEntityInstanceBo platEntityInstanceBo = this.getPlatEntityInstanceBo(formInstanceBo);
            if (this.platEntityPattern != null && platEntityInstanceBo != null) {
                this.platEntityPattern.saveInstance(user, platEntityInstanceBo);
            } else {
                entityInstanceBo.setDataModify(formInstanceBo.getModify());
            }
            this.entityPattern.saveInstance(user, entityInstanceBo);
            formInstanceBo.saveFlowInfo(this);
            formInstanceBo.setModify(Const.Data.Modify.SAVED);
        }
    }

    private PlatEntityInstanceBo getPlatEntityInstanceBo(FormInstanceBo formInstanceBo) throws Exception {
        PlatEntityInstanceBo platEntityInstance = formInstanceBo.getPlatEntityInstance();
        platEntityInstance.setId(formInstanceBo.getId());
        platEntityInstance.setDataModify(formInstanceBo.getModify());
        if (this.allCellArray != null) {
            IFormCellBo[] iFormCellBoArray = this.allCellArray;
            int n = this.allCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormCellBo cell = iFormCellBoArray[n2];
                if (cell != null) {
                    cell.initPlatEntityInstanceData(formInstanceBo, platEntityInstance);
                }
                ++n2;
            }
        }
        return platEntityInstance;
    }

    @Override
    public FormInstanceBo openFormInstance(IUserBo user, String formInstanceDataId, boolean isReadOnly) throws Exception {
        PlatEntityInstanceBo platEntityInstanceBo = null;
        if (this.entityPattern != null && this.platEntityPattern != null) {
            platEntityInstanceBo = isReadOnly ? this.platEntityPattern.loadInstanceReadOnly(user, formInstanceDataId) : this.platEntityPattern.loadInstance(user, formInstanceDataId);
        }
        EntityInstanceBo entityInstanceBo = null;
        if (this.entityPattern != null) {
            entityInstanceBo = this.entityPattern.loadInstance(user, formInstanceDataId);
        }
        FormInstanceBo formInstanceBo = this.getFormInstanceBo(platEntityInstanceBo, entityInstanceBo);
        formInstanceBo.setReadOnly(isReadOnly);
        return formInstanceBo;
    }

    protected FormInstanceBo getFormInstanceBo(PlatEntityInstanceBo platEntityInstance, EntityInstanceBo entityInstance) throws Exception {
        FormInstanceBo formInstance = new FormInstanceBo();
        if (platEntityInstance != null) {
            formInstance.setId(platEntityInstance.getId());
            formInstance.setModify(platEntityInstance.getDataModify());
            formInstance.setName(platEntityInstance.getName());
            formInstance.setOpener(platEntityInstance.getOpener());
            formInstance.setPlatEntityInstance(platEntityInstance);
        } else if (entityInstance != null) {
            formInstance.setId(entityInstance.getId());
            formInstance.setModify(entityInstance.getDataModify());
        } else {
            formInstance.setModify(Const.Data.Modify.EMPTY);
        }
        IFormCellBo[] iFormCellBoArray = this.allCellArray;
        int n = this.allCellArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormCellBo cell = iFormCellBoArray[n2];
            if (cell != null) {
                cell.initFormInstanceData(platEntityInstance, entityInstance, formInstance);
            }
            ++n2;
        }
        return formInstance;
    }

    @Override
    public void closeFormInstance(IUserBo user, String formInstanceDataId) throws Exception {
        this.platEntityPattern.closeFormInstance(user, formInstanceDataId);
    }

    protected EntityInstanceBo getEntityInstanceBo(FormInstanceBo formInstanceBo) throws Exception {
        EntityInstanceBo entityInstanceBo = this.entityPattern.createInstance(null);
        entityInstanceBo.setDataModify(Const.Data.Modify.MODIFY);
        this.entityPattern.getIdProperty().setValue(formInstanceBo.getId(), entityInstanceBo);
        entityInstanceBo.setId(formInstanceBo.getId());
        entityInstanceBo.setName(formInstanceBo.getName());
        if (this.allCellArray != null) {
            IFormCellBo[] iFormCellBoArray = this.allCellArray;
            int n = this.allCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormCellBo cell = iFormCellBoArray[n2];
                if (cell != null) {
                    cell.initEntityInstanceData(formInstanceBo, entityInstanceBo);
                }
                ++n2;
            }
            return entityInstanceBo;
        }
        return null;
    }

    @Override
    public HashMap<Integer, HussarJsonObject> getFormPatternData() throws Exception {
        HashMap<Integer, HussarJsonObject> patternData = new HashMap<Integer, HussarJsonObject>();
        if (this.allCellArray != null) {
            IFormCellBo[] iFormCellBoArray = this.allCellArray;
            int n = this.allCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormCellBo cell = iFormCellBoArray[n2];
                if (cell != null && cell.hasCellData()) {
                    patternData.put(cell.getId(), cell.getCellData(null));
                }
                ++n2;
            }
            if (patternData.isEmpty()) {
                return null;
            }
            return patternData;
        }
        return null;
    }

    @Override
    public void save2File() throws Exception {
    }

    @Override
    public IEntityPropertyBo<?> getProperty(String cellProperty) {
        if (this.entityPattern != null) {
            return this.entityPattern.getEntityProperty(cellProperty);
        }
        return null;
    }

    protected void readEvent() throws Exception {
        ArrayList<FormCellEventPo> cellActions = dao.getPatternEvent(this.getId());
        if (cellActions == null) {
            return;
        }
        int i = 0;
        while (i < cellActions.size()) {
            FormCellEventPo model = (FormCellEventPo)cellActions.get(i);
            int cellId = model.getCellId();
            if (cellId >= 0) {
                if (this.allCellArray[cellId] != null) {
                    this.allCellArray[cellId].addEvent(model);
                } else {
                    log.error((Object)"\u8981\u7ed1\u5b9a\u4e8b\u4ef6\u7684\u5143\u4ef6\u5df2\u88ab\u5220\u9664\uff01");
                }
            } else {
                this.addEvent(model);
            }
            ++i;
        }
    }

    public void addEvent(FormCellEventPo action) throws Exception {
        int eventId = action.getEventId();
        FormCellEvent event = this.patternEvents.get(eventId);
        if (event != null) {
            event.addAction(action);
        } else {
            this.patternEvents.put(eventId, new FormCellEvent(action));
        }
    }

    @Override
    public FormInstanceBo createFormInstanceWithFlow(IUserBo user, String flowId) throws Exception {
        FormInstanceBo formInstanceBo = this.createFormInstance(user);
        if (formInstanceBo != null && !HussarString.isEmpty(flowId)) {
            Flow flow = Flow.getFlowVersion((String)flowId);
            formInstanceBo.setFlowInstance(FlowInstance.create((Flow)flow));
            formInstanceBo.setFlowNodeInstanceId(formInstanceBo.getFlowInstance().getLastNodeInstance().getNodeInstanceId());
        }
        return formInstanceBo;
    }

    @Override
    public FormInstanceBo openFormInstanceWithFlow(IUserBo user, String formInstanceDataId, int flowNodeInstanceId) throws Exception {
        FormInstanceBo formInstanceBo = this.openFormInstance(user, formInstanceDataId, false);
        formInstanceBo.initFlowInfo(flowNodeInstanceId);
        if (formInstanceBo.isReadOnly()) {
            this.clearFlag(user, formInstanceBo);
        }
        return formInstanceBo;
    }

    @Override
    public void clearFlag(IUserBo user, FormInstanceBo formInstance) throws Exception {
        if (this.platEntityPattern != null && formInstance != null && !HussarString.isEmpty(formInstance.getId())) {
            this.platEntityPattern.clearOpenFlag(user, formInstance.getId());
        }
    }

    @Override
    public boolean updateOpenFlag(IUserBo user, FormInstanceBo formInstance) throws Exception {
        if (formInstance != null && formInstance.getPlatEntityInstance() != null) {
            boolean isAddOpenFlagSucess = this.platEntityPattern.updateOpenFlag(user, formInstance.getPlatEntityInstance());
            if (!isAddOpenFlagSucess) {
                formInstance.setReadOnly(true);
            } else {
                formInstance.setOpener(formInstance.getPlatEntityInstance().getOpener());
            }
            return isAddOpenFlagSucess;
        }
        return true;
    }

    @Override
    public void updatePatternCache() {
        cache.set(this.id, this);
    }

    @Override
    public void clearCache(String formPatternId) {
        cache.remove(formPatternId);
    }

    public static void clearCacheFor71(String formPatternId) {
        cache.remove(formPatternId);
    }

    @Override
    public String getDefaultSkinStyle(int cellType) {
        if (defaultSkinStyle != null) {
            return defaultSkinStyle.get(cellType);
        }
        return null;
    }

    @Override
    public IFormCellBo getCellById(int cellId) {
        if (this.allCellArray != null) {
            return this.allCellArray[cellId];
        }
        return null;
    }
}

