/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo.container;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.form72.bo.IFormCellBo;
import com.sdjxd.hussar.core.form72.bo.IFormCellContainer;
import com.sdjxd.hussar.core.form72.po.FormScale;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class CellContainer
implements IFormCellContainer {
    private static final int DEFAULT_SIZE = 5000;
    @Expose(serialize=true, deserialize=true)
    protected String id;
    @Expose(serialize=true, deserialize=true)
    protected String name;
    @Expose(serialize=true, deserialize=true)
    protected String byName;
    @Expose(serialize=true, deserialize=true)
    protected String parentId;
    @Expose(serialize=true, deserialize=true)
    protected FormScale width;
    @Expose(serialize=true, deserialize=true)
    protected FormScale height;
    @Expose(serialize=true, deserialize=true)
    protected String bgColor;
    @Expose(serialize=true, deserialize=true)
    protected String bgImage;
    protected Const.Form.Align isAutoCenter = Const.Form.Align.CENTER;
    @Expose(serialize=true, deserialize=true)
    protected ArrayList<IFormCellBo> cellArray = new ArrayList(5000);
    protected HashMap<String, IFormCellBo> cellMap = new HashMap();
    protected ArrayList<IFormCellContainer> cellContainerArray = new ArrayList(10);
    @Expose(serialize=true, deserialize=true)
    protected HashMap<String, IFormCellContainer> cellContainerMap = new HashMap();

    protected CellContainer() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void addCell(IFormCellBo cell) {
        if (cell != null) {
            String containerId = cell.getContainerID();
            if (containerId == null || "".equals(containerId) || "-1".equals(containerId) || containerId.equals(this.id)) {
                this.cellArray.add(cell);
                if (cell.getByName() != null) {
                    this.cellMap.put(cell.getByName(), cell);
                }
            } else {
                int i = 0;
                while (i < this.cellContainerArray.size()) {
                    IFormCellContainer childContainer = this.cellContainerArray.get(i);
                    childContainer.addCell(cell);
                    ++i;
                }
            }
        }
    }

    @Override
    public void addChildContainer(IFormCellContainer container) {
        if (container != null) {
            String containerId = container.getParentId();
            if (containerId == null || "".equals(containerId) || "-1".equals(containerId) || containerId.equals(this.id)) {
                this.cellContainerArray.add(container);
                if (container.getByName() != null) {
                    this.cellContainerMap.put(container.getByName(), container);
                }
            } else {
                int i = 0;
                while (i < this.cellContainerArray.size()) {
                    IFormCellContainer childContainer = this.cellContainerArray.get(i);
                    childContainer.addChildContainer(container);
                    ++i;
                }
            }
        }
    }

    @Override
    public ArrayList<IFormCellBo> getAllCell() {
        ArrayList<IFormCellBo> cells = new ArrayList<IFormCellBo>(25000);
        cells.addAll(this.cellArray);
        int i = 0;
        while (i < this.cellContainerArray.size()) {
            IFormCellContainer childContainer = this.cellContainerArray.get(i);
            cells.addAll(childContainer.getAllCell());
            ++i;
        }
        return cells;
    }

    @Override
    public IFormCellBo getCell(String byName) {
        IFormCellBo cell = null;
        cell = this.cellMap.get(byName);
        if (cell == null) {
            int i = 0;
            while (i < this.cellContainerArray.size()) {
                IFormCellContainer childContainer = this.cellContainerArray.get(i);
                cell = childContainer.getCell(byName);
                ++i;
            }
        }
        return cell;
    }

    @Override
    public IFormCellContainer getChildContainer(String byName) {
        IFormCellContainer container = null;
        container = this.cellContainerMap.get(byName);
        if (container == null) {
            int i = 0;
            while (i < this.cellContainerArray.size()) {
                IFormCellContainer childContainer = this.cellContainerArray.get(i);
                container = childContainer.getChildContainer(byName);
                ++i;
            }
        }
        return container;
    }

    @Override
    public String getByName() {
        return this.byName;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }
}

