/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.IFormCellProjectBo;
import com.sdjxd.hussar.core.form72.bo.cellData.TreeNodeBo;
import com.sdjxd.hussar.core.form72.dao.CellProjectDao;
import com.sdjxd.hussar.core.form72.po.FormCellAttributePo;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.Limit.service.Limit;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CellProjectTree
implements IFormCellProjectBo {
    protected static CellProjectDao dao;
    @Expose(serialize=true, deserialize=true)
    private String appId;
    @Expose(serialize=true, deserialize=true)
    private String appName;
    private ArrayList<HashMap<String, String>> tables;
    private ArrayList<HashMap<String, String>> links;
    private Table topTable;

    static {
        try {
            dao = Factory.getDao(CellProjectDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CellProjectTree(FormCellAttributePo cellProjectPo) throws Exception {
        if (HussarString.isEmpty(cellProjectPo.getProjectId())) {
            return;
        }
        this.appId = cellProjectPo.getProjectId();
        HashMap<String, String> m_appMap = dao.getAppInfo(this.appId);
        if (m_appMap == null || m_appMap.size() == 0) {
            return;
        }
        this.setAppName(m_appMap.get("APPNAME"));
        this.topTable = new Table();
        this.topTable.setAttColumn(m_appMap.get("ATTCOLUMN"));
        this.topTable.setAttTable(m_appMap.get("ATTTABLE"));
        this.topTable.setTableId(m_appMap.get("TABLEID"));
        this.topTable.setTableName(m_appMap.get("TABLENAME"));
        this.topTable.setDataSourceName(m_appMap.get("DATASOURCENAME"));
        this.topTable.setDataUserName(m_appMap.get("DATAUSERNAME"));
        this.topTable.setFilter(m_appMap.get("FILTER"));
        this.topTable.setOrderBy(m_appMap.get("ORDERBY"));
        this.topTable.setNameColumn(m_appMap.get("SHOWNAMECOL"));
        this.topTable.setKeyColumn(m_appMap.get("PKCOL"));
        this.topTable.setPicPath(m_appMap.get("PICPATH"));
        this.topTable.setLimitId(m_appMap.get("LIMITINFO"));
        m_appMap = null;
        this.links = dao.getAppLinksInfo(this.appId);
        this.tables = dao.getAppLinkTablesInfo(this.appId);
    }

    @Override
    public boolean hasPatternCellData() {
        return true;
    }

    @Override
    public Object getObject(String id) {
        return null;
    }

    public ArrayList<TreeNodeBo> getRootNodeArray() throws SQLException {
        return dao.getLinkAppRootNodeArray(this.appId, this.topTable, this.links, this.tables);
    }

    public ArrayList<TreeNodeBo> getChildNodeArray(String tableId, String linkId, String sheetId, String isGroup, String gId, String parentNodeGuid) throws SQLException {
        return dao.getLinkAppTableNodeArray(this.appId, this.topTable.getDataSourceName(), tableId, linkId, sheetId, isGroup, gId, parentNodeGuid, this.links, this.tables);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public ArrayList<HashMap<String, String>> getLinks() {
        return this.links;
    }

    public void setLinks(ArrayList<HashMap<String, String>> links) {
        this.links = links;
    }

    public ArrayList<HashMap<String, String>> getTables() {
        return this.tables;
    }

    public void setTables(ArrayList<HashMap<String, String>> tables) {
        this.tables = tables;
    }

    public class Table {
        private String tableId;
        private String tableName;
        private String dataSourceName;
        private String dataUserName;
        private String keyColumn;
        private String nameColumn;
        private String attColumn;
        private String attTable;
        private String filter;
        private String orderBy;
        private int moduleId;
        private String picPath;
        private String[] arrLimitId;
        private String filterOfLimit;

        public String getAttColumn() {
            return this.attColumn;
        }

        public String getAttField() {
            String result = this.attColumn;
            if (result == null) {
                result = "";
            }
            String strNameField = this.getNameField();
            String[] arrNameField = strNameField.split(",");
            int i = 0;
            while (i < arrNameField.length) {
                if ((String.valueOf(result) + ",").indexOf(String.valueOf(arrNameField[i]) + ",") < 0) {
                    if (result.length() > 0) {
                        result = String.valueOf(result) + ",";
                    }
                    result = String.valueOf(result) + "T.";
                    result = String.valueOf(result) + arrNameField[i];
                }
                ++i;
            }
            return result;
        }

        public void setAttColumn(String attColumn) {
            this.attColumn = attColumn;
        }

        public String getAttTable() {
            return this.attTable;
        }

        public void setAttTable(String attTable) {
            this.attTable = attTable;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getKeyColumn() {
            return this.keyColumn;
        }

        public void setKeyColumn(String keyColumn) {
            this.keyColumn = keyColumn;
        }

        public int getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(int moduleId) {
            this.moduleId = moduleId;
        }

        public String getNameColumn() {
            return this.nameColumn;
        }

        public String getNameField() {
            String fieldTemp = "";
            String strNameField = "";
            boolean flag = false;
            int pos = 0;
            while (pos < this.nameColumn.length()) {
                if (this.nameColumn.charAt(pos) == '[') {
                    flag = true;
                    fieldTemp = "";
                    ++pos;
                    continue;
                }
                if (this.nameColumn.charAt(pos) == ']') {
                    flag = false;
                    if (strNameField.length() > 0) {
                        strNameField = String.valueOf(strNameField) + ",";
                    }
                    strNameField = String.valueOf(strNameField) + fieldTemp;
                    fieldTemp = "";
                    ++pos;
                    continue;
                }
                if (flag) {
                    fieldTemp = String.valueOf(fieldTemp) + this.nameColumn.charAt(pos);
                }
                ++pos;
            }
            if (strNameField.length() == 0) {
                return this.nameColumn;
            }
            return strNameField;
        }

        public void setNameColumn(String nameColumn) {
            this.nameColumn = nameColumn;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            Object[] temp = StringTool.strToArray((String)orderBy);
            if (temp == null || temp.length == 0) {
                return;
            }
            this.orderBy = "";
            String[] orderByArr = null;
            int i = 0;
            while (i < temp.length) {
                try {
                    orderByArr = (String[])temp[i];
                }
                catch (Exception e) {
                    Logger daoLogger = Logger.getLogger(CellProjectTree.class);
                    daoLogger.error((Object)e.getMessage());
                    return;
                }
                if (orderByArr != null && orderByArr.length > 1) {
                    if (this.orderBy.length() != 0) {
                        this.orderBy = String.valueOf(this.orderBy) + ",";
                    }
                    this.orderBy = String.valueOf(this.orderBy) + orderByArr[0];
                    this.orderBy = String.valueOf(this.orderBy) + " ";
                    this.orderBy = String.valueOf(this.orderBy) + orderByArr[1];
                }
                ++i;
            }
        }

        public String getTableId() {
            return this.tableId;
        }

        public void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getPicPath() {
            return this.picPath;
        }

        public void setPicPath(String picPath) {
            this.picPath = picPath;
        }

        public String[] getLimitId() {
            return this.arrLimitId;
        }

        public void setLimitId(String limitInfo) {
            if (limitInfo == null || limitInfo.equals("")) {
                this.arrLimitId = null;
                this.filterOfLimit = "";
                return;
            }
            this.arrLimitId = (String[])StringTool.strToArray((String)limitInfo);
            this.filterOfLimit = Limit.getLimitSql((String[])this.arrLimitId, null);
        }

        public String getFilterOfLimit() {
            return this.filterOfLimit;
        }

        public String getDataSourceName() {
            return this.dataSourceName == null ? "defaultds" : this.dataSourceName;
        }

        public void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public String getDataUserName() {
            return this.dataUserName == null ? "[S]." : this.dataUserName;
        }

        public void setDataUserName(String dataUserName) {
            this.dataUserName = dataUserName == null ? "[S]." : dataUserName;
        }
    }
}

