/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.IFormCellProjectBo;
import com.sdjxd.hussar.core.form72.bo.cellData.ListData;
import com.sdjxd.hussar.core.form72.dao.CellProjectDao;
import com.sdjxd.hussar.core.form72.po.FormCellAttributePo;
import com.sdjxd.hussar.core.form72.po.ListStyleColumnDataPo;
import com.sdjxd.hussar.core.form72.po.ListStyleDataPo;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.base.Constants;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.table.service.Table;
import com.sdjxd.pms.platform.table.service.mean.FieldMean;
import com.sdjxd.pms.platform.table.service.mean.IFieldMean;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CellProjectList
implements IFormCellProjectBo {
    private static Logger log = Logger.getLogger(CellProjectList.class);
    private static CellProjectDao dao;
    @Expose(serialize=true, deserialize=true)
    private String id;
    @Expose(serialize=true, deserialize=true)
    private List<ListStyleColumnDataPo> columnData;
    private List means;
    private String tableId;
    @Expose(serialize=true, deserialize=true)
    private String pkCol;
    private String tableName;
    private String dataSourceName;
    private String dataUserName;
    private int isView;
    private String viewName;
    private ListMap initOrder = new ListMap();
    private String initQuery;
    private String userDefinfo;
    private int tl_pageDataSize;
    private boolean tl_isAutoHeight;
    private boolean tl_allowPage;
    private boolean tl_loadData;
    private boolean tl_headerSort;

    static {
        try {
            dao = Factory.getDao(CellProjectDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CellProjectList(FormCellAttributePo cellProjectPo) throws Exception {
        if (HussarString.isEmpty(cellProjectPo.getProjectId())) {
            return;
        }
        this.id = cellProjectPo.getProjectId();
        ListStyleDataPo styleData = dao.getFormCellListStylePo(this.id);
        if (styleData == null) {
            return;
        }
        if (styleData.getTableId() == null || "".equals(styleData.getTableId())) {
            this.InitCellProjectList(styleData, true);
        } else {
            this.InitCellProjectList(styleData);
        }
    }

    @Override
    public boolean hasPatternCellData() {
        return true;
    }

    @Override
    public Object getObject(String id) {
        return null;
    }

    public HussarJsonObject getPatternCellData(boolean allowPage, int pageIndex, int pageDataSize, String tempFilter) throws Exception {
        return this.getPatternCellData(allowPage, pageIndex, pageDataSize, tempFilter, this.getOrderField(), null);
    }

    public HussarJsonObject getPatternCellData(boolean allowPage, int pageIndex, int pageDataSize, String tempFilter, String tempOrder) throws Exception {
        return this.getPatternCellData(allowPage, pageIndex, pageDataSize, tempFilter, tempOrder, null);
    }

    public HussarJsonObject getPatternCellData(boolean allowPage, int pageIndex, int pageDataSize, String tempFilter, FormInstanceBo formInstance) throws Exception {
        return this.getPatternCellData(allowPage, pageIndex, pageDataSize, tempFilter, this.getOrderField(), formInstance);
    }

    public HussarJsonObject getPatternCellData(boolean allowPage, int pageIndex, int pageDataSize, String tempFilter, String tempOrder, FormInstanceBo formInstance) throws Exception {
        List data;
        if (tempOrder == null || "".equals(tempOrder)) {
            tempOrder = this.getOrderField();
        }
        String filter = this.getQuery(tempFilter);
        if (formInstance != null) {
            filter = FormInstanceBo.replaceParaValue(filter, formInstance);
        }
        filter = HussarString.replaceKeyWord(filter);
        ListData listData = new ListData();
        listData.setRowsCount(dao.getDataCount(this.dataSourceName, this.dataUserName, this.tableName, filter));
        if (allowPage || pageDataSize > 0) {
            listData.setPageIndex(pageIndex);
            data = dao.getPageListData(this.dataSourceName, this.getField(), this.dataUserName, this.tableName, this.pkCol, filter, tempOrder, pageDataSize, pageIndex);
        } else {
            listData.setPageIndex(1);
            data = dao.getAllListData(this.dataSourceName, this.getField(), this.dataUserName, this.tableName, this.pkCol, filter, tempOrder);
        }
        int cols = this.columnData.size();
        int rows = data.size();
        int c = 0;
        while (c < cols) {
            String colName = this.columnData.get(c).getAsName();
            IFieldMean mean = (IFieldMean)this.means.get(c);
            if (mean != null) {
                mean.setCacheIdValue(true);
                int r = 0;
                while (r < rows) {
                    Map dataRow = (Map)data.get(r);
                    if (colName != null && colName.length() != 0) {
                        String value = (String)dataRow.get(colName);
                        dataRow.put(colName, mean.getText(value));
                    }
                    ++r;
                }
            }
            ++c;
        }
        listData.setList(data);
        listData.setTempFilter(tempFilter);
        return listData;
    }

    public String getQuery(String tempFilter) {
        String finalQuery = null;
        finalQuery = this.initQuery == null || this.initQuery.length() == 0 ? (tempFilter == null || tempFilter.length() == 0 ? "1=1" : tempFilter) : (tempFilter == null || tempFilter.length() == 0 ? this.initQuery : "(" + this.initQuery + ") AND (" + tempFilter + ")");
        return finalQuery;
    }

    private void InitCellProjectList(ListStyleDataPo styleData, boolean noTableId) throws Exception {
        this.pkCol = "SHEETID";
        this.addOrderField(this.pkCol, "ASC");
        this.tableId = "";
        this.tableName = "(" + styleData.getFilterSql() + ") SQLTAB";
        this.tl_headerSort = styleData.isHeaderSort();
        this.tl_pageDataSize = styleData.getPageDataSize();
        this.tl_allowPage = styleData.getAllowPage();
        this.tl_loadData = styleData.isLoadData();
        this.tl_isAutoHeight = styleData.getIsAutoHeight();
        this.columnData = dao.getFormCellListColumnStylePos(this.id, 0, "");
        Map listFieldMean = FieldMean.getListFieldMean((String)this.id);
        int cols = this.columnData.size();
        this.means = new ArrayList(cols);
        String meanId = "";
        int i = 0;
        while (i < cols) {
            ListStyleColumnDataPo column = this.columnData.get(i);
            meanId = column.getMeanId();
            if (meanId != null && meanId.length() != 0) {
                this.means.add(listFieldMean.get(meanId));
            } else {
                this.means.add(new FieldMean());
            }
            ++i;
        }
        Object[] orderList = styleData.getOrderField();
        if (orderList != null) {
            int orderSize = orderList.length;
            int i2 = orderSize - 1;
            while (i2 >= 0) {
                Object dataItem = orderList[i2];
                if (dataItem instanceof String[]) {
                    String[] theOrder = (String[])dataItem;
                    this.addOrderField(theOrder[0], theOrder[1]);
                }
                --i2;
            }
        }
    }

    private void InitCellProjectList(ListStyleDataPo styleData) throws Exception {
        this.id = styleData.getStyleId();
        TableBean table = Table.getTable((String)styleData.getTableId());
        this.pkCol = table.getPkCol();
        this.tableId = table.getTableId();
        this.tableName = table.getTableName();
        this.dataSourceName = table.getDataSourceName();
        this.dataUserName = table.getDataUserName();
        this.addOrderField(this.pkCol, "ASC");
        this.tl_headerSort = styleData.isHeaderSort();
        this.initQuery = styleData.getFilterSql();
        this.isView = table.getIsView();
        if (styleData.getLinkViewId() != null && !styleData.getLinkViewId().equals("")) {
            this.tableName = "(";
            this.tableName = String.valueOf(this.tableName) + dao.getViewSql(styleData.getLinkViewId(), table.getTableName(), this.pkCol);
            this.tableName = String.valueOf(this.tableName) + ") as T ";
            this.isView = 1;
            TableBean indexTableBean = Table.getTable((String)styleData.getLinkViewId());
            this.viewName = indexTableBean.getTableName();
        }
        this.tl_pageDataSize = styleData.getPageDataSize();
        this.tl_allowPage = styleData.getAllowPage();
        this.tl_loadData = styleData.isLoadData();
        this.tl_isAutoHeight = styleData.getIsAutoHeight();
        this.columnData = dao.getFormCellListColumnStylePos(this.id, this.isView, styleData.getTableId());
        Map listFieldMean = FieldMean.getListFieldMean((String)this.id);
        int cols = this.columnData.size();
        this.means = new ArrayList(cols);
        String meanId = "";
        int i = 0;
        while (i < cols) {
            ListStyleColumnDataPo column = this.columnData.get(i);
            meanId = column.getMeanId();
            if (meanId != null && meanId.length() != 0) {
                this.means.add(listFieldMean.get(meanId));
            } else {
                this.means.add(new FieldMean());
            }
            ++i;
        }
        Object[] orderList = styleData.getOrderField();
        if (orderList != null) {
            int orderSize = orderList.length;
            int i2 = orderSize - 1;
            while (i2 >= 0) {
                Object dataItem = orderList[i2];
                if (dataItem instanceof String[]) {
                    String[] theOrder = (String[])dataItem;
                    this.addOrderField(theOrder[0], theOrder[1]);
                }
                --i2;
            }
        }
    }

    public void addOrderField(String fieldName, String orderType) {
        if (fieldName != null && fieldName.length() != 0) {
            if (orderType == null || orderType.length() == 0) {
                this.initOrder.add(0, (Object)fieldName, (Object)"ASC");
            } else {
                this.initOrder.add(0, (Object)fieldName, (Object)orderType);
            }
        }
    }

    public String getOrderField() {
        StringBuffer sb = new StringBuffer(64);
        int orderSize = this.initOrder.size();
        int i = 0;
        while (i < orderSize) {
            String key = (String)this.initOrder.getKey(i);
            sb.append(",");
            sb.append(key);
            sb.append(" ");
            sb.append((String)this.initOrder.getValue(i));
            ++i;
        }
        if (orderSize > 0) {
            return sb.substring(1);
        }
        return this.pkCol;
    }

    public String getTableNoTableId(FormInstanceBo formInstance) {
        if ("".equals(this.tableId)) {
            this.tableName = this.tableName.replaceAll("\\[cell.userDefinfo\\]", this.userDefinfo);
            this.tableName = HussarString.replace(this.tableName, "='" + Constants.resources_blankRootNodeId + "'", " is null");
            if (formInstance != null) {
                this.tableName = FormInstanceBo.replaceParaValue(this.tableName, formInstance);
            }
            this.tableName = HussarString.replaceKeyWord(this.tableName, formInstance);
        }
        return this.tableName;
    }

    private String getField() {
        if (this.columnData == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        int len = this.columnData.size();
        boolean hasPk = false;
        ListStyleColumnDataPo column = null;
        int i = 0;
        while (i < len) {
            String columnId;
            column = this.columnData.get(i);
            if (2 != column.getColumnType() && (columnId = column.getColumnId()) != null && columnId.length() != 0) {
                hasPk = hasPk || columnId.equals(this.pkCol);
                sb.append(",").append(columnId);
            }
            ++i;
        }
        if (this.pkCol != null && this.pkCol.length() != 0 && !hasPk) {
            sb.append(",").append(this.pkCol);
        }
        return HussarString.replaceKeyWord(sb.substring(1));
    }

    public boolean isAllowPage() {
        return this.tl_allowPage;
    }

    public int getPageDataSize() {
        return this.tl_pageDataSize;
    }

    public boolean isHeaderSort() {
        return this.tl_headerSort;
    }

    public boolean isLoadData() {
        return this.tl_loadData;
    }

    public String getPkCol() {
        return this.pkCol;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataUserName() {
        return this.dataUserName;
    }

    public String getPatternIdByFilterMap(Map<String, String> patternIdAndFilter, String formInstanceId) throws SQLException {
        String patternId = null;
        String filter = "";
        if (patternIdAndFilter != null) {
            for (Map.Entry<String, String> entry : patternIdAndFilter.entrySet()) {
                filter = entry.getKey();
                if (HussarString.isEmpty(filter)) {
                    patternId = entry.getValue();
                    break;
                }
                if (!dao.conformFilter(this.dataSourceName, this.tableName, this.pkCol, formInstanceId, filter)) continue;
                patternId = entry.getValue();
                break;
            }
        }
        return patternId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public int getRowCount() throws SQLException {
        return dao.getDataCount(this.dataSourceName, this.dataUserName, this.tableName, StringTool.replaceKeyWord((String)this.getQuery(null)));
    }

    public Map<String, String> getWaitDoPatternIdByFilterMap(Map<String, String> patternIdAndFilter, String waitDoId) throws SQLException {
        if (!"JXD7_XT_WAITDO".equalsIgnoreCase(this.tableName)) {
            return null;
        }
        Object patternId = null;
        String filter = "";
        Map<String, String> WaitDoInfo = null;
        if (patternIdAndFilter != null) {
            WaitDoInfo = dao.getWaitDoInfo(this.dataSourceName, this.tableName, this.pkCol, waitDoId, filter);
            for (Map.Entry<String, String> entry : patternIdAndFilter.entrySet()) {
                filter = entry.getKey();
                if (HussarString.isEmpty(filter)) {
                    WaitDoInfo.put("patternId", entry.getValue());
                    break;
                }
                String flowStr = "FLOWID=" + WaitDoInfo.get("flowId");
                if (filter.toUpperCase().indexOf(flowStr) < 0) continue;
                WaitDoInfo.put("patternId", entry.getValue());
                break;
            }
        }
        return WaitDoInfo;
    }
}

