/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.IFormCellProjectBo;
import com.sdjxd.hussar.core.form72.bo.cellData.OptionBo;
import com.sdjxd.hussar.core.form72.bo.cellData.Options;
import com.sdjxd.hussar.core.form72.dao.CellProjectDao;
import com.sdjxd.hussar.core.form72.po.FormCellAttributePo;
import com.sdjxd.hussar.core.form72.po.FormCellMeanPo;
import com.sdjxd.hussar.core.utils.HussarJson;
import java.sql.SQLException;
import java.util.ArrayList;

public class CellProjectComboBox
implements IFormCellProjectBo {
    @Expose(serialize=true, deserialize=true)
    private String id;
    @Expose(serialize=true, deserialize=true)
    private boolean hasPatternCellData = false;
    @Expose(serialize=true, deserialize=true)
    private ArrayList<OptionBo> options = null;
    private boolean isAddNullOption = false;
    private boolean isMulti = false;
    private static CellProjectDao dao;
    private String dataSouceName;
    private String tableName;
    private String idFieldName;
    private String textFieldName;
    private String filter;
    private String order;

    static {
        try {
            dao = Factory.getDao(CellProjectDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CellProjectComboBox(FormCellAttributePo cellProjectPo) throws Exception {
        this.id = cellProjectPo.getProjectId();
        this.options = new ArrayList();
        FormCellMeanPo meanPo = dao.getFormCellMeanPo(cellProjectPo.getProjectId());
        Object[] meanAssist = HussarJson.strToArray(meanPo.getAssitinfo());
        if (meanAssist.length > 0 && meanAssist[0].equals("2")) {
            this.setHasPatternCellData(true);
        }
        if (meanAssist.length > 2) {
            if (!this.hasPatternCellData()) {
                String[] projectInfo;
                String[] stringArray = projectInfo = (String[])meanAssist[1];
                int n = projectInfo.length;
                int n2 = 0;
                while (n2 < n) {
                    OptionBo b;
                    String str = stringArray[n2];
                    String[] strs = str.split(",");
                    if (strs.length >= 2) {
                        b = new OptionBo();
                        b.setText(strs[1]);
                        b.setValue(strs[0]);
                        this.options.add(b);
                    } else if (strs.length == 1) {
                        b = new OptionBo();
                        b.setText(strs[0]);
                        b.setValue(strs[0]);
                        this.options.add(b);
                    }
                    ++n2;
                }
            } else {
                String[] dataInfo = (String[])meanAssist[1];
                this.dataSouceName = meanPo.getDataSourceName();
                if (dataInfo.length > 3) {
                    this.tableName = dataInfo[0];
                    this.textFieldName = dataInfo[1];
                    this.idFieldName = dataInfo[2];
                    this.filter = dataInfo[3];
                }
                if (dataInfo.length > 4) {
                    this.order = dataInfo[4];
                }
            }
        }
        if (meanAssist.length > 3 && meanAssist[3].equals("1")) {
            this.isMulti = true;
        }
        if (meanAssist.length >= 5 && "1".equals(meanAssist[5])) {
            this.isAddNullOption = true;
        }
    }

    @Override
    public boolean hasPatternCellData() {
        return this.hasPatternCellData;
    }

    public HussarJsonObject getPatternCellData(String tempFilter) throws SQLException {
        Options opts = new Options();
        opts.setOpts(dao.getMeanOptions(this.dataSouceName, this.tableName, this.idFieldName, this.textFieldName, this.filter, this.order, tempFilter));
        return opts;
    }

    @Override
    public Object getObject(String id) throws SQLException {
        if (!this.hasPatternCellData()) {
            for (OptionBo b : this.options) {
                if (!id.equals(b.getValue())) continue;
                return b;
            }
        } else {
            return dao.getMeanOptionByValue(id, this.dataSouceName, this.tableName, this.idFieldName, this.textFieldName, this.filter);
        }
        return null;
    }

    public void setHasPatternCellData(boolean hasPatternCellData) {
        this.hasPatternCellData = hasPatternCellData;
    }

    public boolean isAddNullOption() {
        return this.isAddNullOption;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public ArrayList<OptionBo> getOptions() {
        return this.options;
    }
}

