/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo.cell;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.bo.cell.FormCellBo;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectList;
import com.sdjxd.hussar.core.form72.platEntity72.bo.support.PlatEntityInstanceBo;
import com.sdjxd.hussar.core.form72.po.FormCellEventPo;
import com.sdjxd.hussar.core.form72.po.FormCellPo;
import com.sdjxd.hussar.core.form72.service.support.CellAttributeServices;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.core.utils.HussarString;

public class FormCellList
extends FormCellBo {
    protected String tableLinkId;
    @Expose(serialize=true, deserialize=true)
    protected boolean allowPage;
    @Expose(serialize=true, deserialize=true)
    protected int pageDataSize;
    @Expose(serialize=true, deserialize=true)
    protected boolean headerSort;
    @Expose(serialize=true, deserialize=true)
    protected boolean loadPatternData;
    private boolean isAutoHeight;
    protected int cellStyle;
    @Expose(serialize=true, deserialize=true)
    protected CellProjectList projectList;
    protected String styleId;
    @Expose(serialize=true, deserialize=true)
    protected boolean refresh = true;

    @Override
    public void init(IFormPatternBo formPattern, FormCellPo cellPo) throws Exception {
        this.tl_init(formPattern, cellPo);
        this.tableLinkId = cellPo.getTableLinkId();
        String[] assitInfo = (String[])HussarJson.strToArray(cellPo.getAssitInfo());
        if (assitInfo != null) {
            int len = assitInfo.length;
            if (len > 0) {
                Object o;
                this.styleId = assitInfo[0];
                if (!HussarString.isEmpty(this.styleId) && (o = CellAttributeServices.getFormCellAttribute(this.styleId)) instanceof CellProjectList) {
                    this.projectList = (CellProjectList)o;
                    this.allowPage = this.projectList.isAllowPage();
                    this.pageDataSize = this.projectList.getPageDataSize();
                    this.headerSort = this.projectList.isHeaderSort();
                    this.loadPatternData = this.projectList.isLoadData();
                }
            }
            if (len > 6 && "0".equals(assitInfo[6])) {
                this.refresh = false;
            }
        }
    }

    @Override
    public void initEntityInstanceData(FormInstanceBo formInstance, EntityInstanceBo entityInstance) throws Exception {
        this.tl_initEntityInstanceData(formInstance, entityInstance);
    }

    @Override
    public void initFormInstanceData(PlatEntityInstanceBo platEntityInstance, EntityInstanceBo entityInstance, FormInstanceBo formInstance) throws Exception {
    }

    @Override
    public boolean hasCellData() {
        return true;
    }

    @Override
    public HussarJsonObject getCellData(String tempfilter) throws Exception {
        if (this.loadPatternData) {
            return this.projectList.getPatternCellData(this.allowPage, 1, this.pageDataSize, tempfilter);
        }
        return null;
    }

    @Override
    public void modifyFormInstance(IUserBo user, FormInstanceBo formInstanceBo, FormCellInstanceBo cellData) {
    }

    @Override
    public void addEvent(FormCellEventPo eventPo) throws Exception {
        this.tl_addEvent(eventPo);
    }

    @Override
    public void initPlatEntityInstanceData(FormInstanceBo formInstanceBo, PlatEntityInstanceBo platEntityInstanceBo) throws Exception {
    }

    public CellProjectList getProjectList() {
        return this.projectList;
    }
}

