/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.bo.IFormSessionBo;
import com.sdjxd.hussar.core.form72.service.FormLimitServices;
import com.sdjxd.hussar.core.permit72.bo.ILimitValue;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormSessionBo
implements IFormSessionBo {
    @Expose(serialize=true, deserialize=true)
    protected String id;
    @Expose(serialize=true, deserialize=true)
    protected String patternId;
    protected IFormPatternBo formPattern;
    @Expose(serialize=true, deserialize=true)
    protected HashMap<Integer, HussarJsonObject> formPatternData;
    @Expose(serialize=true, deserialize=true)
    protected FormInstanceBo formInstanceBo;
    @Expose(serialize=true, deserialize=true)
    protected List<String> userLimitGroups;
    @Expose(serialize=true, deserialize=true)
    protected HashMap<String, ILimitValue> formPatternCellLimits;
    protected boolean hasPermit = true;

    protected FormSessionBo() {
    }

    @Override
    public IFormSessionBo create(IUserBo user, String formPatternId, String formInstanceDataId, boolean isReadOnly) throws Exception {
        FormSessionBo formSessionBo = new FormSessionBo();
        IFormPatternBo formPattern = Factory.getBo(Const.LAYER.CORE, IFormPatternBo.class);
        formPattern.load(formPatternId);
        formSessionBo.patternId = formPatternId;
        formSessionBo.formPattern = formPattern;
        formSessionBo.formPatternData = formPattern.getFormPatternData();
        formSessionBo.formInstanceBo = formSessionBo.formPattern.openFormInstance(user, formInstanceDataId, isReadOnly);
        formSessionBo.id = Guid.create();
        formSessionBo.saveToCache();
        formSessionBo.userLimitGroups = FormLimitServices.getFormCurLimitGroupIds(user.getId(), formPatternId, formSessionBo.formPattern.getUsedLimitGroupIds());
        if (!formSessionBo.formInstanceBo.isReadOnly()) {
            formSessionBo.updateOpenFlag(user);
        }
        return formSessionBo;
    }

    @Override
    public IFormSessionBo create(IUserBo user, String formPatternId) throws Exception {
        return this.create(user, formPatternId, null, false);
    }

    @Override
    public IFormSessionBo load(String formSessionId) throws Exception {
        return this.getFromCache(formSessionId);
    }

    @Override
    public void close(IUserBo user) throws Exception {
        this.clearOpenFlag(user);
        this.clearFromCache();
    }

    @Override
    public void saveFormInstance(IUserBo user, Map<Integer, FormCellInstanceBo> formInstanceData) throws Exception {
        this.formPattern.modifyFormInstance(user, this.formInstanceBo, formInstanceData);
        this.formPattern.saveFormInstance(user, this.formInstanceBo);
    }

    @Override
    public IUserBo getInstanceOpener() {
        FormInstanceBo formInstanceBo = this.formInstanceBo;
        if (formInstanceBo != null) {
            return formInstanceBo.getOpener();
        }
        return null;
    }

    @Override
    public void deleteInstance(IUserBo user, FormInstanceBo formInstanceBo) throws Exception {
        this.formPattern.deleteFormInstance(user, formInstanceBo);
        this.clearFromCache();
    }

    protected IFormSessionBo getFromCache(String formSessionId) throws Exception {
        return (FormSessionBo)Global.getContext().getSession(formSessionId);
    }

    protected void saveToCache() throws Exception {
        Global.getContext().setSession(this.id, this);
    }

    protected void clearFromCache() throws Exception {
        Global.getContext().setSession(this.id, null);
    }

    @Override
    public FlowInstance getFlowInstance() {
        if (this.formInstanceBo != null) {
            return this.formInstanceBo.getFlowInstance();
        }
        return null;
    }

    public String getFlowInstanceId() {
        if (this.formInstanceBo != null) {
            return this.formInstanceBo.getFlowInstanceId();
        }
        return null;
    }

    public int getFlowNodeId() {
        if (this.formInstanceBo != null) {
            return this.formInstanceBo.getFlowNodeId();
        }
        return 0;
    }

    @Override
    public FormInstanceBo getFormInstance() {
        return this.formInstanceBo;
    }

    @Override
    public List<String> getUserLimitGroups() {
        return this.userLimitGroups;
    }

    @Override
    public void clearOpenFlag(IUserBo user) throws Exception {
        if (this.formPattern != null) {
            this.formPattern.clearFlag(user, this.formInstanceBo);
            if (this.getFlowInstanceId() != null) {
                FlowInstance.load((String)this.getFlowInstanceId()).updateOpener(false);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPatternId() {
        return this.patternId;
    }

    public HashMap<Integer, HussarJsonObject> getFormPatternData() {
        return this.formPatternData;
    }

    public void setFormPatternData(HashMap<Integer, HussarJsonObject> formPatternData) {
        this.formPatternData = formPatternData;
    }

    public void setUserLimitGroups(List<String> userLimitGroups) {
        this.userLimitGroups = userLimitGroups;
    }

    @Override
    public void setFormInstance(FormInstanceBo formInstanceBo) {
        this.formInstanceBo = formInstanceBo;
    }

    @Override
    public boolean updateOpenFlag(IUserBo user) throws Exception {
        if (this.formPattern != null && this.formInstanceBo != null) {
            if (this.formInstanceBo.isOpenByFlow) {
                if (!this.formInstanceBo.getFlowInstance().updateOpener(true)) {
                    this.formInstanceBo.setReadOnly(true);
                    return false;
                }
                if (!this.formPattern.updateOpenFlag(user, this.formInstanceBo)) {
                    this.formInstanceBo.getFlowInstance().updateOpener(false);
                    return false;
                }
                return true;
            }
            return this.formPattern.updateOpenFlag(user, this.formInstanceBo);
        }
        return true;
    }

    @Override
    public boolean isHasPermit() {
        return this.hasPermit;
    }

    @Override
    public void setHasPermit(boolean hasPermit) {
        this.hasPermit = hasPermit;
    }
}

