/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.bo;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.develop72.service.bo.IActionTypeBo;
import com.sdjxd.hussar.core.form72.bo.IFormSessionBo;
import com.sdjxd.hussar.core.form72.po.FormCellEventPo;
import com.sdjxd.hussar.core.utils.IHussarJson;
import java.util.ArrayList;

public class FormCellEvent
implements IHussarJson {
    @Expose(serialize=true, deserialize=true)
    private EVENTTYPE eventType;
    @Expose(serialize=true, deserialize=true)
    private ArrayList<IActionTypeBo> actionTypes = new ArrayList(10);

    public boolean invoke(IFormSessionBo formSession) throws Exception {
        boolean result = false;
        int i = 0;
        while (i < this.actionTypes.size()) {
            if (this.actionTypes.get(i) != null && Boolean.FALSE.equals(result = this.actionTypes.get(i).invokeAction(formSession))) break;
            ++i;
        }
        return result;
    }

    public FormCellEvent(FormCellEventPo action) throws Exception {
        this.eventType = EVENTTYPE.getEvent(action.getEventId());
        this.addAction(action);
    }

    public void addAction(FormCellEventPo action) throws Exception {
        int cellId = action.getCellId();
        int actionOrder = action.getActionOrder();
        if (this.actionTypes.size() > actionOrder && this.actionTypes.get(actionOrder) != null) {
            this.actionTypes.get(actionOrder).addParam(action);
        } else {
            IActionTypeBo actionTypeBo = Factory.getBo(Const.LAYER.CORE, IActionTypeBo.class);
            this.actionTypes.add(actionOrder, actionTypeBo.loadAction(action));
        }
    }

    public EVENTTYPE getEventType() {
        return this.eventType;
    }

    public static enum EVENTTYPE {
        ONCLICK,
        ONCHANGE,
        ONFOCUS,
        ONBLUR,
        ONLOAD,
        ONRESUME,
        ONBEFOREUNLOAD,
        ONSCREENCHANGED,
        ONSELECTEDCHANGED,
        ONQUERYCLOSE;


        public static EVENTTYPE getEvent(int i) {
            EVENTTYPE e;
            switch (i) {
                case 1: {
                    e = ONCLICK;
                    break;
                }
                case 3: {
                    e = ONFOCUS;
                    break;
                }
                case 4: {
                    e = ONBLUR;
                    break;
                }
                case 5: {
                    e = ONCHANGE;
                    break;
                }
                case 6: {
                    e = ONSELECTEDCHANGED;
                    break;
                }
                case 7: {
                    e = ONLOAD;
                    break;
                }
                case 8: {
                    e = ONBEFOREUNLOAD;
                    break;
                }
                case 45: {
                    e = ONQUERYCLOSE;
                    break;
                }
                case 50: {
                    e = ONRESUME;
                    break;
                }
                case 51: {
                    e = ONSCREENCHANGED;
                    break;
                }
                default: {
                    e = ONCLICK;
                }
            }
            return e;
        }
    }
}

