/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.service.support;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.Cache;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.dao.EntityPatternDao;
import com.sdjxd.hussar.core.entity72.po.EntityPatternPo;
import com.sdjxd.hussar.core.entity72.po.EntityPropertyPo;
import com.sdjxd.hussar.core.entity72.service.IEntityPatternService;
import com.sdjxd.hussar.mobile.base.AppConfig;
import java.util.ArrayList;

public class EntityPatternService
implements IEntityPatternService {
    private static EntityPatternDao dao;
    private static final Cache<IEntityPatternBo> cacheById;
    private static final Cache<IEntityPatternBo> cacheByName;

    static {
        cacheById = Global.createCache(IEntityPatternBo.class, 1000);
        cacheByName = Global.createCache(IEntityPatternBo.class, 1000);
    }

    private EntityPatternService() throws Exception {
        dao = Factory.getDao(EntityPatternDao.class);
    }

    @Override
    public IEntityPatternBo load(String entityPatternId) throws Exception {
        IEntityPatternBo entityPattern;
        if (AppConfig.getModel().equalsIgnoreCase("debug")) {
            EntityPatternPo po = dao.getPattern(entityPatternId);
            ArrayList<EntityPropertyPo> properties = dao.getProperty(entityPatternId);
            entityPattern = Factory.getBo(Const.LAYER.CORE, IEntityPatternBo.class, po.getPhysicalType().name());
            entityPattern.loadByPo(po, properties);
        } else {
            entityPattern = cacheById.get(entityPatternId);
            if (entityPattern == null) {
                EntityPatternPo po = dao.getPattern(entityPatternId);
                ArrayList<EntityPropertyPo> properties = dao.getProperty(entityPatternId);
                entityPattern = Factory.getBo(Const.LAYER.CORE, IEntityPatternBo.class, po.getPhysicalType().name());
                entityPattern.loadByPo(po, properties);
                cacheById.set(entityPatternId, entityPattern);
                cacheByName.set(entityPattern.getByName(), entityPattern);
            }
        }
        return entityPattern;
    }

    @Override
    public IEntityPatternBo loadByName(String entityByName) throws Exception {
        IEntityPatternBo entityPattern;
        if (AppConfig.getModel().equalsIgnoreCase("debug")) {
            EntityPatternPo po = dao.getPatternByName(entityByName);
            ArrayList<EntityPropertyPo> properties = dao.getPropertyByName(entityByName);
            entityPattern = Factory.getBo(Const.LAYER.CORE, IEntityPatternBo.class, po.getPhysicalType().name());
            entityPattern.loadByPo(po, properties);
        } else {
            entityPattern = cacheByName.get(entityByName);
            if (entityPattern == null) {
                EntityPatternPo po = dao.getPatternByName(entityByName);
                ArrayList<EntityPropertyPo> properties = dao.getPropertyByName(entityByName);
                entityPattern = Factory.getBo(Const.LAYER.CORE, IEntityPatternBo.class, po.getPhysicalType().name());
                entityPattern.loadByPo(po, properties);
                cacheById.set(entityByName, entityPattern);
                cacheByName.set(entityPattern.getId(), entityPattern);
            }
        }
        return entityPattern;
    }
}

