/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.dao.support.sql;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.entity72.dao.EntityPatternDao;
import com.sdjxd.hussar.core.entity72.po.EntityPatternPo;
import com.sdjxd.hussar.core.entity72.po.EntityPropertyPo;
import com.sdjxd.hussar.core.entity72.po.EntityViewPo;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.pms.platform.data.DbOper;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.RowSet;

public class EntityPatternDaoImpl
implements EntityPatternDao {
    @Override
    public EntityPatternPo getPatternByName(String patternByName) throws SQLException {
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)"SELECT TABLENAME AS BYNAME,PICPATH AS ICON,TABLEID AS PATTERNID,PKCOL AS IDPROPERTY,MODULEID,TABLEMSG AS PATTERNNAME,SHOWNAMECOL AS NAMEPROPERTY,TABLENOTES AS NOTES,ISVIEW AS ENTITYTYPE,DATAUSERNAME+TABLENAME AS PHYSICALNAME,0 AS PHYSICALTYPE,DATASOURCENAME AS PHYSICALPATH FROM [S].JXD7_XT_SYSTABLEINFO WHERE TABLENAME=?", (Object[])new String[]{patternByName});
        return this.getPatternByRs(rs);
    }

    @Override
    public EntityPatternPo getPattern(String patternId) throws SQLException {
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)"SELECT TABLENAME AS BYNAME,PICPATH AS ICON,TABLEID AS PATTERNID,PKCOL AS IDPROPERTY,MODULEID,TABLEMSG AS PATTERNNAME,SHOWNAMECOL AS NAMEPROPERTY,TABLENOTES AS NOTES,ISVIEW AS ENTITYTYPE,DATAUSERNAME+TABLENAME AS PHYSICALNAME,0 AS PHYSICALTYPE,DATASOURCENAME AS PHYSICALPATH,TABLETYPE FROM [S].JXD7_XT_SYSTABLEINFO WHERE TABLEID=?", (Object[])new String[]{patternId});
        return this.getPatternByRs(rs);
    }

    protected EntityPatternPo getPatternByRs(RowSet rs) throws SQLException {
        EntityPatternPo po = new EntityPatternPo();
        if (rs.next()) {
            po.setByName(rs.getString("BYNAME"));
            po.setIcon(rs.getString("ICON"));
            po.setId(rs.getString("PATTERNID"));
            po.setIdProperty(rs.getString("IDPROPERTY"));
            po.setModuleId(rs.getString("MODULEID"));
            po.setName(rs.getString("PATTERNNAME"));
            po.setNameProperty(rs.getString("NAMEPROPERTY"));
            po.setNotes(rs.getString("NOTES"));
            po.setPhysicalType(Const.Entity.PhysicalType.values()[rs.getInt("PHYSICALTYPE")]);
            po.setPhysicalName(rs.getString("PHYSICALNAME"));
            po.setPhysicalPath(rs.getString("PHYSICALPATH"));
            po.setEntityType(Const.Entity.EntityType.values()[rs.getInt("ENTITYTYPE")]);
            po.setTableType(Const.Entity.Query.TableType.values()[rs.getInt("TABLETYPE")]);
        }
        return po;
    }

    public EntityViewPo getView(String viewId) throws SQLException {
        EntityViewPo po = new EntityViewPo();
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)"SELECT VIEWFIELDINFO,VIEWCONDITION FROM [S].JXD7_XT_SYSVIEWINFO WHERE VIEWID=?", (Object[])new String[]{viewId});
        rs.next();
        return po;
    }

    @Override
    public ArrayList<EntityPropertyPo> getPropertyByName(String patternByName) throws SQLException {
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)"SELECT P.COLUMNTYPE AS DATATYPE,P.COLUMNID AS BYNAME,P.ALLOWNULL,P.COLUMNDEFAULT AS DEFAULTVALUE,P.COLMEANID AS DATAVALIDITYID,P.COLUMNID AS PROPERTYID,P.COLUMNNAME AS PROPERTYNAME,P.COLUMNLENGTH AS PROPERTYLENGTH,1 AS NEEDSAVE FROM [S].JXD7_XT_SYSTABLEINFO PA,[S].JXD7_XT_COLUMNS P WHERE PA.TABLEID=P.TABLEID AND PA.TABLENAME=?", (Object[])new String[]{patternByName});
        return this.getPropertyByRs(rs);
    }

    @Override
    public ArrayList<EntityPropertyPo> getProperty(String patternId) throws SQLException {
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)"SELECT P.COLUMNTYPE AS DATATYPE,P.COLUMNID AS BYNAME,P.ALLOWNULL,P.COLUMNDEFAULT AS DEFAULTVALUE,P.COLMEANID AS DATAVALIDITYID,P.SHOWORDER AS PROPERTYID,P.COLUMNNAME AS PROPERTYNAME,P.COLUMNLENGTH AS PROPERTYLENGTH,1 AS NEEDSAVE FROM [S].JXD7_XT_COLUMNS P WHERE P.TABLEID=?", (Object[])new String[]{patternId});
        return this.getPropertyByRs(rs);
    }

    private ArrayList<EntityPropertyPo> getPropertyByRs(RowSet rs) throws SQLException {
        ArrayList<EntityPropertyPo> list = new ArrayList<EntityPropertyPo>(32);
        while (rs.next()) {
            EntityPropertyPo po = new EntityPropertyPo();
            po.setByName(rs.getString("BYNAME"));
            po.setAllowNull(rs.getBoolean("ALLOWNULL"));
            po.setDefaultValue(rs.getString("DEFAULTVALUE"));
            po.setDataValidityId((String[])HussarJson.strToArray(rs.getString("DATAVALIDITYID")));
            po.setId(rs.getInt("PROPERTYID"));
            po.setName(rs.getString("PROPERTYNAME"));
            po.setLength(rs.getInt("PROPERTYLENGTH"));
            po.setNeedSave(rs.getBoolean("NEEDSAVE"));
            String dataType = rs.getString("DATATYPE");
            if ("varchar".equals(dataType)) {
                po.setDataType(Const.Entity.DataType.STRING);
            } else if ("int".equals(dataType)) {
                po.setDataType(Const.Entity.DataType.NUMBER);
            } else {
                po.setDataType(Const.Entity.DataType.STRING);
            }
            po.setPhysicalName(rs.getString("BYNAME"));
            list.add(po);
        }
        return list;
    }
}

