/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.bo.support.restriction;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.entity72.bo.IEntityPropertyBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityQuery;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.Restriction2;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.RestrictionBetween;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.RestrictionIn;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.RestrictionNull;
import com.sdjxd.hussar.core.utils.HussarDate;
import com.sdjxd.hussar.core.utils.HussarString;
import java.util.Calendar;
import java.util.Date;

public abstract class Restriction {
    protected Restriction() {
    }

    public Restriction(String json) {
    }

    public abstract String getSql(EntityQuery var1) throws Exception;

    public static Restriction create(Const.Entity.Query.OPERATOR operator, Object ... param) {
        Restriction restriction = null;
        switch (operator) {
            case BETWEEN: 
            case NOTBETWEEN: {
                restriction = new RestrictionBetween(operator, param[0], param[1], param[2]);
                break;
            }
            case IN: 
            case NOTIN: {
                restriction = new RestrictionIn(operator, param[0], (Object[])param[1]);
                break;
            }
            case ISNULL: 
            case NOTNULL: {
                restriction = new RestrictionNull(operator, (Restriction)param[0]);
                break;
            }
            default: {
                restriction = new Restriction2(operator, param[0], param[1]);
            }
        }
        return restriction;
    }

    protected String getParamSql(EntityQuery entityQuery, Object param) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (param instanceof Restriction) {
            sql.append("(").append(((Restriction)param).getSql(entityQuery)).append(")");
        } else if (param instanceof IEntityPropertyBo) {
            sql.append(entityQuery.getPropertyQueryByName((IEntityPropertyBo)param));
        } else if (param instanceof Calendar) {
            sql.append("'").append(HussarDate.formatDateTime((Calendar)param)).append("'");
        } else if (param instanceof Date) {
            sql.append("'").append(HussarDate.formatTime((Date)param)).append("'");
        } else if (param instanceof Float) {
            sql.append(((Float)param).floatValue());
        } else if (param instanceof Integer) {
            sql.append((Integer)param);
        } else if (param instanceof String) {
            if (entityQuery.hasProperty((String)param)) {
                sql.append((String)param);
            } else {
                String paramString = (String)param;
                paramString = HussarString.replace(paramString, "'", "''");
                sql.append("'").append(paramString).append("'");
            }
        } else {
            sql.append(param.toString());
        }
        return sql.toString();
    }
}

