/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.bo.support.property;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.entity72.bo.IDataValidityBo;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.bo.IEntityPropertyBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityInstanceBo;
import com.sdjxd.hussar.core.entity72.po.EntityPropertyPo;
import com.sdjxd.hussar.core.entity72.service.IDataValidityService;
import java.util.ArrayList;

public abstract class EntityPropertyBo<T>
implements IEntityPropertyBo<T> {
    private int id;
    private String byName;
    private String name;
    private String entityByName;
    protected boolean allowNull;
    private ArrayList<IDataValidityBo> dataValidity = new ArrayList();

    @Override
    public void init(IEntityPatternBo pattern, EntityPropertyPo po) throws Exception {
        this.id = po.getId();
        this.byName = po.getByName();
        this.name = po.getName();
        this.entityByName = pattern.getByName();
        this.allowNull = po.isAllowNull();
        IDataValidityService service = Factory.getService(Const.LAYER.CORE, IDataValidityService.class);
        String[] dataValiditys = po.getDataValidityId();
        if (dataValiditys != null) {
            int i = 0;
            while (i < dataValiditys.length) {
                this.dataValidity.add(service.load(dataValiditys[i]));
                ++i;
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getByName() {
        return this.byName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getEntityByName() {
        return this.entityByName;
    }

    @Override
    public boolean needSave(EntityInstanceBo instance) {
        return instance.hasData(this.getByName());
    }
}

