/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.bo.support.entity;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.bo.IEntityPropertyBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.Criteria;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityInstanceBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityQuery;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.Restriction;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.Restriction2;
import com.sdjxd.hussar.core.entity72.po.EntityPatternPo;
import com.sdjxd.hussar.core.entity72.po.EntityPropertyPo;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class EntityView
extends EntityQuery
implements IEntityPatternBo {
    private IEntityPatternBo entityPattern;

    private EntityView() throws Exception {
    }

    @Override
    public void createQueryProperties(Criteria criteria, String queryByName) throws Exception {
        this.entityPattern.createQueryProperties(criteria, queryByName);
    }

    @Override
    public ArrayList<EntityInstanceBo> queryInstances(Restriction query) throws Exception {
        return this.entityPattern.queryInstances(query);
    }

    @Override
    public void loadByPo(EntityPatternPo patternPo, ArrayList<EntityPropertyPo> properties) throws Exception {
        this.entityPattern = Factory.getBo(Const.LAYER.CORE, IEntityPatternBo.class, "physical");
        this.entityPattern.loadByPo(patternPo, properties);
    }

    @Override
    public EntityInstanceBo createInstance(IUserBo creater) throws Exception {
        EntityInstanceBo instance = new EntityInstanceBo();
        for (String entityQueryByName : this.entityProperties.keySet()) {
            HashMap properties = (HashMap)this.entityProperties.get(entityQueryByName);
            for (String propertyQueryByName : properties.keySet()) {
                IEntityPropertyBo property = (IEntityPropertyBo)properties.get(propertyQueryByName);
                instance.setData(propertyQueryByName, property.createDefault());
            }
        }
        instance.setId(this.entityPattern.getIdProperty().getValue(instance));
        instance.setName(this.entityPattern.getNameProperty().getValue(instance));
        instance.setEntityPatternId(this.entityPattern.getId());
        instance.setDataModify(Const.Data.Modify.NEW);
        return instance;
    }

    @Override
    public EntityInstanceBo loadInstance(IUserBo user, String entityInstanceId) throws Exception {
        Restriction restriction = Restriction.create(Const.Entity.Query.OPERATOR.EQ, this.entityPattern.getIdProperty(), entityInstanceId);
        String sql = this.getSql(restriction);
        return this.entityPattern.getInstance(EntityQuery.first(sql));
    }

    @Override
    public void deleteInstance(IUserBo user, EntityInstanceBo instance) throws Exception {
        instance.setDataModifyDelete();
        this.saveInstance(user, instance);
    }

    @Override
    public void deleteInstance(IUserBo user, String entityInstanceId) throws Exception {
        EntityInstanceBo instance = new EntityInstanceBo();
        instance.setId(entityInstanceId);
        instance.setDataModifyDelete();
        this.saveInstance(user, instance);
    }

    @Override
    public void saveInstance(IUserBo user, EntityInstanceBo entityInstance) throws Exception {
        HashMap<String, EntityInstanceBo> instances = new HashMap<String, EntityInstanceBo>();
        for (String entityQueryName : this.entities.keySet()) {
            HashMap entityProperties = (HashMap)this.entityProperties.get(entityQueryName);
            Iterator itProperties = entityProperties.keySet().iterator();
            EntityInstanceBo physicalInstance = new EntityInstanceBo();
            while (itProperties.hasNext()) {
                String propertyQueryName = (String)itProperties.next();
                IEntityPropertyBo property = (IEntityPropertyBo)entityProperties.get(propertyQueryName);
                property.setValue(entityInstance.getData(propertyQueryName), physicalInstance);
            }
            instances.put(entityQueryName, physicalInstance);
            physicalInstance.setDataModify(entityInstance.getDataModify());
        }
        this.setInstanceValueByRestriction(this.restriction, instances);
        for (String entityQueryName : this.entities.keySet()) {
            EntityInstanceBo physicalInstance = instances.get(entityQueryName);
            ((IEntityPatternBo)this.entities.get(entityQueryName)).saveInstance(user, physicalInstance);
        }
    }

    private void setInstanceValueByRestriction(Restriction restriction, HashMap<String, EntityInstanceBo> instances) throws Exception {
        Restriction2 restriction2;
        if (restriction instanceof Restriction2 && (restriction2 = (Restriction2)restriction).getOperator() == Const.Entity.Query.OPERATOR.EQ) {
            Object leftParamObj = restriction2.getLeft();
            Object rightParamObj = restriction2.getRight();
            if (leftParamObj instanceof IEntityPropertyBo && rightParamObj instanceof IEntityPropertyBo) {
                IEntityPropertyBo leftParamProperty = (IEntityPropertyBo)leftParamObj;
                String leftEntityName = leftParamProperty.getEntityByName();
                Object leftValue = leftParamProperty.getValue(instances.get(leftEntityName));
                IEntityPropertyBo rightParamProperty = (IEntityPropertyBo)rightParamObj;
                String rightEntityName = rightParamProperty.getEntityByName();
                if (leftValue == null || leftValue.toString().length() == 0) {
                    Object rightValue = rightParamProperty.getValue(instances.get(rightEntityName));
                    leftParamProperty.setValue(rightValue, instances.get(leftEntityName));
                } else {
                    rightParamProperty.setValue(leftValue, instances.get(rightEntityName));
                }
            }
        }
    }

    @Override
    public IEntityPropertyBo<?> getEntityProperty(String propertyByName) {
        return this.entityPattern.getEntityProperty(propertyByName);
    }

    @Override
    public String getId() {
        return this.entityPattern.getId();
    }

    @Override
    public String getByName() {
        return this.entityPattern.getByName();
    }

    @Override
    public IEntityPropertyBo<String> getIdProperty() {
        return this.entityPattern.getIdProperty();
    }

    @Override
    public IEntityPropertyBo<String> getNameProperty() {
        return this.entityPattern.getNameProperty();
    }

    @Override
    public String getName() {
        return this.entityPattern.getName();
    }

    @Override
    public String getNotes() {
        return this.entityPattern.getNotes();
    }

    @Override
    public String getIcon() {
        return this.entityPattern.getIcon();
    }

    @Override
    public String getModuleId() {
        return this.entityPattern.getModuleId();
    }

    @Override
    public EntityInstanceBo getInstance(HashMap<String, Object> data) {
        return this.entityPattern.getInstance(data);
    }

    @Override
    public ArrayList<EntityInstanceBo> getInstances(ArrayList<HashMap<String, Object>> list) {
        return this.entityPattern.getInstances(list);
    }
}

