/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.bo.support.entity;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.bo.IEntityPropertyBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityPhysicalBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityView;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.Restriction;
import com.sdjxd.pms.platform.data.DbOper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.sql.RowSet;

public abstract class EntityQuery {
    protected HashMap<String, IEntityPatternBo> entities = new HashMap();
    protected HashMap<String, HashMap<String, IEntityPropertyBo<?>>> entityProperties;
    protected HashMap<String, IEntityPropertyBo<?>> properties = new HashMap();
    protected HashMap<String, HashMap<String, IEntityPropertyBo<?>>> entityGroupProperties;
    protected HashMap<String, IEntityPropertyBo<?>> groupProperties = new HashMap();
    protected HashMap<String, Const.Entity.Query.ORDER> orders = new HashMap();
    protected Restriction restriction;

    protected EntityQuery() {
        this.entityProperties = new HashMap();
    }

    protected String getSql(Restriction curRestriction) throws Exception {
        IEntityPropertyBo<?> property;
        HashMap<String, IEntityPropertyBo<?>> properties;
        if (this.properties.size() == 0 && this.groupProperties.size() == 0) {
            throw new Exception("\u5fc5\u987b\u6709\u67e5\u8be2\u5c5e\u6027\u6216\u8005\u5206\u7ec4\u5c5e\u6027");
        }
        if (this.entities.size() < 0) {
            throw new Exception("\u5fc5\u987b\u6709\u67e5\u8be2\u5b9e\u4f53");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this.groupProperties.size() > 0) {
            for (String entityQueryByName : this.entityGroupProperties.keySet()) {
                properties = this.entityGroupProperties.get(entityQueryByName);
                for (String propertyQueryByName : properties.keySet()) {
                    property = properties.get(propertyQueryByName);
                    sql.append(entityQueryByName).append(".").append(property.getPhysicalName()).append(" AS ").append(propertyQueryByName).append(",");
                }
            }
            sql.setLength(sql.length() - 1);
        } else {
            for (String entityQueryByName : this.entityProperties.keySet()) {
                properties = this.entityProperties.get(entityQueryByName);
                for (String propertyQueryByName : properties.keySet()) {
                    property = properties.get(propertyQueryByName);
                    sql.append(entityQueryByName).append(".").append(property.getPhysicalName()).append(" AS ").append(propertyQueryByName).append(",");
                }
            }
            sql.setLength(sql.length() - 1);
        }
        sql.append(" FROM ");
        Iterator<String> it = this.entities.keySet().iterator();
        while (it.hasNext()) {
            String entityQueryByName;
            entityQueryByName = it.next();
            IEntityPatternBo entity = this.entities.get(entityQueryByName);
            if (entity instanceof EntityPhysicalBo) {
                EntityPhysicalBo entityPhysical = (EntityPhysicalBo)entity;
                sql.append(entityPhysical.getPhysicalName()).append(" ").append(entityQueryByName).append(" ,");
                continue;
            }
            if (!(entity instanceof EntityView)) continue;
            EntityView entityView = (EntityView)entity;
            sql.append("(").append(entityView.getSql()).append(") ").append(this.entities.get(entityQueryByName)).append(",");
        }
        sql.setLength(sql.length() - 1);
        if (this.restriction != null || curRestriction != null) {
            sql.append(" WHERE ");
            Restriction finalRestriction = curRestriction == null ? this.restriction : Restriction.create(Const.Entity.Query.OPERATOR.AND, this.restriction, curRestriction);
            sql.append(finalRestriction.getSql(this));
        }
        if (!this.orders.isEmpty()) {
            sql.append(" ORDER BY ");
            Iterator<String> orderIt = this.orders.keySet().iterator();
            while (it.hasNext()) {
                String property2 = orderIt.next();
                sql.append(property2).append(" ").append((Object)this.orders.get(property2)).append(",");
            }
            sql.setLength(sql.length() - 1);
        }
        return sql.toString();
    }

    public String getSql() throws Exception {
        return this.getSql(null);
    }

    public HashMap<String, Object> first() throws Exception {
        String entityQueryByName;
        IEntityPatternBo entity;
        String dataSourceName = "defaultds";
        Iterator<String> it = this.entities.keySet().iterator();
        if (it.hasNext() && (entity = this.entities.get(entityQueryByName = it.next())) instanceof EntityPhysicalBo) {
            EntityPhysicalBo entityPhysical = (EntityPhysicalBo)entity;
            dataSourceName = ((EntityPhysicalBo)entity).getPhysicalPath();
        }
        return EntityQuery.first(dataSourceName, this.getSql());
    }

    public static HashMap<String, Object> first(String dataSourceName, String sql) throws Exception {
        HashMap<String, Object> bo = null;
        RowSet rs = DbOper.executeQuery((String)dataSourceName, (String)sql);
        if (rs.next()) {
            bo = new HashMap<String, Object>();
            int i = 1;
            while (i <= rs.getMetaData().getColumnCount()) {
                bo.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                ++i;
            }
        }
        return bo;
    }

    public static HashMap<String, Object> first(String sql) throws Exception {
        return EntityQuery.first("defaultds", sql);
    }

    public ArrayList<HashMap<String, Object>> list() throws Exception {
        return EntityQuery.list(this.getSql());
    }

    public static ArrayList<HashMap<String, Object>> list(String sql) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(32);
        RowSet rs = DbOper.executeQuery((String)"defaultds", (String)sql);
        while (rs.next()) {
            HashMap<String, Object> bo = new HashMap<String, Object>();
            int i = 1;
            while (i < rs.getMetaData().getColumnCount()) {
                bo.put(rs.getMetaData().getColumnName(i), rs.getObject(i - 1));
                ++i;
            }
            list.add(bo);
        }
        return list;
    }

    public boolean hasProperty(String queryByName) {
        return this.properties.containsKey(queryByName);
    }

    public String getPropertyQueryByName(IEntityPropertyBo<?> property) {
        String propertyQueryName = null;
        for (String currentName : this.properties.keySet()) {
            if (!this.properties.get(currentName).equals(property)) continue;
            propertyQueryName = currentName;
            break;
        }
        return propertyQueryName;
    }
}

