/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.entity72.bo.support.entity;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.bo.IEntityPropertyBo;
import com.sdjxd.hussar.core.entity72.bo.support.entity.Criteria;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityInstanceBo;
import com.sdjxd.hussar.core.entity72.bo.support.restriction.Restriction;
import com.sdjxd.hussar.core.entity72.po.EntityPatternPo;
import com.sdjxd.hussar.core.entity72.po.EntityPropertyPo;
import com.sdjxd.hussar.core.entity72.service.IEntityPropertyService;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.pms.platform.data.DbOper;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class EntityPatternBo
implements IEntityPatternBo {
    protected String id;
    protected String byName;
    protected String name = null;
    protected String notes;
    protected String icon = null;
    protected String moduleId;
    protected String physicalName;
    protected String physicalPath;
    protected IEntityPropertyBo<String> idProperty;
    protected IEntityPropertyBo<String> nameProperty;
    protected HashMap<String, IEntityPropertyBo<?>> propertyMap;
    protected IEntityPropertyBo<?>[] propertyArray;
    protected Const.Entity.Query.TableType tableType;

    protected EntityPatternBo() throws Exception {
    }

    @Override
    public void createQueryProperties(Criteria criteria, String queryByName) throws Exception {
        int i = 0;
        while (i < this.propertyArray.length) {
            criteria.add(queryByName, this.propertyArray[i]);
            ++i;
        }
    }

    @Override
    public ArrayList<EntityInstanceBo> queryInstances(Restriction query) throws Exception {
        Criteria criteria = Factory.getBo(Const.LAYER.CORE, Criteria.class);
        criteria.add(true, this);
        criteria.add(query);
        ArrayList<HashMap<String, Object>> list = criteria.list();
        return this.getInstances(list);
    }

    @Override
    public ArrayList<EntityInstanceBo> getInstances(ArrayList<HashMap<String, Object>> list) {
        ArrayList<EntityInstanceBo> instances = new ArrayList<EntityInstanceBo>();
        int i = 0;
        while (i < instances.size()) {
            HashMap<String, Object> data = list.get(i);
            instances.add(this.getInstance(data));
            ++i;
        }
        return instances;
    }

    @Override
    public EntityInstanceBo getInstance(HashMap<String, Object> data) {
        EntityInstanceBo instance = new EntityInstanceBo(data);
        if (this.idProperty.getValue(instance) != null) {
            instance.setId(this.idProperty.getValue(instance).toString());
        }
        if (this.nameProperty.getValue(instance) != null) {
            instance.setName(this.nameProperty.getValue(instance).toString());
        }
        instance.setDataModify(Const.Data.Modify.SAVED);
        return instance;
    }

    @Override
    public void loadByPo(EntityPatternPo patternPo, ArrayList<EntityPropertyPo> properties) throws Exception {
        this.id = patternPo.getId();
        this.byName = patternPo.getByName();
        this.name = patternPo.getName();
        this.icon = patternPo.getIcon();
        this.notes = patternPo.getNotes();
        this.moduleId = patternPo.getModuleId();
        this.physicalName = patternPo.getPhysicalName();
        this.physicalPath = patternPo.getPhysicalPath();
        this.tableType = patternPo.getTableType();
        IEntityPropertyService service = Factory.getService(Const.LAYER.CORE, IEntityPropertyService.class);
        this.propertyMap = new HashMap();
        this.propertyArray = new IEntityPropertyBo[properties.size()];
        int i = 0;
        while (i < properties.size()) {
            IEntityPropertyBo<?> property = service.load(properties.get(i));
            property.init(this, properties.get(i));
            this.propertyMap.put(property.getByName(), property);
            this.propertyArray[property.getId()] = property;
            ++i;
        }
        this.idProperty = this.propertyMap.get(patternPo.getIdProperty());
        this.nameProperty = this.propertyMap.get(patternPo.getNameProperty());
    }

    @Override
    public EntityInstanceBo createInstance(IUserBo creater) throws Exception {
        EntityInstanceBo instance = new EntityInstanceBo();
        instance.setEntityPatternId(this.id);
        instance.setDataModify(Const.Data.Modify.NEW);
        for (String propertyName : this.propertyMap.keySet()) {
            IEntityPropertyBo<?> entityProperty = this.propertyMap.get(propertyName);
            instance.setData(propertyName, entityProperty.createDefault());
        }
        instance.setId(Guid.create());
        return instance;
    }

    @Override
    public EntityInstanceBo loadInstance(IUserBo user, String entityInstanceId) throws Exception {
        Criteria criteria = Factory.getBo(Const.LAYER.CORE, Criteria.class);
        criteria.add(true, this);
        criteria.add(Restriction.create(Const.Entity.Query.OPERATOR.EQ, this.idProperty, entityInstanceId));
        EntityInstanceBo instance = this.getInstance(criteria.first());
        return instance;
    }

    @Override
    public void deleteInstance(IUserBo user, EntityInstanceBo instance) throws Exception {
        instance.setDataModifyDelete();
        this.saveInstance(user, instance);
    }

    @Override
    public void deleteInstance(IUserBo user, String entityInstanceId) throws Exception {
        EntityInstanceBo instance = new EntityInstanceBo();
        instance.setId(entityInstanceId);
        instance.setDataModifyDelete();
        this.saveInstance(user, instance);
    }

    @Override
    public void saveInstance(IUserBo user, EntityInstanceBo entityInstance) throws Exception {
        StringBuffer sql = new StringBuffer(128);
        if (Const.Data.Modify.NEW.equals((Object)entityInstance.getDataModify())) {
            StringBuffer sqlColumnName = new StringBuffer(128);
            StringBuffer sqlColumnValue = new StringBuffer(128);
            Object[] values = new Object[this.propertyArray.length];
            sqlColumnName.append(this.propertyArray[0].getPhysicalName());
            sqlColumnValue.append("?");
            values[0] = this.propertyArray[0].getValue(entityInstance);
            int i = 1;
            while (i < this.propertyArray.length) {
                sqlColumnName.append(",").append(this.propertyArray[i].getPhysicalName());
                sqlColumnValue.append(",?");
                values[i] = this.propertyArray[i].getValue(entityInstance);
                ++i;
            }
            sqlColumnName.append(")");
            sql.append("INSERT INTO ").append(this.physicalName);
            sql.append("(").append(sqlColumnName.toString()).append(") VALUES(").append(sqlColumnValue.toString()).append(")");
            DbOper.executeNonQuery((String)this.physicalPath, (String)sql.toString(), (Object[])values);
        } else if (Const.Data.Modify.MODIFY.equals((Object)entityInstance.getDataModify())) {
            sql.append("UPDATE ").append(this.physicalName).append(" SET ");
            Object[] values = new Object[this.propertyArray.length + 1];
            sql.append(this.propertyArray[0].getPhysicalName()).append("=?");
            values[0] = this.propertyArray[0].getValue(entityInstance);
            int i = 1;
            while (i < this.propertyArray.length) {
                sql.append(",").append(this.propertyArray[i].getPhysicalName()).append("=?");
                values[i] = this.propertyArray[i].getValue(entityInstance);
                ++i;
            }
            sql.append(" WHERE ").append(this.idProperty.getPhysicalName()).append("=?");
            values[this.propertyArray.length] = this.idProperty.getValue(entityInstance);
            DbOper.executeNonQuery((String)this.physicalPath, (String)sql.toString(), (Object[])values);
        } else if (Const.Data.Modify.DELETE.equals((Object)entityInstance.getDataModify())) {
            sql.append("DELETE FROM ").append(this.physicalName);
            sql.append(" WHERE ").append(this.idProperty.getPhysicalName()).append("=?");
            DbOper.executeNonQuery((String)this.physicalPath, (String)sql.toString(), (Object[])new Object[]{this.idProperty.getValue(entityInstance)});
        }
    }

    @Override
    public IEntityPropertyBo<?> getEntityProperty(String propertyByName) {
        return this.propertyMap.get(propertyByName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getByName() {
        return this.byName;
    }

    @Override
    public IEntityPropertyBo<String> getIdProperty() {
        return this.idProperty;
    }

    @Override
    public IEntityPropertyBo<String> getNameProperty() {
        return this.nameProperty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    public Const.Entity.Query.TableType getTableType() {
        return this.tableType;
    }
}

