/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.develop72.service.bo;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.develop72.service.bo.IActionParamTypeBo;
import com.sdjxd.hussar.core.form72.bo.IFormSessionBo;
import com.sdjxd.hussar.core.form72.po.FormCellEventPo;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.core.utils.IJson;
import com.sdjxd.pms.platform.data.DbOper;
import java.io.IOException;
import java.util.ArrayList;
import javax.sql.RowSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.ListOrderedMap;

public class ActionParamTypeBo
implements IActionParamTypeBo,
IJson<ActionParamTypeBo> {
    protected String id;
    private ParamType paramType;
    protected String value;
    protected Object valueObject;
    private int paramOrder;
    private String actionId;
    private static int STRING = 1;
    private static int FORM = 2;
    private static int FLOW = 3;
    private static int OPENTYPE = 4;
    private static int CELLIDARR = 5;
    private static int CELLID = 6;
    private static int VAR = 7;
    private static int FILTER = 8;
    private static int OBJECT = 9;
    private static int BOOL = 15;
    private static int MOPENTYPE = 16;
    private static int CUSTOMMETHOD = 17;
    private static int KEYVALUE = 18;
    private static int INT = 14;
    private static int ARRAY = 20;
    private static int CUSTOM = 21;

    public static int getParamType(String typeName) {
        int typeId = STRING;
        if ("\u5bf9\u5e94\u8868\u5355".equals(typeName)) {
            typeId = FORM;
        } else if ("\u5bf9\u5e94\u6d41\u7a0b".equals(typeName)) {
            typeId = FLOW;
        } else if ("\u6253\u5f00\u65b9\u5f0f".equals(typeName)) {
            typeId = OPENTYPE;
        } else if ("\u5143\u4ef6\u5c5e\u6027".equals(typeName)) {
            typeId = CELLID;
        } else if ("\u5143\u4ef6id\u6570\u7ec4".equals(typeName)) {
            typeId = CELLIDARR;
        } else if ("\u73af\u5883\u53d8\u91cf".equals(typeName)) {
            typeId = VAR;
        } else if ("\u8fc7\u6ee4\u6761\u4ef6".equals(typeName)) {
            typeId = FILTER;
        } else if ("\u6574\u578b".equals(typeName)) {
            typeId = INT;
        } else if ("\u5e03\u5c14\u578b".equals(typeName)) {
            typeId = BOOL;
        } else if ("\u81ea\u5b9a\u4e49\u7c7b\u578b".equals(typeName)) {
            typeId = CUSTOM;
        } else if ("\u952e\u503c\u5bf9".equals(typeName)) {
            typeId = KEYVALUE;
        } else if ("\u6570\u7ec4".equals(typeName)) {
            typeId = ARRAY;
        }
        return typeId;
    }

    public String getName() {
        return this.paramType.typeName;
    }

    public int getType() {
        return this.paramType.typeId;
    }

    public void setType(int type) {
        this.paramType.typeId = type;
    }

    public void setName(String name) {
        this.paramType.typeName = name;
    }

    public String getValue() {
        return this.value;
    }

    private static ListOrderedMap getKeyValueMap(ParamType desObj, String value) {
        ListOrderedMap map = new ListOrderedMap();
        if (!(desObj instanceof ParamTypeKeyValue)) {
            return map;
        }
        if (HussarString.isEmpty(value)) {
            return map;
        }
        ParamType keyParam = ((ParamTypeKeyValue)desObj).keyType;
        ParamType valueParam = ((ParamTypeKeyValue)desObj).valueType;
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        JSONArray values = JSONArray.fromObject((Object)value);
        int i = 0;
        while (i < values.size()) {
            JSONArray kvalue = values.getJSONArray(i);
            String key = kvalue.getString(0);
            String keyValue = kvalue.getString(1);
            if (key.startsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if (keyValue.startsWith("\"")) {
                keyValue = keyValue.substring(1, keyValue.length() - 1);
            }
            map.put(ActionParamTypeBo.getParamValue(keyParam, key), ActionParamTypeBo.getParamValue(valueParam, keyValue));
            ++i;
        }
        return map;
    }

    private static ListOrderedMap getCustomMap(ParamType desObj, String value) {
        ListOrderedMap map = new ListOrderedMap();
        if (!(desObj instanceof ParamTypeCustom)) {
            return map;
        }
        ArrayList keyParam = ((ParamTypeCustom)desObj).listType;
        JSONArray values = JSONArray.fromObject((Object)value);
        if (keyParam.size() != values.size()) {
            return map;
        }
        int i = 0;
        while (i < values.size()) {
            JSONArray kvalue = values.getJSONArray(i);
            map.put((Object)((ParamType)keyParam.get((int)i)).typeName, ActionParamTypeBo.getParamValue((ParamType)keyParam.get(i), kvalue.getString(1)));
            ++i;
        }
        return map;
    }

    private static ArrayList getArrayList(ParamType desObj, String value) {
        if (!(desObj instanceof ParamTypeArray)) {
            return null;
        }
        ParamType keyParam = ((ParamTypeArray)desObj).elementType;
        ArrayList<Object> list = new ArrayList<Object>();
        JSONArray values = JSONArray.fromObject((Object)value);
        int i = 0;
        while (i < values.size()) {
            JSONArray kvalue = values.getJSONArray(i);
            list.add(ActionParamTypeBo.getParamValue(keyParam, kvalue.getString(0)));
            ++i;
        }
        return list;
    }

    public Object getParamValue() {
        if (this.valueObject == null) {
            this.valueObject = ActionParamTypeBo.getParamValue(this.paramType, this.value);
            return this.valueObject;
        }
        return this.valueObject;
    }

    private static Object getParamValue(ParamType paramType, String value) {
        if (paramType.typeId == INT || paramType.typeId == CELLID) {
            if (HussarString.isEmpty(value)) {
                return 0;
            }
            return Integer.parseInt(value);
        }
        if (paramType.typeId == BOOL) {
            if (HussarString.isEmpty(value)) {
                return true;
            }
            if ("0".equals(value) || "1".equals(value)) {
                return "1".equals(value);
            }
            return Boolean.parseBoolean(value);
        }
        if (paramType.typeId == STRING || paramType.typeId == FORM || paramType.typeId == FLOW || paramType.typeId == OPENTYPE || paramType.typeId == CELLIDARR || paramType.typeId == MOPENTYPE || paramType.typeId == FILTER) {
            return String.valueOf(value);
        }
        if (paramType.typeId == CUSTOMMETHOD) {
            return ActionParamTypeBo.getCustomMethod(value);
        }
        if (paramType.typeId == CUSTOM) {
            return ActionParamTypeBo.getCustomMap(paramType, value);
        }
        if (paramType.typeId == KEYVALUE) {
            return ActionParamTypeBo.getKeyValueMap(paramType, value);
        }
        if (paramType.typeId == ARRAY) {
            return ActionParamTypeBo.getArrayList(paramType, value);
        }
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ActionParamTypeBo(FormCellEventPo data) {
        this.setId(data.getParamId());
        this.setValue(data.getParamValue());
        this.setParamOrder(data.getParamOrder());
        this.paramType = this.InitDescirp(new Object[]{data.getParamName(), String.valueOf(data.getParamType()), HussarJson.parse(data.getDescription())});
        this.valueObject = this.getParamValue();
    }

    private ActionParamTypeBo() {
    }

    public ArrayList getParamForMobile() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getName());
        list.add(new Integer(this.getType()));
        list.add(this.getParamValue());
        return list;
    }

    public String getActionId() {
        return this.actionId;
    }

    public int getParamOrder() {
        return this.paramOrder;
    }

    public void setParamOrder(int paramOrder) {
        this.paramOrder = paramOrder;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private ParamType InitDescirp(Object[] typeDescirpData) {
        if (Integer.parseInt((String)typeDescirpData[1]) == KEYVALUE) {
            if (typeDescirpData[2] == null) {
                return new ParamType((String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
            }
            Object[] keyValueType = (Object[])typeDescirpData[2];
            ParamType key = this.InitDescirp((Object[])keyValueType[0]);
            ParamType valueParam = this.InitDescirp((Object[])keyValueType[1]);
            return new ParamTypeKeyValue(key, valueParam, (String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
        }
        if (Integer.parseInt((String)typeDescirpData[1]) == CUSTOM) {
            if (typeDescirpData[2] == null) {
                return new ParamType((String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
            }
            Object[] keyValueType = (Object[])typeDescirpData[2];
            ArrayList<ParamType> array = new ArrayList<ParamType>();
            int i = 0;
            while (i < keyValueType.length) {
                array.add(this.InitDescirp((Object[])keyValueType[i]));
                ++i;
            }
            return new ParamTypeCustom(array, (String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
        }
        if (Integer.parseInt((String)typeDescirpData[1]) == ARRAY) {
            if (typeDescirpData[2] == null) {
                return new ParamType((String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
            }
            Object[] arrayType = (Object[])typeDescirpData[2];
            ParamType elementType = this.InitDescirp(arrayType);
            return new ParamTypeArray(elementType, (String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
        }
        return new ParamType((String)typeDescirpData[0], Integer.parseInt((String)typeDescirpData[1]));
    }

    private static String getCustomMethod(String actionid) {
        String actioncode = "";
        String acSql = "SELECT ACTIONCODE FROM [S].JXD7_PM_ACTION WHERE SUPPORTER=2 AND ACTIONID='" + actionid + "'";
        try {
            RowSet rs = DbOper.executeQuery((String)acSql);
            if (rs.next()) {
                actioncode = rs.getString("ACTIONCODE");
            }
        }
        catch (Exception e) {
            return actioncode;
        }
        return actioncode;
    }

    @Override
    public void getInstanceValue(IFormSessionBo formSession) {
    }

    @Override
    public String toJson() throws IOException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"paramType", (Object)this.paramType.typeId);
        jsonObj.put((Object)"value", this.valueObject);
        return jsonObj.toString();
    }

    @Override
    public ActionParamTypeBo fromJson(String json) {
        ActionParamTypeBo param = new ActionParamTypeBo();
        JSONObject jsonObj = JSONObject.fromObject((Object)json);
        param.setType(jsonObj.getInt("paramType"));
        param.valueObject = jsonObj.get("value");
        return param;
    }

    class ParamType {
        public String typeName;
        @Expose(serialize=true, deserialize=true)
        public int typeId;

        public ParamType(String name, int type) {
            this.typeName = name;
            this.typeId = type;
        }
    }

    class ParamTypeArray
    extends ParamType {
        public ParamType elementType;

        public ParamTypeArray(ParamType element, String name, int type) {
            super(name, type);
            this.elementType = element;
        }
    }

    class ParamTypeCustom
    extends ParamType {
        public ArrayList listType;

        public ParamTypeCustom(ArrayList list, String name, int type) {
            super(name, type);
            this.listType = list;
        }
    }

    class ParamTypeKeyValue
    extends ParamType {
        public ParamType keyType;
        public ParamType valueType;

        public ParamTypeKeyValue(ParamType key, ParamType value, String name, int type) {
            super(name, type);
            this.keyType = key;
            this.valueType = value;
        }
    }
}

