/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.css.service.support;

import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.css.bo.ThemeBo;
import com.sdjxd.hussar.core.css.dao.CssDao;
import com.sdjxd.hussar.core.css.po.ThemeElementInstancePo;
import com.sdjxd.hussar.core.css.po.ThemePo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ThemeServices {
    protected static CssDao dao;

    static {
        try {
            dao = Factory.getDao(CssDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<ThemeBo> getThemes() throws SQLException {
        ArrayList<ThemeBo> themes = null;
        List<ThemePo> themePos = dao.getThemePos();
        if (themePos != null && themePos.size() > 0) {
            themes = new ArrayList<ThemeBo>(10);
            for (ThemePo themePo : themePos) {
                List<ThemeElementInstancePo> themeElementInstancePos = dao.getThemeElementInstancePos(themePo.getThemeId());
                ThemeBo themeBo = new ThemeBo(themePo, themeElementInstancePos);
                themes.add(themeBo);
            }
        }
        return themes;
    }

    public static boolean saveSenceAttrs(String sences, Object[] attrs) {
        return dao.saveSenceAttrs(sences, attrs);
    }

    public static List getAttrs(String senceId) {
        return dao.getAttrs(senceId);
    }

    public static boolean saveCellStatus(String cellTypeId, Object[] status) {
        return dao.saveCellStatus(cellTypeId, status);
    }

    public static List getCellStatus(String cellTypeId) {
        return dao.getStatus(cellTypeId);
    }

    public static boolean saveSenceStatus(String sceneId, Object[] statusId, Object[] statusName) {
        return dao.saveSenceStatus(sceneId, statusId, statusName);
    }

    public static List getSenceStatus(String sceneId) {
        return dao.getSenceStatus(sceneId);
    }
}

