/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.css.bo;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.css.bo.ThemeElementInstanceBo;
import com.sdjxd.hussar.core.css.po.ThemeElementInstancePo;
import com.sdjxd.hussar.core.css.po.ThemePo;
import com.sdjxd.hussar.core.utils.HussarString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThemeBo {
    @Expose(serialize=true, deserialize=true)
    private String themeCode;
    @Expose(serialize=true, deserialize=true)
    private String themeName;
    @Expose(serialize=true, deserialize=true)
    private Map<String, ThemeElementInstanceBo> themeElements = new HashMap<String, ThemeElementInstanceBo>();

    public ThemeBo(ThemePo themePo, List<ThemeElementInstancePo> themeElementInstancePos) {
        this.themeCode = themePo.getThemeCode();
        this.themeName = themePo.getThemeName();
        if (themeElementInstancePos != null && themeElementInstancePos.size() > 0) {
            for (ThemeElementInstancePo elementInstancePo : themeElementInstancePos) {
                ThemeElementInstanceBo themeElement = new ThemeElementInstanceBo(elementInstancePo);
                if (HussarString.isEmpty(elementInstancePo.getParentElementId())) {
                    this.themeElements.put(elementInstancePo.getElementCode(), themeElement);
                    continue;
                }
                ThemeElementInstanceBo parentThemeElement = this.themeElements.get(elementInstancePo.getParentElementCode());
                if (parentThemeElement != null) {
                    parentThemeElement.addChild(elementInstancePo.getElementCode(), themeElement);
                    continue;
                }
                ThemeElementInstanceBo emptyThemeElement = new ThemeElementInstanceBo();
                emptyThemeElement.addChild(elementInstancePo.getElementCode(), themeElement);
                this.themeElements.put(elementInstancePo.getParentElementCode(), emptyThemeElement);
            }
        }
    }

    public String getThemeCode() {
        return this.themeCode;
    }

    public String getThemeName() {
        return this.themeName;
    }
}

