/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72.service;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.dao.BaseDao;
import com.sdjxd.hussar.core.base72.po.SystemLogPo;
import com.sdjxd.hussar.core.utils.Guid;
import java.util.Calendar;

public class SystemLogService {
    private boolean[] logs;
    private BaseDao dao = Factory.getDao(BaseDao.class);

    public SystemLogService() throws Exception {
        this.logs = new boolean[Const.LOGTYPE.values().length];
        try {
            String value = Global.getParam("logcontent");
            String[] logTypes = value.split(",");
            int i = 0;
            while (i < logTypes.length) {
                try {
                    int index = Enum.valueOf(Const.LOGTYPE.class, logTypes[i]).ordinal();
                    this.logs[index] = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void log(String userId, String patternId, String instanceId, String beizu, Const.LOGTYPE type, String ip) {
        if (this.logs[type.ordinal()]) {
            SystemLogPo po = new SystemLogPo();
            po.setId(Guid.create());
            po.setCreateTime(Calendar.getInstance());
            po.setUserId(userId);
            po.setPatternId(patternId);
            po.setInstanceId(instanceId);
            po.setBeizu(beizu);
            po.setType(type);
            po.setIp(ip);
            this.dao.log(po);
        }
    }
}

