/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72.service;

import com.sdjxd.hussar.core.base72.bo.EncodedProperties;
import java.util.Hashtable;

public final class PropertiesService {
    private Boolean isDebug;
    private Hashtable<String, EncodedProperties> propertyFiles = new Hashtable();

    public PropertiesService() {
        this.isDebug = this.getConfigBool("global", "debug");
    }

    public EncodedProperties getConfig(String fileName) {
        EncodedProperties properties = null;
        if (!this.propertyFiles.containsKey(fileName) || this.isDebug.booleanValue()) {
            properties = new EncodedProperties();
            properties.load(new StringBuffer(fileName).append(".properties").toString());
            this.propertyFiles.put(fileName, properties);
        } else {
            properties = this.propertyFiles.get(fileName);
        }
        return properties;
    }

    public String getConfig(String fileName, String keyName) {
        EncodedProperties properties = null;
        if (!this.propertyFiles.containsKey(fileName) || this.isDebug.booleanValue()) {
            properties = new EncodedProperties();
            properties.load(new StringBuffer(fileName).append(".properties").toString());
            this.propertyFiles.put(fileName, properties);
        } else {
            properties = this.propertyFiles.get(fileName);
        }
        return properties.getProperty(keyName);
    }

    public int getConfigInt(String fileName, String keyName) {
        String value = this.getConfig(fileName, keyName);
        return Integer.parseInt(value);
    }

    public boolean getConfigBool(String fileName, String keyName) {
        String value = this.getConfig(fileName, keyName);
        return Boolean.parseBoolean(value);
    }

    public Boolean isDebug() {
        return this.isDebug;
    }
}

