/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72.service;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.bo.SystemParam;
import com.sdjxd.hussar.core.base72.dao.BaseDao;
import com.sdjxd.hussar.core.base72.po.SystemParamPo;
import java.util.ArrayList;
import java.util.HashMap;

public final class ParamService {
    private BaseDao dao;
    private HashMap<String, SystemParam> params = new HashMap();

    public ParamService() throws Exception {
        this.dao = Factory.getDao(BaseDao.class);
        this.loadParam();
    }

    public String getParam(String paramByName) {
        if (this.params.containsKey(paramByName)) {
            return this.params.get(paramByName).getParamValue();
        }
        return "";
    }

    public int getParamInt(String paramByName) {
        String value = this.getParam(paramByName);
        if (value == null || "".equals(value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public boolean getParamBool(String paramByName) throws Exception {
        String value = this.getParam(paramByName);
        return Boolean.parseBoolean(value);
    }

    private void loadParam() throws Exception {
        ArrayList<SystemParamPo> list = this.dao.loadParams();
        this.params.clear();
        SystemParam param = null;
        int i = 0;
        while (i < list.size()) {
            param = Factory.getBo(Const.LAYER.CORE, SystemParam.class);
            param.loadByPo(list.get(i));
            this.params.put(param.getParamByName(), param);
            ++i;
        }
    }
}

