/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72.service;

import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.utils.HussarString;
import java.util.HashMap;
import java.util.Properties;

public class MessageService {
    private static String LANG_KEY = "_JXDPMSLANG";
    private static String DEFAULT_LANG = "zh-cn";
    private static String lang = null;
    private static HashMap<String, String> messages = new HashMap();

    public static HashMap<String, String> getMessage() {
        if (Global.getContext() != null) {
            lang = Global.getContext().getCookie(LANG_KEY);
        }
        if (lang == null || lang.length() == 0) {
            lang = Global.getConfig(LANG_KEY);
        }
        if (lang == null || lang.length() == 0) {
            lang = DEFAULT_LANG;
        }
        if (!messages.containsKey(lang)) {
            Properties properties = null;
            try {
                properties = Global.getConfigService().getConfig("messages_" + lang + ".properties");
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            if (properties != null) {
                for (String string : properties.keySet()) {
                    messages.put(String.valueOf(lang) + string, properties.getProperty(string));
                }
                messages.put(lang, "true");
            }
        }
        return messages;
    }

    public static String getMessage(String key, Object ... args) {
        if (key == null || key.length() == 0) {
            return "";
        }
        MessageService.getMessage();
        return MessageService.getMessage(lang, key, args);
    }

    private static String getMessage(String curLang, String key, Object ... args) {
        if (!messages.containsKey(String.valueOf(curLang) + key)) {
            if (!DEFAULT_LANG.equals(curLang)) {
                return MessageService.getMessage(DEFAULT_LANG, key, args);
            }
            return "";
        }
        return HussarString.format(messages.get(String.valueOf(curLang) + key), args);
    }
}

