/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72.service;

import com.sdjxd.hussar.core.base72.bo.Context;
import java.io.File;

public final class ContextService {
    private String contextPath = "";
    private String realPath;
    private ThreadLocal<Context> currentContext = new ThreadLocal();

    public Context getContext() {
        Context context = this.currentContext.get();
        return context;
    }

    public void setContext(Context context) {
        if (context != null) {
            if (this.contextPath == null || this.contextPath.length() <= 0) {
                this.contextPath = context.getContextPath();
            }
            if (this.realPath == null || this.realPath.length() == 0) {
                this.realPath = context.getRealPath("/");
            }
            this.currentContext.set(context);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getRealPath() {
        if (this.realPath == null || this.realPath.length() == 0) {
            String tempPath = null;
            try {
                File classPath = new File(Thread.currentThread().getContextClassLoader().getResource("").getPath());
                tempPath = String.valueOf(classPath.getParentFile().getParent()) + "/";
                tempPath = tempPath.replace("%20", " ");
            }
            catch (Exception exp) {
                exp.printStackTrace();
                tempPath = "";
            }
            return tempPath;
        }
        return this.realPath;
    }

    public void setRealPath(String realPath) {
        this.realPath = realPath;
    }
}

