/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72.bo;

import com.sdjxd.hussar.core.base72.Global;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class EncodedProperties
extends Properties {
    private static final long serialVersionUID = -5198646494427187315L;
    private static final Logger m_logger = Logger.getLogger(EncodedProperties.class);

    @Override
    public String getProperty(String key) {
        String value = this.decodeValue(super.getProperty(key));
        if (!"x-charset".equals(key) && value != null) {
            value = this.convertCharset(value);
        }
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = super.getProperty(key);
        if (value == null) {
            value = defaultValue;
        } else {
            value = this.decodeValue(value);
            if (!"x-charset".equals(key)) {
                value = this.convertCharset(value);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(String filename) {
        InputStream inStream = EncodedProperties.getInStream(filename);
        if (inStream != null) {
            OutputStream outStream = null;
            try {
                try {
                    this.load(inStream);
                    if (!"true".equals(this.getProperty("x-encoding"))) return;
                    outStream = new FileOutputStream(String.valueOf(Global.getContextPath()) + "/WEB-INF/" + filename);
                    this.store(outStream, null);
                    return;
                }
                catch (IOException e) {
                    m_logger.error((Object)e.toString(), (Throwable)e);
                    try {
                        inStream.close();
                    }
                    catch (IOException e1) {
                        m_logger.error((Object)e1.toString(), (Throwable)e1);
                    }
                    if (outStream == null) return;
                    try {
                        outStream.close();
                        return;
                    }
                    catch (IOException e2) {
                        m_logger.error((Object)e2.toString(), (Throwable)e2);
                    }
                }
                return;
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e1) {
                    m_logger.error((Object)e1.toString(), (Throwable)e1);
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e2) {
                        m_logger.error((Object)e2.toString(), (Throwable)e2);
                    }
                }
            }
        }
        m_logger.error((Object)"\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u6d41\u4e3a\u7a7a");
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        if ("true".equals(this.getProperty("x-encoding"))) {
            Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
            BASE64Encoder encoder = new BASE64Encoder();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || value.startsWith("++")) continue;
                value = encoder.encode(value.getBytes());
                this.setProperty(key, "++" + value);
            }
        }
        super.store(out, comments);
    }

    private String convertCharset(String value) {
        String str;
        String charset = this.getProperty("x-charset", "GBK");
        try {
            str = new String(value.getBytes("ISO8859_1"), charset);
        }
        catch (UnsupportedEncodingException e) {
            str = value;
        }
        return str;
    }

    private String decodeValue(String value) {
        String str = value;
        if (str != null && str.startsWith("++")) {
            str = str.substring(2);
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                byte[] dec = decoder.decodeBuffer(str);
                str = new String(dec);
            }
            catch (IOException e) {
                str = null;
            }
        }
        return str;
    }

    private static InputStream getInStream(String filename) {
        FileInputStream inStream;
        try {
            String allName = String.valueOf(Global.getRealPath()) + "/WEB-INF/" + filename;
            inStream = new FileInputStream(allName);
        }
        catch (FileNotFoundException e) {
            try {
                String allName = String.valueOf(Global.getRealPath()) + "/WEB-INF/classes/" + filename;
                inStream = new FileInputStream(allName);
                m_logger.warn((Object)"\u914d\u7f6e\u6587\u4ef6\u9700\u8981\u653e\u5728WEB-INF\u76ee\u5f55\u4e2d\u3002");
            }
            catch (FileNotFoundException e1) {
                try {
                    String allName = String.valueOf(Global.getRealPath()) + "/WEB-INF/classfactory/" + filename;
                    inStream = new FileInputStream(allName);
                    m_logger.warn((Object)"\u914d\u7f6e\u6587\u4ef6\u9700\u8981\u653e\u5728WEB-INF\u76ee\u5f55\u4e2d\u3002");
                }
                catch (FileNotFoundException e2) {
                    m_logger.warn((Object)("\u914d\u7f6e\u6587\u4ef6\"" + filename + "\"\u672a\u627e\u5230\u3002"));
                    inStream = null;
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            inStream = null;
        }
        return inStream;
    }
}

