/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.bo.Cache;
import com.sdjxd.hussar.core.base72.bo.Context;
import com.sdjxd.hussar.core.base72.service.CacheService;
import com.sdjxd.hussar.core.base72.service.ContextService;
import com.sdjxd.hussar.core.base72.service.MessageService;
import com.sdjxd.hussar.core.base72.service.ParamService;
import com.sdjxd.hussar.core.base72.service.PropertiesService;
import com.sdjxd.hussar.core.base72.service.SystemLogService;
import com.sdjxd.hussar.core.utils.HussarEvent;

public final class Global {
    private static String version;
    private static Boolean isDebug;
    public static final HussarEvent onServerStart;
    private static PropertiesService propertiesService;
    private static ContextService contextService;
    private static CacheService cacheService;
    private static MessageService messageService;
    private static ParamService paramService;
    private static SystemLogService logService;

    static {
        onServerStart = new HussarEvent();
        contextService = new ContextService();
        cacheService = new CacheService();
    }

    public static PropertiesService getConfigService() {
        if (propertiesService == null) {
            propertiesService = new PropertiesService();
        }
        return propertiesService;
    }

    public static ContextService getContextService() {
        return contextService;
    }

    public static CacheService getCacheService() {
        return cacheService;
    }

    public static ParamService getParamService() {
        if (paramService == null) {
            try {
                paramService = new ParamService();
            }
            catch (Exception exp) {
                System.out.println("\u521b\u5efa\u7cfb\u7edf\u53c2\u6570\u670d\u52a1\u7c7b\u5931\u8d25\uff01");
            }
        }
        return paramService;
    }

    public static SystemLogService getSystemLogService() {
        if (logService == null) {
            try {
                logService = new SystemLogService();
            }
            catch (Exception exp) {
                System.out.println("\u521b\u5efa\u7cfb\u7edf\u65e5\u5fd7\u670d\u52a1\u7c7b\u5931\u8d25\uff01");
            }
        }
        return logService;
    }

    public static MessageService getMessageService() {
        if (messageService == null) {
            try {
                messageService = new MessageService();
            }
            catch (Exception exp) {
                System.out.println("\u521b\u5efa\u56fd\u9645\u5316\u670d\u52a1\u7c7b\u5931\u8d25\uff01");
            }
        }
        return messageService;
    }

    public static String getConfig(String keyName) {
        return Global.getConfig("global", keyName);
    }

    public static String getConfig(String fileName, String keyName) {
        if (propertiesService == null) {
            propertiesService = new PropertiesService();
        }
        return propertiesService.getConfig(fileName, keyName);
    }

    public static Context getContext() {
        return contextService.getContext();
    }

    public static <T> Cache<T> createCache(Class<T> cacheClass, int maxSize) {
        return cacheService.createCache(cacheClass, maxSize);
    }

    public static <T> Cache<T> getCache(Class<T> cacheClass) throws Exception {
        return cacheService.getCache(cacheClass);
    }

    public static String getParam(String paramByName) throws Exception {
        if (paramService == null) {
            try {
                paramService = new ParamService();
            }
            catch (Exception exp) {
                System.out.println("\u521b\u5efa\u7cfb\u7edf\u53c2\u6570\u670d\u52a1\u7c7b\u5931\u8d25\uff01");
                throw exp;
            }
        }
        return paramService.getParam(paramByName);
    }

    public static String getContextPath() {
        return contextService.getContextPath();
    }

    public static String getRealPath() {
        return contextService.getRealPath();
    }

    public static void setRealPath(String path) {
        contextService.setRealPath(path);
    }

    public static void log(String userId, String patternId, String instanceId, String beizu, Const.LOGTYPE type, String ip) {
        if (logService == null) {
            try {
                logService = new SystemLogService();
            }
            catch (Exception exp) {
                System.out.println("\u521b\u5efa\u7cfb\u7edf\u65e5\u5fd7\u670d\u52a1\u7c7b\u5931\u8d25\uff01");
            }
        }
        logService.log(userId, patternId, instanceId, beizu, type, ip);
    }

    public static boolean isDebug() throws Exception {
        if (isDebug == null) {
            isDebug = propertiesService.isDebug();
        }
        return isDebug;
    }

    public static String getVersion() {
        return version;
    }

    public static void setContext(Context context) {
        contextService.setContext(context);
    }
}

