/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.base72;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.form72.bo.IFormCellBo;
import com.sdjxd.hussar.core.utils.HussarBean;
import com.sdjxd.pms.platform.data.DataSource;
import org.apache.log4j.Logger;

public class Factory {
    private static Logger log = Logger.getLogger(Factory.class);

    public static <T> T getBo(Const.LAYER layer, Class<T> boInterfaceClass) throws Exception {
        return Factory.getBo(layer, boInterfaceClass, null);
    }

    public static <T> T getBo(Const.LAYER layer, Class<T> boInterfaceClass, String boImplName) throws Exception {
        T o = null;
        String className = boInterfaceClass.getName().substring(boInterfaceClass.getPackage().getName().length() + 1);
        String aImplClassName = null;
        aImplClassName = boImplName != null && boImplName.length() != 0 ? Global.getConfig("beanFactory", new StringBuffer().append(layer.name()).append(".").append(className).append(".").append(boImplName).toString()) : Global.getConfig("beanFactory", new StringBuffer().append(layer.name()).append(".").append(className).toString());
        o = (T)HussarBean.getInstance(HussarBean.getClassType(aImplClassName), null);
        return o;
    }

    public static <T> T getService(Const.LAYER layer, Class<T> serviceInterfaceClass) throws Exception {
        T o = null;
        String className = serviceInterfaceClass.getName().substring(serviceInterfaceClass.getPackage().getName().length() + 1);
        String aImplClassName = Global.getConfig("beanFactory", String.valueOf(layer.name()) + "." + className);
        o = (T)HussarBean.getSingleInstance(HussarBean.getClassType(aImplClassName));
        return o;
    }

    public static <T> T getDao(String dataSourceName, Class<T> daoClass) throws Exception {
        Object o = null;
        String packageName = daoClass.getPackage().getName();
        String daoClassName = daoClass.getName().substring(packageName.length());
        DataSource dataSource = DataSource.getDataSource((String)dataSourceName);
        StringBuffer daoClassBuffer = new StringBuffer(packageName);
        daoClassBuffer.append(".support.").append(dataSource.getDbType().getName());
        daoClassBuffer.append(daoClassName).append("Impl");
        String fullClassName = daoClassBuffer.toString();
        if (!HussarBean.isExist(fullClassName)) {
            daoClassBuffer.setLength(0);
            daoClassBuffer.append(packageName).append(".support.sql").append(daoClassName).append("Impl");
            fullClassName = daoClassBuffer.toString();
        }
        o = HussarBean.getSingleInstance(fullClassName);
        return (T)o;
    }

    public static <T> T getDao(Class<T> daoClass) throws Exception {
        return Factory.getDao("defaultds", daoClass);
    }

    public static IFormCellBo getFormCell(Const.LAYER layer, int cellType) throws Exception {
        return Factory.getBo(layer, IFormCellBo.class, String.valueOf(cellType));
    }
}

