/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.util.Convertion;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbTime {
    final int DMDT_HOUR_POS = 0;
    final int DMDT_HOUR_LEN = 5;
    final int DMDT_MIN_POS = 5;
    final int DMDT_MIN_LEN = 6;
    final int DMDT_SEC_POS = 11;
    final int DMDT_SEC_LEN = 6;
    final int DMDT_MSEC_POS = 17;
    final int DMDT_MSEC_LEN = 20;
    byte[] times = new byte[5];

    public DmdbTime() {
    }

    public DmdbTime(byte[] bt) {
        this.times = bt;
    }

    public DmdbTime(String str) throws SQLException {
        String[] tmp = str.split(" ");
        if (tmp.length == 2) {
            str = tmp[1];
        }
        String[] subStr = StringUtil.split(str, ":.");
        try {
            byte h = Byte.parseByte(subStr[0]);
            byte m = Byte.parseByte(subStr[1]);
            byte s = Byte.parseByte(subStr[2]);
            int nano = 0;
            if (subStr.length > 3) {
                StringBuffer strNano = new StringBuffer(10);
                strNano.append("0");
                strNano.append(".");
                strNano.append(subStr[3]);
                double d_v = Double.valueOf(strNano.toString());
                nano = (int)(d_v * 1000000.0);
            }
            this.setBit(this.times, 0, 5, h);
            this.setBit(this.times, 5, 6, m);
            this.setBit(this.times, 11, 6, s);
            this.setBit(this.times, 17, 20, nano);
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
    }

    public final byte[] getByteArrayValue() throws SQLException {
        String str = this.getTimeWithNano();
        byte[] dt = new byte[12];
        String[] subStr = StringUtil.split(str, ":.");
        byte hour = Byte.parseByte(subStr[0]);
        byte minute = Byte.parseByte(subStr[1]);
        byte sec = Byte.parseByte(subStr[2]);
        if (hour > 24 || hour < 0 || minute > 60 || minute < 0 || sec > 60 || sec < 0) {
            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
        }
        dt[4] = hour;
        dt[5] = minute;
        dt[6] = sec;
        int nano = 0;
        if (subStr.length > 3) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(subStr[3]);
            double d_v = Double.valueOf(strNano.toString());
            nano = (int)(d_v * 1000000.0);
        }
        byte[] msec = Convertion.IntToByteArray(nano);
        System.arraycopy(msec, 0, dt, 7, 3);
        return dt;
    }

    public final byte getHour() {
        int b = this.getBit(this.times, 0, 5);
        return (byte)b;
    }

    public final byte getMinute() {
        int b = this.getBit(this.times, 5, 6);
        return (byte)b;
    }

    public final byte getSecond() {
        int b = this.getBit(this.times, 11, 6);
        return (byte)b;
    }

    public final int getNano() {
        int b = this.getBit(this.times, 17, 20);
        return b;
    }

    public final Time getTime() {
        return new Time(this.getHour(), this.getMinute(), this.getSecond());
    }

    public final String getTimeWithNano() {
        byte hour = this.getHour();
        byte min = this.getMinute();
        byte sec = this.getSecond();
        int nano = this.getNano();
        StringBuffer sb = new StringBuffer(15);
        String h = new Integer(hour).toString();
        String m = new Integer(min).toString();
        String s = new Integer(sec).toString();
        String n = new Integer(nano).toString();
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        String naro = "";
        for (int i = 0; i < 6 - n.length(); ++i) {
            naro = naro.concat("0");
        }
        n = naro.concat(n);
        sb.append(h).append(":").append(m).append(":").append(s).append(".").append(n);
        return sb.toString();
    }

    public final String toString() {
        return this.getTimeWithNano();
    }

    public final Timestamp getTimestamp() {
        long t2 = this.getTime().getTime();
        Timestamp ts = new Timestamp(t2);
        ts.setNanos(this.getNano() * 1000);
        return ts;
    }

    int getBit(byte[] x, int start, int len) {
        int xx0 = 0;
        int start_bit = start & 7;
        int s = start >> 3;
        int e = (start + len - 1 >> 3) + 1;
        int n = e - s;
        int p = start >> 3;
        if (n == 1) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            xx0 = Convertion.fourByteToInt(t1);
        } else if (n == 2) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            xx0 = x1 + x2;
        } else if (n == 3) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            System.arraycopy(x, p + 2, t1, 0, 1);
            int x3 = Convertion.fourByteToInt(t1);
            x3 = x3 << 16 & 0xFFFFFFFF;
            xx0 = x1 + x2 + x3;
        }
        return xx0 >> start_bit & -1 >>> 32 - len;
    }

    void setBit(byte[] x, int start, int len, int data) {
        int start_bit = start & 7;
        int last_bit = start + len & 7;
        int s = start >> 3;
        int e = (start + len - 1 >> 3) + 1;
        byte[] p = Convertion.IntToByteArray(data <<= start_bit);
        for (int n = s; n < e; ++n) {
            if (n == s) {
                x[n] = (byte)(x[n] & 255 >>> 8 - start_bit);
                x[n] = (byte)(x[n] | p[n - s]);
                continue;
            }
            if (n == e - 1) {
                x[n] = (byte)(x[n] & 255 << last_bit);
                x[n] = (byte)(x[n] | p[n - s]);
                continue;
            }
            x[n] = p[n - s];
        }
    }
}

