/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.util.Convertion;
import dm.jdbc.util.StringUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbDateTime {
    final int DMDT_YEAR_POS = 0;
    final int DMDT_YEAR_LEN = 15;
    final int DMDT_MONTH_POS = 15;
    final int DMDT_MONTH_LEN = 4;
    final int DMDT_DAY_POS = 19;
    final int DMDT_DAY_LEN = 5;
    final int DMDT_DATE_SIZE = 24;
    final int DMDT_HOUR_POS = 0;
    final int DMDT_HOUR_LEN = 5;
    final int DMDT_MIN_POS = 5;
    final int DMDT_MIN_LEN = 6;
    final int DMDT_SEC_POS = 11;
    final int DMDT_SEC_LEN = 6;
    final int DMDT_MSEC_POS = 17;
    final int DMDT_MSEC_LEN = 20;
    byte[] dateTime = new byte[3];
    public static final int DMDT_DATE = 0;
    public static final int DMDT_TIME = 1;
    public static final int DMDT_TIMESTAMP = 2;

    public DmdbDateTime(byte[] dt) {
        this.dateTime = dt;
    }

    public DmdbDateTime(String str, int flag) {
        this.dateTime = new byte[12];
        if (flag == 0) {
            String[] subStr = StringUtil.split(str, "-");
            short year = Short.parseShort(subStr[0]);
            byte month = Byte.parseByte(subStr[1]);
            byte day = Byte.parseByte(subStr[2]);
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = month;
            this.dateTime[3] = day;
        } else if (flag == 2) {
            String[] subStr = StringUtil.split(str, "-: .");
            short year = Short.parseShort(subStr[0]);
            byte month = Byte.parseByte(subStr[1]);
            byte day = Byte.parseByte(subStr[2]);
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = month;
            this.dateTime[3] = day;
            byte hour = Byte.parseByte(subStr[3]);
            byte minute = Byte.parseByte(subStr[4]);
            byte sec = Byte.parseByte(subStr[5]);
            this.dateTime[4] = hour;
            this.dateTime[5] = minute;
            this.dateTime[6] = sec;
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(subStr[6]);
            double d_v = Double.valueOf(strNano.toString());
            int nano = (int)(d_v * 1000000.0);
            byte[] msec = Convertion.IntToByteArray(nano);
            System.arraycopy(msec, 0, this.dateTime, 7, 3);
        }
    }

    public byte[] getByteArrayValue() {
        return this.dateTime;
    }

    short getYear() {
        int y;
        if (this.dateTime.length == 12) {
            byte[] byte_tmp = new byte[]{this.dateTime[0], this.dateTime[1]};
            y = Convertion.twoByteToShort(byte_tmp);
        } else {
            y = this.getBit(this.dateTime, 0, 15);
        }
        return (short)y;
    }

    byte getMonth() {
        int b = this.dateTime.length == 12 ? this.dateTime[2] : this.getBit(this.dateTime, 15, 4);
        return (byte)b;
    }

    byte getDay() {
        int b1 = this.dateTime.length == 12 ? this.dateTime[3] : this.getBit(this.dateTime, 19, 5);
        return (byte)b1;
    }

    byte getHour(int offset) {
        int b = this.dateTime.length == 12 ? this.dateTime[4] : this.getBit(this.dateTime, offset + 0, 5);
        return (byte)b;
    }

    byte getMinute(int offset) {
        int b = this.dateTime.length == 12 ? this.dateTime[5] : this.getBit(this.dateTime, offset + 5, 6);
        return (byte)b;
    }

    byte getSecond(int offset) {
        int b = this.dateTime.length == 12 ? this.dateTime[6] : this.getBit(this.dateTime, offset + 11, 6);
        return (byte)b;
    }

    int getNano(int offset) {
        int b;
        if (this.dateTime.length == 12) {
            byte[] msec = new byte[4];
            System.arraycopy(this.dateTime, 7, msec, 0, 3);
            b = Convertion.fourByteToInt(msec);
        } else {
            b = this.getBit(this.dateTime, offset + 17, 20);
        }
        return b;
    }

    public final Date getDate() {
        return new Date(this.getYear() - 1900, this.getMonth() - 1, this.getDay());
    }

    public final Time getTime() {
        return new Time(this.getHour(0), this.getMinute(0), this.getSecond(0));
    }

    public final String getTimeInString() {
        byte hour = this.getHour(0);
        byte min = this.getMinute(0);
        byte sec = this.getSecond(0);
        int nano = this.getNano(0);
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        String n = "" + nano;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s + "." + n;
    }

    public final String getTimeOfTimestamp() {
        byte hour = this.getHour(24);
        byte min = this.getMinute(24);
        byte sec = this.getSecond(24);
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s;
    }

    public final Timestamp getTimestamp() {
        String str = String.valueOf(this.getDate()) + " " + this.getTimeOfTimestamp();
        Timestamp ts = Timestamp.valueOf(str);
        ts.setNanos(this.getNano(24) * 1000);
        return ts;
    }

    public static Date getDateByString(String s) throws SQLException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int dividingSpace = s.indexOf(32);
        if (dividingSpace > 0) {
            s = s.substring(0, dividingSpace);
        }
        int firstDash = s.indexOf(45);
        int secondDash = s.indexOf(45, firstDash + 1);
        if (firstDash < 0 || secondDash < 0) {
            firstDash = s.indexOf(46);
            secondDash = s.indexOf(46, firstDash + 1);
        }
        if (firstDash < 0 || secondDash < 0) {
            firstDash = s.indexOf(47);
            secondDash = s.indexOf(47, firstDash + 1);
        }
        if (!(firstDash > 0 & secondDash > 0 & secondDash < s.length() - 1)) {
            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
        }
        int year = Integer.parseInt(s.substring(0, firstDash)) - 1900;
        int month = Integer.parseInt(s.substring(firstDash + 1, secondDash)) - 1;
        int day = Integer.parseInt(s.substring(secondDash + 1));
        if (!DmdbDateTime.checkDate(year + 1900, month + 1, day)) {
            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
        }
        return new Date(year, month, day);
    }

    public static boolean dmdt_is_leap_year(int year) {
        if (year < 0) {
            year = -year;
        }
        if (year % 4 == 0) {
            return year % 100 != 0 || year % 400 == 0;
        }
        return false;
    }

    public static boolean checkDate(int year, int month, int day) {
        if (year == 0 || month == 0 || day == 0) {
            return false;
        }
        if (year > 10000 || year < -10000 || month > 12 || month < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (day <= 31 && day >= 1) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (day <= 30 && day >= 1) break;
                return false;
            }
            case 2: {
                if (!(DmdbDateTime.dmdt_is_leap_year(year) ? day > 29 || day < 1 : day > 28 || day < 1)) break;
                return false;
            }
        }
        return true;
    }

    public static Timestamp getTimestampByString(String s) throws SQLException {
        int a_nanos;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        block25: {
            year = 0;
            month = 0;
            day = 0;
            hour = 0;
            minute = 0;
            second = 0;
            a_nanos = 0;
            int firstColon = 0;
            int secondColon = 0;
            int period = 0;
            String zeros = "000000000";
            if (s == null) {
                throw new IllegalArgumentException("null string");
            }
            int dividingSpace = (s = s.trim()).indexOf(32);
            if (dividingSpace > 0) {
                String date_s = s.substring(0, dividingSpace);
                String time_s = s.substring(dividingSpace + 1);
                int firstDash = date_s.indexOf(45);
                int secondDash = date_s.indexOf(45, firstDash + 1);
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s.indexOf(46);
                    secondDash = s.indexOf(46, firstDash + 1);
                }
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s.indexOf(47);
                    secondDash = s.indexOf(47, firstDash + 1);
                }
                if (time_s == null) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                firstColon = time_s.indexOf(58);
                secondColon = time_s.indexOf(58, firstColon + 1);
                period = time_s.indexOf(46, secondColon + 1);
                if (!(firstDash > 0 & secondDash > 0 & secondDash < date_s.length() - 1)) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                year = Integer.parseInt(date_s.substring(0, firstDash)) - 1900;
                month = Integer.parseInt(date_s.substring(firstDash + 1, secondDash)) - 1;
                day = Integer.parseInt(date_s.substring(secondDash + 1));
                if (firstColon > 0 & secondColon > 0 & secondColon < time_s.length() - 1) {
                    hour = Integer.parseInt(time_s.substring(0, firstColon));
                    minute = Integer.parseInt(time_s.substring(firstColon + 1, secondColon));
                    if (period > 0 & period < time_s.length() - 1) {
                        second = Integer.parseInt(time_s.substring(secondColon + 1, period));
                        String nanos_s = time_s.substring(period + 1);
                        if (nanos_s.length() > 9) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        if (!Character.isDigit(nanos_s.charAt(0))) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        nanos_s = nanos_s + zeros.substring(0, 9 - nanos_s.length());
                        a_nanos = Integer.parseInt(nanos_s);
                    } else {
                        if (period > 0) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        second = Integer.parseInt(time_s.substring(secondColon + 1));
                    }
                } else {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                if (!DmdbDateTime.checkDate(year + 1900, month + 1, day)) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                if (hour > 24 || hour < 0 || minute > 60 || minute < 0 || second > 60 || second < 0) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
            } else {
                dividingSpace = s.indexOf(45);
                int dividingSpace1 = s.indexOf(46);
                int dividingSpace2 = s.indexOf(47);
                if (dividingSpace > 0 || dividingSpace1 > 0 || dividingSpace2 > 0) {
                    try {
                        int firstDash = s.indexOf(45);
                        int secondDash = s.indexOf(45, firstDash + 1);
                        if (firstDash < 0 || secondDash < 0) {
                            firstDash = s.indexOf(46);
                            secondDash = s.indexOf(46, firstDash + 1);
                        }
                        if (firstDash < 0 || secondDash < 0) {
                            firstDash = s.indexOf(47);
                            secondDash = s.indexOf(47, firstDash + 1);
                        }
                        if (!(firstDash > 0 & secondDash > 0 & secondDash < s.length() - 1)) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        year = Integer.parseInt(s.substring(0, firstDash)) - 1900;
                        month = Integer.parseInt(s.substring(firstDash + 1, secondDash)) - 1;
                        day = Integer.parseInt(s.substring(secondDash + 1));
                        if (!DmdbDateTime.checkDate(year + 1900, month + 1, day)) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        break block25;
                    }
                    catch (Exception ex) {
                        throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                    }
                }
                try {
                    Time t2 = Time.valueOf(s);
                    hour = t2.getHours();
                    minute = t2.getMinutes();
                    second = t2.getSeconds();
                    day = 1;
                }
                catch (Exception ex) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
        }
        return new Timestamp(year, month, day, hour, minute, second, a_nanos);
    }

    public static String getTimeFromTimestamp(Timestamp ts) {
        int hour = ts.getHours();
        int min = ts.getMinutes();
        int sec = ts.getSeconds();
        int msec = ts.getNanos();
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s + "." + msec;
    }

    int getBit(byte[] x, int start, int len) {
        int xx0 = 0;
        int start_bit = start & 7;
        int s = start >> 3;
        int e = (start + len - 1 >> 3) + 1;
        int n = e - s;
        int p = start >> 3;
        if (n == 1) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            xx0 = Convertion.fourByteToInt(t1);
        } else if (n == 2) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            xx0 = x1 + x2;
        } else if (n == 3) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            System.arraycopy(x, p + 2, t1, 0, 1);
            int x3 = Convertion.fourByteToInt(t1);
            x3 = x3 << 16 & 0xFFFFFFFF;
            xx0 = x1 + x2 + x3;
        }
        return xx0 >> start_bit & -1 >>> 32 - len;
    }
}

