/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.xa;

import dm.jdbc.driver.DmdbConnection;
import java.sql.Connection;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DmdbXAResource
implements XAResource {
    public boolean recoverd = false;
    Connection conn;
    int m_timeout;

    public DmdbXAResource() {
        this.conn = null;
        this.m_timeout = 60;
    }

    public DmdbXAResource(Connection connection) {
        this.conn = connection;
        this.m_timeout = 60;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        int k = onePhase ? 0x40000000 : 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(4, xid, k);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception ee) {
            // empty catch block
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(2, xid, flags);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(7, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        Connection connection = null;
        if (!(xares instanceof DmdbXAResource)) {
            return false;
        }
        connection = ((DmdbXAResource)xares).getConnection();
        if (connection == null) {
            return false;
        }
        String url = ((DmdbConnection)connection).getURL();
        return connection.equals(this.conn) || url.equals(((DmdbConnection)this.conn).getURL());
    }

    public int prepare(Xid xid) throws XAException {
        int retcode = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            retcode = ((DmdbConnection)this.conn).getCSI().xa_process(3, xid, 0);
            if (retcode != 0 && retcode != 3) {
                throw new XAException();
            }
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retcode;
    }

    public Xid[] recover(int flag) throws XAException {
        ArrayList<Xid> rec_xids = new ArrayList<Xid>();
        Xid[] xids = null;
        Xid[] tmp = null;
        if (flag != 0x1000000 && flag != 0x800000 && flag != 0 && flag != 0x1800000) {
            throw new XAException(-5);
        }
        try {
            if (flag == 0x1800000) {
                int i;
                this.recoverd = false;
                tmp = ((DmdbConnection)this.conn).getCSI().xa_recover(this, 0x1000000);
                if (this.recoverd) {
                    return tmp;
                }
                for (i = 0; i < tmp.length; ++i) {
                    rec_xids.add(tmp[i]);
                }
                do {
                    tmp = ((DmdbConnection)this.conn).getCSI().xa_recover(this, 0);
                    for (i = 0; i < tmp.length; ++i) {
                        rec_xids.add(tmp[i]);
                    }
                } while (!this.recoverd);
                xids = new Xid[rec_xids.size()];
                xids = (Xid[])rec_xids.toArray();
                return xids;
            }
            if (flag == 0x1000000) {
                this.recoverd = false;
                xids = ((DmdbConnection)this.conn).getCSI().xa_recover(this, 0x1000000);
                return xids;
            }
            if (flag == 0) {
                if (this.recoverd) {
                    return null;
                }
                xids = ((DmdbConnection)this.conn).getCSI().xa_recover(this, 0);
                return xids;
            }
            if (this.recoverd) {
                return null;
            }
            xids = ((DmdbConnection)this.conn).getCSI().xa_recover(this, 0x800000);
            return xids;
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception ee) {
            return xids;
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(5, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.m_timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(1, xid, flags);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void heurCommit(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(8, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void heurRollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            ((DmdbConnection)this.conn).getCSI().xa_process(9, xid, 0);
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

