/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

public class StringUtil {
    private static final int _$5221 = 256;
    private static byte[] _$5224 = new byte[256];
    private static char[] _$5225 = new char[256];

    public static final String toAsciiString(byte[] buffer) {
        return StringUtil.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        for (int i = 0; i < length; ++i) {
            charArray[i] = _$5225[buffer[readpoint] - -128];
            ++readpoint;
        }
        return new String(charArray);
    }

    public static final char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        for (int i = 0; i < length; ++i) {
            char c = searchIn.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return Character.toUpperCase(c);
        }
        return '\u0000';
    }

    public static final boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtil.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static final boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, 0, searchFor, startAt, searchFor.length());
    }

    public static final boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        int beginPos = 0;
        int inLength = searchIn.length();
        for (beginPos = 0; beginPos < inLength && Character.isWhitespace(searchIn.charAt(beginPos)); ++beginPos) {
        }
        return StringUtil.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static final String[] split(String s, String seperators) {
        if (s == null || seperators == null) {
            return null;
        }
        int[] foot = new int[s.length()];
        int count = 0;
        int sLen = s.length();
        int seperatorsLen = seperators.length();
        block0: for (int i = 0; i < sLen; ++i) {
            if (i == 0 && sLen >= seperatorsLen && s.substring(0, seperatorsLen).equals(seperators)) {
                i += seperatorsLen - 1;
                continue;
            }
            for (int j = 0; j < seperatorsLen; ++j) {
                if (s.charAt(i) != seperators.charAt(j)) continue;
                foot[count] = i;
                ++count;
                continue block0;
            }
        }
        String[] ret = new String[count + 1];
        if (count == 0) {
            ret[0] = s;
            return ret;
        }
        ret[0] = s.substring(0, foot[0]);
        for (int i = 1; i < count; ++i) {
            ret[i] = s.substring(foot[i - 1] + 1, foot[i]);
        }
        ret[count] = s.substring(foot[count - 1] + 1, s.length());
        return ret;
    }

    public static final String getEscObjName(String name) {
        String escName = "";
        if (name == null || name.indexOf("\"") == -1) {
            return name;
        }
        int index = 0;
        while (true) {
            int index2;
            if ((index2 = name.indexOf("\"", index)) == -1) break;
            escName = escName + name.substring(index, index2 + 1);
            escName = escName + "\"";
            index = index2 + 1;
        }
        escName = escName + name.substring(index);
        return escName;
    }

    public static final String getEscStringName(String name) {
        String escName = "";
        if (name == null || name.indexOf("'") == -1) {
            return name;
        }
        int index = 0;
        while (true) {
            int index2;
            if ((index2 = name.indexOf("'", index)) == -1) break;
            escName = escName + name.substring(index, index2 + 1);
            escName = escName + "'";
            index = index2 + 1;
        }
        escName = escName + name.substring(index);
        return escName;
    }

    static {
        for (int i = -128; i <= 127; ++i) {
            StringUtil._$5224[i - -128] = (byte)i;
        }
        String allBytesString = new String(_$5224, 0, 255);
        int allBytesStringLen = allBytesString.length();
        for (int i = 0; i < 255 && i < allBytesStringLen; ++i) {
            StringUtil._$5225[i] = allBytesString.charAt(i);
        }
    }
}

