/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class Convertion {
    public static final byte[] byteToByteArray(byte b) {
        byte[] b_array = new byte[]{b};
        return b_array;
    }

    public static final byte[] doubleToByteArray(double d) {
        long l = Double.doubleToLongBits(d);
        return Convertion.longToByteArray(l);
    }

    public static final byte[] floatToByteArray(float f) {
        int i = Float.floatToIntBits(f);
        byte[] b = new byte[4];
        int position = 0;
        b[position++] = (byte)(i & 0xFF);
        b[position++] = (byte)(i >>> 8);
        b[position++] = (byte)(i >>> 16);
        b[position] = (byte)(i >>> 24);
        return b;
    }

    public static final byte[] shortToByteArray(int i) {
        byte[] b = new byte[2];
        int position = 0;
        b[position++] = (byte)(i & 0xFF);
        b[position] = (byte)(i >>> 8);
        return b;
    }

    public static final byte[] IntToByteArray(long i) {
        byte[] b = new byte[4];
        int position = 0;
        b[position++] = (byte)(i & 0xFFL);
        b[position++] = (byte)(i >>> 8);
        b[position++] = (byte)(i >>> 16);
        b[position] = (byte)(i >>> 24);
        return b;
    }

    public static final byte[] longToByteArray(long i) {
        byte[] b = new byte[8];
        int position = 0;
        b[position++] = (byte)(i & 0xFFL);
        b[position++] = (byte)(i >>> 8);
        b[position++] = (byte)(i >>> 16);
        b[position++] = (byte)(i >>> 24);
        b[position++] = (byte)(i >>> 32);
        b[position++] = (byte)(i >>> 40);
        b[position++] = (byte)(i >>> 48);
        b[position++] = (byte)(i >>> 56);
        return b;
    }

    public static final byte[] BigDecimalToByteArray(BigDecimal x) {
        String s = x.abs().toString();
        byte[] b = s.getBytes();
        int length = b.length;
        byte[] inValueBytes = new byte[length + 1];
        System.arraycopy(b, 0, inValueBytes, 1, length);
        int signNum = x.signum();
        inValueBytes[0] = signNum < 0 ? 45 : 43;
        return inValueBytes;
    }

    public static final short twoByteToShort(byte[] byte1) {
        long n = 0L;
        int p = 2;
        for (int i = 0; i < 2; ++i) {
            long b = 0xFF & byte1[--p];
            n = b | n << 8;
        }
        return (short)(0xFFFFFFFFFFFFFFFFL & n);
    }

    public static final int fourByteToInt(byte[] byte1) {
        if (byte1.length == 2) {
            return Convertion.twoByteToShort(byte1);
        }
        long n = 0L;
        int p = 4;
        for (int i = 0; i < 4; ++i) {
            long b = 0xFF & byte1[--p];
            n = b | n << 8;
        }
        return (int)(0xFFFFFFFFFFFFFFFFL & n);
    }

    public static final long eightByteToLong(byte[] byte1) {
        long n = 0L;
        int p = 8;
        for (int i = 0; i < 8; ++i) {
            long b = 0xFF & byte1[--p];
            n = b | n << 8;
        }
        return n;
    }

    public static final byte[] getMetaDataPointer(byte[] bytes) {
        byte[] locator = new byte[16];
        System.arraycopy(bytes, 5, locator, 0, 6);
        System.arraycopy(bytes, 11, locator, 6, 8);
        System.arraycopy(bytes, 19, locator, 14, 2);
        return locator;
    }

    public static final byte[] setRowid(byte[] locator) {
        int i;
        byte[] rowid_high = new byte[4];
        byte[] rowid_low = new byte[4];
        byte[] tmplocator = (byte[])locator.clone();
        for (i = 0; i < 4; ++i) {
            rowid_low[i] = locator[9 - i];
        }
        for (i = 0; i < 4; ++i) {
            rowid_high[i] = locator[13 - i];
        }
        for (i = 0; i < 4; ++i) {
            tmplocator[6 + i] = rowid_low[i];
        }
        for (i = 0; i < 4; ++i) {
            tmplocator[10 + i] = rowid_high[i];
        }
        return tmplocator;
    }

    public static final byte[] truncate_rowid(byte[] rowid) {
        byte[] new_rowid = new byte[5];
        System.arraycopy(rowid, 4, new_rowid, 0, 4);
        System.arraycopy(rowid, 0, new_rowid, 4, 1);
        return new_rowid;
    }

    public static final void setByte(byte[] buf, int off, byte val) {
        buf[off] = val;
    }

    public static final void setShort(byte[] buf, int off, short val) {
        buf[off] = (byte)(val & 0xFF);
        buf[off + 1] = (byte)(val >> 8 & 0xFF);
    }

    public static final void setInt(byte[] buf, int off, int val) {
        buf[off++] = (byte)(val & 0xFF);
        buf[off++] = (byte)((val >>= 8) & 0xFF);
        buf[off++] = (byte)((val >>= 8) & 0xFF);
        buf[off++] = (byte)((val >>= 8) & 0xFF);
        val >>= 8;
    }

    public static final byte getByte(byte[] buf, int off) {
        return buf[off];
    }

    public static final short getShort(byte[] buf, int off) {
        byte low = buf[off];
        byte high = buf[off + 1];
        return (short)(high << 8 | 0xFF & low);
    }

    public static final int getInt(byte[] buf, int off) {
        short low = Convertion.getShort(buf, off);
        short high = Convertion.getShort(buf, off + 2);
        return high << 16 | 0xFFFF & low;
    }

    public static final long getLong(byte[] buf, int off) {
        int low = Convertion.getInt(buf, off);
        int high = Convertion.getInt(buf, off + 4);
        return high << 32 | 0xFFFFFFFF & low;
    }

    public static final byte[] getBytes(String str, String serverEncoding) {
        byte[] buf = null;
        if (serverEncoding != null) {
            try {
                buf = str.getBytes(serverEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        } else {
            buf = str.getBytes();
        }
        return buf;
    }

    public static final byte[] getBytes(String str, int offset, int len, String charsetName) {
        byte[] buf = null;
        if (str == null) {
            return buf;
        }
        if (charsetName != null) {
            try {
                buf = str.substring(offset, offset + len).getBytes(charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        } else {
            buf = str.substring(offset, offset + len).getBytes();
        }
        return buf;
    }

    public static final String getString(byte[] buffer, int offset, int bytelen) {
        if (buffer == null) {
            return null;
        }
        return new String(buffer, offset, bytelen);
    }

    public static final String getString(byte[] buffer, int offset, int byteLen, String charsetName) {
        String str = null;
        if (buffer == null) {
            return str;
        }
        if (charsetName == null) {
            str = new String(buffer, offset, byteLen);
        } else {
            try {
                str = new String(buffer, offset, byteLen, charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        }
        return str;
    }

    public static final void setString(byte[] buffer, String str, int offset) {
        byte[] buf = str.getBytes();
        int len = buf.length;
        for (int i = 0; i < len; ++i) {
            buffer[offset++] = buf[i];
        }
    }

    public static final byte[] setStringWithNTS(byte[] buffer, int offset, byte[] buf) {
        int len = buf.length;
        if (len + offset >= buffer.length) {
            byte[] buf2 = new byte[len + offset + 1024];
            System.arraycopy(buffer, 0, buf2, 0, buffer.length);
            buffer = buf2;
        }
        System.arraycopy(buf, 0, buffer, offset, len);
        buffer[offset + len] = 0;
        return buffer;
    }

    public static final byte[] getBytes(byte[] buffer, int offset, int len) {
        if (buffer == null) {
            return null;
        }
        byte[] buf = new byte[len];
        System.arraycopy(buffer, offset, buf, 0, len);
        return buf;
    }

    public static final byte[] getBytes(byte[] buffer, int offset, int len, String charsetName, String destCharsetName) {
        if (buffer == null) {
            return null;
        }
        byte[] buf = new byte[len];
        System.arraycopy(buffer, offset, buf, 0, len);
        if (charsetName != null && destCharsetName != null) {
            try {
                String str = new String(buf, charsetName);
                buf = str.getBytes(destCharsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        }
        return buf;
    }

    public static final byte[] getBytes(char[] buffer, int offset, int len, String charsetName, String destCharsetName) {
        if (buffer == null) {
            return null;
        }
        String str = new String(buffer, offset, len);
        return Convertion.getBytes(str, offset, len, charsetName, destCharsetName);
    }

    public static final byte[] getBytes(String str, int offset, int len, String charsetName, String destCharsetName) {
        byte[] buf = null;
        if (str == null) {
            return null;
        }
        if (destCharsetName != null) {
            try {
                buf = str.getBytes(destCharsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        } else {
            buf = str.getBytes();
        }
        return buf;
    }

    public static final String bytesToHexString(byte[] bs) {
        if (bs == null) {
            return null;
        }
        if (bs.length == 0) {
            return "";
        }
        String hexDigits = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < bs.length; ++i) {
            int high = 0xF & bs[i] >> 4;
            int low = 0xF & bs[i];
            ret = ret + hexDigits.charAt(high);
            ret = ret + hexDigits.charAt(low);
        }
        return ret;
    }

    public static final String intToHex(int num) {
        String ret = "";
        block8: for (int i = 0; i < 2; ++i) {
            int a;
            if (i == 0) {
                a = num & 0xF0;
                a >>= 4;
            } else {
                a = num & 0xF;
            }
            if (a < 10) {
                ret = ret + a;
                continue;
            }
            switch (a) {
                case 10: {
                    ret = ret + "A";
                    continue block8;
                }
                case 11: {
                    ret = ret + "B";
                    continue block8;
                }
                case 12: {
                    ret = ret + "C";
                    continue block8;
                }
                case 13: {
                    ret = ret + "D";
                    continue block8;
                }
                case 14: {
                    ret = ret + "E";
                    continue block8;
                }
                case 15: {
                    ret = ret + "F";
                    continue block8;
                }
                default: {
                    return "";
                }
            }
        }
        return ret;
    }

    public static final String rowIdToHex(int high, int low) {
        byte[] low_tmp = Convertion.IntToByteArray(low);
        String tmp = "0x";
        for (int i = 0; i < 4; ++i) {
            tmp = tmp + Convertion.intToHex(low_tmp[i]);
        }
        tmp = tmp + Convertion.intToHex(high);
        return tmp;
    }
}

