/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.driver.DmdbConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DmdbPooledConnection
implements PooledConnection {
    private Hashtable _$6822;
    private SQLException _$6823;
    protected Connection physicalConn;
    protected Connection logicalHandle = null;
    protected Properties props;

    public DmdbPooledConnection() {
    }

    public DmdbPooledConnection(Connection connection, Properties props) {
        this._$6823 = null;
        this.physicalConn = connection;
        this._$6822 = new Hashtable(10);
        this.props = props;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this._$6822 == null) {
            this._$6823 = new SQLException("Listener Hashtable Null");
        } else {
            this._$6822.put(listener, listener);
        }
    }

    void callListener(int i) {
        if (this._$6822 == null) {
            return;
        }
        Enumeration enumeration = this._$6822.keys();
        ConnectionEvent connectionevent = new ConnectionEvent(this, this._$6823);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectioneventlistener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectioneventlistener1 = (ConnectionEventListener)this._$6822.get(connectioneventlistener);
            if (i == 1) {
                connectioneventlistener1.connectionClosed(connectionevent);
                continue;
            }
            if (i != 2) continue;
            connectioneventlistener1.connectionErrorOccurred(connectionevent);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.close();
            this.physicalConn = null;
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            this._$6823 = new SQLException("Physical Connection doesn't exis");
            this.callListener(2);
            return null;
        }
        try {
            if (this.logicalHandle != null) {
                return this.logicalHandle;
            }
            this.logicalHandle = new DmdbConnection(this, (DmdbConnection)this.physicalConn);
            String database = "";
            int transLevel = 1;
            int language = 0;
            boolean autoCommit = true;
            if (this.props != null) {
                database = this.props.getProperty("dbName", "");
                transLevel = Integer.parseInt(this.props.getProperty("transLevel", "1"));
                language = Integer.parseInt(this.props.getProperty("language", "0"));
                autoCommit = Boolean.valueOf(this.props.getProperty("autoCommit", "true"));
            }
            ((DmdbConnection)this.logicalHandle).resetPooledConnection(database, transLevel, language, autoCommit);
        }
        catch (SQLException sqlexception) {
            this._$6823 = sqlexception;
            this.callListener(2);
            return null;
        }
        return this.logicalHandle;
    }

    public synchronized void logicalClose() {
        this.callListener(1);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this._$6822 == null) {
            this._$6823 = new SQLException("Listener Hashtable Null");
        } else {
            this._$6822.remove(listener);
        }
    }
}

