/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.pool.DmdbConnectionCache;
import dm.jdbc.pool.DmdbConnectionPoolDataSource;
import dm.jdbc.pool.DmdbDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class DmdbDataSourceFactory
implements ObjectFactory {
    protected final String dataSourceClassName = "dm.jdbc.pool.DmdbDataSource";
    protected final String poolDataSourceName = "dm.jdbc.pool.DmdbConnectionPoolDataSource";
    protected final String connectionCacheImpl = "dm.jdbc.pool.DmdbConnectionCache";

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        DmdbDataSource retObject = null;
        String className = ref.getClassName();
        if (className.equals("dm.jdbc.pool.DmdbDataSource")) {
            retObject = new DmdbDataSource();
        } else if (className.equals("dm.jdbc.pool.DmdbConnectionPoolDataSource")) {
            retObject = new DmdbConnectionPoolDataSource();
        } else if (className.equals("dm.jdbc.pool.DmdbConnectionCache")) {
            retObject = new DmdbConnectionCache();
        }
        if (retObject != null) {
            DmdbDataSource ds = retObject;
            StringRefAddr stringRefAddr = null;
            stringRefAddr = (StringRefAddr)ref.get("host");
            if (stringRefAddr != null || (stringRefAddr = (StringRefAddr)ref.get("serverName")) != null) {
                ds.setServer((String)stringRefAddr.getContent());
            }
            if ((stringRefAddr = (StringRefAddr)ref.get("port")) != null || (stringRefAddr = (StringRefAddr)ref.get("portNumber")) != null) {
                String port = (String)stringRefAddr.getContent();
                ds.setPort(Integer.parseInt(port));
            }
            if ((stringRefAddr = (StringRefAddr)ref.get("url")) != null) {
                ds.setURL((String)stringRefAddr.getContent());
            }
            if ((stringRefAddr = (StringRefAddr)ref.get("userName")) != null || (stringRefAddr = (StringRefAddr)ref.get("u")) != null || (stringRefAddr = (StringRefAddr)ref.get("user")) != null) {
                ds.setUser((String)stringRefAddr.getContent());
            }
            if ((stringRefAddr = (StringRefAddr)ref.get("passWord")) != null || (stringRefAddr = (StringRefAddr)ref.get("password")) != null) {
                ds.setPassword((String)stringRefAddr.getContent());
            }
            if ((stringRefAddr = (StringRefAddr)ref.get("databaseName")) != null || (stringRefAddr = (StringRefAddr)ref.get("dbName")) != null) {
                ds.setDatabase((String)stringRefAddr.getContent());
            }
            if (className.equals("dm.jdbc.pool.DmdbConnectionCache")) {
                DmdbConnectionCache cache = (DmdbConnectionCache)retObject;
                stringRefAddr = (StringRefAddr)ref.get("minLimit");
                if (stringRefAddr != null) {
                    cache.setMinLimit(Integer.parseInt((String)stringRefAddr.getContent()));
                }
                if ((stringRefAddr = (StringRefAddr)ref.get("maxLimit")) != null) {
                    cache.setMaxLimit(Integer.parseInt((String)stringRefAddr.getContent()));
                }
                if ((stringRefAddr = (StringRefAddr)ref.get("cacheScheme")) != null) {
                    cache.setCacheScheme(Integer.parseInt((String)stringRefAddr.getContent()));
                }
            }
        }
        return retObject;
    }
}

