/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.pool.DmdbConnectionEventListener;
import dm.jdbc.pool.DmdbConnectionPoolDataSource;
import dm.jdbc.pool.DmdbDataSource;
import dm.jdbc.pool.DmdbPooledConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class DmdbConnectionCache
extends DmdbDataSource
implements Serializable,
Referenceable {
    private static final long serialVersionUID = -7503863927581289230L;
    private ConnectionPoolDataSource _$15061;
    private static final int _$15062 = 0;
    private static final int _$15063 = 10;
    private int _$15064 = 0;
    private int _$15065 = 10;
    private Stack _$2528 = new Stack();
    private Hashtable _$15066 = new Hashtable();
    private int _$11295 = 0;
    private int _$15067 = 0;
    private int _$15068 = 1;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    private DmdbConnectionEventListener _$15072;

    public DmdbConnectionCache() throws SQLException {
        this(null);
    }

    public DmdbConnectionCache(ConnectionPoolDataSource connectionpooldatasource) throws SQLException {
        this._$15061 = connectionpooldatasource;
        this._$15072 = new DmdbConnectionEventListener(this);
    }

    private void _$15074(String user, String password) throws SQLException {
        String l_user = null;
        String l_password = null;
        if (this._$15061 != null) {
            l_user = ((DmdbConnectionPoolDataSource)this._$15061).getUser();
            l_password = ((DmdbConnectionPoolDataSource)this._$15061).getPassword();
        }
        if (user != null && !user.equals(l_user) || password != null && !password.equals(l_password)) {
            throw new SQLException("Cannot create a connection with user as " + user + " as it is doesnt match the existing user " + this.user + " Or the Password");
        }
    }

    public synchronized void close() throws SQLException {
        Enumeration enumeration = this._$15066.keys();
        while (enumeration.hasMoreElements()) {
            DmdbPooledConnection dmpooledconnection1 = (DmdbPooledConnection)enumeration.nextElement();
            DmdbPooledConnection dmpooledconnection = (DmdbPooledConnection)this._$15066.get(dmpooledconnection1);
            this.reusePooledConnection(dmpooledconnection);
        }
        while (!this._$2528.empty()) {
            this._$15081((DmdbPooledConnection)this._$2528.pop());
        }
        this._$2528 = null;
        this._$15066 = null;
    }

    public synchronized void closePooledConnection(PooledConnection pooledconnection) throws SQLException {
        this._$15083(pooledconnection);
        this._$15081(pooledconnection);
    }

    private void _$15081(PooledConnection pooledconnection) throws SQLException {
        --this._$11295;
        pooledconnection.close();
        pooledconnection = null;
    }

    private void _$15083(PooledConnection pooledconnection) {
        --this._$15067;
        pooledconnection.removeConnectionEventListener(this._$15072);
        this._$15066.remove(pooledconnection);
    }

    public int getActiveSize() {
        return this._$15067;
    }

    public synchronized int getCacheScheme() {
        return this._$15068;
    }

    public int getCacheSize() {
        return this._$11295;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection getConnection(String user, String password) throws SQLException {
        DmdbPooledConnection dmpooledconnection;
        if (!this._$2528.empty()) {
            this._$15074(user, password);
            dmpooledconnection = (DmdbPooledConnection)this._$2528.pop();
        } else if (this._$11295 < this._$15065 || this._$15068 == 1) {
            String l_user = null;
            String l_password = null;
            if (this._$15061 != null) {
                l_user = ((DmdbConnectionPoolDataSource)this._$15061).getUser();
                l_password = ((DmdbConnectionPoolDataSource)this._$15061).getPassword();
            }
            if (this._$11295 > 0 && user != null && !user.equals(l_user)) {
                DBError.throwSQLException(Const.res.getString("error.username.differ"));
            } else if (user != null) {
                this.user = user;
                if (this._$15061 != null) {
                    ((DmdbConnectionPoolDataSource)this._$15061).setUser(user);
                }
            }
            if (this._$11295 > 0 && password != null && !password.equals(l_password)) {
                DBError.throwSQLException(Const.res.getString("error.password.differ"));
            } else if (password != null) {
                this.password = password;
                if (this._$15061 != null) {
                    ((DmdbConnectionPoolDataSource)this._$15061).setPassword(password);
                }
            }
            dmpooledconnection = this._$15088();
            ++this._$11295;
        } else {
            if (this._$15068 == 3) {
                return null;
            }
            this._$15074(user, password);
            while (this._$2528.empty()) {
                Stack stack = this._$2528;
                synchronized (stack) {
                    try {
                        this._$2528.wait(1000L);
                    }
                    catch (InterruptedException interruptedexception) {
                        // empty catch block
                    }
                }
            }
            dmpooledconnection = (DmdbPooledConnection)this._$2528.pop();
        }
        if (dmpooledconnection != null) {
            dmpooledconnection.addConnectionEventListener(this._$15072);
            this._$15066.put(dmpooledconnection, dmpooledconnection);
            ++this._$15067;
            return dmpooledconnection.getConnection();
        }
        return null;
    }

    public synchronized int getMaxLimit() {
        return this._$15065;
    }

    public synchronized int getMinLimit() {
        return this._$15064;
    }

    private synchronized DmdbPooledConnection _$15088() throws SQLException {
        if (this._$15061 == null) {
            if (this.user == null || this.password == null) {
                DBError.throwSQLException(Const.res.getString("error.UserOrPwd.null"));
            }
            this._$15061 = new DmdbConnectionPoolDataSource();
            ((DmdbConnectionPoolDataSource)this._$15061).setUser(this.user);
            ((DmdbConnectionPoolDataSource)this._$15061).setPassword(this.password);
            ((DmdbConnectionPoolDataSource)this._$15061).setURL(super.getURL());
        }
        return (DmdbPooledConnection)this._$15061.getPooledConnection();
    }

    public Reference getReference() throws NamingException {
        String factoryName = "dm.jdbc.pool.DmdbDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("url", this.getURL()));
        ref.add(new StringRefAddr("server", this.getServer()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("minLimit", Integer.toString(this._$15064)));
        ref.add(new StringRefAddr("maxLimit", Integer.toString(this._$15065)));
        ref.add(new StringRefAddr("cacheScheme", Integer.toString(this._$15068)));
        return ref;
    }

    public void reusePooledConnection(PooledConnection pooledconnection) throws SQLException {
        this._$15083(pooledconnection);
        if (this._$11295 > this._$15065 && this._$15068 == 1) {
            this._$15081(pooledconnection);
        } else {
            this._$2528.push(pooledconnection);
        }
    }

    public synchronized void setCacheScheme(int i) throws SQLException {
        if (i == 1 || i == 3 || i == 2) {
            this._$15068 = i;
        } else {
            DBError.throwSQLException(Const.res.getString("error.pooled.inexistence"));
        }
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionpooldatasource) throws SQLException {
        if (this._$11295 > 0) {
            DBError.throwSQLException(Const.res.getString("error.cachesize.overload"));
        }
        this._$15061 = connectionpooldatasource;
    }

    public synchronized void setMaxLimit(int i) throws SQLException {
        if (i < 0 || i < this._$15064) {
            DBError.throwSQLException(Const.res.getString("error.pooled.limit"));
        }
        this._$15065 = i;
        if (this._$11295 > this._$15065 && this._$15068 != 1) {
            for (int j = this._$15065; j < this._$11295; ++j) {
                if (this._$2528.empty()) {
                    DBError.throwSQLException(Const.res.getString("error.pooled.overflow"));
                    continue;
                }
                ((DmdbPooledConnection)this._$2528.pop()).close();
            }
            this._$11295 = this._$15065;
        }
    }

    public synchronized void setMinLimit(int i) throws SQLException {
        if (i < 0 || i > this._$15065) {
            DBError.throwSQLException(Const.res.getString("error.pooled.minOverflow"));
        }
        this._$15064 = i;
        if (this._$11295 < this._$15064) {
            for (int j = this._$11295; j < this._$15064; ++j) {
                DmdbPooledConnection dmpooledconnection = this._$15088();
                this._$2528.push(dmpooledconnection);
            }
            this._$11295 = this._$15064;
        }
    }
}

