/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbField;

public class DmdbType {
    static final String VERSION = "6.0.2.62";
    static final String display_VERSION = "6.0.2.62";
    static final String BUILD_TIME = "2010.04.09";
    static final String DRIVER_NAME = "dm.jdbc.driver.DmDriver";
    static final String DATABASE_PRODUCT_VERSION = "6.0.2.30";
    static final int DM_FIX_CHAR = 100;
    static final int DATA_CHAR = 0;
    static final int DATA_VARCHAR2 = 1;
    static final int DATA_VARCHAR = 2;
    static final int DATA_BIT = 3;
    static final int DATA_VARBIT = 4;
    static final int DATA_TINYINT = 5;
    static final int DATA_SMALLINT = 6;
    static final int DATA_INT = 7;
    static final int DATA_INT64 = 8;
    static final int DATA_DEC = 9;
    static final int DATA_FLOAT = 10;
    static final int DATA_DOUBLE = 11;
    static final int DATA_BLOB = 12;
    static final int DATA_BOOLEAN = 13;
    static final int DATA_DATE = 14;
    static final int DATA_TIME = 15;
    static final int DATA_DATETIME = 16;
    static final int DATA_BINARY = 17;
    static final int DATA_VARBINARY = 18;
    static final int DATA_TEXT = 19;
    static final int DATA_INTERVAL_YM = 20;
    static final int DATA_INTERVAL_DT = 21;
    static final int DATA_DEC_INT64 = 22;
    static final int DATA_NULL = 30;
    static final int DATA_UNKNOWN = 53;
    public static final int INTERVAL_YEAR = 0;
    public static final int INTERVAL_YEAR_TO_MONTH = 1;
    public static final int INTERVAL_MONTH = 2;
    public static final int INTERVAL_DAY = 3;
    public static final int INTERVAL_DAY_TO_HOUR = 4;
    public static final int INTERVAL_DAY_TO_MIMUTE = 5;
    public static final int INTERVAL_DAY_TO_SECOND = 6;
    public static final int INTERVAL_HOUR = 7;
    public static final int INTERVAL_HOUR_TO_MIMUTE = 8;
    public static final int INTERVAL_HOUR_TO_SECOND = 9;
    public static final int INTERVAL_MIMUTE = 10;
    public static final int INTERVAL_MIMUTE_TO_SECOND = 11;
    public static final int INTERVAL_SECOND = 12;
    public static final int MAX_STRING_LEN = 8188;
    public static final int DATA_BIT_LEN = 1;
    public static final int DATA_TINYINT_LEN = 1;
    public static final int DATA_SMALLINT_LEN = 2;
    public static final int DATA_INT_LEN = 4;
    public static final int DATA_INT64_LEN = 8;
    public static final int DATA_FLOAT_LEN = 4;
    public static final int DATA_DOUBLE_LEN = 8;
    public static final int DATA_DATE_LEN = 3;
    public static final int DATA_TIME_LEN = 5;
    public static final int DATA_DATETIME_LEN = 8;
    public static final int DATA_INTERVAL_YM_LEN = 12;
    public static final int DATA_INTERVAL_DT_LEN = 24;
    public static final int DATA_DEC_INT64_LEN = 8;
    public static final int DATA_NULL_LNE = 4;

    public static final int CPrecToJdbcPrec(int jdbcType, int cprec) {
        int jdbcPrec = 0;
        switch (jdbcType) {
            case -7: {
                jdbcPrec = 1;
                break;
            }
            case -6: {
                jdbcPrec = 3;
                break;
            }
            case -5: {
                jdbcPrec = 19;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                jdbcPrec = cprec;
                break;
            }
            case -1: {
                jdbcPrec = 0x7FFFFFFB;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                jdbcPrec = cprec;
                break;
            }
            case 4: {
                jdbcPrec = 10;
                break;
            }
            case 5: {
                jdbcPrec = 5;
                break;
            }
            case 6: {
                jdbcPrec = 53;
                break;
            }
            case 7: {
                jdbcPrec = 24;
                break;
            }
            case 8: {
                jdbcPrec = 53;
            }
        }
        if (jdbcPrec != 0) {
            return jdbcPrec;
        }
        switch (jdbcType) {
            case 12: {
                if (cprec != 0) {
                    jdbcPrec = cprec;
                    break;
                }
                jdbcPrec = 8188;
                break;
            }
            case 16: {
                jdbcPrec = 1;
            }
        }
        if (jdbcPrec != 0) {
            return jdbcPrec;
        }
        switch (jdbcType) {
            case 91: {
                jdbcPrec = 10;
                break;
            }
            case 92: {
                jdbcPrec = 15;
                break;
            }
            case 93: {
                jdbcPrec = 26;
                break;
            }
            default: {
                jdbcPrec = cprec;
            }
        }
        return jdbcPrec;
    }

    public static final int CTypeToJdbcType(int type, DmdbField fld) {
        int jdbcType = 0;
        switch (type) {
            case 0: {
                jdbcType = 1;
                break;
            }
            case 1: {
                jdbcType = 1;
                break;
            }
            case 2: {
                jdbcType = 12;
                break;
            }
            case 3: {
                String typeName = fld.getTypeName();
                if (typeName.equalsIgnoreCase("BOOLEAN")) {
                    jdbcType = 16;
                    break;
                }
                jdbcType = -7;
                break;
            }
            case 4: {
                jdbcType = 1;
                break;
            }
            case 5: {
                jdbcType = -6;
                break;
            }
            case 6: {
                jdbcType = 5;
                break;
            }
            case 7: {
                jdbcType = 4;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: 
            case 22: {
                String typeName = fld.getTypeName();
                if (typeName.equalsIgnoreCase("NUMERIC")) {
                    jdbcType = 2;
                    break;
                }
                jdbcType = 3;
                break;
            }
            case 10: {
                jdbcType = 7;
                break;
            }
            case 11: {
                String typeName = fld.getTypeName();
                if (typeName.equalsIgnoreCase("FLOAT")) {
                    jdbcType = 6;
                    break;
                }
                jdbcType = 8;
                break;
            }
            case 12: {
                String typeName = fld.getTypeName();
                if (typeName.equalsIgnoreCase("BLOB")) {
                    jdbcType = 2004;
                    break;
                }
                jdbcType = -4;
                break;
            }
            case 13: {
                jdbcType = 16;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 15: {
                jdbcType = 92;
                break;
            }
            case 16: {
                jdbcType = 93;
                break;
            }
            case 17: {
                jdbcType = -2;
                break;
            }
            case 18: {
                jdbcType = -3;
                break;
            }
            case 19: {
                String typeName = fld.getTypeName();
                if (typeName.equalsIgnoreCase("CLOB")) {
                    jdbcType = 2005;
                    break;
                }
                jdbcType = -1;
                break;
            }
            case 20: 
            case 21: {
                jdbcType = 2000;
                break;
            }
            case 53: {
                jdbcType = 12;
                break;
            }
            default: {
                jdbcType = 0;
            }
        }
        return jdbcType;
    }

    public static final int getIntervalLoadPrec(int typePrec) {
        int prec = (typePrec & 0xF0) >> 4;
        return prec;
    }

    public static final int getIntervalScale(int typePrec) {
        int scale = 2;
        int type = (typePrec & 0xFF00) >> 8;
        if (type == 6 || type == 9 || type == 11 || type == 12) {
            scale = typePrec & 0xF;
        }
        return scale;
    }

    public static final String interval_dtype_to_name(int scale) {
        String name = "";
        int qua = (scale & 0xFF00) >> 8;
        int lead_prec = (scale & 0xF0) >> 4;
        int second_prec = scale & 0xF;
        switch (qua) {
            case 0: {
                name = "INTERVAL YEAR(" + lead_prec + ")";
                break;
            }
            case 2: {
                name = "INTERVAL MONTH(" + lead_prec + ")";
                break;
            }
            case 3: {
                name = "INTERVAL DAY(" + lead_prec + ")";
                break;
            }
            case 7: {
                name = "INTERVAL HOUR(" + lead_prec + ")";
                break;
            }
            case 10: {
                name = "INTERVAL MINUTE(" + lead_prec + ")";
                break;
            }
            case 12: {
                name = "INTERVAL SECOND(" + lead_prec + "," + second_prec + ")";
                break;
            }
            case 1: {
                name = "INTERVAL YEAR(" + lead_prec + ") TO MONTH";
                break;
            }
            case 4: {
                name = "INTERVAL DAY(" + lead_prec + ") TO HOUR";
                break;
            }
            case 5: {
                name = "INTERVAL DAY(" + lead_prec + ") TO MINUTE";
                break;
            }
            case 6: {
                name = "INTERVAL DAY(" + lead_prec + ") TO SECOND(" + second_prec + ")";
                break;
            }
            case 8: {
                name = "INTERVAL HOUR(" + lead_prec + ") TO MINUTE";
                break;
            }
            case 9: {
                name = "INTERVAL HOUR(" + lead_prec + ") TO SECOND(" + second_prec + ")";
                break;
            }
            case 11: {
                name = "INTERVAL MINUTE(" + lead_prec + ") TO SECOND(" + second_prec + ")";
            }
        }
        return name;
    }

    static boolean dtype_is_fixed_low(int dtype) {
        switch (dtype) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 9: 
            case 22: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return false;
            }
            case 19: {
                return false;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 20: {
                return true;
            }
            case 21: {
                return true;
            }
            case 17: {
                return true;
            }
            case 18: {
                return false;
            }
            case 30: {
                return true;
            }
        }
        return false;
    }

    static int dtype_get_internal_len_low(int dtype, int len) {
        switch (dtype) {
            case 7: {
                return 4;
            }
            case 0: {
                return len;
            }
            case 9: {
                return (2 + len + 1) / 2;
            }
            case 11: {
                return 8;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 10: {
                return 4;
            }
            case 14: {
                return 3;
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 8;
            }
            case 17: {
                return len;
            }
            case 3: {
                return 1;
            }
            case 20: {
                return 12;
            }
            case 21: {
                return 24;
            }
            case 30: {
                return 4;
            }
            case 22: {
                return 8;
            }
        }
        return 0;
    }
}

