/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbCachedResultSet;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbParameter;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.util.StringUtil;
import java.io.StringReader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class DmdbStatement
implements Statement {
    public static final int STATEMENT = 0;
    public static final int PREPARED_STATEMENT = 1;
    public static final int CALLABLE_STATEMENT = 2;
    public static final int STATICPREPARED_STATEMENT = 3;
    int handle;
    DmdbConnection connection;
    DmdbCSI m_csi;
    protected DmdbInfo dbInfo;
    DmdbResultSetCache rsCache = null;
    DmdbResultSet currentRs = null;
    protected boolean generateKey = false;
    protected byte[] autoGeneratedRowid = null;
    protected String[] autoGeneratedColName;
    protected String insertTableName = "";
    protected int resultSetConcurrency;
    protected int resultSetType;
    protected int resultSetHoldability;
    boolean process_escapes;
    protected int m_queryTimeout;
    int max_field_size;
    int maxRows;
    int row_prefetch;
    public boolean closed;
    int fetch_direction;
    SQLWarning m_warnings;
    ArrayList m_batchItems;
    String cursorName;
    boolean metaDataResultSet = false;
    long cursorUpdateRow;
    boolean fromRowSetFlag = false;
    int type = 0;
    int putLobData = 1;
    public int lob_mode = 1;
    protected String originalSql = null;
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;

    void initializeState() throws SQLException {
        this.m_csi = this.connection.getCSI();
        this.resultSetConcurrency = 1007;
        this.resultSetType = 1003;
        this.resultSetHoldability = this.connection.getHoldability();
        this.process_escapes = this.connection.getEscapesProcessing();
        this.m_queryTimeout = 0;
        this.max_field_size = 0;
        this.maxRows = this.connection.getMaxRows();
        this.row_prefetch = this.connection.getDefaultRowPrefetch();
        this.closed = false;
        this.fetch_direction = 1000;
        this.m_warnings = null;
        this.m_batchItems = null;
        this.handle = this.m_csi.allocStmtHandle();
        long ttt = this.handle;
        if (this.handle < 0) {
            ttt = 0xFFFFFFFFL & ttt;
        }
        this.cursorName = "DM_CURSOR_" + ttt;
        this.type = 0;
    }

    public void initializeReuseStmt(DmdbConnection conn) throws SQLException {
        this.closed = false;
    }

    public DmdbStatement(DmdbConnection conn) throws SQLException {
        this.connection = conn;
        this.initializeState();
        this.lob_mode = DmdbConnection.lob_mode;
    }

    public DmdbStatement(DmdbConnection conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(conn);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.checkClosed();
            this.metaDataResultSet = false;
            this.clearWarnings();
            this.checkNullOrEmpty(sql);
            if (this.process_escapes) {
                sql = this.connection.nativeSQL(sql);
            }
            this.autoGeneratedColName = null;
            this.originalSql = sql;
            ++DmdbConnection.execSqlNum;
            this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, null);
            if (this.currentRs != null) {
                ++DmdbConnection.rsCachedNum;
                this.dbInfo = this.currentRs.dbInfo;
                return this.currentRs;
            }
            this.dbInfo = this.directExec(this, sql, true, 1);
            this.getResultSetPrivate();
            return this.currentRs;
        }
        catch (SQLException e) {
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return null;
        }
    }

    public synchronized ResultSet executeQuery(String sql, int flag) throws SQLException {
        this.checkClosed();
        this.clearWarnings();
        this.checkNullOrEmpty(sql);
        this.metaDataResultSet = true;
        if (this.process_escapes) {
            sql = this.connection.nativeSQL(sql);
        }
        this.autoGeneratedColName = null;
        this.originalSql = sql;
        ++DmdbConnection.execSqlNum;
        this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, null);
        if (this.currentRs != null) {
            ++DmdbConnection.rsCachedNum;
            this.dbInfo = this.currentRs.dbInfo;
            return this.currentRs;
        }
        this.dbInfo = this.directExec(this, sql, true, 1);
        DmdbResultSet rs = this.getResultSet(true);
        return rs;
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            this.checkClosed();
            this.clearWarnings();
            this.checkNullOrEmpty(sql);
            if (this.connection.isReadOnly()) {
                DBError.throwSQLException(6008);
            }
            if (this.process_escapes) {
                sql = this.connection.nativeSQL(sql);
            }
            this.autoGeneratedColName = null;
            this.originalSql = sql;
            ++DmdbConnection.execSqlNum;
            this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, null);
            if (this.currentRs != null) {
                ++DmdbConnection.rsCachedNum;
                this.dbInfo = this.currentRs.dbInfo;
                if (this.dbInfo.getHasResultSet()) {
                    DBError.throwSQLException(6009);
                }
                return (int)this.dbInfo.getRowCount();
            }
            this.dbInfo = this.directExec(this, sql, true, 2);
            if (this.generateKey && this.dbInfo.getRetStmtType() == 157) {
                this.getTableNameBySql(sql);
                this.autoGeneratedRowid = this.dbInfo.getRowId();
            } else {
                this.insertTableName = "";
                this.autoGeneratedRowid = null;
            }
            if (this.dbInfo.getHasResultSet()) {
                DBError.throwSQLException(6009);
            }
            this.getResultSetPrivate();
            return (int)this.dbInfo.getRowCount();
        }
        catch (SQLException e) {
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return 0;
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            DBError.throwSQLException(6035);
            return;
        }
        if (this.connection == null || this.connection.closed) {
            this.close();
            DBError.throwSQLException(6035);
        }
    }

    void resetState(boolean clear_dbInfo) throws SQLException {
        if (clear_dbInfo) {
            this.dbInfo = null;
        }
        this.rsCache = null;
        this.generateKey = false;
        this.autoGeneratedRowid = null;
        this.autoGeneratedColName = null;
        this.insertTableName = "";
        this.metaDataResultSet = false;
        this.cursorUpdateRow = 0L;
        this.fromRowSetFlag = false;
        this.resultSetConcurrency = 1007;
        this.resultSetType = 1003;
        this.resultSetHoldability = this.connection.getHoldability();
        this.process_escapes = this.connection.getEscapesProcessing();
        this.m_queryTimeout = 0;
        this.max_field_size = 0;
        this.maxRows = this.connection.getMaxRows();
        this.row_prefetch = this.connection.getDefaultRowPrefetch();
        this.fetch_direction = 1000;
        long ttt = this.handle;
        if (this.handle < 0) {
            ttt = 0xFFFFFFFFL & ttt;
        }
        this.cursorName = "DM_CURSOR_" + ttt;
        this.type = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.type == 0) {
            if (this.currentRs != null) {
                this.currentRs.close();
                this.currentRs = null;
            }
            this.originalSql = null;
            if (this.connection != null && !this.connection.closed && this.connection.getStmtPoolSize() < this.connection.getStmtPoolMaxSize()) {
                this.resetState(true);
                this.clearWarnings();
                this.clearBatch();
                this.closed = true;
                this.connection.remove_statement(this.handle);
                this.connection.addToStmtPool(this);
                return;
            }
        }
        try {
            this.m_csi.freeHandle(this);
            if (this.connection != null && !this.connection.closed) {
                this.connection.remove_statement(this.handle);
            }
        }
        finally {
            this.m_csi = null;
            this.connection = null;
            this.clearWarnings();
            this.clearBatch();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void innerClose() throws SQLException {
        try {
            this.m_csi.freeHandle(this);
            this.connection.remove_statement(this.handle);
        }
        finally {
            this.m_csi = null;
            this.connection = null;
            this.clearWarnings();
            this.clearBatch();
            this.closed = true;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.process_escapes = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            DBError.throwSQLException(6036);
        }
        this.m_queryTimeout = seconds;
    }

    public synchronized void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warnings;
    }

    public void clearWarnings() throws SQLException {
        this.m_warnings = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.m_csi.setCursorName(this, name);
        this.cursorName = name;
    }

    public synchronized boolean execute(String sql) throws SQLException {
        try {
            this.checkClosed();
            this.clearWarnings();
            this.checkNullOrEmpty(sql);
            if (this.process_escapes) {
                sql = this.connection.nativeSQL(sql);
            }
            this.autoGeneratedColName = null;
            this.originalSql = sql;
            ++DmdbConnection.execSqlNum;
            this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, null);
            if (this.currentRs != null) {
                ++DmdbConnection.rsCachedNum;
                this.dbInfo = this.currentRs.dbInfo;
                return this.dbInfo.getHasResultSet();
            }
            this.dbInfo = this.directExec(this, sql, true, 0);
            if (this.dbInfo.getHasResultSet()) {
                this.autoGeneratedRowid = null;
            } else if (this.generateKey && this.dbInfo.getRetStmtType() == 157) {
                this.getTableNameBySql(sql);
                this.autoGeneratedRowid = this.dbInfo.getRowId();
            } else {
                this.insertTableName = "";
                this.autoGeneratedRowid = null;
            }
            this.getResultSetPrivate();
            return this.dbInfo.getHasResultSet();
        }
        catch (SQLException e) {
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return false;
        }
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (!this.dbInfo.getHasResultSet()) {
            return null;
        }
        return this.currentRs;
    }

    public synchronized int getUpdateCount() throws SQLException {
        int updateCount = -1;
        if (!this.dbInfo.getHasResultSet()) {
            updateCount = (int)this.dbInfo.getRowCount();
            this.dbInfo.setRowCount(-1L);
        }
        return updateCount;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(this.CLOSE_CURRENT_RESULT);
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (direction == 1000 || direction == 1001) {
            this.fetch_direction = direction;
        } else if (direction == 1002) {
            this.fetch_direction = 1000;
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, 37);
        } else {
            DBError.throwSQLException(6036);
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.fetch_direction;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.maxRows) {
            DBError.throwSQLException(6036);
        }
        this.row_prefetch = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.row_prefetch;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public void addBatch(String sql) throws SQLException {
        if (this.m_batchItems == null) {
            this.m_batchItems = new ArrayList(10);
        }
        this.checkNullOrEmpty(sql);
        this.m_batchItems.add(sql);
    }

    public void clearBatch() throws SQLException {
        if (this.m_batchItems != null) {
            this.m_batchItems.clear();
            this.m_batchItems = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.clearWarnings();
        if (this.connection.isReadOnly()) {
            DBError.throwSQLException(6008);
        }
        try {
            int[] updateCounts = new int[]{};
            if (this.m_batchItems != null) {
                int nbrCommands = this.m_batchItems.size();
                updateCounts = new int[nbrCommands];
                for (int i = 0; i < nbrCommands; ++i) {
                    updateCounts[i] = this.EXECUTE_FAILED;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                try {
                    for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                        updateCounts[commandIndex] = this.executeUpdate((String)this.m_batchItems.get(commandIndex));
                    }
                }
                catch (SQLException ex) {
                    updateCounts[commandIndex] = this.EXECUTE_FAILED;
                    if (this.connection.getContinueBatchOnError()) {
                        sqlEx = ex;
                    }
                    int[] newUpdateCounts = new int[commandIndex];
                    System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
        }
        catch (Throwable throwable) {
            try {
                this.clearBatch();
                throw throwable;
            }
            catch (SQLException e) {
                if (DmdbConnection.infoLevel == 1) {
                    throw e;
                }
                return new int[0];
            }
        }
        this.clearBatch();
        return nArray;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public synchronized boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                DBError.throwSQLException(Const.res.getString("error.unsupportedParam"));
            }
        }
        this.dbInfo = this.m_csi.getMoreResult(this, this.dbInfo);
        this.getResultSetPrivate();
        return this.dbInfo.getHasResultSet();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        int i = 0;
        String sql = "";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        String rowid = "";
        if (this.insertTableName.equals("")) {
            return null;
        }
        rowid = "0x";
        if (this.autoGeneratedRowid == null) {
            rowid = rowid + "FFFFFFFFFFFFFFFF";
        } else {
            for (i = 4; i < 8; ++i) {
                rowid = rowid + this._$5289(this.autoGeneratedRowid[i]);
            }
            rowid = rowid + this._$5289(this.autoGeneratedRowid[2]);
            rowid = rowid + this._$5289(this.autoGeneratedRowid[3]);
        }
        if (this.autoGeneratedColName == null) {
            sql = "select rowid from " + StringUtil.getEscObjName(this.insertTableName) + " where rowid = " + rowid;
        } else {
            sql = "select ";
            for (i = 0; i < this.autoGeneratedColName.length - 1; ++i) {
                if (this.autoGeneratedColName[i] != null) {
                    sql = sql + StringUtil.getEscObjName(this.autoGeneratedColName[i]);
                    sql = sql + ", ";
                    continue;
                }
                sql = sql + "null, ";
            }
            sql = this.autoGeneratedColName[i] != null ? sql + StringUtil.getEscObjName(this.autoGeneratedColName[i]) : sql + "null";
            sql = sql + " from ";
            sql = sql + StringUtil.getEscObjName(this.insertTableName);
            sql = sql + " where rowid = ";
            sql = sql + rowid;
        }
        stmt = (DmdbStatement)this.connection.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.clearWarnings();
            this.generateKey = autoGeneratedKeys == 1;
            int updateCount = this.executeUpdate(sql);
            this.autoGeneratedColName = null;
            if (this.generateKey) {
                if (this.dbInfo.getRetStmtType() != 157) {
                    this.autoGeneratedRowid = null;
                }
                this.generateKey = false;
            }
            return updateCount;
        }
        catch (SQLException e) {
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return 0;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.clearWarnings();
            this.generateKey = true;
            int updateCount = this.executeUpdate(sql);
            if (this.dbInfo.getRetStmtType() == 157) {
                int i;
                DmdbColumn[] colInfo = this.getColumnsInfo();
                int count = 0;
                for (i = 0; i < columnIndexes.length; ++i) {
                    if (columnIndexes[i] < 1 || columnIndexes[i] > colInfo.length) continue;
                    ++count;
                }
                this.autoGeneratedColName = new String[count];
                count = 0;
                for (i = 0; i < columnIndexes.length; ++i) {
                    if (columnIndexes[i] < 1 || columnIndexes[i] > colInfo.length) continue;
                    this.autoGeneratedColName[count++] = colInfo[columnIndexes[i] - 1].getName();
                }
            } else {
                this.autoGeneratedRowid = null;
            }
            return updateCount;
        }
        catch (SQLException e) {
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return 0;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this.clearWarnings();
            this.generateKey = true;
            int updateCount = this.executeUpdate(sql);
            if (this.generateKey) {
                if (this.dbInfo.getRetStmtType() != 157) {
                    this.autoGeneratedRowid = null;
                } else {
                    int i;
                    int count = 0;
                    for (i = 0; i < columnNames.length; ++i) {
                        if (columnNames[i] == null) continue;
                        ++count;
                    }
                    this.autoGeneratedColName = new String[count];
                    count = 0;
                    for (i = 0; i < columnNames.length; ++i) {
                        if (columnNames[i] == null) continue;
                        this.autoGeneratedColName[count++] = columnNames[i];
                    }
                }
                this.generateKey = false;
            }
            return updateCount;
        }
        catch (SQLException e) {
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return 0;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean hasResultSet;
        block4: {
            hasResultSet = false;
            try {
                this.generateKey = autoGeneratedKeys == 1;
                hasResultSet = this.execute(sql);
                this.autoGeneratedColName = null;
                if (this.generateKey) {
                    if (this.dbInfo.getRetStmtType() != 157) {
                        this.autoGeneratedRowid = null;
                    }
                    this.generateKey = false;
                }
            }
            catch (SQLException e) {
                if (DmdbConnection.infoLevel != 1) break block4;
                throw e;
            }
        }
        return hasResultSet;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean hasResultSet;
        block6: {
            hasResultSet = false;
            try {
                this.generateKey = true;
                hasResultSet = this.execute(sql);
                if (this.dbInfo.getRetStmtType() == 157) {
                    int i;
                    DmdbColumn[] colInfo = this.getColumnsInfo();
                    int count = 0;
                    for (i = 0; i < columnIndexes.length; ++i) {
                        if (columnIndexes[i] < 1 || columnIndexes[i] > colInfo.length) continue;
                        ++count;
                    }
                    this.autoGeneratedColName = new String[count];
                    count = 0;
                    for (i = 0; i < columnIndexes.length; ++i) {
                        if (columnIndexes[i] < 1 || columnIndexes[i] > colInfo.length) continue;
                        this.autoGeneratedColName[count++] = colInfo[columnIndexes[i] - 1].getName();
                    }
                } else {
                    this.autoGeneratedRowid = null;
                }
            }
            catch (SQLException e) {
                if (DmdbConnection.infoLevel != 1) break block6;
                throw e;
            }
        }
        return hasResultSet;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean hasResultSet;
        block7: {
            hasResultSet = false;
            try {
                this.generateKey = true;
                hasResultSet = this.execute(sql);
                if (this.generateKey) {
                    if (this.dbInfo.getRetStmtType() != 157) {
                        this.autoGeneratedRowid = null;
                    } else {
                        int i;
                        int count = 0;
                        for (i = 0; i < columnNames.length; ++i) {
                            if (columnNames[i] == null) continue;
                            ++count;
                        }
                        this.autoGeneratedColName = new String[count];
                        count = 0;
                        for (i = 0; i < columnNames.length; ++i) {
                            if (columnNames[i] == null) continue;
                            this.autoGeneratedColName[count++] = columnNames[i];
                        }
                    }
                    this.generateKey = false;
                }
            }
            catch (SQLException e) {
                if (DmdbConnection.infoLevel != 1) break block7;
                throw e;
            }
        }
        return hasResultSet;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    void checkNullOrEmpty(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
    }

    protected int getHandle() {
        return this.handle;
    }

    protected DmdbInfo directExec(DmdbStatement stmt, String s, boolean direct, int checkFlag) throws SQLException {
        DmdbInfo info = this.m_csi.prepareSQL(stmt, s, direct, checkFlag);
        int sqlcode = info.getSQLCode();
        if (sqlcode > 0) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, sqlcode);
        }
        return info;
    }

    protected DmdbResultSet getResultSet(boolean fetchAll) throws SQLException {
        this.rsCache = new DmdbResultSetCache(this, this.dbInfo.getColumnsInfo());
        DmdbResultSet rs = new DmdbResultSet(this.rsCache, this.dbInfo, true);
        return rs;
    }

    protected void getResultSetPrivate() throws SQLException {
        if (this.currentRs != null) {
            this.currentRs.close();
        }
        if (!this.dbInfo.getHasResultSet()) {
            this.currentRs = null;
            return;
        }
        if (this.rsCache == null) {
            this.rsCache = new DmdbResultSetCache(this, this.dbInfo.getColumnsInfo());
        }
        this.currentRs = new DmdbResultSet(this.rsCache, this.dbInfo);
        this.currentRs.startRow = 0L;
    }

    void getTableNameBySql(String sql) {
        this.insertTableName = "";
        long parse_ret = this.connection.parse_it(new StringReader(sql));
        if (parse_ret == 0L && this.connection.getSqlType(0) == 1) {
            String[] str = this.connection.getSqlWordList(0);
            for (int i = 2; i < str.length && i < 8; i += 2) {
                this.insertTableName = this.insertTableName + str[i];
                if (str[i + 1].equals(".")) {
                    this.insertTableName = this.insertTableName + ".";
                    continue;
                }
                break;
            }
        } else {
            this.insertTableName = "";
        }
    }

    private String _$5289(int num) throws SQLException {
        String ret = "";
        block8: for (int i = 0; i < 2; ++i) {
            int a;
            if (i == 0) {
                a = num & 0xF0;
                a >>= 4;
            } else {
                a = num & 0xF;
            }
            if (a < 10) {
                ret = ret + a;
                continue;
            }
            switch (a) {
                case 10: {
                    ret = ret + "A";
                    continue block8;
                }
                case 11: {
                    ret = ret + "B";
                    continue block8;
                }
                case 12: {
                    ret = ret + "C";
                    continue block8;
                }
                case 13: {
                    ret = ret + "D";
                    continue block8;
                }
                case 14: {
                    ret = ret + "E";
                    continue block8;
                }
                case 15: {
                    ret = ret + "F";
                    continue block8;
                }
                default: {
                    return "";
                }
            }
        }
        return ret;
    }

    protected DmdbColumn[] getColumnsInfo() throws SQLException {
        DmdbColumn[] colInfo = null;
        String sql = "select * from " + StringUtil.getEscObjName(this.insertTableName) + " where 1 = 2";
        DmdbStatement stmt = (DmdbStatement)this.connection.createStatement();
        stmt.executeQuery(sql);
        colInfo = stmt.dbInfo.getColumnsInfo();
        stmt.close();
        return colInfo;
    }

    int getPutLobData() {
        return this.putLobData;
    }

    void setPutLobData(int flag) {
        this.putLobData = flag;
    }

    public DmdbParameter[] getParams() {
        return null;
    }
}

