/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbParamValue;
import dm.jdbc.util.Convertion;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbSetValue {
    String serverEncoding;

    public DmdbSetValue(String serverEncoding) {
        this.serverEncoding = serverEncoding;
    }

    void setNull(DmdbParamValue paraVal) throws SQLException {
        paraVal.setInNull();
    }

    void setBoolean(DmdbParamValue paraVal, boolean x, int sqlType, int cType, int prec, int scale) throws SQLException {
        int value = x ? 1 : 0;
        switch (sqlType) {
            case 16: {
                paraVal.setInValue(Convertion.byteToByteArray((byte)value));
                break;
            }
            case -7: 
            case -6: {
                this.setByte(paraVal, (byte)value, sqlType, cType, prec, scale);
                break;
            }
            case 5: {
                this.setShort(paraVal, (short)value, sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                this.setInt(paraVal, value, sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, value, sqlType, cType, prec, scale);
                break;
            }
            case 7: {
                this.setFloat(paraVal, value, sqlType, cType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, value, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal((double)value), sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setByte(DmdbParamValue paraVal, byte x, int sqlType, int cType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case -7: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                x = x == 0 ? (byte)0 : 1;
                paraVal.setInValue(Convertion.byteToByteArray(x));
                break;
            }
            case -6: {
                paraVal.setInValue(Convertion.byteToByteArray(x));
                break;
            }
            case 5: {
                this.setShort(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                this.setInt(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, x, sqlType, cType, prec, scale);
                return;
            }
            case 7: {
                this.setFloat(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal((double)x), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                this.setBoolean(paraVal, x != 0, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setShort(DmdbParamValue paraVal, short x, int sqlType, int cType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case 5: {
                paraVal.setInValue(Convertion.shortToByteArray(x));
                break;
            }
            case -7: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                x = x == 0 ? (short)0 : 1;
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                this.setInt(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, x, sqlType, cType, prec, scale);
                return;
            }
            case 7: {
                this.setFloat(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal((double)x), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                this.setBoolean(paraVal, x != 0, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setInt(DmdbParamValue paraVal, int x, int sqlType, int cType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case 4: {
                paraVal.setInValue(Convertion.IntToByteArray(x));
                break;
            }
            case -7: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                x = x == 0 ? 0 : 1;
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case 5: {
                if (x > Short.MAX_VALUE || x < Short.MIN_VALUE) {
                    DBError.throwSQLException(6004);
                }
                this.setShort(paraVal, (short)x, sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, x, sqlType, cType, prec, scale);
                return;
            }
            case 7: {
                this.setFloat(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal((double)x), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                this.setBoolean(paraVal, x != 0, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            case -2: {
                byte[] b = new byte[4];
                byte[] c = new byte[prec];
                int position = 3;
                b[position--] = (byte)(x & 0xFF);
                b[position--] = (byte)(x >>> 8);
                b[position--] = (byte)(x >>> 16);
                b[position--] = (byte)(x >>> 24);
                if (prec <= b.length) {
                    System.arraycopy(b, b.length - prec, c, 0, prec);
                } else {
                    System.arraycopy(b, 0, c, prec - b.length, b.length);
                }
                this.setBytes(paraVal, c, sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setLong(DmdbParamValue paraVal, long x, int sqlType, int cType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case -5: {
                paraVal.setInValue(Convertion.longToByteArray(x));
                break;
            }
            case -7: {
                if (x > 127L || x < -128L) {
                    DBError.throwSQLException(6004);
                }
                x = x == 0L ? 0L : 1L;
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                if (x > 127L || x < -128L) {
                    DBError.throwSQLException(6004);
                }
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case 5: {
                if (x > 32767L || x < -32768L) {
                    DBError.throwSQLException(6004);
                }
                this.setShort(paraVal, (short)x, sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
                    DBError.throwSQLException(6004);
                }
                this.setInt(paraVal, (int)x, sqlType, cType, prec, scale);
                break;
            }
            case 7: {
                this.setFloat(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal((double)x), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                this.setBoolean(paraVal, x != 0L, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            case -2: {
                byte[] b = new byte[8];
                byte[] c = new byte[prec];
                int position = 7;
                b[position--] = (byte)(x & 0xFFL);
                b[position--] = (byte)(x >>> 8);
                b[position--] = (byte)(x >>> 16);
                b[position--] = (byte)(x >>> 24);
                b[position--] = (byte)(x >>> 32);
                b[position--] = (byte)(x >>> 40);
                b[position--] = (byte)(x >>> 48);
                b[position--] = (byte)(x >>> 56);
                if (prec <= 8) {
                    System.arraycopy(b, 8 - prec, c, 0, prec);
                } else {
                    System.arraycopy(b, 0, c, prec - b.length, b.length);
                }
                this.setBytes(paraVal, c, sqlType, cType, prec, scale);
                break;
            }
            case 93: {
                if (x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                this.setString(paraVal, new Date(x * 24L * 60L * 60L * 1000L - 2209017600000L).toString(), sqlType, cType, prec, scale);
                break;
            }
            case 92: {
                this.setTime(paraVal, new Time(0L), sqlType, cType, prec, scale);
                break;
            }
            case 91: {
                if (x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                this.setDate(paraVal, new Date(x * 24L * 60L * 60L * 1000L - 2209017600000L), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setFloat(DmdbParamValue paraVal, float x, int sqlType, int cType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case 7: {
                paraVal.setInValue(Convertion.floatToByteArray(x));
                break;
            }
            case -7: {
                if (x > 127.0f || x < -128.0f) {
                    DBError.throwSQLException(6004);
                }
                x = x == 0.0f ? 0.0f : 1.0f;
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case 5: {
                this.setShort(paraVal, (short)x, sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                this.setInt(paraVal, (int)x, sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, (long)x, sqlType, cType, prec, scale);
                return;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, x, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal(x), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                this.setBoolean(paraVal, x != 0.0f, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setDouble(DmdbParamValue paraVal, double x, int sqlType, int cType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case 6: 
            case 8: {
                paraVal.setInValue(Convertion.doubleToByteArray(x));
                break;
            }
            case -7: {
                if (x > 127.0 || x < -128.0) {
                    DBError.throwSQLException(6004);
                }
                x = x == 0.0 ? 0.0 : 1.0;
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                this.setByte(paraVal, (byte)x, sqlType, cType, prec, scale);
                break;
            }
            case 5: {
                this.setShort(paraVal, (short)x, sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                this.setInt(paraVal, (int)x, sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, (long)x, sqlType, cType, prec, scale);
                return;
            }
            case 7: {
                this.setFloat(paraVal, (float)x, sqlType, cType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(paraVal, new BigDecimal(x), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                this.setBoolean(paraVal, x != 0.0, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setBigDecimal(DmdbParamValue paraVal, BigDecimal x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case 2: 
            case 3: {
                byte[] inValueBytes;
                String vmVersion = System.getProperty("java.vm.version");
                String mainVersion = vmVersion.substring(0, 3);
                double version = Double.valueOf(mainVersion);
                String s = null;
                x = x.setScale(scale, 4);
                s = version < 1.5 ? x.abs().toString() : x.abs().toPlainString();
                if (cType == 9) {
                    int length = s.length();
                    int point = s.indexOf(46);
                    if (length > prec && point == -1) {
                        DBError.throwSQLException(6052);
                    }
                    if (!(length <= prec + 1 || point == -1 || s.startsWith("0") && length == prec + 2)) {
                        DBError.throwSQLException(6052);
                    }
                    byte[] b = s.getBytes();
                    inValueBytes = new byte[length + 1];
                    System.arraycopy(b, 0, inValueBytes, 1, length);
                    int signNum = x.signum();
                    inValueBytes[0] = signNum < 0 ? 45 : 43;
                } else {
                    int signNum;
                    int length = s.length();
                    int point = s.indexOf(46);
                    if (length > prec && point == -1) {
                        DBError.throwSQLException(6052);
                    }
                    if (!(length <= prec + 1 || point == -1 || s.startsWith("0") && length == prec + 2)) {
                        DBError.throwSQLException(6052);
                    }
                    if (point != -1) {
                        s = s.substring(0, point) + s.substring(point + 1);
                    }
                    if ((signNum = x.signum()) < 0) {
                        s = "-" + s;
                    }
                    long tmp = new Long(s);
                    inValueBytes = Convertion.longToByteArray(tmp);
                }
                paraVal.setInValue(inValueBytes);
                break;
            }
            case -7: {
                byte value = 0;
                if (x.byteValue() > 127 || x.byteValue() < -128) {
                    DBError.throwSQLException(6004);
                }
                value = x.byteValue() == 0 ? (byte)0 : 1;
                this.setByte(paraVal, value, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                this.setByte(paraVal, x.byteValue(), sqlType, cType, prec, scale);
                break;
            }
            case 5: {
                this.setShort(paraVal, x.shortValue(), sqlType, cType, prec, scale);
                break;
            }
            case 4: {
                this.setInt(paraVal, x.intValue(), sqlType, cType, prec, scale);
                break;
            }
            case -5: {
                this.setLong(paraVal, x.longValue(), sqlType, cType, prec, scale);
                return;
            }
            case 7: {
                this.setFloat(paraVal, x.floatValue(), sqlType, cType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(paraVal, x.doubleValue(), sqlType, cType, prec, scale);
                break;
            }
            case 16: {
                boolean b_v = x.equals(new BigDecimal(0));
                this.setBoolean(paraVal, !b_v, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setString(DmdbParamValue paraVal, String x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        block2 : switch (sqlType) {
            case 1: {
                try {
                    byte[] inValueBytes = this.serverEncoding != null ? x.getBytes(this.serverEncoding) : x.getBytes();
                    int length = inValueBytes.length;
                    if (prec == length) {
                        byte[] bs = inValueBytes;
                        paraVal.setInValue(bs);
                        break;
                    }
                    if (prec > length) {
                        byte[] bs;
                        if (cType == 0) {
                            bs = new byte[prec];
                            System.arraycopy(inValueBytes, 0, bs, 0, length);
                            for (int i = length; i < prec; ++i) {
                                bs[i] = 32;
                            }
                        } else {
                            bs = inValueBytes;
                        }
                        paraVal.setInValue(bs);
                        break;
                    }
                    DBError.throwSQLException(Const.res.getString("error.StringCut"));
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("encoding methods not supported!");
                }
                break;
            }
            case -1: 
            case 12: 
            case 2005: {
                try {
                    byte[] inValueBytes = this.serverEncoding != null ? x.getBytes(this.serverEncoding) : x.getBytes();
                    int length = inValueBytes.length;
                    if (prec < length) {
                        DBError.throwSQLException(Const.res.getString("error.StringCut"));
                        break;
                    }
                    byte[] bs = inValueBytes;
                    paraVal.setInValue(bs);
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("encoding methods not supported!");
                }
                break;
            }
            case -7: {
                byte val = 1;
                if (x.compareToIgnoreCase("false") == 0) {
                    val = 0;
                } else {
                    for (int i = 0; i < x.trim().length(); ++i) {
                        val = 0;
                        if (x.trim().charAt(i) == '0') continue;
                        val = 1;
                        break;
                    }
                }
                this.setByte(paraVal, val, sqlType, cType, prec, scale);
                break;
            }
            case -6: {
                if (x.trim().length() > 0) {
                    this.setByte(paraVal, Byte.parseByte(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 5: {
                if (x.trim().length() > 0) {
                    this.setShort(paraVal, Short.parseShort(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 4: {
                if (x.trim().length() > 0) {
                    this.setInt(paraVal, Integer.parseInt(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case -5: {
                if (x.trim().length() > 0) {
                    this.setLong(paraVal, Long.parseLong(x), sqlType, cType, prec, scale);
                } else {
                    this.setNull(paraVal);
                }
                return;
            }
            case 7: {
                if (x.trim().length() > 0) {
                    this.setFloat(paraVal, Float.parseFloat(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 6: 
            case 8: {
                if (x.trim().length() > 0) {
                    this.setDouble(paraVal, Double.parseDouble(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 2: 
            case 3: {
                if (x.trim().length() > 0) {
                    this.setBigDecimal(paraVal, new BigDecimal(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 16: {
                if (x.trim().length() > 0) {
                    this.setBoolean(paraVal, Boolean.valueOf(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case -2: {
                byte[] bs;
                byte[] inValueBytes = x.getBytes();
                int length = inValueBytes.length;
                if (prec == length) {
                    bs = inValueBytes;
                } else {
                    bs = new byte[prec];
                    if (prec > length) {
                        System.arraycopy(inValueBytes, 0, bs, 0, length);
                        for (int i = length; i < prec; ++i) {
                            bs[i] = 0;
                        }
                    } else {
                        System.arraycopy(inValueBytes, 0, bs, 0, prec);
                    }
                }
                paraVal.setInValue(bs);
                break;
            }
            case -4: 
            case -3: 
            case 2004: {
                byte[] bs;
                byte[] inValueBytes = x.getBytes();
                int length = inValueBytes.length;
                if (prec < length) {
                    bs = new byte[prec];
                    System.arraycopy(inValueBytes, 0, bs, 0, prec);
                } else {
                    bs = inValueBytes;
                }
                paraVal.setInValue(bs);
                break;
            }
            case 91: {
                if (x.trim().length() > 0) {
                    this.setDate(paraVal, DmdbDateTime.getDateByString(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 92: {
                if (x.trim().length() > 0) {
                    DmdbTime t2 = new DmdbTime(x);
                    paraVal.setInValue(t2.getByteArrayValue());
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 93: {
                if (x.trim().length() > 0) {
                    this.setTimestamp(paraVal, DmdbDateTime.getTimestampByString(x), sqlType, cType, prec, scale);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            case 2000: {
                if (x.trim().length() > 0) {
                    int secPrec = scale & 0xF;
                    int loadPrec = scale >> 4 & 0xF;
                    switch (cType) {
                        case 21: {
                            this.setINTERVALDT(paraVal, new DmdbIntervalDT(x, loadPrec, secPrec), sqlType, cType, prec, scale);
                            break block2;
                        }
                        case 20: {
                            this.setINTERVALYM(paraVal, new DmdbIntervalYM(x, loadPrec), sqlType, cType, prec, scale);
                            break block2;
                        }
                    }
                    DBError.throwSQLException(6005);
                    break;
                }
                this.setNull(paraVal);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    public void setINTERVALYM(DmdbParamValue paraVal, DmdbIntervalYM ym, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (ym == null) {
            this.setNull(paraVal);
            return;
        }
        switch (cType) {
            case 20: {
                paraVal.setInValue(ym.convertStrToBs(scale));
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                this.setString(paraVal, String.valueOf(ym.toString()), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    public void setINTERVALDT(DmdbParamValue paraVal, DmdbIntervalDT dt, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (dt == null) {
            this.setNull(paraVal);
            return;
        }
        switch (cType) {
            case 21: {
                paraVal.setInValue(dt.convertStrToBs(scale));
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                this.setString(paraVal, String.valueOf(dt.toString()), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setBytes(DmdbParamValue paraVal, byte[] x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case -2: {
                byte[] bs;
                int length = x.length;
                if (prec == length) {
                    bs = x;
                } else {
                    bs = new byte[prec];
                    if (prec > length) {
                        System.arraycopy(x, 0, bs, 0, length);
                        for (int i = length; i < prec; ++i) {
                            bs[i] = 0;
                        }
                    } else {
                        System.arraycopy(x, 0, bs, 0, prec);
                    }
                }
                paraVal.setInValue(bs);
                break;
            }
            case -4: 
            case -3: 
            case -1: 
            case 12: 
            case 2004: 
            case 2005: {
                byte[] bs;
                int length = x.length;
                if (prec < length) {
                    bs = new byte[prec];
                    System.arraycopy(x, 0, bs, 0, prec);
                } else {
                    bs = x;
                }
                paraVal.setInValue(bs);
                break;
            }
            case 1: {
                byte[] bs;
                int length = x.length;
                if (prec == length) {
                    bs = x;
                } else if (prec > length) {
                    if (cType == 0) {
                        bs = new byte[prec];
                        System.arraycopy(x, 0, bs, 0, length);
                        for (int i = length; i < prec; ++i) {
                            bs[i] = 32;
                        }
                    } else {
                        bs = x;
                    }
                } else {
                    bs = new byte[prec];
                    System.arraycopy(x, 0, bs, 0, prec);
                }
                paraVal.setInValue(bs);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setDate(DmdbParamValue paraVal, Date x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case 91: {
                DmdbDateTime dt = new DmdbDateTime(x.toString(), 0);
                paraVal.setInValue(dt.getByteArrayValue());
                break;
            }
            case 93: {
                Timestamp ts = new Timestamp(x.getTime());
                this.setTimestamp(paraVal, ts, sqlType, cType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setTime(DmdbParamValue paraVal, Time x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case 92: {
                DmdbTime t2 = new DmdbTime(String.valueOf(x));
                paraVal.setInValue(t2.getByteArrayValue());
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    public void setTime(DmdbParamValue paraVal, DmdbTime t2, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (t2 == null) {
            this.setNull(paraVal);
            return;
        }
        switch (cType) {
            case 15: {
                paraVal.setInValue(t2.getByteArrayValue());
                break;
            }
            case 16: {
                Timestamp ts = new Timestamp(t2.getTime().getTime());
                ts.setNanos(t2.getNano());
                this.setTimestamp(paraVal, ts, sqlType, cType, prec, scale);
                break;
            }
            default: {
                this.setString(paraVal, t2.toString(), sqlType, cType, prec, scale);
            }
        }
    }

    void setTimestamp(DmdbParamValue paraVal, Timestamp x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case 91: {
                this.setDate(paraVal, new Date(x.getTime()), sqlType, cType, prec, scale);
                break;
            }
            case 92: {
                this.setString(paraVal, DmdbDateTime.getTimeFromTimestamp(x), sqlType, cType, prec, scale);
                break;
            }
            case 93: {
                DmdbDateTime dt = new DmdbDateTime(x.toString(), 2);
                paraVal.setInValue(dt.getByteArrayValue());
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(paraVal, String.valueOf(x), sqlType, cType, prec, scale);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setAsciiStream(DmdbParamValue paraVal, InputStream x, int length, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (length > prec) {
                    length = prec;
                }
                byte[] bs = new byte[length];
                try {
                    x.read(bs, 0, length);
                    this.setString(paraVal, Convertion.getString(bs, 0, bs.length), sqlType, cType, prec, scale);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(ioex.toString(), -1);
                }
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (length > prec) {
                    length = prec;
                }
                byte[] bs = new byte[length];
                try {
                    x.read(bs, 0, length);
                    this.setBytes(paraVal, bs, sqlType, cType, prec, scale);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(ioex.toString(), -1);
                }
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setUnicodeStream(DmdbParamValue paraVal, InputStream x, int length, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        try {
            byte[] bs = new byte[length];
            x.read(bs);
            String s = new String(bs, "UTF-16");
            bs = s.getBytes();
            this.setBytes(paraVal, bs, sqlType, cType, prec, scale);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(ioex.toString(), -1);
        }
    }

    void setBinaryStream(DmdbParamValue paraVal, InputStream x, int length, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (length > prec) {
                    length = prec;
                }
                byte[] bs = new byte[length];
                try {
                    x.read(bs, 0, length);
                    this.setBytes(paraVal, bs, sqlType, cType, prec, scale);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(ioex.toString(), -1);
                }
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setObject(DmdbParamValue paraVal, Object x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        if (x instanceof Byte) {
            this.setInt(paraVal, ((Byte)x).intValue(), sqlType, cType, prec, scale);
        } else if (x instanceof String) {
            this.setString(paraVal, (String)x, sqlType, cType, prec, scale);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(paraVal, (BigDecimal)x, sqlType, cType, prec, scale);
        } else if (x instanceof Short) {
            this.setShort(paraVal, (Short)x, sqlType, cType, prec, scale);
        } else if (x instanceof Integer) {
            this.setInt(paraVal, (Integer)x, sqlType, cType, prec, scale);
        } else if (x instanceof Long) {
            this.setLong(paraVal, (Long)x, sqlType, cType, prec, scale);
        } else if (x instanceof Float) {
            this.setFloat(paraVal, ((Float)x).floatValue(), sqlType, cType, prec, scale);
        } else if (x instanceof Double) {
            this.setDouble(paraVal, (Double)x, sqlType, cType, prec, scale);
        } else if (x instanceof byte[]) {
            this.setBytes(paraVal, (byte[])x, sqlType, cType, prec, scale);
        } else if (x instanceof Date) {
            this.setDate(paraVal, (Date)x, sqlType, cType, prec, scale);
        } else if (x instanceof Time) {
            this.setTime(paraVal, (Time)x, sqlType, cType, prec, scale);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(paraVal, (Timestamp)x, sqlType, cType, prec, scale);
        } else if (x instanceof Boolean) {
            this.setBoolean(paraVal, (Boolean)x, sqlType, cType, prec, scale);
        } else if (x instanceof Blob) {
            this.setBlob(paraVal, (Blob)x, sqlType, cType, prec, scale);
        } else if (x instanceof Clob) {
            this.setClob(paraVal, (Clob)x, sqlType, cType, prec, scale);
        } else if (x instanceof DmdbTime) {
            this.setTime(paraVal, (DmdbTime)x, sqlType, cType, prec, scale);
        } else if (x instanceof DmdbIntervalYM) {
            this.setINTERVALYM(paraVal, (DmdbIntervalYM)x, sqlType, cType, prec, scale);
        } else if (x instanceof DmdbIntervalDT) {
            this.setINTERVALDT(paraVal, (DmdbIntervalDT)x, sqlType, cType, prec, scale);
        } else if (x instanceof java.util.Date) {
            Date date = new Date(((java.util.Date)x).getTime());
            this.setDate(paraVal, date, sqlType, cType, prec, scale);
        } else if (x instanceof Reader) {
            int size = 1000;
            int i = 0;
            char[] tmp = new char[size];
            try {
                int j;
                int ch;
                while ((ch = ((Reader)x).read()) != -1) {
                    tmp[i] = (char)ch;
                    if (++i != size) continue;
                    char[] longer = new char[size * 2];
                    for (j = 0; j < size; ++j) {
                        longer[j] = tmp[j];
                    }
                    tmp = new char[size * 2];
                    for (j = 0; j < size; ++j) {
                        tmp[j] = longer[j];
                    }
                    size *= 2;
                }
                char[] tmp1 = new char[i];
                for (j = 0; j < tmp1.length; ++j) {
                    tmp1[j] = tmp[j];
                }
                String str = new String(tmp1);
                this.setString(paraVal, str, sqlType, cType, prec, scale);
            }
            catch (Exception e) {
                DBError.throwSQLException("IO error");
            }
        } else {
            DBError.throwSQLException(6006);
        }
    }

    void setCharacterStream(DmdbParamValue paraVal, Reader reader, int length, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (reader == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                if (length > prec) {
                    length = prec;
                }
                char[] bs = new char[length];
                try {
                    reader.read(bs, 0, length);
                    this.setString(paraVal, new String(bs), sqlType, cType, prec, scale);
                }
                catch (IOException ioex) {
                    DBError.throwSQLException(ioex.toString(), -1);
                }
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setRef(DmdbParamValue paraVal, Ref x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        DBError.throwUnsupportedSQLException();
    }

    void setBlob(DmdbParamValue paraVal, Blob x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case -4: 
            case 2004: {
                paraVal.setBlob(x);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setClob(DmdbParamValue paraVal, Clob x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        switch (sqlType) {
            case -1: 
            case 2005: {
                paraVal.setClob(x);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    void setArray(DmdbParamValue paraVal, Array x, int sqlType, int cType, int prec, int scale) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        DBError.throwUnsupportedSQLException();
    }

    void setURL(DmdbParamValue paraVal, URL x, int sqlType) throws SQLException {
        if (x == null) {
            this.setNull(paraVal);
            return;
        }
        DBError.throwUnsupportedSQLException();
    }
}

