/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbParamValue;
import java.util.ArrayList;
import java.util.Vector;

public class DmdbRowSetInsCache {
    ArrayList row;
    ArrayList insCache = new ArrayList();
    ArrayList ifUpdated = new ArrayList();
    ArrayList Lengths = new ArrayList();
    int currentRow = -1;
    int insRowAt = -1;

    void insRow(DmdbParamValue[] params, boolean[] updatedParam, Vector lengths) {
        int i;
        this.row = new ArrayList(params.length);
        boolean[] ifUpd = new boolean[updatedParam.length];
        for (i = 0; i < params.length; ++i) {
            this.row.add(i, params[i]);
        }
        for (i = 0; i < updatedParam.length; ++i) {
            ifUpd[i] = updatedParam[i];
        }
        this.insCache.add(this.row);
        this.ifUpdated.add(ifUpd);
    }

    ArrayList getOneRow(int rowId) {
        return (ArrayList)this.insCache.get(rowId);
    }

    DmdbParamValue getField(int fieldNum) {
        this.row = (ArrayList)this.insCache.get(this.currentRow);
        return (DmdbParamValue)this.row.get(fieldNum - 1);
    }

    DmdbParamValue getInsField(int fieldNum) {
        this.row = (ArrayList)this.insCache.get(this.insRowAt);
        return (DmdbParamValue)this.row.get(fieldNum - 1);
    }

    boolean first() {
        if (this.insCache.size() < 1) {
            return false;
        }
        this.currentRow = 0;
        return true;
    }

    boolean last() {
        if (this.insCache.size() < 1) {
            return false;
        }
        this.currentRow = this.insCache.size() - 1;
        return true;
    }

    boolean next() {
        if (this.insCache.size() < 1) {
            return false;
        }
        if (this.currentRow == -1) {
            ++this.currentRow;
            return true;
        }
        if (this.currentRow < this.insCache.size()) {
            ++this.currentRow;
            return this.currentRow != this.insCache.size();
        }
        return false;
    }

    boolean previous() {
        if (this.currentRow > 0) {
            --this.currentRow;
            return this.currentRow != -1;
        }
        return false;
    }

    boolean absolute(int rows) {
        if (this.insCache.size() == 0) {
            this.currentRow = -1;
            return false;
        }
        if (rows < 0) {
            return false;
        }
        if (rows > 0) {
            if (rows <= this.insCache.size()) {
                this.currentRow = rows - 1;
            } else {
                this.currentRow = this.insCache.size();
                return false;
            }
        }
        return true;
    }

    int getRow() {
        if (this.insCache.size() == 0 || this.currentRow == -1 || this.currentRow >= this.insCache.size()) {
            return 0;
        }
        return this.currentRow + 1;
    }

    public int getRowNum() {
        return this.insCache.size();
    }

    public void setInsRowAt() {
        this.insRowAt = this.insCache.size();
    }

    public void resetInsRowAt() {
        this.insRowAt = -1;
    }

    public int getInsRowAt() {
        return this.insRowAt;
    }
}

