/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbGetValue;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbParamValue;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowSetInsCache;
import dm.jdbc.driver.DmdbRowSetMetaData;
import dm.jdbc.driver.DmdbSetValue;
import dm.jdbc.driver.DmdbUpdatedRow;
import dm.jdbc.util.Convertion;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class DmdbRowSet
extends DmdbResultSet
implements RowSet {
    protected static DmDriver DmDriver = null;
    String url;
    String dataSourceName;
    String userName;
    String password;
    int transationIsolation;
    String command;
    boolean readOnly;
    int maxFieldSize;
    int maxRows;
    int queryTimeout;
    int rowSetType;
    boolean process_escapes;
    int direction;
    int fetchSize;
    Object[] setParams = new Object[20];
    DmdbResultSet resultSet = null;
    private Hashtable _$16291 = new Hashtable();
    private DmdbRowSetInsCache _$16264;
    private DmdbUpdatedRow _$16292;
    boolean atInsCache = false;
    boolean ifWasNull = false;
    DmdbRowSetMetaData rowSetMetaData = null;
    DmdbGetValue dmGetVal = null;
    DmdbSetValue dmSetVal = null;
    String serverEncoding = null;
    private Vector _$16296 = new Vector();

    public DmdbRowSet() {
        this.setParams[0] = new Integer(0);
        this._$16264 = new DmdbRowSetInsCache();
        this._$7090();
    }

    private void _$7090() {
        this.rowSetType = 1004;
        this.resultConcurrencyType = 1007;
        this.transationIsolation = 2;
        this.direction = 1000;
        this.process_escapes = true;
    }

    public String getUrl() throws SQLException {
        return this.url;
    }

    public void setUrl(String url) throws SQLException {
        this.url = url;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String name) throws SQLException {
        this.dataSourceName = name;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String name) throws SQLException {
        this.userName = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) throws SQLException {
        this.password = password;
    }

    public int getTransactionIsolation() {
        return this.transationIsolation;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.transationIsolation = level;
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Method getTypeMap() not yet implemented.");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException("Method getTypeMap() not yet implemented.");
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String cmd) throws SQLException {
        this.command = cmd;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) throws SQLException {
        this.readOnly = value;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkClose();
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClose();
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        this.checkClose();
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkClose();
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.maxRows = max;
    }

    public boolean getEscapeProcessing() throws SQLException {
        this.checkClose();
        return this.process_escapes;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClose();
        this.process_escapes = enable;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClose();
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClose();
        if (seconds < 0) {
            DBError.throwSQLException(6036);
        }
        this.queryTimeout = seconds;
    }

    public void setType(int type) throws SQLException {
        if (type == 1003) {
            this.rowSetType = 1003;
        } else if (type == 1004) {
            this.rowSetType = 1004;
        } else if (type == 1005) {
            this.rowSetType = 1005;
        } else {
            DBError.throwSQLException(6036);
        }
    }

    public void setConcurrency(int concurrency) throws SQLException {
        if (concurrency == 1007) {
            this.resultConcurrencyType = 1007;
        } else if (concurrency == 1008) {
            this.resultConcurrencyType = 1008;
        } else {
            DBError.throwSQLException(6036);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = null;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Boolean(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Byte(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Short(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Integer(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Long(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Float(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = new Double(x);
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClose();
        byte[] tmp = new byte[length];
        try {
            x.read(tmp, 0, length);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(ioex.toString(), -1);
        }
        this.setParams[parameterIndex] = tmp;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClose();
        byte[] tmp = new byte[length];
        try {
            x.read(tmp, 0, length);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(ioex.toString(), -1);
        }
        this.setParams[parameterIndex] = tmp;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClose();
        char[] tmp = new char[length];
        try {
            reader.read(tmp, 0, length);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(ioex.toString(), -1);
        }
        String str = new String(tmp);
        this.setParams[parameterIndex] = str;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClose();
        this.setParams[parameterIndex] = x;
        if ((Integer)this.setParams[0] < parameterIndex) {
            this.setParams[0] = new Integer(parameterIndex);
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Method setRef() not yet implemented.");
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClose();
        this.setParams[i] = x;
        if ((Integer)this.setParams[0] < i) {
            this.setParams[0] = new Integer(i);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkClose();
        this.setParams[i] = x;
        if ((Integer)this.setParams[0] < i) {
            this.setParams[0] = new Integer(i);
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new UnsupportedOperationException("Method setArray() not yet implemented.");
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkClose();
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setDate(parameterIndex, new Date(cal.getTimeInMillis()));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkClose();
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setTime(parameterIndex, new Time(cal.getTimeInMillis()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClose();
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setTimestamp(parameterIndex, new Timestamp(cal.getTimeInMillis()));
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < (Integer)this.setParams[0]; ++i) {
            this.setParams[i + 1] = null;
        }
        this.setParams[0] = new Integer(0);
    }

    private void _$16309(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        switch (this.transationIsolation) {
            case 0: {
                break;
            }
            case 2: {
                stmt.execute("set transaction isolation level read COMMITTED");
                break;
            }
            case 8: {
                stmt.execute("set transaction isolation level SERIALIZABLE");
                break;
            }
            case 1: {
                stmt.execute("set transaction isolation level read UNCOMMITTED");
                break;
            }
            case 4: {
                stmt.execute("set transaction isolation level REPEATABLE READ");
                break;
            }
            default: {
                DBError.throwSQLException(6038);
            }
        }
    }

    private void _$6671(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        if (this.readOnly) {
            stmt.execute("select set_session_readonly(1)");
        } else {
            stmt.execute("select set_session_readonly(0)");
        }
        if (!((DmdbConnection)conn).getAutoCommit()) {
            ((DmdbConnection)conn).commit();
        }
        if (stmt != null) {
            stmt.close();
            stmt = null;
        }
    }

    public void execute() throws SQLException {
        if (this._$16264 == null) {
            this._$16264 = new DmdbRowSetInsCache();
        }
        if (this._$16291 == null) {
            this._$16291 = new Hashtable();
        }
        Properties props = new Properties();
        ((Hashtable)props).put("user", this.userName);
        ((Hashtable)props).put("password", this.password);
        Connection conn = DmDriver.connect(this.url, props);
        this.fetchSize = ((DmdbConnection)conn).getMaxRows();
        this._$16309(conn);
        this._$6671(conn);
        if (this.process_escapes) {
            this.command = conn.nativeSQL(this.command);
        }
        PreparedStatement preStmt = conn.prepareStatement(this.command, this.rowSetType, this.resultConcurrencyType, 1);
        for (int i = 0; i < (Integer)this.setParams[0]; ++i) {
            preStmt.setObject(i + 1, this.setParams[i + 1]);
        }
        ResultSet rs = ((DmdbPreparedStatement)preStmt).executeQuery2();
        this.resultSet = (DmdbResultSet)rs;
        DmdbResultSetMetaData resultSetMetaData = (DmdbResultSetMetaData)this.resultSet.getMetaData();
        this.rowSetMetaData = new DmdbRowSetMetaData(this.resultSet.colInfo);
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            this.rowSetMetaData.setAutoIncrement(i + 1, resultSetMetaData.isAutoIncrement(i + 1));
        }
        this.resultSet.resultConcurrencyType = this.resultConcurrencyType;
        this.serverEncoding = ((DmdbConnection)conn).getServerEncoding();
        this.dmGetVal = new DmdbGetValue(this.serverEncoding, null, true);
        this.dmSetVal = new DmdbSetValue(this.serverEncoding);
        this.notifyRowSetChanged();
        conn.close();
        this.isClosed = false;
    }

    public synchronized void addRowSetListener(RowSetListener listener) {
        this._$16296.addElement(listener);
    }

    public synchronized void removeRowSetListener(RowSetListener listener) {
        this._$16296.removeElement(listener);
    }

    public boolean next() throws SQLException {
        this.checkClose();
        if (this.resultSet.next()) {
            this.atInsCache = false;
            this.notifyCursorMoved();
            return true;
        }
        if (this._$16264.next()) {
            this.atInsCache = true;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this._$16264 != null) {
            this._$16264 = null;
        }
        if (this._$16292 != null) {
            this._$16292 = null;
        }
        if (this.resultSet != null) {
            this.resultSet = null;
        }
        if (this._$16291 != null) {
            this._$16291 = null;
        }
        this._$7090();
        this.setParams[0] = new Integer(0);
        this.isClosed = true;
    }

    public boolean wasNull() throws SQLException {
        this.checkClose();
        return this.ifWasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        Object tmp;
        DmdbParamValue field;
        String value = null;
        boolean retFlag = false;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            tmp = this._$16317();
            if (tmp == null || tmp != null && !((DmdbUpdatedRow)tmp).getIfUpdated(columnIndex)) {
                value = this.resultSet.getString(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = ((DmdbUpdatedRow)tmp).updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            tmp = new byte[field.getStreamLen()];
            field.getBytes((byte[])tmp, 0, 0, ((Object)tmp).length);
            return Convertion.getString((byte[])tmp, 0, ((Object)tmp).length, this.serverEncoding);
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getString(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        DmdbParamValue field;
        boolean value = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getBoolean(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return false;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getBoolean(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public byte getByte(int columnIndex) throws SQLException {
        DmdbParamValue field;
        byte value = 0;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getByte(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return 0;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getByte(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public short getShort(int columnIndex) throws SQLException {
        DmdbParamValue field;
        short value = 0;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getShort(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return 0;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getShort(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public int getInt(int columnIndex) throws SQLException {
        DmdbParamValue field;
        int value = 0;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getInt(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return 0;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getInt(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public long getLong(int columnIndex) throws SQLException {
        DmdbParamValue field;
        long value = 0L;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getLong(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return 0L;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getLong(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public float getFloat(int columnIndex) throws SQLException {
        DmdbParamValue field;
        float value = 0.0f;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getFloat(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return 0.0f;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getFloat(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public double getDouble(int columnIndex) throws SQLException {
        DmdbParamValue field;
        double value = 0.0;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getDouble(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return 0.0;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getDouble(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        DmdbParamValue field;
        BigDecimal value = null;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getBigDecimal(columnIndex, scale);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = 1;
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        return this.dmGetVal.getBigDecimal(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Object tmp;
        DmdbParamValue field;
        byte[] value = null;
        boolean retFlag = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            tmp = this._$16317();
            if (tmp == null || tmp != null && !((DmdbUpdatedRow)tmp).getIfUpdated(columnIndex)) {
                value = this.resultSet.getBytes(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = ((DmdbUpdatedRow)tmp).updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            tmp = new byte[field.getStreamLen()];
            field.getBytes((byte[])tmp, 0, 0, ((Object)tmp).length);
            return tmp;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        if (sqlType == 2004 || sqlType == -4 || sqlType == 2005 || sqlType == -1) {
            sqlType = 12;
        }
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getBytes(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public Date getDate(int columnIndex) throws SQLException {
        DmdbParamValue field;
        Date value = null;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getDate(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getDate(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public Time getTime(int columnIndex) throws SQLException {
        DmdbParamValue field;
        Time value = null;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getTime(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getTime(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        DmdbParamValue field;
        Timestamp value = null;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getTimestamp(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getTimestamp(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Object tmp;
        DmdbParamValue field;
        InputStream value = null;
        boolean retFlag = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            tmp = this._$16317();
            if (tmp == null || tmp != null && !((DmdbUpdatedRow)tmp).getIfUpdated(columnIndex)) {
                value = this.resultSet.getAsciiStream(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = ((DmdbUpdatedRow)tmp).updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            if (field.getStreamType() == 1) {
                return field.getInputStream();
            }
            tmp = new byte[field.getStreamLen()];
            field.getBytes((byte[])tmp, 0, 0, ((Object)tmp).length);
            return new DmdbInputStream(tmp, true, this.serverEncoding);
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getAsciiStream(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        DmdbParamValue field;
        InputStream value = null;
        boolean retFlag = false;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                if (field.getStreamType() == 1) {
                    return field.getInputStream();
                }
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getUnicodeStream(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            ByteArrayInputStream in = null;
            byte[] tmp = new byte[field.getStreamLen()];
            field.getBytes(tmp, 0, 0, tmp.length);
            in = new ByteArrayInputStream(Convertion.getString(tmp, 0, tmp.length, this.serverEncoding).getBytes());
            return new UtilBinaryToUnicodeInputStream(in);
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getUnicodeStream(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        DmdbParamValue field;
        InputStream value = null;
        boolean retFlag = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getBinaryStream(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            if (field.getStreamType() == 1) {
                return field.getInputStream();
            }
            byte[] tmp1 = new byte[field.getStreamLen()];
            field.getBytes(tmp1, 0, 0, tmp1.length);
            return new DmdbInputStream(tmp1, true, this.serverEncoding);
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getBinaryStream(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("Method getWarnings() not yet implemented.");
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("Method clearWarnings() not yet implemented.");
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("Method getCursorName() not yet implemented.");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowSetMetaData;
    }

    public Object getObject(int columnIndex) throws SQLException {
        DmdbParamValue field;
        Object value = null;
        this.resultSet.checkIndex(columnIndex);
        this.ifWasNull = false;
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getObject(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getObject(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        this.checkClose();
        return this.resultSet.findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object tmp;
        DmdbParamValue field;
        Reader value = null;
        boolean retFlag = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            tmp = this._$16317();
            if (tmp == null || tmp != null && !((DmdbUpdatedRow)tmp).getIfUpdated(columnIndex)) {
                value = this.resultSet.getCharacterStream(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = ((DmdbUpdatedRow)tmp).updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            if (field.getStreamType() == 2) {
                return field.getReader();
            }
            tmp = new byte[field.getStreamLen()];
            field.getBytes((byte[])tmp, 0, 0, ((Object)tmp).length);
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])tmp)));
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[columnIndex - 1].getJdbcSqlType();
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getCharacterStream(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        DmdbParamValue field;
        BigDecimal value = null;
        this.ifWasNull = false;
        this.resultSet.checkIndex(columnIndex);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else if (!this.atInsCache) {
            DmdbUpdatedRow tmp = this._$16317();
            if (tmp == null || tmp != null && !tmp.getIfUpdated(columnIndex)) {
                value = this.resultSet.getBigDecimal(columnIndex);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = tmp.updParams[columnIndex - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        } else {
            field = this._$16264.getField(columnIndex);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = 1;
        int CType = col[columnIndex - 1].getCType();
        int prec = col[columnIndex - 1].getPrecision();
        int scale = col[columnIndex - 1].getScale();
        return this.dmGetVal.getBigDecimal(columnIndex, field.getInValue(), sqlType, CType, prec, scale);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.resultSet.rowCount > 0L) {
            return this.resultSet.isBeforeFirst();
        }
        return this._$16264.getRowNum() > 0 && this._$16264.currentRow <= -1;
    }

    public boolean isAfterLast() throws SQLException {
        if (this._$16264.getRowNum() == 0) {
            return this.resultSet.isAfterLast();
        }
        return this._$16264.currentRow >= this._$16264.getRowNum();
    }

    public boolean isFirst() throws SQLException {
        if (this.resultSet.rowCount > 0L) {
            return this.resultSet.isFirst();
        }
        return this._$16264.getRowNum() > 0 && this._$16264.currentRow == 0;
    }

    public boolean isLast() throws SQLException {
        if (this._$16264.getRowNum() > 0) {
            return this._$16264.currentRow == this._$16264.getRow() - 1;
        }
        return this.resultSet.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.rowSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.resultSet.rowCount > 0L) {
            this.resultSet.beforeFirst();
            this.notifyCursorMoved();
        } else if (this._$16264.getRowNum() > 0) {
            this._$16264.currentRow = 0;
            this.notifyCursorMoved();
        }
    }

    public void afterLast() throws SQLException {
        this.checkClose();
        if (this._$16264.getRowNum() == 0) {
            this.resultSet.afterLast();
            this.notifyCursorMoved();
        } else {
            this._$16264.currentRow = this._$16264.getRowNum();
            this.notifyCursorMoved();
        }
    }

    public boolean first() throws SQLException {
        this.checkClose();
        if (this.rowSetType == 1003 && !this.isBeforeFirst()) {
            DBError.throwSQLException(6019);
        }
        if (this.resultSet == null) {
            return false;
        }
        if (this.resultSet.first()) {
            this.atInsCache = false;
            this.notifyCursorMoved();
            return true;
        }
        if (this._$16264.first()) {
            this.atInsCache = true;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean last() throws SQLException {
        this.checkClose();
        if (this._$16264.last()) {
            this.atInsCache = true;
            this.notifyCursorMoved();
            return true;
        }
        if (this.resultSet.last()) {
            this.atInsCache = false;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public int getRow() throws SQLException {
        this.checkClose();
        if (!this.atInsCache) {
            return this.resultSet.getRow();
        }
        return (int)this.resultSet.rowCount + this._$16264.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (row == 0) {
            DBError.throwSQLException(6020);
        }
        if (this.rowSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (row > 0) {
            if ((long)row <= this.resultSet.rowCount) {
                this.atInsCache = false;
                boolean flag = this.resultSet.absolute(row);
                if (flag) {
                    this.notifyCursorMoved();
                }
                return flag;
            }
            this.atInsCache = true;
            boolean flag = this._$16264.absolute(row - (int)this.resultSet.rowCount);
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        if (row < 0) {
            if (row + this._$16264.getRowNum() >= 0) {
                this.atInsCache = true;
                boolean flag = this._$16264.absolute(row + this._$16264.getRowNum() + 1);
                if (flag) {
                    this.notifyCursorMoved();
                }
                return flag;
            }
            this.atInsCache = false;
            boolean flag = this.resultSet.absolute(row + this._$16264.getRowNum() + (int)this.resultSet.rowCount + 1);
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        if (this.rowSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (!this.atInsCache) {
            if (rows > 0) {
                if ((long)rows + this.resultSet.currentRow + 1L > this.resultSet.rowCount + (long)this._$16264.getRowNum()) {
                    this.afterLast();
                    return false;
                }
                boolean flag = this.absolute((int)this.resultSet.currentRow + rows + 1);
                if (flag) {
                    this.notifyCursorMoved();
                }
                return flag;
            }
            if ((long)rows + this.resultSet.currentRow + 1L <= 0L) {
                this.beforeFirst();
                return false;
            }
            boolean flag = this.absolute((int)this.resultSet.currentRow + rows + 1);
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        if (rows > 0) {
            boolean flag = this._$16264.absolute(this._$16264.currentRow + rows);
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        if (this._$16264.currentRow + rows > -1) {
            boolean flag = this._$16264.absolute(this._$16264.currentRow + rows);
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        this.atInsCache = false;
        boolean flag = this.absolute((int)this.resultSet.rowCount + this._$16264.currentRow + rows + 1);
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.rowSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (!this.atInsCache) {
            boolean flag = this.resultSet.previous();
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        if (this._$16264.currentRow == 0 && this.resultSet.rowCount > 0L) {
            this.atInsCache = false;
            boolean flag = this.resultSet.last();
            if (flag) {
                this.notifyCursorMoved();
            }
            return flag;
        }
        boolean flag = this._$16264.previous();
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1002 && direction != 1000 && direction != 1001) {
            DBError.throwSQLException(6022);
        }
        if (this.rowSetType == 1003 && direction != 1000) {
            DBError.throwSQLException(6023);
        }
        this.direction = direction;
    }

    public int getFetchDirection() throws SQLException {
        this.checkClose();
        return this.direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
        if (rows >= 0 && (rows <= this.fetchSize || this.fetchSize == 0)) {
            if (this.resultSetType != 1004) {
                this.fetchSize = rows;
            }
        } else {
            DBError.throwSQLException(6020);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkClose();
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.resultConcurrencyType;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClose();
        return this._$16317() != null;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClose();
        return this.atInsCache;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClose();
        return this.resultSet.rsCache.rec4_is_deleted_rec();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateNull(columnIndex);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateBoolean(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateByte(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateShort(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateInt(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateLong(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateFloat(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateDouble(columnIndex, x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateBigDecimal(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateString(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateBytes(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateDate(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateTime(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateTimestamp(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateObject(columnIndex, x, scale);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        this.checkUpdatable();
        this.resultSet.updateObject(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.resultSet.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.resultSet.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.resultSet.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.resultSet.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.resultSet.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.resultSet.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.resultSet.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.resultSet.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.resultSet.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.resultSet.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.resultSet.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.resultSet.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.resultSet.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.resultSet.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.resultSet.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.resultSet.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.resultSet.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.resultSet.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        if (!this.isInsertStatus) {
            DBError.throwSQLException(6026);
        }
        this._$16264.insRow(this.resultSet.params, this.resultSet.updatedParam, this.resultSet.lengths);
        this.resultSet.initializePara();
        this.isInsertStatus = false;
    }

    public void updateRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this._$16292 = new DmdbUpdatedRow(this.resultSet.params, this.resultSet.lengths, this.resultSet.updatedParam);
        this._$16320(this._$16292);
        this.resultSet.initializePara();
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.resultSet.rsCache.rec4_set_deleted_mark();
        this.resultSet.rsCache.move_to_next();
        --this.resultSet.rowCount;
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Method refreshRow() not yet implemented.");
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.initializePara();
        this.updatedParam = new boolean[this.colInfo.length];
    }

    public void moveToInsertRow() throws SQLException {
        this.checkClose();
        this._$16264.setInsRowAt();
        super.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkClose();
        this._$16264.resetInsRowAt();
        this.resultSet.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("Method getStatement() not yet implemented.");
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new UnsupportedOperationException("Method getObject() not yet implemented.");
    }

    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException("Method getRef() not yet implemented.");
    }

    public Blob getBlob(int i) throws SQLException {
        Object tmp;
        DmdbParamValue field;
        Blob value = null;
        boolean retFlag = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(i);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(i);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            tmp = this._$16317();
            if (tmp == null || tmp != null && !((DmdbUpdatedRow)tmp).getIfUpdated(i)) {
                value = this.resultSet.getBlob(i);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = ((DmdbUpdatedRow)tmp).updParams[i - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(i);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            if (field.getStreamType() == 3) {
                return field.getBlob();
            }
            tmp = new byte[field.getStreamLen()];
            field.getBytes((byte[])tmp, 0, 0, ((Object)tmp).length);
            return new DmdbBlob((byte[])tmp);
        }
        tmp = null;
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[i - 1].getJdbcSqlType();
        int CType = col[i - 1].getCType();
        int prec = col[i - 1].getPrecision();
        int scale = col[i - 1].getScale();
        if (field.getStreamType() == 3) {
            Blob blob = field.getBlob();
            return blob;
        }
        tmp = field.getInValue();
        return this.dmGetVal.getBlob(i, (byte[])tmp, sqlType, CType, prec, scale);
    }

    public Clob getClob(int i) throws SQLException {
        Object tmp;
        DmdbParamValue field;
        Clob value = null;
        boolean retFlag = false;
        this.ifWasNull = false;
        this.resultSet.checkIndex(i);
        if (this._$16264.getInsRowAt() != -1) {
            field = this._$16264.getInsField(i);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else if (!this.atInsCache) {
            tmp = this._$16317();
            if (tmp == null || tmp != null && !((DmdbUpdatedRow)tmp).getIfUpdated(i)) {
                value = this.resultSet.getClob(i);
                this.ifWasNull = this.resultSet.wasNullFlag;
                return value;
            }
            field = ((DmdbUpdatedRow)tmp).updParams[i - 1];
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        } else {
            field = this._$16264.getField(i);
            if (field == null || field.getIsInDataNull()) {
                this.ifWasNull = true;
            } else {
                retFlag = true;
            }
        }
        if (this.ifWasNull) {
            return null;
        }
        if (retFlag) {
            if (field.getStreamType() == 4) {
                return field.getClob();
            }
            tmp = new byte[field.getStreamLen()];
            field.getBytes((byte[])tmp, 0, 0, ((Object)tmp).length);
            return new DmdbClob((byte[])tmp, this.serverEncoding);
        }
        DmdbColumn[] col = this.resultSet.colInfo;
        int sqlType = col[i - 1].getJdbcSqlType();
        int CType = col[i - 1].getCType();
        int prec = col[i - 1].getPrecision();
        int scale = col[i - 1].getScale();
        if (field.getStreamType() == 4) {
            Clob clob = field.getClob();
            return clob;
        }
        return this.dmGetVal.getClob(i, field.getInValue(), sqlType, CType, prec, scale);
    }

    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException("Method getArray() not yet implemented.");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new UnsupportedOperationException("Method getObject() not yet implemented.");
    }

    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException("Method getRef() not yet implemented.");
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException("Method getArray() not yet implemented.");
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.resultSet.checkIndex(columnIndex);
        Date d = this.getDate(columnIndex);
        if (this.ifWasNull) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(d);
        return new Date(cal.getTimeInMillis());
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (this.ifWasNull) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (this.ifWasNull) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        timestamp = new Timestamp(cal.getTimeInMillis());
        return timestamp;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Method getURL() not yet implemented.");
    }

    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException("Method getURL() not yet implemented.");
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Method updateRef() not yet implemented.");
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Method updateRef() not yet implemented.");
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.resultSet.updateBlob(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.resultSet.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.resultSet.updateClob(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Method updateArray() not yet implemented.");
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException("Method updateArray() not yet implemented.");
    }

    private void _$16322(Connection conn) throws SQLException {
        int i;
        Vector deletedRowid = this.resultSet.rsCache.getDeletedRowid();
        if (deletedRowid == null) {
            return;
        }
        StringBuffer[] deleteStmtBuffer = new StringBuffer[deletedRowid.size()];
        String catalog = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getCatalog()) + "\"";
        String schema = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getSchema()) + "\"";
        String table = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getTable()) + "\"";
        for (i = 0; i < deletedRowid.size(); ++i) {
            deleteStmtBuffer[i] = new StringBuffer();
            deleteStmtBuffer[i].append("DELETE FROM ");
            deleteStmtBuffer[i].append(catalog).append(".");
            deleteStmtBuffer[i].append(schema).append(".");
            deleteStmtBuffer[i].append(table);
            deleteStmtBuffer[i].append(" WHERE rowid= " + (String)deletedRowid.get(i));
        }
        Statement stmtForDel = null;
        stmtForDel = conn.createStatement();
        for (i = 0; i < deletedRowid.size(); ++i) {
            stmtForDel.executeUpdate(deleteStmtBuffer[i].toString());
        }
        stmtForDel.close();
    }

    private void _$16324(Connection conn) throws SQLException {
        Set rowids = this._$16291.keySet();
        if (rowids == null) {
            return;
        }
        Object[] rowidArray = rowids.toArray();
        String catalog = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getCatalog()) + "\"";
        String schema = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getSchema()) + "\"";
        String table = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getTable()) + "\"";
        for (int i = 0; i < rowidArray.length; ++i) {
            int j;
            String paramNames = "";
            DmdbUpdatedRow updRow = (DmdbUpdatedRow)this._$16291.get(rowidArray[i]);
            int pan = 0;
            for (j = 0; j < this.resultSet.colInfo.length; ++j) {
                if (!updRow.getIfUpdated(j + 1)) continue;
                if (pan++ > 0) {
                    paramNames = paramNames + ", ";
                }
                paramNames = paramNames + "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[j].getName()) + "\"" + " = ? ";
            }
            if (paramNames.length() == 0) continue;
            String updateSql = "update " + catalog + "." + schema + "." + table + " set " + paramNames + " where rowid = " + (String)rowidArray[i];
            DmdbPreparedStatement stmtForUpd = (DmdbPreparedStatement)conn.prepareStatement(updateSql);
            pan = 0;
            for (j = 0; j < this.resultSet.colInfo.length; ++j) {
                if (!updRow.getIfUpdated(j + 1)) continue;
                stmtForUpd.setParamValue(++pan, updRow.updParams[j]);
            }
            stmtForUpd.setPutLobData(2);
            stmtForUpd.executeUpdate();
            stmtForUpd.close();
        }
    }

    private void _$16330(Connection conn) throws SQLException {
        if (this._$16264.getRowNum() == 0) {
            return;
        }
        String catalog = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getCatalog()) + "\"";
        String schema = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getSchema()) + "\"";
        String table = "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[0].getTable()) + "\"";
        for (int i = 0; i < this._$16264.getRowNum(); ++i) {
            int j;
            boolean[] ifUpd = (boolean[])this._$16264.ifUpdated.get(i);
            String paramNames = "";
            String paramEntity = "";
            int pan = 0;
            for (j = 0; j < this.resultSet.colInfo.length; ++j) {
                if (!ifUpd[j]) continue;
                if (pan++ > 0) {
                    paramNames = paramNames + " , ";
                    paramEntity = paramEntity + " , ";
                }
                paramNames = paramNames + "\"" + StringUtil.getEscObjName(this.resultSet.colInfo[j].getName()) + "\"";
                paramEntity = paramEntity + " ? ";
            }
            if (paramEntity.length() == 0 || paramNames.length() == 0) continue;
            String insertSql = "insert into " + catalog + "." + schema + "." + table + " (" + paramNames + ") values(" + paramEntity + ")";
            DmdbPreparedStatement stmtForIns = (DmdbPreparedStatement)conn.prepareStatement(insertSql);
            pan = 0;
            ArrayList row = this._$16264.getOneRow(i);
            for (j = 0; j < this.resultSet.colInfo.length; ++j) {
                if (!ifUpd[j]) continue;
                stmtForIns.setParamValue(++pan, (DmdbParamValue)row.get(j));
            }
            stmtForIns.setPutLobData(2);
            stmtForIns.executeUpdate();
            stmtForIns.close();
        }
    }

    public void acceptChange() throws SQLException {
        this.checkUpdatable();
        Properties props = new Properties();
        ((Hashtable)props).put("user", this.userName);
        ((Hashtable)props).put("password", this.password);
        Connection conn = DmDriver.connect(this.url, props);
        this._$16309(conn);
        this._$16322(conn);
        this._$16324(conn);
        this._$16330(conn);
        conn.close();
    }

    private String _$16333() {
        int high = 0;
        int low = 0;
        high = this.resultSet.rsCache.rec4_get_rowid_high();
        low = this.resultSet.rsCache.rec4_get_rowid_low();
        return Convertion.rowIdToHex(high, low);
    }

    private void _$16320(DmdbUpdatedRow updatedRow) {
        String rowId = this._$16333();
        this._$16291.put(rowId, updatedRow);
    }

    private DmdbUpdatedRow _$16317() {
        String rowId = this._$16333();
        Object tmp = this._$16291.get(rowId);
        if (tmp == null) {
            return null;
        }
        return (DmdbUpdatedRow)tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCursorMoved() {
        Vector v;
        RowSetEvent e = new RowSetEvent(this);
        DmdbRowSet dmdbRowSet = this;
        synchronized (dmdbRowSet) {
            v = (Vector)this._$16296.clone();
        }
        for (int i = 0; i < v.size(); ++i) {
            ((RowSetListener)v.elementAt(i)).cursorMoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRowChanged() {
        Vector v;
        RowSetEvent e = new RowSetEvent(this);
        DmdbRowSet dmdbRowSet = this;
        synchronized (dmdbRowSet) {
            v = (Vector)this._$16296.clone();
        }
        for (int i = 0; i < v.size(); ++i) {
            ((RowSetListener)v.elementAt(i)).rowChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRowSetChanged() {
        Vector v;
        RowSetEvent e = new RowSetEvent(this);
        DmdbRowSet dmdbRowSet = this;
        synchronized (dmdbRowSet) {
            v = (Vector)this._$16296.clone();
        }
        for (int i = 0; i < v.size(); ++i) {
            ((RowSetListener)v.elementAt(i)).rowSetChanged(e);
        }
    }

    static {
        try {
            DmDriver = (DmDriver)Class.forName("dm.jdbc.driver.DmDriver").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
        }
    }
}

