/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbDataTypeMetaData;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DmdbResultSetMetaData
extends DmdbDataTypeMetaData
implements ResultSetMetaData {
    DmdbStatement stmt = null;
    DmdbColumn[] columnsInfo = null;
    int concurrency;
    private int _$5082;
    private int _$5083;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;

    public DmdbResultSetMetaData(DmdbColumn[] columnsInfo) {
        this.stmt = null;
        this.columnsInfo = columnsInfo;
    }

    public DmdbResultSetMetaData(DmdbStatement stmt, DmdbColumn[] columnsInfo, int concurrency) {
        this.stmt = stmt;
        this.columnsInfo = columnsInfo;
        this.concurrency = concurrency;
    }

    public int getColumnCount() throws SQLException {
        return this.columnsInfo.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkIndex(column);
        boolean identity = this.columnsInfo[column - 1].getIdentity();
        if (identity) {
            DmdbResultSet rs;
            DmdbStatement stmt;
            block4: {
                String cata = "\"" + this.columnsInfo[column - 1].getCatalog() + "\"";
                String sch = this.columnsInfo[column - 1].getSchema();
                String tab = this.columnsInfo[column - 1].getTable();
                String col = this.columnsInfo[column - 1].getName();
                String sql = "SELECT \"I_SEED\", \"I_INCREMENT\" FROM " + cata + ".SYSDBA.SYSIDENTITY AA " + "WHERE AA.ID = " + "(SELECT ID FROM " + cata + ".SYSDBA.SYSTABLES WHERE NAME = '" + tab + "' AND " + "SCHID = (SELECT SCHID FROM " + cata + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch + "')) " + "AND AA.COLID = " + "(SELECT COLID FROM " + cata + ".SYSDBA.SYSCOLUMNS WHERE ID = AA.ID AND NAME = '" + col + "')";
                stmt = null;
                rs = null;
                try {
                    stmt = (DmdbStatement)this.stmt.connection.createStatement(1003, 1007, 1);
                    rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
                    stmt.close();
                }
                catch (SQLException e) {
                    if (stmt == null) break block4;
                    stmt.close();
                }
            }
            if (rs != null && rs.next()) {
                this._$5082 = rs.getInt(1);
                this._$5083 = rs.getInt(2);
                rs.close();
                stmt.close();
            }
        }
        return identity;
    }

    protected int getSeed() {
        return this._$5082;
    }

    protected int getIncrement() {
        return this._$5083;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        boolean isCaseSensitive;
        this.checkIndex(column);
        int t2 = this.getColumnType(column);
        switch (t2) {
            case -7: 
            case -6: 
            case -4: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: 
            case 2005: {
                isCaseSensitive = false;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                isCaseSensitive = true;
                break;
            }
            default: {
                isCaseSensitive = false;
            }
        }
        return isCaseSensitive;
    }

    public boolean isSearchable(int column) throws SQLException {
        this.checkIndex(column);
        int t2 = this.getColumnType(column);
        switch (t2) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 2004: 
            case 2005: {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        if (this.getColumnType(column) == 3) {
            return this.getPrecision(column) == 19 && this.getScale(column) == 4;
        }
        return false;
    }

    public int isNullable(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getNullable() ? this.columnNullable : this.columnNoNulls;
    }

    public boolean isSigned(int column) throws SQLException {
        this.checkIndex(column);
        int t2 = this.getColumnType(column);
        return this.signed(t2);
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getJdbcPrecision();
    }

    public String getColumnLabel(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getName();
    }

    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    public String getSchemaName(int column) throws SQLException {
        this.checkIndex(column);
        String s = this.columnsInfo[column - 1].getSchema();
        if (s != null && s.length() > 0) {
            return s;
        }
        if (this.stmt != null) {
            return this.stmt.connection.getUserName();
        }
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getJdbcPrecision();
    }

    public int getScale(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getScale();
    }

    public String getTableName(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getTable();
    }

    public String getCatalogName(int column) throws SQLException {
        this.checkIndex(column);
        String s = this.columnsInfo[column - 1].getCatalog();
        if (s != null && s.trim().length() > 0) {
            return s.trim();
        }
        if (this.stmt != null) {
            return this.stmt.connection.getCatalog();
        }
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        this.checkIndex(column);
        return this.columnsInfo[column - 1].getJdbcSqlType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.checkIndex(column);
        String typeName = this.columnsInfo[column - 1].getTypeName();
        if (typeName == null || typeName.equals("")) {
            int dataType = this.columnsInfo[column - 1].getCType();
            int jdbcType = this.columnsInfo[column - 1].getJdbcSqlType();
            int scale = this.columnsInfo[column - 1].getOrigIntervalScale();
            typeName = this.getTypeName(dataType, jdbcType, scale);
        }
        return typeName;
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.checkIndex(column);
        return this.concurrency == 1007;
    }

    public boolean isWritable(int column) throws SQLException {
        this.checkIndex(column);
        return this.concurrency == 1008;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkIndex(column);
        return this.concurrency == 1008;
    }

    public String getColumnClassName(int column) throws SQLException {
        this.checkIndex(column);
        int t2 = this.columnsInfo[column - 1].getJdbcSqlType();
        return this.getClassName(t2);
    }

    void checkIndex(int i) throws SQLException {
        if (i < 1 || i > this.getColumnCount()) {
            DBError.throwSQLException(6032);
        }
    }
}

