/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.Convertion;
import java.sql.SQLException;
import java.util.Vector;

public class DmdbResultSetCache
implements Cloneable {
    DmdbStatement statement = null;
    int realLen = 0;
    int rownum = 0;
    int offset = 0;
    int curpos = 0;
    short nflds = (short)-1;
    byte[] rowbuf;
    private int _$1269 = 0;
    private DmdbColumn[] _$6204 = null;
    private int[] _$9579 = null;

    DmdbResultSetCache(DmdbStatement stmt, DmdbColumn[] colsInfo) throws SQLException {
        this.statement = stmt;
        this.rowbuf = null;
        this._$6204 = colsInfo;
        this._$9579 = new int[colsInfo.length];
    }

    void env_stmt_init_curbuf() {
        this.rownum = 0;
        this.offset = 0;
        this.curpos = 0;
    }

    public void fillBuffer(byte[] buffer, int len, int rows) {
        this._$9581();
        this.env_stmt_init_curbuf();
        this.rowbuf = buffer;
        this.rownum = rows;
        this.realLen = len;
        this.nflds = (short)this._$6204.length;
    }

    public void fillBuffer2(byte[] buffer, int off, int len, int rows) {
        this._$9581();
        this.env_stmt_init_curbuf();
        if (this.rowbuf == null) {
            this.rowbuf = new byte[32768];
        }
        System.arraycopy(buffer, off, this.rowbuf, 0, len);
        this.rownum = rows;
        this.realLen = len;
        this.nflds = (short)this._$6204.length;
    }

    boolean rec4_nth_fld_is_null(short nth) {
        byte[] ctl_bit = this.rec4_get_ctl_bit();
        byte ctl_bit_val = this.rec4_get_nth_ctl_bit_value(ctl_bit, nth);
        return ctl_bit_val == 3;
    }

    public byte[] getBytes(short columnNo) {
        byte[] alen = new byte[2];
        int ddd = 0;
        if (this.rowbuf == null) {
            return null;
        }
        if (columnNo < 0 || columnNo >= this.nflds) {
            return null;
        }
        if (this.rec4_nth_fld_is_null(columnNo)) {
            return null;
        }
        int size_of_before_n = this.rec4_get_nth_fld_addr(this.rowbuf, this.offset, columnNo, alen);
        short fld_len = Convertion.getShort(alen, 0);
        byte[] val_buf = new byte[fld_len];
        System.arraycopy(this.rowbuf, ddd += size_of_before_n, val_buf, 0, fld_len);
        return val_buf;
    }

    public boolean next() {
        this._$9581();
        if (this.curpos >= this.rownum) {
            return false;
        }
        short rec_len = this.rec4_get_len(this.rowbuf, this.offset);
        this.offset += rec_len;
        if (this.offset >= this.realLen) {
            ++this.curpos;
            return true;
        }
        while (this.rec4_is_deleted_rec()) {
            rec_len = this.rec4_get_len(this.rowbuf, this.offset);
            this.offset += rec_len;
        }
        ++this.curpos;
        return true;
    }

    public boolean previous() {
        this._$9581();
        if (this.curpos <= 0) {
            return false;
        }
        this.offset = 0;
        for (int i = 0; i < this.curpos - 1; i = (int)((short)(i + 1))) {
            while (this.rec4_is_deleted_rec()) {
                short rec_len = this.rec4_get_len(this.rowbuf, this.offset);
                this.offset += rec_len;
            }
            this.offset += this.rec4_get_len(this.rowbuf, this.offset);
        }
        --this.curpos;
        return true;
    }

    public boolean absolute(int position) {
        short rec_len;
        this._$9581();
        if (position < 0) {
            position = 0;
        }
        if (position >= this.rownum) {
            position = this.rownum - 1;
        }
        this.offset = 0;
        for (int i = 0; i < position; i = (int)((short)(i + 1))) {
            while (this.rec4_is_deleted_rec()) {
                rec_len = this.rec4_get_len(this.rowbuf, this.offset);
                this.offset += rec_len;
            }
            this.offset += this.rec4_get_len(this.rowbuf, this.offset);
        }
        while (this.rec4_is_deleted_rec()) {
            rec_len = this.rec4_get_len(this.rowbuf, this.offset);
            this.offset += rec_len;
        }
        this.curpos = position;
        return true;
    }

    byte[] rec4_get_ctl_bit() {
        short ctl_bit_size = this.rec4_get_ctl_bit_size(this.nflds);
        short len_size = this.rec4_get_len_size(this.rowbuf, this.offset);
        short rowid_size = this.rec4_get_rowid_size();
        byte[] ctl_bit = new byte[ctl_bit_size];
        System.arraycopy(this.rowbuf, this.offset + len_size + rowid_size + 1, ctl_bit, 0, ctl_bit.length);
        return ctl_bit;
    }

    byte rec4_get_nth_ctl_bit_value(byte[] ctl_bit, short nth) {
        short byte_off = (short)(nth / 4);
        short bit_off = (short)(nth % 4 * 2);
        byte off = ctl_bit[byte_off];
        return (byte)(off >> bit_off & 3);
    }

    short rec4_read_2byte_len(byte[] addr, int off) {
        return (short)(((short)addr[off] << 8) + (short)(0xFF & addr[off + 1]));
    }

    short rec4_get_var_alen(byte[] addr, int off, byte[] nth_ctl_len) {
        if ((addr[off] & 0x80) != 0) {
            nth_ctl_len[0] = 1;
            return (short)(addr[off] & 0x7F);
        }
        nth_ctl_len[0] = 2;
        return this.rec4_read_2byte_len(addr, off);
    }

    int rec4_get_nth_fld_addr(byte[] rec, int off, short n, byte[] alen) {
        byte ctl_bit_val;
        int scale;
        int prec;
        int cType;
        short i;
        short nth_alen = 0;
        byte[] nth_ctl_len = new byte[1];
        byte[] ctl_bit = this.rec4_get_ctl_bit();
        if (this._$9579[n] != 0) {
            int cType2 = this._$6204[n].getCType();
            int prec2 = this._$6204[n].getPrecision();
            byte ctl_bit_val2 = this.rec4_get_nth_ctl_bit_value(ctl_bit, n);
            switch (ctl_bit_val2) {
                case 3: {
                    nth_alen = DmdbType.dtype_is_fixed_low(cType2) ? (short)DmdbType.dtype_get_internal_len_low(cType2, prec2) : (short)0;
                    Convertion.setShort(alen, 0, (short)-2);
                    break;
                }
                case 0: {
                    if (DmdbType.dtype_is_fixed_low(cType2)) {
                        nth_alen = (short)DmdbType.dtype_get_internal_len_low(cType2, prec2);
                        Convertion.setShort(alen, 0, nth_alen);
                        break;
                    }
                    nth_alen = this.rec4_get_var_alen(rec, this._$9579[n], nth_ctl_len);
                    Convertion.setShort(alen, 0, nth_alen);
                    nth_alen = (short)(nth_alen + nth_ctl_len[0]);
                }
            }
            if (n < this._$9579.length - 1) {
                this._$9579[n + 1] = this._$9579[n] + nth_alen;
            }
            return this._$9579[n] + nth_ctl_len[0];
        }
        for (i = n; i > 0 && this._$9579[i] == 0; i = (short)(i - 1)) {
        }
        if (i == 0) {
            this._$9579[0] = off + this.rec4_get_data_offset(this.nflds);
        }
        int tmp = this._$9579[i];
        while (i < n) {
            nth_ctl_len[0] = 0;
            cType = this._$6204[i].getCType();
            prec = this._$6204[i].getPrecision();
            scale = this._$6204[i].getScale();
            ctl_bit_val = this.rec4_get_nth_ctl_bit_value(ctl_bit, i);
            switch (ctl_bit_val) {
                case 3: {
                    if (DmdbType.dtype_is_fixed_low(cType)) {
                        nth_alen = (short)DmdbType.dtype_get_internal_len_low(cType, prec);
                        break;
                    }
                    nth_alen = 0;
                    break;
                }
                case 0: {
                    nth_alen = DmdbType.dtype_is_fixed_low(cType) ? (short)DmdbType.dtype_get_internal_len_low(cType, prec) : this.rec4_get_var_alen(rec, tmp, nth_ctl_len);
                }
            }
            this._$9579[i + 1] = tmp += nth_alen + nth_ctl_len[0];
            i = (short)(i + 1);
        }
        cType = this._$6204[n].getCType();
        prec = this._$6204[n].getPrecision();
        scale = this._$6204[n].getScale();
        ctl_bit_val = this.rec4_get_nth_ctl_bit_value(ctl_bit, n);
        nth_ctl_len[0] = 0;
        switch (ctl_bit_val) {
            case 3: {
                nth_alen = DmdbType.dtype_is_fixed_low(cType) ? (short)DmdbType.dtype_get_internal_len_low(cType, prec) : (short)0;
                Convertion.setShort(alen, 0, (short)-2);
                break;
            }
            case 0: {
                if (DmdbType.dtype_is_fixed_low(cType)) {
                    nth_alen = (short)DmdbType.dtype_get_internal_len_low(cType, prec);
                    Convertion.setShort(alen, 0, nth_alen);
                    break;
                }
                nth_alen = this.rec4_get_var_alen(rec, tmp, nth_ctl_len);
                Convertion.setShort(alen, 0, nth_alen);
            }
        }
        tmp += nth_ctl_len[0];
        if (n < this._$9579.length - 1) {
            this._$9579[n + 1] = tmp + nth_alen;
        }
        return tmp;
    }

    byte rec4_get_len_size(byte[] rec, int off) {
        if ((rec[off] & 0x10) == 0) {
            return 1;
        }
        return 2;
    }

    short rec4_get_ctl_bit_size(short n_flds) {
        if (n_flds % 4 != 0) {
            return (short)(n_flds / 4 + 1);
        }
        return (short)(n_flds / 4 + 0);
    }

    short rec4_get_data_offset(short n_flds) {
        return (short)(1 + this.rec4_get_len_size(this.rowbuf, this.offset) + this.rec4_get_rowid_size() + this.rec4_get_ctl_bit_size(n_flds));
    }

    short rec4_get_len(byte[] rec, int off) {
        if (this.rec4_get_len_size(rec, off) == 1) {
            return (short)(rec[off + 1] & 0xFF);
        }
        return Convertion.getShort(rec, off + 1);
    }

    byte rec4_get_rowid_offset() {
        return (byte)(this.rec4_get_len_size(this.rowbuf, this.offset) + 1);
    }

    byte rec4_get_rowid_size() {
        return (byte)(((this.rowbuf[this.offset] & 0x60) >> 5) + 3);
    }

    int rec4_get_rowid_high() {
        int off = this.offset + this.rec4_get_rowid_offset();
        byte size = this.rec4_get_rowid_size();
        switch (size) {
            case 3: 
            case 4: {
                return 0;
            }
            case 5: {
                return this.rowbuf[off + 4] & 0xFF;
            }
            case 6: {
                return Convertion.getShort(this.rowbuf, off + 4) & 0xFFFF;
            }
        }
        return 0;
    }

    int rec4_get_rowid_low() {
        int off = this.offset + this.rec4_get_rowid_offset();
        byte size = this.rec4_get_rowid_size();
        switch (size) {
            case 3: {
                return Convertion.getShort(this.rowbuf, off) & 0xFFFF | 0xFF0000 & this.rowbuf[off + 2] << 16;
            }
            case 4: 
            case 5: 
            case 6: {
                return Convertion.getInt(this.rowbuf, off);
            }
        }
        return 0;
    }

    public void move_to_next() {
        while (this.rec4_is_deleted_rec()) {
            short rec_len = this.rec4_get_len(this.rowbuf, this.offset);
            this.offset += rec_len;
            if (this.offset < this.realLen) continue;
            return;
        }
    }

    void rec4_set_deleted_mark() {
        int n = this.offset;
        this.rowbuf[n] = (byte)(this.rowbuf[n] | 0x80);
    }

    boolean rec4_is_deleted_rec() {
        return (this.rowbuf[this.offset] & 0x80) != 0;
    }

    public Vector getDeletedRowid() {
        Vector<String> tmp = new Vector<String>();
        this.offset = 0;
        for (int row = 0; row < this.rownum; ++row) {
            if (this.rec4_is_deleted_rec()) {
                String rowid = Convertion.rowIdToHex(this.rec4_get_rowid_high(), this.rec4_get_rowid_low());
                tmp.add(rowid);
            }
            short rec_len = this.rec4_get_len(this.rowbuf, this.offset);
            this.offset += rec_len;
        }
        return tmp;
    }

    public void setType(int type) {
        this._$1269 = type;
    }

    public void setCols(DmdbColumn[] colInfo) {
        this._$6204 = colInfo;
        this._$9579 = new int[colInfo.length];
    }

    private void _$9581() {
        for (int i = 0; i < this._$9579.length; ++i) {
            this._$9579[i] = 0;
        }
    }

    public final Object clone() {
        DmdbResultSetCache rsCache = null;
        try {
            rsCache = (DmdbResultSetCache)super.clone();
            rsCache._$6204 = null;
            rsCache.statement = null;
            rsCache._$9581();
            rsCache.offset = 0;
            rsCache.curpos = 0;
            if (this.rowbuf != null) {
                rsCache.rowbuf = (byte[])this.rowbuf.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return rsCache;
    }
}

