/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCachedResultSet;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbGetValue;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbParamValue;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSetValue;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.Convertion;
import dm.jdbc.util.StringUtil;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DmdbResultSet
implements ResultSet,
Cloneable {
    DmdbResultSetCache rsCache;
    DmdbStatement statement = null;
    DmdbConnection conn = null;
    protected SQLWarning m_warnings = null;
    protected int maxFieldSize;
    protected boolean isClosed = false;
    int fetchDirection;
    int fetchSize;
    protected int resultSetType;
    protected int resultConcurrencyType;
    protected int resultSetHoldability;
    protected boolean wasNullFlag = false;
    private boolean _$2512 = true;
    long startRow = 0L;
    DmdbInfo dbInfo = null;
    DmdbColumn[] colInfo = null;
    protected long currentRow = -1L;
    protected boolean[] updatedParam = null;
    DmdbParamValue[] params = null;
    Vector lengths = new Vector();
    protected boolean isUpdateStatus = false;
    protected boolean isInsertStatus = false;
    boolean metaRsFlag = false;
    long rowCount = 0L;
    int columnCount = 0;
    DmdbGetValue dmGetVal;
    DmdbSetValue dmSetVal;
    String serverEncoding = null;
    HashMap colNames = null;
    boolean canCache = true;
    DmdbBlob[][] blobArray = null;
    DmdbClob[][] clobArray = null;
    int FETCH_FORWARD = 1000;
    int FETCH_REVERSE = 1001;
    int FETCH_UNKNOWN = 1002;
    int TYPE_FORWARD_ONLY = 1003;
    int TYPE_SCROLL_INSENSITIVE = 1004;
    int TYPE_SCROLL_SENSITIVE = 1005;
    int CONCUR_READ_ONLY = 1007;
    int CONCUR_UPDATABLE = 1008;
    int HOLD_CURSORS_OVER_COMMIT = 1;
    int CLOSE_CURSORS_AT_COMMIT = 2;

    DmdbResultSet() {
    }

    DmdbResultSet(DmdbInfo info) throws SQLException {
        this.dbInfo = info;
        this.canCache = info.getCanCache();
        this.colInfo = info.getColumnsInfo();
        this.rowCount = info.getRowCount();
        this.columnCount = info.getColumnCount();
        this.statement = null;
        this.conn = null;
        this.updatedParam = new boolean[this.columnCount];
        this.initializePara();
    }

    DmdbResultSet(DmdbResultSetCache cache, DmdbInfo info) throws SQLException {
        this.rsCache = cache;
        this.dbInfo = info;
        this.canCache = info.getCanCache();
        this.colInfo = info.getColumnsInfo();
        this.rowCount = info.getRowCount();
        this.columnCount = info.getColumnCount();
        this.statement = this.rsCache.statement;
        this.conn = this.statement.connection;
        this.maxFieldSize = 0;
        this.resultSetType = 1003;
        this.resultConcurrencyType = 1007;
        this.resultSetHoldability = 1;
        this.serverEncoding = this.conn.getServerEncoding();
        this.dmGetVal = new DmdbGetValue(this.serverEncoding, this.statement, this.statement.fromRowSetFlag);
        this.dmSetVal = new DmdbSetValue(this.serverEncoding);
        this.fetchDirection = 1000;
        this.fetchSize = 5;
        if (this.statement != null) {
            this.maxFieldSize = this.statement.getMaxFieldSize();
            this.resultSetType = this.statement.getResultSetType();
            this.resultConcurrencyType = this.statement.getResultSetConcurrency();
            this.resultSetHoldability = this.statement.getResultSetHoldability();
            this.fetchDirection = this.statement.getFetchDirection();
            this.fetchSize = this.statement.getFetchSize();
        }
        this.updatedParam = new boolean[this.columnCount];
        this.initializePara();
    }

    DmdbResultSet(DmdbResultSetCache cache, DmdbInfo info, boolean fetchAll) throws SQLException {
        this.rsCache = cache;
        this.dbInfo = info;
        this.canCache = info.getCanCache();
        this.colInfo = info.getColumnsInfo();
        this.rowCount = info.getRowCount();
        this.columnCount = info.getColumnCount();
        this.statement = this.rsCache.statement;
        this.conn = this.statement.connection;
        this.maxFieldSize = 0;
        this.resultSetType = 1003;
        this.resultConcurrencyType = 1007;
        this.resultSetHoldability = 1;
        this.serverEncoding = this.conn.getServerEncoding();
        this.dmGetVal = new DmdbGetValue(this.serverEncoding, this.statement, this.statement.fromRowSetFlag);
        this.dmSetVal = new DmdbSetValue(this.serverEncoding);
        this.fetchDirection = 1000;
        this.fetchSize = 5;
        if (this.statement != null) {
            this.maxFieldSize = this.statement.getMaxFieldSize();
            this.resultSetType = this.statement.getResultSetType();
            this.resultConcurrencyType = this.statement.getResultSetConcurrency();
            this.resultSetHoldability = this.statement.getResultSetHoldability();
            this.fetchDirection = this.statement.getFetchDirection();
            this.fetchSize = this.statement.getFetchSize();
        }
        this._$2529(1, fetchAll, this);
        this.metaRsFlag = true;
        this.statement = null;
        this.updatedParam = new boolean[this.columnCount];
        this.initializePara();
    }

    public boolean next() throws SQLException {
        this.checkClose();
        if (this.rowCount == 0L) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, 100);
            return false;
        }
        if (this.currentRow == -1L) {
            ++this.currentRow;
            if (this.startRow == 0L && this.rsCache.rownum > 0) {
                this.rsCache.absolute(0);
            } else {
                this._$2529(1, false, null);
            }
            return true;
        }
        if (this.currentRow < this.rowCount) {
            ++this.currentRow;
            if (this.currentRow == this.rowCount) {
                this.rsCache.next();
                return false;
            }
            if (this.currentRow >= this.startRow + (long)this.rsCache.rownum) {
                this.startRow = this.currentRow;
                int code = this._$2529(1, false, null);
                if (code == -3336) {
                    this.startRow = this.currentRow = this.rowCount - 1L;
                    this._$2529(1, false, null);
                    this.currentRow = this.rowCount;
                    this.rsCache.next();
                    return false;
                }
            } else {
                this.rsCache.next();
            }
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.rowCount == Long.MAX_VALUE) {
            this.statement.m_csi.closeHandle(this.statement);
        } else if (this.canCache && DmdbConnection.maxCachedResultSet > 0 && this.statement != null && this.dbInfo.getHasResultSet() && this.rsCache != null && this.rowCount == (long)this.rsCache.rownum && !(this.statement instanceof DmdbCallableStatement) && (DmdbConnection.sqlMap.get(this.statement.originalSql) != null || this.statement.originalSql.indexOf("/*CACHE*/") != -1)) {
            DmdbResultSet rs = (DmdbResultSet)this.clone();
            DmdbCachedResultSet.putResultSet(this.statement.originalSql, this.statement.getParams(), rs);
        }
        this.isClosed = true;
        this.dbInfo = null;
        this.colInfo = null;
        this.currentRow = -1L;
        if (this.rsCache != null) {
            this.rsCache = null;
        }
        this.blobArray = null;
        this.clobArray = null;
        this.clearWarnings();
        this.statement = null;
        this.conn = null;
    }

    public boolean wasNull() throws SQLException {
        this.checkClose();
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        String str = null;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        str = this.dmGetVal.getString(columnIndex, val, type, CType, prec, scale);
        return str;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean bl = false;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return false;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        bl = this.dmGetVal.getBoolean(columnIndex, val, type, CType, prec, scale);
        return bl;
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        byte tmp = this.dmGetVal.getByte(columnIndex, val, type, CType, prec, scale);
        return tmp;
    }

    public short getShort(int columnIndex) throws SQLException {
        short dbl = 0;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        dbl = this.dmGetVal.getShort(columnIndex, val, type, CType, prec, scale);
        return dbl;
    }

    public int getInt(int columnIndex) throws SQLException {
        int dbl = 0;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        dbl = this.dmGetVal.getInt(columnIndex, val, type, CType, prec, scale);
        return dbl;
    }

    public long getLong(int columnIndex) throws SQLException {
        long dbl = 0L;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return 0L;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        dbl = this.dmGetVal.getLong(columnIndex, val, type, CType, prec, scale);
        return dbl;
    }

    public float getFloat(int columnIndex) throws SQLException {
        float flt = 0.0f;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return 0.0f;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        flt = this.dmGetVal.getFloat(columnIndex, val, type, CType, prec, scale);
        return flt;
    }

    public double getDouble(int columnIndex) throws SQLException {
        double dbl = 0.0;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return 0.0;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        dbl = this.dmGetVal.getDouble(columnIndex, val, type, CType, prec, scale);
        return dbl;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal dec = this.getBigDecimal(columnIndex);
        return this.wasNullFlag ? null : dec.setScale(scale, 4);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        int scale;
        int prec;
        int CType;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int len = val.length;
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        byte[] buf = this.dmGetVal.getBytes(columnIndex, val, type, CType = this.colInfo[columnIndex - 1].getCType(), prec = this.colInfo[columnIndex - 1].getPrecision(), scale = this.colInfo[columnIndex - 1].getScale());
        if (buf == null && (type == 2004 || type == 2005 || type == -4 || type == -1)) {
            byte[] s2 = Convertion.getMetaDataPointer(val);
            byte[] s3 = new byte[4];
            System.arraycopy(val, 1, s3, 0, 4);
            int chunkSize = Convertion.fourByteToInt(s3);
            byte[] value = null;
            value = this.statement.m_csi.getBlobData(this.statement.handle, true, s2, 1, chunkSize);
            buf = value;
        }
        if (this.maxFieldSize > 0 && len < this.maxFieldSize) {
            len = this.maxFieldSize;
            val = new byte[len];
            System.arraycopy(buf, 0, val, 0, len);
            return val;
        }
        return buf;
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] bs = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getDate(columnIndex, bs, type, CType, prec, scale);
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] bs = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getTime(columnIndex, bs, type, CType, prec, scale);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] bs = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getTimestamp(columnIndex, bs, type, CType, prec, scale);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] s = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getAsciiStream(columnIndex, s, type, CType, prec, scale);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] bs = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getUnicodeStream(columnIndex, bs, type, CType, prec, scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] s = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int cType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getBinaryStream(columnIndex, s, type, cType, prec, scale);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        return this.m_warnings;
    }

    public void clearWarnings() throws SQLException {
        this.m_warnings = null;
    }

    public String getCursorName() throws SQLException {
        if (this.statement.cursorName == null) {
            this.statement.setCursorName("BPXLYBHQ" + this.statement.handle);
        }
        this.statement.connection.remove_statement(this.statement.handle);
        this.statement.connection.add_statement(this.statement.handle, this.statement);
        return this.statement.cursorName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        return new DmdbResultSetMetaData(this.statement, this.colInfo, this.resultConcurrencyType);
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (this.isClosed) {
            DBError.throwSQLException(6034);
        }
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] s = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int len = s.length;
        int jdbcsqltype = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        if (jdbcsqltype == -2 || jdbcsqltype == -3 || jdbcsqltype == -4) {
            byte[] val = (byte[])this.dmGetVal.getObject(columnIndex, s, jdbcsqltype, CType, prec, scale);
            if (val == null) {
                byte[] s2 = Convertion.getMetaDataPointer(s);
                byte[] s3 = new byte[4];
                System.arraycopy(s, 1, s3, 0, 4);
                int chunkSize = Convertion.fourByteToInt(s3);
                byte[] value = null;
                value = this.statement.m_csi.getBlobData(this.statement.handle, true, s2, 1, chunkSize);
                val = value;
            }
            if (this.maxFieldSize > 0 && len < this.maxFieldSize) {
                len = this.maxFieldSize;
                s = new byte[len];
                System.arraycopy(val, 0, s, 0, len);
                return s;
            }
            return val;
        }
        return this.dmGetVal.getObject(columnIndex, s, jdbcsqltype, CType, prec, scale);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        Integer index;
        this.checkClose();
        String colName = columnName;
        if (this.colNames == null) {
            this.initalizeColNames();
        }
        if ((index = this._$2512 ? (Integer)this.colNames.get(colName) : (Integer)this.colNames.get(colName.toUpperCase())) == null) {
            DBError.throwSQLException(6017);
        }
        return index;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] buf = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        return this.dmGetVal.getCharacterStream(columnIndex, buf, type, CType, prec, scale);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal dec = null;
        this.checkIndex(columnIndex);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        byte[] val = this.getByteArrayValue(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        dec = this.dmGetVal.getBigDecimal(columnIndex, val, type, CType, prec, scale);
        return dec;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow <= -1L && this.rowCount > 0L;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = this.statement.m_csi.getRowCount(this.statement);
        }
        return this.currentRow >= this.rowCount && this.rowCount > 0L;
    }

    public boolean isFirst() throws SQLException {
        return this.currentRow == 0L && this.currentRow < this.rowCount;
    }

    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = this.statement.m_csi.getRowCount(this.statement);
        }
        return this.currentRow >= this.rowCount - 1L && this.currentRow > -1L;
    }

    public void beforeFirst() throws SQLException {
        if (this.rowCount != 0L) {
            this.absolute(1);
            this.currentRow = -1L;
        }
    }

    public void afterLast() throws SQLException {
        this.last();
        this.currentRow = this.rowCount;
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = this.statement.m_csi.getRowCount(this.statement);
        }
        if (this.rowCount == 0L) {
            return false;
        }
        return this.absolute((int)this.rowCount);
    }

    public int getRow() throws SQLException {
        this.checkClose();
        if (this.rowCount == 0L || this.currentRow == -1L || this.currentRow >= this.rowCount) {
            return 0;
        }
        return (int)this.currentRow + 1;
    }

    public boolean absolute(int rows) throws SQLException {
        this.checkClose();
        if (rows == 0) {
            DBError.throwSQLException(6020);
        }
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == 0L) {
            this.currentRow = -1L;
            return false;
        }
        if (rows > 0) {
            if ((long)rows > this.startRow && (long)rows <= this.startRow + (long)this.rsCache.rownum) {
                this.currentRow = rows - 1;
                this.rsCache.absolute((int)((long)rows - this.startRow - 1L));
                return true;
            }
            if ((long)rows <= this.rowCount) {
                this.startRow = this.currentRow = (long)(rows - 1);
                int code = this._$2529(1, false, null);
                if (code == -3336) {
                    this.startRow = this.currentRow = this.rowCount - 1L;
                    code = this._$2529(1, false, null);
                    this.rsCache.absolute(this.rsCache.rownum);
                    this.currentRow = this.rowCount;
                    return false;
                }
                return true;
            }
            this.startRow = this.currentRow = this.rowCount - 1L;
            int code = this._$2529(1, false, null);
            this.rsCache.absolute(this.rsCache.rownum);
            this.currentRow = this.rowCount;
            return false;
        }
        if (rows < 0) {
            if (this.rowCount == Long.MAX_VALUE) {
                this.rowCount = this.statement.m_csi.getRowCount(this.statement);
            }
            if ((long)rows + this.rowCount >= this.startRow && (long)rows + this.rowCount < this.startRow + (long)this.rsCache.rownum) {
                this.currentRow = this.rowCount + (long)rows;
                this.rsCache.absolute(this.rsCache.rownum + rows);
            } else if (this.rowCount + (long)rows >= 0L) {
                this.startRow = this.currentRow = this.rowCount + (long)rows;
                this._$2529(1, false, null);
            } else if (this.rowCount + (long)rows <= -1L) {
                this.currentRow = 0L;
                this.startRow = 0L;
                this._$2529(1, false, null);
                this.rsCache.absolute(0);
                this.currentRow = -1L;
                return false;
            }
        }
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        int rowNum;
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if ((rowNum = (int)((long)rows + this.currentRow + 1L)) <= 0) {
            this.beforeFirst();
            return false;
        }
        if ((long)rowNum > this.rowCount) {
            this.afterLast();
            return false;
        }
        return this.absolute(rowNum);
    }

    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.currentRow > -1L) {
            if (this.currentRow <= this.startRow) {
                if (this.currentRow > 0L) {
                    this.startRow = this.currentRow - 1L;
                    this._$2529(2, false, null);
                }
            } else if (this.currentRow != this.rowCount) {
                this.rsCache.previous();
            }
            --this.currentRow;
        }
        return this.currentRow > -1L;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkClose();
        if (direction != 1002 && direction != 1000 && direction != 1001) {
            DBError.throwSQLException(6022);
        }
        if (this.resultSetType == 1003 && direction != 1000) {
            DBError.throwSQLException(6023);
        }
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
        if (rows >= 0 && (this.statement.getMaxRows() > 0 && rows <= this.statement.getMaxRows() || this.statement.getMaxRows() == 0)) {
            this.fetchSize = rows;
        } else {
            DBError.throwSQLException(6020);
        }
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        this.checkClose();
        return this.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.resultConcurrencyType;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (!this.colInfo[columnIndex - 1].getNullable()) {
            DBError.throwSQLException(6024);
        }
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setNull(this.params[columnIndex - 1]);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setBoolean(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setByte(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setShort(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setInt(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setLong(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setFloat(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setDouble(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setBigDecimal(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setString(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setBytes(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setDate(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setTime(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setTimestamp(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(new Integer(length));
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setAsciiStream(this.params[columnIndex - 1], x, length, sqlType, CType, prec, scale);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int cType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(new Integer(length));
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setBinaryStream(this.params[columnIndex - 1], x, length, sqlType, cType, prec, scale);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(new Integer(length));
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setCharacterStream(this.params[columnIndex - 1], x, length, sqlType, CType, prec, scale);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int sca = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setObject(this.params[columnIndex - 1], x, sqlType, CType, prec, sca);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            int scale = 0;
            if (x instanceof BigDecimal) {
                scale = ((BigDecimal)x).scale();
            }
            this.updateObject(columnIndex, x, scale);
        }
        this.updatedParam[columnIndex - 1] = true;
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        if (!this.isInsertStatus) {
            DBError.throwSQLException(6026);
        }
        if (this.updatedParam == null) {
            throw new SQLException("Can't insert Row for nothing update.");
        }
        int pan = 0;
        String paramNames = "";
        String paramEntity = "";
        String catalogName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getCatalog()) + "\"";
        String schemaName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getSchema()) + "\"";
        String tableName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getTable()) + "\"";
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.updatedParam[i]) continue;
            if (pan++ > 0) {
                paramNames = paramNames + " , ";
                paramEntity = paramEntity + " , ";
            }
            paramNames = paramNames + "\"" + StringUtil.getEscObjName(this.colInfo[i].getName()) + "\"";
            paramEntity = paramEntity + " ? ";
        }
        if (paramEntity.length() == 0 || paramNames.length() == 0) {
            return;
        }
        String insertSql = "insert into " + catalogName + "." + schemaName + "." + tableName + " (" + paramNames + ") values(" + paramEntity + ")";
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this.conn, insertSql);
        pan = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.updatedParam[i]) continue;
            pstmt.setParamValue(++pan, this.params[i]);
        }
        pstmt.setPutLobData(2);
        pstmt.executeUpdate();
        pstmt.close();
        this.initializePara();
        this.isInsertStatus = false;
    }

    public void updateRow() throws SQLException {
        int i;
        this.checkClose();
        this.checkUpdatable();
        if (this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        if (this.updatedParam == null) {
            throw new SQLException("Can't insert Row for nothing update.");
        }
        int pan = 0;
        String paramNames = "";
        String tableName = null;
        String catalogName = null;
        String schemaName = null;
        DmdbPreparedStatement pstmt = null;
        catalogName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getCatalog()) + "\"";
        schemaName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getSchema()) + "\"";
        tableName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getTable()) + "\"";
        for (i = 0; i < this.columnCount; ++i) {
            if (!this.updatedParam[i]) continue;
            if (pan++ > 0) {
                paramNames = paramNames + ", ";
            }
            paramNames = paramNames + "\"" + StringUtil.getEscObjName(this.colInfo[i].getName()) + "\"" + " = ? ";
        }
        if (paramNames.length() == 0) {
            return;
        }
        String insertSql = "update " + catalogName + "." + schemaName + "." + tableName + " set " + paramNames + " where current of \"" + StringUtil.getEscObjName(this.getCursorName()) + "\"";
        pstmt = new DmdbPreparedStatement(this.conn, insertSql);
        pan = 0;
        for (i = 0; i < this.columnCount; ++i) {
            if (!this.updatedParam[i]) continue;
            pstmt.setParamValue(++pan, this.params[i]);
        }
        pstmt.setPutLobData(2);
        pstmt.executeUpdate();
        pstmt.close();
        this.initializePara();
        this.isUpdateStatus = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        if (this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        StringBuffer deleteStmtBuffer = new StringBuffer();
        deleteStmtBuffer.append("DELETE FROM ");
        String catalog = "\"" + StringUtil.getEscObjName(this.colInfo[0].getCatalog()) + "\"";
        String schema = "\"" + StringUtil.getEscObjName(this.colInfo[0].getSchema()) + "\"";
        String table = "\"" + StringUtil.getEscObjName(this.colInfo[0].getTable()) + "\"";
        deleteStmtBuffer.append(catalog).append(".");
        deleteStmtBuffer.append(schema).append(".");
        deleteStmtBuffer.append(table);
        deleteStmtBuffer.append(" WHERE CURRENT OF \"" + StringUtil.getEscObjName(this.getCursorName()) + "\"");
        String sql = deleteStmtBuffer.toString();
        DmdbStatement stmtForDel = null;
        try {
            stmtForDel = new DmdbStatement(this.conn, 1003, 1007, 1);
            stmtForDel.executeUpdate(sql);
            stmtForDel.close();
        }
        finally {
            if (stmtForDel != null) {
                stmtForDel.close();
            }
        }
    }

    public void refreshRow() throws SQLException {
        this.checkClose();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkClose();
        this.updatedParam = new boolean[this.columnCount];
    }

    public void moveToInsertRow() throws SQLException {
        this.checkClose();
        if (this.resultConcurrencyType == 1007) {
            DBError.throwSQLException(6029);
        }
        this.isInsertStatus = true;
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkClose();
        this.isInsertStatus = false;
        if (this.resultConcurrencyType == 1007) {
            DBError.throwSQLException(6029);
        }
    }

    public Statement getStatement() throws SQLException {
        this.checkClose();
        return this.statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.checkIndex(i);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.colInfo[i - 1].getJdbcSqlType() != 2004 && this.colInfo[i - 1].getJdbcSqlType() != -4) {
            DBError.throwSQLException(6016);
        }
        byte[] bs = this.getByteArrayValue(i);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[i - 1].getJdbcSqlType();
        int CType = this.colInfo[i - 1].getCType();
        int prec = this.colInfo[i - 1].getPrecision();
        int scale = this.colInfo[i - 1].getScale();
        if (this.statement == null && DmdbConnection.lob_mode == 2 && this.rowCount == (long)this.rsCache.rownum) {
            return this.blobArray[(int)this.currentRow][i - 1];
        }
        Blob blob = this.dmGetVal.getBlob(i, bs, type, CType, prec, scale);
        if (DmdbConnection.lob_mode == 2 && this.rowCount == (long)this.rsCache.rownum) {
            if (this.blobArray == null) {
                this.blobArray = new DmdbBlob[(int)this.rowCount][this.colInfo.length];
            }
            this.blobArray[(int)this.currentRow][i - 1] = (DmdbBlob)blob;
        }
        return blob;
    }

    public Clob getClob(int i) throws SQLException {
        Clob clob = null;
        this.checkIndex(i);
        if (this.isBeforeFirst()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.colInfo[i - 1].getJdbcSqlType() != 2005 && this.colInfo[i - 1].getJdbcSqlType() != -1) {
            DBError.throwSQLException(6016);
        }
        byte[] bs = this.getByteArrayValue(i);
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.colInfo[i - 1].getJdbcSqlType();
        int CType = this.colInfo[i - 1].getCType();
        int prec = this.colInfo[i - 1].getPrecision();
        int scale = this.colInfo[i - 1].getScale();
        if (this.statement == null && DmdbConnection.lob_mode == 2 && this.rowCount == (long)this.rsCache.rownum) {
            return this.clobArray[(int)this.currentRow][i - 1];
        }
        clob = this.dmGetVal.getClob(i, bs, type, CType, prec, scale);
        if (DmdbConnection.lob_mode == 2 && this.rowCount == (long)this.rsCache.rownum) {
            if (this.clobArray == null) {
                this.clobArray = new DmdbClob[(int)this.rowCount][this.colInfo.length];
            }
            this.clobArray[(int)this.currentRow][i - 1] = (DmdbClob)clob;
        }
        return clob;
    }

    public Array getArray(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(d);
        return new Date(cal.getTimeInMillis());
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        timestamp = new Timestamp(cal.getTimeInMillis());
        return timestamp;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setBlob(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        this.updateBlob(columnIndex, x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int sqlType = this.colInfo[columnIndex - 1].getJdbcSqlType();
        int CType = this.colInfo[columnIndex - 1].getCType();
        int prec = this.colInfo[columnIndex - 1].getPrecision();
        int scale = this.colInfo[columnIndex - 1].getScale();
        this.params[columnIndex - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[columnIndex - 1] = true;
        this.dmSetVal.setClob(this.params[columnIndex - 1], x, sqlType, CType, prec, scale);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        this.updateClob(columnIndex, x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(i);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        DmdbColumn[] col = this.colInfo;
        int sqlType = col[i - 1].getJdbcSqlType();
        int CType = col[i - 1].getCType();
        int prec = col[i - 1].getPrecision();
        int scale = col[i - 1].getScale();
        this.params[i - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[i - 1] = true;
        this.dmSetVal.setINTERVALYM(this.params[i - 1], ym, sqlType, CType, prec, scale);
    }

    public void updateINTERVALYM(String s, DmdbIntervalYM ym) throws SQLException {
        this.updateINTERVALYM(this.findColumn(s), ym);
    }

    public void updateINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(i);
        if ((this.isBeforeFirst() || this.isAfterLast()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.isUpdateStatus = true;
        DmdbColumn[] col = this.colInfo;
        int sqlType = col[i - 1].getJdbcSqlType();
        int CType = col[i - 1].getCType();
        int prec = col[i - 1].getPrecision();
        int scale = col[i - 1].getScale();
        this.params[i - 1] = new DmdbParamValue(this.serverEncoding);
        this.lengths.add(null);
        this.updatedParam[i - 1] = true;
        this.dmSetVal.setINTERVALDT(this.params[i - 1], dt, sqlType, CType, prec, scale);
    }

    public void updateINTERVALDT(String s, DmdbIntervalDT dt) throws SQLException {
        this.updateINTERVALDT(this.findColumn(s), dt);
    }

    byte[] getByteArrayValue(int columnIndex) throws SQLException {
        int precision;
        byte[] value = this.rsCache.getBytes((short)(--columnIndex));
        this.wasNullFlag = false;
        if (value == null) {
            this.wasNullFlag = true;
            return null;
        }
        int ctype = this.colInfo[columnIndex].getCType();
        if (ctype == 1 && value.length < (precision = this.colInfo[columnIndex].getPrecision())) {
            byte[] padded = new byte[precision];
            System.arraycopy(value, 0, padded, 0, value.length);
            for (int i = value.length; i < precision; ++i) {
                padded[i] = 32;
            }
            return padded;
        }
        return value;
    }

    void checkIndex(int i) throws SQLException {
        this.checkClose();
        if (i < 1 || i > this.columnCount) {
            DBError.throwSQLException(6032);
        }
    }

    protected long getCurrentRowNum() {
        return this.currentRow;
    }

    void checkClose() throws SQLException {
        if (this.isClosed) {
            DBError.throwSQLException(6034);
        }
    }

    void checkUpdatable() throws SQLException {
        if (this.resultConcurrencyType != 1008) {
            DBError.throwSQLException(6029);
        }
    }

    private int _$2529(int fetchType, boolean fetchAll, DmdbResultSet rs) throws SQLException {
        long curPos;
        int ret = 1;
        if (this.metaRsFlag) {
            return ret;
        }
        if (fetchType == 1) {
            curPos = this.startRow;
        } else {
            int tmp_tuple_len = DmdbColumn.getMaxTupleLen(this.colInfo, this.conn.maxRowSize);
            int max_row_num = 32768 / tmp_tuple_len;
            curPos = this.startRow - (long)(max_row_num / 2);
            if (curPos < 0L) {
                curPos = 0L;
            }
        }
        ret = this.statement.m_csi.fetch(this.statement, curPos, fetchAll, rs);
        if (fetchType == 2) {
            int offset = 0;
            int i = 0;
            while ((long)i < this.startRow - curPos) {
                offset += this.rsCache.rec4_get_len(this.rsCache.rowbuf, offset);
                ++i;
            }
            this.rsCache.offset = offset;
            this.rsCache.curpos = (int)(this.startRow - curPos);
            this.startRow = curPos;
        }
        return ret;
    }

    public int getRowidHigh() {
        return this.rsCache.rec4_get_rowid_high();
    }

    public int getRowidLow() {
        return this.rsCache.rec4_get_rowid_low();
    }

    public long getRowCount() throws SQLException {
        this.checkClose();
        if (this.rowCount == Long.MAX_VALUE) {
            try {
                this.rowCount = this.statement.m_csi.getRowCount(this.statement);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.rowCount;
    }

    void initializePara() {
        this.params = new DmdbParamValue[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.updatedParam[i] = false;
        }
    }

    void initalizeColNames() {
        if (this.conn != null) {
            this._$2512 = this.conn.getCaseSensitive();
            if (this.conn.getIgnoreCase()) {
                this._$2512 = false;
            }
        }
        this.colNames = new HashMap();
        for (int index = 0; index < this.columnCount; ++index) {
            if (this._$2512) {
                this.colNames.put(this.colInfo[index].getName(), new Integer(index + 1));
                continue;
            }
            this.colNames.put(this.colInfo[index].getName().toUpperCase(), new Integer(index + 1));
        }
    }

    public final boolean canCache() {
        return this.canCache;
    }

    public final Object clone() {
        boolean hasLob = false;
        DmdbResultSet rs = null;
        try {
            int i;
            rs = (DmdbResultSet)super.clone();
            rs.statement = null;
            rs.conn = null;
            if (this.dbInfo != null) {
                rs.dbInfo = (DmdbInfo)this.dbInfo.clone();
            }
            if (this.colInfo != null) {
                rs.colInfo = (DmdbColumn[])this.colInfo.clone();
            }
            if (this.updatedParam != null) {
                rs.updatedParam = (boolean[])this.updatedParam.clone();
            }
            if (this.params != null) {
                rs.params = (DmdbParamValue[])this.params.clone();
            }
            if (this.lengths != null) {
                rs.lengths = (Vector)this.lengths.clone();
            }
            rs.dmGetVal = new DmdbGetValue(this.serverEncoding, null, true);
            rs.dmSetVal = new DmdbSetValue(this.serverEncoding);
            rs.colNames = null;
            if (this.rsCache != null) {
                rs.rsCache = (DmdbResultSetCache)this.rsCache.clone();
                rs.rsCache.setCols(rs.colInfo);
            }
            rs.startRow = 0L;
            rs.currentRow = -1L;
            rs.initializePara();
            for (i = 0; i < this.colInfo.length; ++i) {
                if (this.colInfo[i].getCType() != 12 && this.colInfo[i].getCType() != 19) continue;
                hasLob = true;
                break;
            }
            if (hasLob) {
                try {
                    this.first();
                    do {
                        for (int j = 0; j < this.colInfo.length; ++j) {
                            if (this.colInfo[j].getCType() == 12) {
                                if (this.blobArray[i][j] == null) {
                                    this.blobArray[i][j] = (DmdbBlob)rs.getBlob(j);
                                }
                                rs.blobArray[i][j] = (DmdbBlob)this.blobArray[i][j].clone();
                                continue;
                            }
                            if (this.colInfo[j].getCType() != 19) continue;
                            if (this.clobArray[i][j] == null) {
                                this.clobArray[i][j] = (DmdbClob)rs.getClob(j);
                            }
                            rs.clobArray[i][j] = (DmdbClob)this.clobArray[i][j].clone();
                        }
                    } while (this.next());
                }
                catch (SQLException e) {}
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return rs;
    }
}

