/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DmdbReader
extends Reader {
    private DmdbBlob _$9777 = null;
    private DmdbClob _$9778 = null;
    private int _$10633;
    private String _$10634 = null;
    byte[] byteBuffer = null;
    char[] charBuffer = null;
    int currentPos = 0;
    static final int blobLen = 32000;
    static final int clobLen = 8000;
    int curPos = 0;
    int byteLen;
    int charLen;
    private boolean _$1197 = false;

    public DmdbReader(Object o) throws NumberFormatException {
        if (o instanceof DmdbBlob) {
            this._$9777 = (DmdbBlob)o;
            this._$10633 = 0;
        } else if (o instanceof DmdbClob) {
            this._$9778 = (DmdbClob)o;
            this._$10633 = 1;
        } else if (o instanceof String) {
            this._$10633 = 2;
            this._$10634 = (String)o;
        } else if (o instanceof byte[]) {
            this._$10633 = 3;
            this.byteBuffer = (byte[])o;
        } else {
            throw new NumberFormatException("cast error.");
        }
    }

    public int read(char[] dest, int destOff, int readLen) throws IOException {
        String tempString = null;
        int realLen = 0;
        if (this._$1197) {
            throw new IOException(Const.res.getString("error.ClosedStream"));
        }
        if (destOff < 0 || readLen < 0 || destOff + readLen > dest.length) {
            throw new IndexOutOfBoundsException(Const.res.getString("error.IndexOutOfBound"));
        }
        try {
            block1 : switch (this._$10633) {
                case 0: {
                    if (readLen > 32000) {
                        this.byteBuffer = this._$9777.getBytes(this.currentPos + 1, readLen);
                        if (this.byteBuffer == null || this.byteBuffer.length == 0) {
                            return -1;
                        }
                        this.byteLen = this.byteBuffer.length;
                        if (readLen > this.byteLen) {
                            readLen = this.byteLen;
                        }
                        for (int i = 0; i < readLen; ++i) {
                            dest[destOff + i] = (char)this.byteBuffer[i];
                            ++realLen;
                        }
                        this.currentPos += readLen;
                        this.curPos = this.byteLen;
                        break;
                    }
                    if (this.curPos + readLen <= this.byteLen) {
                        for (int i = 0; i < readLen; ++i) {
                            dest[destOff + i] = (char)this.byteBuffer[this.curPos + i];
                            ++realLen;
                        }
                        this.currentPos += readLen;
                        this.curPos += readLen;
                        break;
                    }
                    this.byteBuffer = this._$9777.getBytes(this.currentPos + 1, 32000);
                    if (this.byteBuffer == null || this.byteBuffer.length == 0) {
                        return -1;
                    }
                    this.byteLen = this.byteBuffer.length;
                    this.curPos = 0;
                    if (readLen > this.byteLen) {
                        readLen = this.byteLen;
                    }
                    for (int i = 0; i < readLen; ++i) {
                        dest[destOff + i] = (char)this.byteBuffer[this.curPos + i];
                        ++realLen;
                    }
                    this.currentPos += readLen;
                    this.curPos += readLen;
                    break;
                }
                case 1: {
                    int i;
                    String tmpStr = "";
                    for (i = 0; i < readLen && this.curPos < this.charLen; ++i) {
                        dest[destOff + i] = this.charBuffer[this.curPos++];
                        ++realLen;
                    }
                    if (i < readLen) {
                        int tmpReadLen = readLen - i;
                        int tmpLen = tmpReadLen > 8000 ? tmpReadLen : 8000;
                        tmpStr = this._$9778.getSubString(this.currentPos + 1, tmpLen);
                        if (tmpStr == null || tmpStr.length() == 0) {
                            if (realLen > 0) {
                                return realLen;
                            }
                            return -1;
                        }
                        this.charBuffer = tmpStr.toCharArray();
                        this.charLen = tmpStr.length();
                        this.currentPos += tmpLen;
                        this.curPos = 0;
                        for (int j = 0; j < tmpReadLen; ++j) {
                            if (this.curPos >= this.charLen) break block1;
                            dest[destOff + i++] = this.charBuffer[this.curPos++];
                            ++realLen;
                        }
                    }
                    break;
                }
                case 2: {
                    if (this._$10634 == null) {
                        return -1;
                    }
                    int len = this._$10634.length();
                    if (len <= this.currentPos) {
                        return -1;
                    }
                    if (len < this.currentPos + readLen) {
                        readLen = len - this.currentPos;
                    }
                    tempString = this._$10634.substring(this.currentPos, readLen);
                    for (int i = 0; i < tempString.length(); ++i) {
                        dest[destOff + i] = tempString.charAt(i);
                        ++realLen;
                    }
                    this.currentPos += readLen;
                    break;
                }
                case 3: {
                    if (this.byteBuffer == null) {
                        return -1;
                    }
                    int len = this.byteBuffer.length;
                    if (len <= this.currentPos) {
                        return -1;
                    }
                    if (len < this.currentPos + readLen) {
                        readLen = len - this.currentPos;
                    }
                    for (int i = 0; i < readLen; ++i) {
                        dest[destOff + i] = (char)this.byteBuffer[i + this.currentPos];
                        ++realLen;
                    }
                    this.currentPos += readLen;
                    break;
                }
                default: {
                    throw new IOException("io read error.");
                }
            }
        }
        catch (SQLException e) {
            DBError.SQLToIOException(e);
        }
        return realLen;
    }

    public void close() throws IOException {
        this._$1197 = true;
    }
}

