/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbCachedResultSet;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbParamValue;
import dm.jdbc.driver.DmdbParameter;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSetValue;
import dm.jdbc.driver.DmdbStatement;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;

public class DmdbPreparedStatement
extends DmdbStatement
implements PreparedStatement {
    DmdbParameter[] params = null;
    DmdbSetValue setValue = null;
    String printMsg = null;
    boolean realClose = false;
    private final ResourceBundle _$306 = Const.res;

    void initialize(String sql) throws SQLException {
        this.checkNullOrEmpty(sql);
        if (this.process_escapes) {
            sql = this.connection.nativeSQL(sql);
        }
        this.originalSql = sql;
        this.dbInfo = this.directExec(this, sql, false, 0);
        this.params = this.dbInfo.getParamsInfo();
        if (this.params == null) {
            this.params = new DmdbParameter[0];
        }
        this.setValue = new DmdbSetValue(this.connection.getServerEncoding());
        this.type = 1;
    }

    void initializeReusePreparedStmt(DmdbConnection conn, String sql) throws SQLException {
        super.initializeReuseStmt(conn);
        this.setValue = new DmdbSetValue(this.connection.getServerEncoding());
        this.type = 1;
    }

    public DmdbPreparedStatement(DmdbConnection conn, String sql) throws SQLException {
        super(conn);
        this.initialize(sql);
    }

    public DmdbPreparedStatement(DmdbConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
    }

    protected DmdbPreparedStatement(DmdbConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
        this.autoGeneratedColName = null;
        this.generateKey = autoGeneratedKeys == 1;
        if (this.generateKey && this.dbInfo.getRetStmtType() == 157) {
            this.getTableNameBySql(sql);
        } else {
            this.insertTableName = "";
        }
    }

    protected DmdbPreparedStatement(DmdbConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int[] columnIndexes) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
        this.autoGeneratedColName = null;
        this.generateKey = true;
        if (this.generateKey && this.dbInfo.getRetStmtType() == 157) {
            this.getTableNameBySql(sql);
        } else {
            this.insertTableName = "";
        }
        if (this.dbInfo.getRetStmtType() == 157) {
            int i;
            DmdbColumn[] colInfo = this.getColumnsInfo();
            int count = 0;
            for (i = 0; i < columnIndexes.length; ++i) {
                if (columnIndexes[i] < 1 || columnIndexes[i] > colInfo.length) continue;
                ++count;
            }
            this.autoGeneratedColName = new String[count];
            count = 0;
            for (i = 0; i < columnIndexes.length; ++i) {
                if (columnIndexes[i] < 1 || columnIndexes[i] > colInfo.length) continue;
                this.autoGeneratedColName[count++] = colInfo[columnIndexes[i] - 1].getName();
            }
        } else {
            this.autoGeneratedRowid = null;
        }
    }

    protected DmdbPreparedStatement(DmdbConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String[] columnNames) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
        this.autoGeneratedColName = null;
        this.generateKey = true;
        if (this.generateKey && this.dbInfo.getRetStmtType() == 157) {
            this.getTableNameBySql(sql);
        } else {
            this.insertTableName = "";
        }
        if (this.dbInfo.getRetStmtType() != 157) {
            this.autoGeneratedRowid = null;
        } else {
            int i;
            int count = 0;
            for (i = 0; i < columnNames.length; ++i) {
                if (columnNames[i] == null) continue;
                ++count;
            }
            this.autoGeneratedColName = new String[count];
            count = 0;
            for (i = 0; i < columnNames.length; ++i) {
                if (columnNames[i] == null) continue;
                this.autoGeneratedColName[count++] = columnNames[i];
            }
        }
    }

    protected DmdbPreparedStatement(DmdbConnection conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            this.checkClosed();
            if (!this.dbInfo.isRetStmtTypeQuery()) {
                DBError.throwSQLException(6009);
            }
            this._$10077(this.params);
            ++DmdbConnection.execSqlNum;
            this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, this.params);
            if (this.currentRs != null) {
                ++DmdbConnection.rsCachedNum;
                return this.currentRs;
            }
            this.dbInfo = this.preparedExceute(this.params);
            if (this instanceof DmdbCallableStatement) {
                ((DmdbCallableStatement)this).params = this.dbInfo.getParamsInfo();
            }
            this.getResultSetPrivate();
            return this.currentRs;
        }
        catch (SQLException e) {
            this.realClose = true;
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return null;
        }
    }

    public synchronized ResultSet executeQuery2() throws SQLException {
        this.fromRowSetFlag = true;
        try {
            this.checkClosed();
            if (!this.dbInfo.isRetStmtTypeQuery()) {
                DBError.throwSQLException(6009);
            }
            this._$10077(this.params);
            ++DmdbConnection.execSqlNum;
            this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, this.params);
            if (this.currentRs != null) {
                ++DmdbConnection.rsCachedNum;
                return this.currentRs;
            }
            this.dbInfo = this.preparedExceute(this.params);
            if (this instanceof DmdbCallableStatement) {
                ((DmdbCallableStatement)this).params = this.dbInfo.getParamsInfo();
            }
            this.currentRs = this.getResultSet(true);
            return this.currentRs;
        }
        catch (SQLException e) {
            this.realClose = true;
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return null;
        }
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.params);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        this.setValue.setNull(paraVal);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(13);
            param.setJdbcSqlType(16);
            param.setPrecision(1);
            param.setJdbcPrecision(1);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setBoolean(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(6);
            param.setJdbcSqlType(-6);
            param.setPrecision(2);
            param.setJdbcPrecision(5);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setByte(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(6);
            param.setJdbcSqlType(5);
            param.setPrecision(2);
            param.setJdbcPrecision(5);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setShort(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(7);
            param.setJdbcSqlType(4);
            param.setPrecision(4);
            param.setJdbcPrecision(10);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setInt(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(8);
            param.setJdbcSqlType(-5);
            param.setPrecision(8);
            param.setJdbcPrecision(19);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setLong(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(10);
            param.setJdbcSqlType(6);
            param.setPrecision(4);
            param.setJdbcPrecision(15);
            String num = Double.toString(x);
            int pos = num.indexOf(".");
            if (pos > -1) {
                param.setScale(num.length() - pos);
            } else {
                param.setScale(0);
            }
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setFloat(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(11);
            param.setJdbcSqlType(8);
            param.setPrecision(8);
            param.setJdbcPrecision(15);
            String num = Double.toString(x);
            int pos = num.indexOf(".");
            if (pos > -1) {
                param.setScale(num.length() - pos);
            } else {
                param.setScale(0);
            }
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setDouble(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(9);
            param.setJdbcSqlType(3);
            String str = x.toString();
            param.setPrecision(str.length());
            param.setJdbcPrecision(str.length());
            param.setScale(x.scale());
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setBigDecimal(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(2);
            param.setJdbcSqlType(12);
            param.setPrecision(x.getBytes().length);
            param.setJdbcPrecision(x.getBytes().length);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setString(paraVal, x, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && x.length() > 2048) {
            this.putLobData = 2;
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setBytes(paraVal, x, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && x.length > 2048) {
            this.putLobData = 2;
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(14);
            param.setJdbcSqlType(91);
            param.setPrecision(1);
            param.setJdbcPrecision(1);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setDate(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setTime(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setTimestamp(paraVal, x, sqlType, cType, prec, scale);
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setAsciiStream(paraVal, x, length, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && length > 2048) {
            this.putLobData = 2;
        }
    }

    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setUnicodeStream(paraVal, x, length, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && length > 2048) {
            this.putLobData = 2;
        }
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setBinaryStream(paraVal, x, length, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && length > 2048) {
            this.putLobData = 2;
        }
    }

    public synchronized void clearParameters() throws SQLException {
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].getInOutType() == 1) continue;
            this.params[i].clearInParam();
        }
    }

    void resetState() throws SQLException {
        super.resetState(false);
        this.setValue = null;
        this.printMsg = null;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
        if (this.connection != null && !this.connection.closed && !this.realClose && this.connection.getStmtPoolMaxSize() > 0) {
            this.resetState();
            this.clearWarnings();
            this.clearBatch();
            this.closed = true;
            this.connection.remove_statement(this.handle);
            this.connection.addToPreparedStmtPool(this);
            return;
        }
        super.close();
        this.dbInfo = null;
        this.params = null;
        this.realClose = false;
    }

    public synchronized void innerClose() throws SQLException {
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
        super.innerClose();
        this.dbInfo = null;
        this.params = null;
        this.realClose = false;
    }

    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        scale = param.getScale();
        this.setValue.setObject(paraVal, x, sqlType, cType, prec, scale);
        if (cType == 12 || cType == 19) {
            this.putLobData = 2;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.setObject(parameterIndex, x, targetSqlType, this.dbInfo.getParamsInfo()[parameterIndex - 1].getScale());
    }

    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setObject(paraVal, x, sqlType, cType, prec, scale);
        if (cType == 12 || cType == 19) {
            this.putLobData = 2;
        }
    }

    public synchronized boolean execute() throws SQLException {
        try {
            this.checkClosed();
            this._$10077(this.params);
            ++DmdbConnection.execSqlNum;
            this.currentRs = DmdbCachedResultSet.getResutlSet(this.originalSql, this.params);
            if (this.currentRs != null) {
                ++DmdbConnection.rsCachedNum;
                return true;
            }
            this.dbInfo = this.preparedExceute(this.params);
            this.setPrintMsg(this.dbInfo.getPrintMsg());
            this.autoGeneratedRowid = (byte[])(this.generateKey && this.dbInfo.getRetStmtType() == 157 ? this.dbInfo.getRowId() : null);
            if (this instanceof DmdbCallableStatement) {
                ((DmdbCallableStatement)this).params = this.dbInfo.getParamsInfo();
            }
            if (this.generateKey) {
                if (this.dbInfo.getRetStmtType() != 157) {
                    this.autoGeneratedRowid = null;
                }
                this.generateKey = false;
            }
            this.getResultSetPrivate();
            return this.dbInfo.getHasResultSet();
        }
        catch (SQLException e) {
            this.realClose = true;
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return false;
        }
    }

    public void addBatch() throws SQLException {
        this._$10077(this.params);
        if (this.m_batchItems == null) {
            this.m_batchItems = new ArrayList(10);
        }
        int length = this.params.length;
        DmdbParameter[] paramsCopy = (DmdbParameter[])this.params.clone();
        try {
            for (int num = 0; num < length; ++num) {
                paramsCopy[num] = (DmdbParameter)this.params[num].clone();
            }
        }
        catch (Exception ex) {
            DBError.throwSQLException(6001);
        }
        this.m_batchItems.add(paramsCopy);
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        try {
            this.checkClosed();
            if (this.connection.isReadOnly()) {
                DBError.throwSQLException(6008);
            }
            if (this.dbInfo.getRetStmtType() == 160) throw new BatchUpdateException(this._$306.getString("error.invalidSqlType"), null);
            if (this.dbInfo.getRetStmtType() == 198) {
                throw new BatchUpdateException(this._$306.getString("error.invalidSqlType"), null);
            }
            if (this.m_batchItems != null && (this.dbInfo.getRetStmtType() == 162 || this.putLobData != 1 || this.m_batchItems.size() == 1 || this.connection.getBatchType() == 2)) {
                try {
                    int[] updateCounts = new int[]{};
                    if (this.m_batchItems != null) {
                        int nbrCommands = this.m_batchItems.size();
                        updateCounts = new int[nbrCommands];
                        for (int i = 0; i < nbrCommands; ++i) {
                            updateCounts[i] = -3;
                        }
                        Throwable sqlEx = null;
                        int commandIndex = 0;
                        for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                            Object arg = this.m_batchItems.get(commandIndex);
                            if (arg instanceof String) {
                                updateCounts[commandIndex] = this.executeUpdate((String)arg);
                                continue;
                            }
                            try {
                                updateCounts[commandIndex] = this.executeUpdate((DmdbParameter[])arg);
                                this.putLobData = 2;
                                continue;
                            }
                            catch (SQLException ex) {
                                updateCounts[commandIndex] = -3;
                                if (!this.connection.getContinueBatchOnError()) {
                                    int[] newUpdateCounts = new int[commandIndex];
                                    System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                }
                                sqlEx = ex;
                            }
                        }
                        if (sqlEx != null) {
                            throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                        }
                    }
                    int[] nbrCommands = updateCounts != null ? updateCounts : new int[]{};
                    return nbrCommands;
                }
                finally {
                    this.clearBatch();
                }
            }
            int[] updateCounts = new int[]{};
            if (this.m_batchItems != null) {
                updateCounts = new int[this.m_batchItems.size()];
                if (this.m_batchItems.size() > 1) {
                    try {
                        updateCounts = this.m_csi.executePreparedBatch(this, this.m_batchItems, this.dbInfo);
                    }
                    catch (SQLException ex) {
                        this.clearBatch();
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), updateCounts);
                    }
                }
            }
            this.clearBatch();
            return updateCounts;
        }
        catch (SQLException e) {
            this.realClose = true;
            if (DmdbConnection.infoLevel != 1) return new int[0];
            throw e;
        }
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (reader == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int cType = param.getCType();
        if (cType == 53) {
            param.setCType(14);
            param.setJdbcSqlType(91);
            param.setPrecision(1);
            param.setJdbcPrecision(1);
            param.setScale(0);
        }
        int sqlType = param.getJdbcSqlType();
        cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setCharacterStream(paraVal, reader, length, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && length > 2048) {
            this.putLobData = 2;
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setRef(paraVal, x, sqlType, cType, prec, scale);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setBlob(paraVal, x, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && x.length() > 2048L) {
            this.putLobData = 2;
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setClob(paraVal, x, sqlType, cType, prec, scale);
        if ((cType == 12 || cType == 19) && x.length() > 2048L) {
            this.putLobData = 2;
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setArray(paraVal, x, sqlType, cType, prec, scale);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.dbInfo != null) {
            return new DmdbResultSetMetaData(this, this.dbInfo.getColumnsInfo(), this.resultSetConcurrency);
        }
        return null;
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setDate(parameterIndex, new Date(cal.getTimeInMillis()));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setTime(parameterIndex, new Time(cal.getTimeInMillis()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setTimestamp(parameterIndex, new Timestamp(cal.getTimeInMillis()));
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkIndex(parameterIndex);
        DmdbParamValue paraVal = this.params[parameterIndex - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[parameterIndex - 1];
        if (x == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        this.setValue.setURL(paraVal, x, sqlType);
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new DmdbParameterMetaData(this);
    }

    public void setINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (ym == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setINTERVALYM(paraVal, ym, sqlType, cType, prec, scale);
    }

    public void setINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (dt == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setINTERVALDT(paraVal, dt, sqlType, cType, prec, scale);
    }

    public void setTIME(int i, DmdbTime t2) throws SQLException {
        this.checkIndex(i);
        DmdbParamValue paraVal = this.params[i - 1].value;
        DmdbParameter param = this.dbInfo.getParamsInfo()[i - 1];
        if (t2 == null) {
            this.setValue.setNull(paraVal);
            return;
        }
        int sqlType = param.getJdbcSqlType();
        int cType = param.getCType();
        int prec = param.getPrecision();
        int scale = param.getScale();
        this.setValue.setTime(paraVal, t2, sqlType, cType, prec, scale);
    }

    protected DmdbInfo preparedExceute(DmdbParameter[] Values2) throws SQLException {
        this.dbInfo = this.m_csi.executePrepared(this, Values2, this.dbInfo);
        return this.dbInfo;
    }

    protected synchronized int executeUpdate(DmdbParameter[] inParas) throws SQLException {
        try {
            this.checkClosed();
            if (this.connection.isReadOnly()) {
                DBError.throwSQLException(6008);
            }
            if (this.dbInfo.getRetStmtType() == 160 || this.dbInfo.getRetStmtType() == 198) {
                DBError.throwSQLException(6009);
            }
            this._$10077(inParas);
            this.dbInfo = this.preparedExceute(inParas);
            this.setPrintMsg(this.dbInfo.getPrintMsg());
            this.autoGeneratedRowid = (byte[])(this.generateKey && this.dbInfo.getRetStmtType() == 157 ? this.dbInfo.getRowId() : null);
            if (this instanceof DmdbCallableStatement) {
                ((DmdbCallableStatement)this).params = this.dbInfo.getParamsInfo();
            }
            if (this.generateKey) {
                if (this.dbInfo.getRetStmtType() != 157) {
                    this.autoGeneratedRowid = null;
                }
                this.generateKey = false;
            }
            return (int)this.dbInfo.getRowCount();
        }
        catch (SQLException e) {
            this.realClose = true;
            if (DmdbConnection.infoLevel == 1) {
                throw e;
            }
            return 0;
        }
    }

    protected synchronized void checkIndex(int index) throws SQLException {
        if (index < 1 || index > this.params.length) {
            DBError.throwSQLException(6010);
        }
    }

    public String getPrintMsg() throws SQLException {
        return this.printMsg;
    }

    protected void setPrintMsg(String msg) {
        this.printMsg = this.printMsg == null ? msg : this.printMsg + "\t" + msg;
    }

    private void _$10077(DmdbParameter[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getInOutType() == 1 || params[i].getInDataBound()) continue;
            DBError.throwSQLException(6054);
        }
    }

    public int getSqlType() throws SQLException {
        int sqlType;
        int retType = this.dbInfo.getRetStmtType();
        switch (retType) {
            case 162: 
            case 178: {
                sqlType = 3;
                break;
            }
            case 160: {
                sqlType = 1;
                break;
            }
            case 152: {
                sqlType = 4;
                break;
            }
            default: {
                sqlType = 2;
            }
        }
        return sqlType;
    }

    public void setParamValue(int colIndex, DmdbParamValue paraVal) throws SQLException {
        this.checkIndex(colIndex);
        DmdbParameter param = this.params[colIndex - 1];
        param.value = paraVal;
    }

    public DmdbParameter[] getParams() {
        return this.params;
    }
}

