/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbDataTypeMetaData;
import dm.jdbc.driver.DmdbParameter;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class DmdbParameterMetaData
extends DmdbDataTypeMetaData
implements ParameterMetaData {
    DmdbStatement stmt = null;
    DmdbParameter[] paramsInfo = null;
    int parameterNoNulls = 0;
    int parameterNullable = 1;
    int parameterNullableUnknown = 2;
    int parameterModeUnknown = 0;
    int parameterModeIn = 1;
    int parameterModeInOut = 2;
    int parameterModeOut = 4;

    DmdbParameterMetaData(DmdbPreparedStatement pstmt) {
        this.stmt = pstmt;
        this.paramsInfo = this.stmt.dbInfo.getParamsInfo();
    }

    public int getParameterCount() throws SQLException {
        if (this.paramsInfo == null) {
            return 0;
        }
        return this.paramsInfo.length;
    }

    public int isNullable(int param) throws SQLException {
        this.checkIndex(param);
        boolean nullable = this.paramsInfo[param - 1].getNullable();
        return nullable ? this.parameterNullable : this.parameterNoNulls;
    }

    public boolean isSigned(int param) throws SQLException {
        this.checkIndex(param);
        int dataType = this.paramsInfo[param - 1].getJdbcSqlType();
        return this.signed(dataType);
    }

    public int getPrecision(int param) throws SQLException {
        this.checkIndex(param);
        return this.paramsInfo[param - 1].getPrecision();
    }

    public int getScale(int param) throws SQLException {
        this.checkIndex(param);
        return this.paramsInfo[param - 1].getScale();
    }

    public int getParameterType(int param) throws SQLException {
        this.checkIndex(param);
        return this.paramsInfo[param - 1].getJdbcSqlType();
    }

    public String getParameterTypeName(int param) throws SQLException {
        this.checkIndex(param);
        String typeName = this.paramsInfo[param - 1].getTypeName();
        if (typeName == null || typeName.equals("")) {
            int dataType = this.paramsInfo[param - 1].getCType();
            int jdbcType = this.paramsInfo[param - 1].getJdbcSqlType();
            int scale = this.paramsInfo[param - 1].getOrigIntervalScale();
            typeName = this.getTypeName(dataType, jdbcType, scale);
        }
        return typeName;
    }

    public String getParameterClassName(int param) throws SQLException {
        this.checkIndex(param);
        int dataType = this.paramsInfo[param - 1].getJdbcSqlType();
        return this.getClassName(dataType);
    }

    public int getParameterMode(int param) throws SQLException {
        this.checkIndex(param);
        int jdbcInOutType = 0;
        short dmInOutType = this.paramsInfo[param - 1].getInOutType();
        switch (dmInOutType) {
            case 0: {
                if (this.stmt.dbInfo.getRetStmtType() == 157) {
                    jdbcInOutType = 0;
                    break;
                }
                jdbcInOutType = 1;
                break;
            }
            case 1: {
                jdbcInOutType = 4;
                break;
            }
            case 2: {
                jdbcInOutType = 2;
                break;
            }
        }
        return jdbcInOutType;
    }

    void checkIndex(int i) throws SQLException {
        if (i < 1 || i > this.getParameterCount()) {
            DBError.throwSQLException(6032);
        }
    }
}

