/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.Convertion;
import java.sql.SQLException;

public class DmdbLob
implements Cloneable {
    DmdbStatement statement;
    short dbid;
    int schid;
    int tabid;
    int rowid_high;
    int rowid_low;
    short colid;
    short colIndex;
    byte[] value;
    boolean fromRowSetFlag = false;
    boolean isUpdated = false;
    long curPos = -1L;

    public DmdbLob(byte[] bs) {
        this.value = bs;
        this.fromRowSetFlag = true;
        this.statement = null;
    }

    protected DmdbLob(DmdbCallableStatement cstmt, int columnIndex, byte[] value) throws SQLException {
        this.statement = cstmt;
        this.colIndex = (short)columnIndex;
        this.value = value;
        this.getIds();
    }

    public DmdbLob(DmdbStatement stmt, int columnIndex, long curPos) throws SQLException {
        this.statement = stmt;
        this.colIndex = (short)columnIndex;
        this.curPos = curPos;
        this.value = ((DmdbResultSet)this.statement.getResultSet()).getByteArrayValue(this.colIndex);
        this.getIds();
    }

    protected void getIds() throws SQLException {
        if (this.value[0] == 2) {
            byte[] buf = new byte[8];
            this.dbid = Convertion.getShort(this.value, 5);
            this.tabid = Convertion.getInt(this.value, 7);
            for (int i = 0; i < 8; ++i) {
                buf[i] = this.value[18 - i];
            }
            this.rowid_high = Convertion.getInt(buf, 4);
            this.rowid_low = Convertion.getInt(buf, 0);
            this.colid = Convertion.getShort(this.value, 19);
        } else if (this.statement.dbInfo.getUpdatable()) {
            this.rowid_high = ((DmdbResultSet)this.statement.getResultSet()).getRowidHigh();
            this.rowid_low = ((DmdbResultSet)this.statement.getResultSet()).getRowidLow();
            this.dbid = this.statement.dbInfo.getColumnsInfo()[this.colIndex - 1].getDbID();
            this.tabid = this.statement.dbInfo.getColumnsInfo()[this.colIndex - 1].getTableID();
            this.colid = this.statement.dbInfo.getColumnsInfo()[this.colIndex - 1].getColID();
        }
    }

    protected boolean isValueInRow() {
        return this.value[0] != 2;
    }

    protected int getLobLen() {
        if (this.fromRowSetFlag) {
            return Convertion.getInt(this.value, 1);
        }
        if (this.statement == null) {
            return Convertion.getInt(this.value, 1);
        }
        if (this.statement.dbInfo == null) {
            return Convertion.getInt(this.value, 1);
        }
        if (!this.fromRowSetFlag && this.statement.dbInfo.getUpdatable() && this.isUpdated) {
            return -1;
        }
        return Convertion.getInt(this.value, 1);
    }

    protected byte[] getValueInRow() throws SQLException {
        if (!this.isValueInRow()) {
            return null;
        }
        int len = Convertion.getInt(this.value, 1);
        byte[] val = new byte[len];
        System.arraycopy(this.value, 5, val, 0, len);
        return val;
    }

    public Object clone() {
        DmdbLob lob = null;
        try {
            lob = (DmdbLob)super.clone();
            lob.statement = null;
            if (this.value != null) {
                lob.value = (byte[])this.value.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return lob;
    }
}

