/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.Convertion;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DmdbInputStream
extends InputStream {
    public DmdbBlob blob = null;
    private DmdbClob _$9778 = null;
    private int _$10633;
    boolean fromRowSet = false;
    String serverEncoding = null;
    byte[] byteBuffer = null;
    int currentPos = 0;
    static final int blobLen = 32000;
    int curPos = 0;
    int byteLen = 0;

    public DmdbInputStream(Object o, boolean fromRowSet, String serverEncoding) throws NumberFormatException {
        this.fromRowSet = fromRowSet;
        if (fromRowSet) {
            this.serverEncoding = serverEncoding;
        }
        if (o instanceof DmdbBlob) {
            this._$10633 = 0;
            this.blob = (DmdbBlob)o;
        } else if (o instanceof DmdbClob) {
            this._$10633 = 1;
            this._$9778 = (DmdbClob)o;
        } else if (o instanceof byte[]) {
            this._$10633 = 3;
            this.byteBuffer = (byte[])o;
            this.curPos = 0;
            this.byteLen = this.byteBuffer == null ? 0 : this.byteBuffer.length;
        } else {
            throw new NumberFormatException("cast error.");
        }
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int retLen = this.read(buf);
        if (retLen == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public int read(byte[] bs) throws IOException {
        int bufLen = 0;
        int retLen = -1;
        int needLen = bs.length;
        try {
            switch (this._$10633) {
                case 0: {
                    bufLen = 0;
                    retLen = -1;
                    needLen = bs.length;
                    if (this.curPos < this.byteLen) {
                        bufLen = bs.length > this.byteLen - this.curPos ? this.byteLen - this.curPos : bs.length;
                        System.arraycopy(this.byteBuffer, this.curPos, bs, 0, bufLen);
                        this.curPos += bufLen;
                        needLen -= bufLen;
                        retLen = bufLen;
                    }
                    if (this.curPos >= this.byteLen) {
                        bufLen = needLen > 32000 ? needLen : 32000;
                        this.byteBuffer = this.blob.getBytes(this.currentPos + 1, bufLen);
                        if (this.byteBuffer == null || this.byteBuffer.length == 0) {
                            return retLen;
                        }
                        this.byteLen = this.byteBuffer.length;
                        this.curPos = 0;
                        this.currentPos += this.byteLen;
                        int realNeedLen = needLen;
                        if (this.byteLen < realNeedLen) {
                            realNeedLen = this.byteLen;
                        }
                        System.arraycopy(this.byteBuffer, this.curPos, bs, bs.length - needLen, realNeedLen);
                        this.curPos += realNeedLen;
                        retLen = retLen == -1 ? realNeedLen : (retLen += realNeedLen);
                    }
                    return retLen;
                }
                case 1: {
                    if (!this.fromRowSet) {
                        DmdbConnection conn = (DmdbConnection)this._$9778.statement.getConnection();
                        this.serverEncoding = conn.getServerEncoding();
                    }
                    if (this.curPos < this.byteLen) {
                        bufLen = bs.length > this.byteLen - this.curPos ? this.byteLen - this.curPos : bs.length;
                        System.arraycopy(this.byteBuffer, this.curPos, bs, 0, bufLen);
                        this.curPos += bufLen;
                        needLen -= bufLen;
                        retLen = bufLen;
                    }
                    if (this.curPos >= this.byteLen) {
                        bufLen = needLen > 32000 ? needLen : 32000;
                        String str = this._$9778.getSubString(this.currentPos + 1, bufLen);
                        if (str == null || str.length() < 1) {
                            return retLen;
                        }
                        this.byteBuffer = Convertion.getBytes(str, 0, str.length(), null);
                        this.byteLen = this.byteBuffer.length;
                        this.curPos = 0;
                        this.currentPos += str.length();
                        int realNeedLen = needLen;
                        if (this.byteLen < realNeedLen) {
                            realNeedLen = this.byteLen;
                        }
                        System.arraycopy(this.byteBuffer, this.curPos, bs, bs.length - needLen, realNeedLen);
                        this.curPos += realNeedLen;
                        retLen = retLen == -1 ? realNeedLen : (retLen += realNeedLen);
                    }
                    return retLen;
                }
                case 3: {
                    if (this.curPos >= this.byteLen) {
                        return -1;
                    }
                    bufLen = bs.length > this.byteLen - this.curPos ? this.byteLen - this.curPos : bs.length;
                    System.arraycopy(this.byteBuffer, this.curPos, bs, 0, bufLen);
                    this.curPos += bufLen;
                    retLen = bufLen;
                    return retLen;
                }
            }
            throw new IOException("io read error.");
        }
        catch (SQLException e) {
            DBError.SQLToIOException(e);
            return -1;
        }
    }

    public int available() throws IOException {
        int length = 0;
        switch (this._$10633) {
            case 0: {
                length = this.blob.getLobLen();
                break;
            }
            case 1: {
                length = this._$9778.getLobLen();
                break;
            }
            case 3: {
                length = this.byteBuffer.length;
                break;
            }
            default: {
                throw new IOException("io read error.");
            }
        }
        return length - this.curPos;
    }
}

