/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.Convertion;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbGetValue {
    String serverEncoding;
    DmdbStatement statement;
    boolean fromRowSetFlag = false;

    public DmdbGetValue(String serverEncoding, DmdbStatement statement, boolean fromRowSetFlag) {
        this.serverEncoding = serverEncoding;
        this.statement = statement;
        this.fromRowSetFlag = fromRowSetFlag;
    }

    String getString(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        String str = null;
        block0 : switch (sqlType) {
            case 1: 
            case 12: {
                str = Convertion.getString(val, 0, val.length, this.serverEncoding);
                break;
            }
            case -7: 
            case -6: {
                str = String.valueOf(this.getByte(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 5: {
                str = String.valueOf(this.getShort(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 4: {
                str = String.valueOf(this.getInt(i, val, sqlType, CType, prec, scale));
                break;
            }
            case -5: {
                str = String.valueOf(this.getLong(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 7: {
                str = String.valueOf(this.getFloat(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 6: 
            case 8: {
                str = String.valueOf(this.getDouble(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 2: 
            case 3: {
                str = String.valueOf(this.getBigDecimal(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 16: {
                str = String.valueOf(this.getBoolean(i, val, sqlType, CType, prec, scale));
                break;
            }
            case -3: 
            case -2: {
                str = Convertion.bytesToHexString(val);
                break;
            }
            case -4: 
            case 2004: {
                Blob blob = this.getBlob(i, val, sqlType, CType, prec, scale);
                int len = (int)blob.length();
                str = Convertion.getString(blob.getBytes(1L, len), 0, len, this.serverEncoding);
                break;
            }
            case -1: 
            case 2005: {
                Clob clob = this.getClob(i, val, sqlType, CType, prec, scale);
                int len = (int)clob.length();
                str = clob.getSubString(1L, len);
                break;
            }
            case 91: {
                str = String.valueOf(this.getDate(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 92: {
                DmdbDateTime dt = new DmdbDateTime(val);
                str = dt.getTimeInString();
                break;
            }
            case 93: {
                str = String.valueOf(this.getTimestamp(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 2000: {
                switch (CType) {
                    case 21: {
                        DmdbIntervalDT dt = this.getINTERVALDT(i, val, sqlType, CType, prec, scale);
                        str = dt == null ? null : dt.getDTString();
                        break block0;
                    }
                    case 20: {
                        DmdbIntervalYM ym = this.getINTERVALYM(i, val, sqlType, CType, prec, scale);
                        str = ym == null ? null : ym.getYMString();
                        break block0;
                    }
                }
                DBError.throwSQLException(6005);
                break;
            }
            case 0: {
                return null;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return str;
    }

    boolean getBoolean(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        boolean bl = false;
        switch (sqlType) {
            case 16: {
                if (val[0] == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case -7: 
            case -6: {
                if (this.getByte(i, val, sqlType, CType, prec, scale) == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 5: {
                if (this.getShort(i, val, sqlType, CType, prec, scale) == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 4: {
                if (this.getInt(i, val, sqlType, CType, prec, scale) == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case -5: {
                if (this.getLong(i, val, sqlType, CType, prec, scale) == 0L) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 7: {
                if ((double)this.getFloat(i, val, sqlType, CType, prec, scale) == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 6: 
            case 8: {
                if (this.getDouble(i, val, sqlType, CType, prec, scale) == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                if (this.getBigDecimal(i, val, sqlType, CType, prec, scale).byteValue() == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this.getString(i, val, sqlType, CType, prec, scale).charAt(0) == '0') {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 0: {
                return false;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return bl;
    }

    byte getByte(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case -7: 
            case -6: {
                return val[0];
            }
            case 5: {
                Short tmp = new Short(this.getShort(i, val, sqlType, CType, prec, scale));
                if (tmp < -128 || tmp > 127) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case 4: {
                Integer tmp = new Integer(this.getInt(i, val, sqlType, CType, prec, scale));
                if (tmp < -128 || tmp > 127) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case -5: {
                Long tmp = new Long(this.getLong(i, val, sqlType, CType, prec, scale));
                if (tmp < -128L || tmp > 127L) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case 7: {
                Float tmp = new Float(this.getFloat(i, val, sqlType, CType, prec, scale));
                if (tmp.floatValue() < -128.0f || tmp.floatValue() > 127.0f) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case 6: 
            case 8: {
                Double tmp = new Double(this.getDouble(i, val, sqlType, CType, prec, scale));
                if (tmp < -128.0 || tmp > 127.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case 2: 
            case 3: {
                BigDecimal tmp = this.getBigDecimal(i, val, sqlType, CType, prec, scale);
                if (tmp.doubleValue() < -128.0 || tmp.doubleValue() > 127.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case 16: {
                if (this.getBoolean(i, val, sqlType, CType, prec, scale)) {
                    return 1;
                }
                return 0;
            }
            case -1: 
            case 1: 
            case 12: {
                Double tmp = null;
                try {
                    tmp = Double.valueOf(this.getString(i, val, sqlType, CType, prec, scale));
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp < -128.0 || tmp > 127.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                return tmp.byteValue();
            }
            case 0: {
                return 0;
            }
        }
        DBError.throwSQLException(6007);
        return 0;
    }

    short getShort(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        short tmp = 0;
        switch (sqlType) {
            case 5: {
                tmp = Convertion.twoByteToShort(val);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                tmp = this.getByte(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 4: {
                int tmp1 = this.getInt(i, val, sqlType, CType, prec, scale);
                if (tmp1 < Short.MIN_VALUE || tmp1 > Short.MAX_VALUE) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (short)tmp1;
                break;
            }
            case -5: {
                long tmp1 = this.getLong(i, val, sqlType, CType, prec, scale);
                if (tmp1 < -32768L || tmp1 > 32767L) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (short)tmp1;
                break;
            }
            case 7: {
                float tmp1 = this.getFloat(i, val, sqlType, CType, prec, scale);
                if (tmp1 < -32768.0f || tmp1 > 32767.0f) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (short)tmp1;
                break;
            }
            case 6: 
            case 8: {
                double tmp1 = this.getDouble(i, val, sqlType, CType, prec, scale);
                if (tmp1 < -32768.0 || tmp1 > 32767.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (short)tmp1;
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                Double tmp1 = null;
                try {
                    tmp1 = Double.valueOf(this.getString(i, val, sqlType, CType, prec, scale).trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp1 < -32768.0 || tmp1 > 32767.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = tmp1.shortValue();
                break;
            }
            case 0: {
                return 0;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return tmp;
    }

    int getInt(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        int tmp = 0;
        switch (sqlType) {
            case 4: {
                tmp = Convertion.fourByteToInt(val);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                tmp = this.getByte(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 5: {
                tmp = this.getShort(i, val, sqlType, CType, prec, scale);
                break;
            }
            case -5: {
                long tmp1 = this.getLong(i, val, sqlType, CType, prec, scale);
                if (tmp1 < Integer.MIN_VALUE || tmp1 > Integer.MAX_VALUE) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (int)tmp1;
                break;
            }
            case 7: {
                float tmp1 = this.getFloat(i, val, sqlType, CType, prec, scale);
                if (tmp1 < -2.1474836E9f || tmp1 > 2.1474836E9f) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (int)tmp1;
                break;
            }
            case 6: 
            case 8: {
                double tmp1 = this.getDouble(i, val, sqlType, CType, prec, scale);
                if (tmp1 < -2.147483648E9 || tmp1 > 2.147483647E9) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = (int)tmp1;
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                Double tmp1 = null;
                try {
                    tmp1 = Double.valueOf(this.getString(i, val, sqlType, CType, prec, scale).trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp1 < -2.147483648E9 || tmp1 > 2.147483647E9) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                tmp = tmp1.intValue();
                break;
            }
            case -2: {
                if (val.length > 4) {
                    for (int j = 0; j < val.length - 4 - 1; ++j) {
                        if (val[j] == 0) continue;
                        DBError.throwSQLException(6007);
                    }
                }
                int n = 0;
                int b = 0;
                for (int j = 0; j < val.length; ++j) {
                    b = 0xFF & val[j];
                    n = b | n << 8;
                }
                tmp = n;
                break;
            }
            case 0: {
                return 0;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return tmp;
    }

    long getLong(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        long tmp = 0L;
        switch (sqlType) {
            case -5: {
                tmp = Convertion.eightByteToLong(val);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                tmp = this.getByte(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 5: {
                tmp = this.getShort(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 4: {
                tmp = this.getInt(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 7: {
                tmp = (long)this.getFloat(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                tmp = (long)this.getDouble(i, val, sqlType, CType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                try {
                    tmp = Double.valueOf(this.getString(i, val, sqlType, CType, prec, scale).trim()).longValue();
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                break;
            }
            case -2: {
                if (val.length > 8) {
                    for (int j = 0; j < val.length - 8 - 1; ++j) {
                        if (val[j] == 0) continue;
                        DBError.throwSQLException(6007);
                    }
                }
                long n = 0L;
                long b = 0L;
                for (int j = 0; j < val.length; ++j) {
                    b = 0xFF & val[j];
                    n = b | n << 8;
                }
                tmp = n;
                break;
            }
            case 0: {
                return 0L;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return tmp;
    }

    float getFloat(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        float flt = 0.0f;
        switch (sqlType) {
            case 7: {
                flt = Float.intBitsToFloat(Convertion.fourByteToInt(val));
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                flt = this.getByte(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 5: {
                flt = this.getShort(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 4: {
                flt = this.getInt(i, val, sqlType, CType, prec, scale);
                break;
            }
            case -5: {
                flt = this.getLong(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 6: 
            case 8: {
                flt = (float)this.getDouble(i, val, sqlType, CType, prec, scale);
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                try {
                    flt = Double.valueOf(this.getString(i, val, sqlType, CType, prec, scale).trim()).floatValue();
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                break;
            }
            case 0: {
                return 0.0f;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return flt;
    }

    double getDouble(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        double dbl = 0.0;
        switch (sqlType) {
            case 6: 
            case 8: {
                dbl = Double.longBitsToDouble(Convertion.eightByteToLong(val));
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                dbl = this.getByte(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 5: {
                dbl = this.getShort(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 4: {
                dbl = this.getInt(i, val, sqlType, CType, prec, scale);
                break;
            }
            case -5: {
                dbl = this.getLong(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 7: {
                dbl = this.getFloat(i, val, sqlType, CType, prec, scale);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal dec = this.getBigDecimal(i, val, sqlType, CType, prec, scale);
                dbl = dec.doubleValue();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    dbl = Double.valueOf(this.getString(i, val, sqlType, CType, prec, scale).trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                break;
            }
            case 0: {
                return 0.0;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return dbl;
    }

    BigDecimal getBigDecimal(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        BigDecimal dec = null;
        switch (sqlType) {
            case 2: 
            case 3: {
                int len;
                if (CType == 9) {
                    String s = null;
                    try {
                        int ind;
                        int dotIndex;
                        StringBuffer sb = new StringBuffer(10);
                        block25: for (int j = 0; j < val.length; ++j) {
                            int tmp = 0xF & val[j];
                            switch (tmp) {
                                case 10: {
                                    sb.append('.');
                                    break;
                                }
                                case 11: {
                                    sb.append('+');
                                    break;
                                }
                                case 12: {
                                    sb.append('-');
                                    break;
                                }
                                default: {
                                    sb.append(tmp);
                                }
                            }
                            tmp = val[j] >>> 4 & 0xF;
                            switch (tmp) {
                                case 10: {
                                    sb.append('.');
                                    continue block25;
                                }
                                case 11: {
                                    sb.append('+');
                                    continue block25;
                                }
                                case 12: {
                                    sb.append('-');
                                    continue block25;
                                }
                                default: {
                                    sb.append(tmp);
                                }
                            }
                        }
                        s = sb.toString();
                        if (s.charAt(0) == '0') {
                            s = s.substring(1);
                        }
                        if (s.indexOf("-", 1) != -1) {
                            s = s.substring(0, s.indexOf("-", 1));
                        }
                        if (s.indexOf("+", 1) != -1) {
                            s = s.substring(0, s.indexOf("+", 1));
                        }
                        if (s.indexOf(".", (dotIndex = s.indexOf(".")) + 1) != -1) {
                            s = s.substring(0, s.indexOf(".", dotIndex + 1));
                        }
                        if (prec % 2 != 0 && (ind = s.indexOf(46)) > -1 && s.length() - ind - 1 > scale) {
                            s = s.substring(0, ind) + s.substring(ind, ind + scale + 1);
                        }
                        dec = new BigDecimal(s);
                        dec = dec.setScale(scale, 4);
                    }
                    catch (NumberFormatException e) {
                        DBError.throwSQLException(6018);
                    }
                    break;
                }
                String sign = "";
                long tmp = Convertion.eightByteToLong(val);
                String s = "" + tmp;
                if (s.startsWith("+") || s.startsWith("-")) {
                    sign = s.substring(0, 1);
                    s = s.substring(1);
                }
                if ((len = s.length()) > scale) {
                    String subStr1 = s.substring(0, len - scale);
                    String subStr2 = s.substring(len - scale);
                    s = subStr1 + "." + subStr2;
                } else {
                    for (int k = 0; k < scale - len; ++k) {
                        s = "0" + s;
                    }
                    s = "0." + s;
                }
                s = sign + s;
                dec = new BigDecimal(s);
                dec = dec.setScale(scale, 4);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                dec = new BigDecimal(this.getByte(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 5: {
                dec = new BigDecimal(this.getShort(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 4: {
                dec = new BigDecimal(this.getInt(i, val, sqlType, CType, prec, scale));
                break;
            }
            case -5: {
                dec = new BigDecimal(this.getLong(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 7: {
                dec = new BigDecimal(this.getFloat(i, val, sqlType, CType, prec, scale));
                break;
            }
            case 6: 
            case 8: {
                dec = new BigDecimal(this.getDouble(i, val, sqlType, CType, prec, scale));
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                try {
                    dec = new BigDecimal(this.getString(i, val, sqlType, CType, prec, scale).trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                break;
            }
            case 0: {
                return null;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return dec;
    }

    private boolean _$10565(byte[] bs) throws SQLException {
        boolean realData = false;
        byte b = bs[0];
        if ((b & 1) == 1) {
            realData = true;
        } else if ((b & 2) == 2) {
            realData = false;
        } else {
            DBError.throwSQLException(6033);
        }
        return realData;
    }

    byte[] getBytes(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        int len = val.length;
        switch (sqlType) {
            case -7: 
            case -3: 
            case -2: 
            case 12: {
                return val;
            }
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                if (len < 5) {
                    DBError.throwSQLException(Const.res.getString("error.Lob.length"));
                }
                if (this._$10565(val)) {
                    byte[] s1 = new byte[4];
                    System.arraycopy(val, 1, s1, 0, 4);
                    len = Math.min(len - 5, Convertion.fourByteToInt(s1));
                    byte[] buf = new byte[len];
                    System.arraycopy(val, 5, buf, 0, len);
                    val = buf;
                    break;
                }
                return null;
            }
            case 0: {
                return null;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return val;
    }

    Date getDate(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        DmdbDateTime dt = new DmdbDateTime(val);
        switch (sqlType) {
            case 91: {
                return dt.getDate();
            }
            case 93: {
                return new Date(dt.getTimestamp().getTime());
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return DmdbDateTime.getDateByString(this.getString(i, val, sqlType, CType, prec, scale).trim());
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    Time getTime(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        DmdbDateTime dt = new DmdbDateTime(val);
        switch (sqlType) {
            case 92: {
                return dt.getTime();
            }
            case 93: {
                return new Time(dt.getTimestamp().getTime());
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                DmdbTime dt1 = new DmdbTime(this.getString(i, val, sqlType, CType, prec, scale).trim());
                return dt1.getTime();
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    Timestamp getTimestamp(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        DmdbDateTime dt = new DmdbDateTime(val);
        switch (sqlType) {
            case 93: {
                return dt.getTimestamp();
            }
            case 91: {
                return new Timestamp(dt.getDate().getTime());
            }
            case 92: {
                DmdbTime dt1 = new DmdbTime(val);
                return dt1.getTimestamp();
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return DmdbDateTime.getTimestampByString(this.getString(i, val, sqlType, CType, prec, scale).trim());
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    InputStream getAsciiStream(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        InputStream in = null;
        switch (sqlType) {
            case -3: 
            case -2: {
                return new DmdbInputStream(this.getBytes(i, val, sqlType, CType, prec, scale), this.fromRowSetFlag, this.serverEncoding);
            }
            case -4: 
            case 2004: {
                Blob blob = this.getBlob(i, val, sqlType, CType, prec, scale);
                return new DmdbInputStream(blob, this.fromRowSetFlag, this.serverEncoding);
            }
            case -1: {
                Clob clob = this.getClob(i, val, sqlType, CType, prec, scale);
                return new DmdbInputStream(clob, this.fromRowSetFlag, this.serverEncoding);
            }
            case 1: 
            case 12: {
                return new DmdbInputStream(val, this.fromRowSetFlag, this.serverEncoding);
            }
            case 2005: {
                Clob clob1 = this.getClob(i, val, sqlType, CType, prec, scale);
                in = clob1.getAsciiStream();
                return in;
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    InputStream getUnicodeStream(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        ByteArrayInputStream in = null;
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                in = new ByteArrayInputStream(this.getString(i, val, sqlType, CType, prec, scale).getBytes());
                return new UtilBinaryToUnicodeInputStream(in);
            }
            case -1: 
            case 2005: {
                in = new ByteArrayInputStream(this.getBytes(i, val, sqlType, CType, prec, scale));
                return new UtilBinaryToUnicodeInputStream(in);
            }
            case 1: 
            case 12: {
                in = new ByteArrayInputStream(val);
                return new UtilBinaryToUnicodeInputStream(in);
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    InputStream getBinaryStream(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case -3: 
            case -2: {
                return new DmdbInputStream(val, this.fromRowSetFlag, this.serverEncoding);
            }
            case -4: 
            case 2004: {
                Blob blob = this._$10568(i, val);
                return new DmdbInputStream(blob, this.fromRowSetFlag, this.serverEncoding);
            }
            case -1: 
            case 2005: {
                Clob clob = this._$10569(i, val);
                return new DmdbInputStream(clob, this.fromRowSetFlag, this.serverEncoding);
            }
            case 1: 
            case 12: {
                return new DmdbInputStream(val, this.fromRowSetFlag, this.serverEncoding);
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    Object getObject(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 16: {
                return new Boolean(this.getBoolean(i, val, sqlType, CType, prec, scale));
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(i, val, sqlType, CType, prec, scale));
            }
            case -5: {
                return new Long(this.getLong(i, val, sqlType, CType, prec, scale));
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(i, val, sqlType, CType, prec, scale);
            }
            case 7: {
                return new Float(this.getFloat(i, val, sqlType, CType, prec, scale));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(i, val, sqlType, CType, prec, scale));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(i, val, sqlType, CType, prec, scale);
            }
            case 91: {
                return this.getDate(i, val, sqlType, CType, prec, scale);
            }
            case 92: {
                return this.getTime(i, val, sqlType, CType, prec, scale);
            }
            case 93: {
                return this.getTimestamp(i, val, sqlType, CType, prec, scale);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(i, val, sqlType, CType, prec, scale);
            }
            case 2004: {
                return this.getBlob(i, val, sqlType, CType, prec, scale);
            }
            case 2005: {
                return this.getClob(i, val, sqlType, CType, prec, scale);
            }
            case 2000: {
                if (CType == 21) {
                    return this.getINTERVALDT(i, val, sqlType, CType, prec, scale);
                }
                if (CType == 20) {
                    return this.getINTERVALYM(i, val, sqlType, CType, prec, scale);
                }
            }
            case 0: {
                return null;
            }
        }
        return this.getBytes(i, val, sqlType, CType, prec, scale);
    }

    Reader getCharacterStream(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        switch (sqlType) {
            case -3: 
            case -2: {
                return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(val)));
            }
            case -4: 
            case 2004: {
                Blob blob1 = this.getBlob(i, val, sqlType, CType, prec, scale);
                if (blob1 == null) {
                    return new DmdbReader(null);
                }
                return ((DmdbBlob)blob1).getCharacterStream();
            }
            case -1: 
            case 2005: {
                Clob clob1 = this.getClob(i, val, sqlType, CType, prec, scale);
                return clob1.getCharacterStream();
            }
            case 1: 
            case 12: {
                String str = Convertion.getString(val, 0, val.length, this.serverEncoding);
                return new StringReader(str);
            }
            case 0: {
                return null;
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    Blob getBlob(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        return this._$10568(i, val);
    }

    Clob getClob(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        return this._$10569(i, val);
    }

    public DmdbIntervalDT getINTERVALDT(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        switch (CType) {
            case 21: {
                return new DmdbIntervalDT(val, prec, scale);
            }
            case 0: {
                return null;
            }
        }
        return new DmdbIntervalDT(this.getString(i, val, sqlType, CType, prec, scale), prec, scale);
    }

    public DmdbIntervalYM getINTERVALYM(int i, byte[] val, int sqlType, int CType, int prec, int scale) throws SQLException {
        switch (CType) {
            case 20: {
                DmdbIntervalYM ym = new DmdbIntervalYM(val, prec);
                return ym;
            }
            case 0: {
                return null;
            }
        }
        return new DmdbIntervalYM(this.getString(i, val, sqlType, CType, prec, scale), prec);
    }

    private Blob _$10568(int i, byte[] bs) throws SQLException {
        DmdbBlob ret = null;
        if (!this.fromRowSetFlag) {
            long curPos = this.statement.currentRs.currentRow;
            ret = new DmdbBlob(this.statement, i, curPos);
            if (this.statement.lob_mode == 2 && ret != null && !ret.isValueInRow()) {
                this.statement.lob_mode = 1;
                byte[] tmp = ret.getBytes(1L, (int)ret.length());
                byte[] value = new byte[5 + tmp.length];
                System.arraycopy(ret.value, 0, value, 0, 21);
                System.arraycopy(tmp, 0, value, 5, tmp.length);
                ret.value = value;
                this.statement.lob_mode = 2;
            }
        } else {
            ret = new DmdbBlob(bs);
        }
        return ret;
    }

    private Clob _$10569(int i, byte[] bs) throws SQLException {
        DmdbClob ret = null;
        if (!this.fromRowSetFlag) {
            long curPos = this.statement.currentRs.currentRow;
            ret = new DmdbClob(this.statement, i, curPos);
            if (this.statement.lob_mode == 2 && ret != null && !ret.isValueInRow()) {
                this.statement.lob_mode = 1;
                byte[] tmp = ret.getBytes(1L, ret.getLobLen());
                byte[] value = new byte[5 + tmp.length];
                System.arraycopy(ret.value, 0, value, 0, 21);
                System.arraycopy(tmp, 0, value, 5, tmp.length);
                ret.value = value;
                this.statement.lob_mode = 2;
            }
        } else {
            ret = new DmdbClob(bs, this.serverEncoding);
        }
        return ret;
    }
}

